/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ExtendedCellBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.WhereCompiler;
import org.apache.phoenix.coprocessor.ColumnMutator;
import org.apache.phoenix.coprocessor.MetaDataEndpointImpl;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ViewUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropColumnMutator
implements ColumnMutator {
    private List<Pair<PTable, PColumn>> tableAndDroppedColPairs = Lists.newArrayList();
    private Configuration conf;
    private static final Logger logger = LoggerFactory.getLogger(DropColumnMutator.class);

    public DropColumnMutator(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public ColumnMutator.MutateColumnType getMutateColumnType() {
        return ColumnMutator.MutateColumnType.DROP_COLUMN;
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult validateWithChildViews(PTable table, List<PTable> childViews, List<Mutation> tableMetadata, byte[] schemaName, byte[] tableName) throws IOException, SQLException {
        ArrayList columnDeletesForBaseTable = Lists.newArrayListWithExpectedSize((int)5);
        for (Mutation m : tableMetadata) {
            if (!(m instanceof Delete)) continue;
            byte[][] rkmd = new byte[5][];
            int pkCount = SchemaUtil.getVarChars((byte[])m.getRow(), (byte[][])rkmd);
            if (pkCount <= 3 || Bytes.compareTo((byte[])schemaName, (byte[])rkmd[1]) != 0 || Bytes.compareTo((byte[])tableName, (byte[])rkmd[2]) != 0) continue;
            columnDeletesForBaseTable.add((Delete)m);
        }
        for (PTable view : childViews) {
            for (Delete columnDeleteForBaseTable : columnDeletesForBaseTable) {
                PColumn existingViewColumn = null;
                byte[][] rkmd = new byte[5][];
                SchemaUtil.getVarChars((byte[])columnDeleteForBaseTable.getRow(), (byte[][])rkmd);
                String columnName = Bytes.toString((byte[])rkmd[3]);
                String columnFamily = rkmd[4] == null ? null : Bytes.toString((byte[])rkmd[4]);
                try {
                    existingViewColumn = columnFamily == null ? view.getColumnForColumnName(columnName) : view.getColumnFamily(columnFamily).getPColumnForColumnName(columnName);
                }
                catch (ColumnFamilyNotFoundException columnFamilyNotFoundException) {
                }
                catch (ColumnNotFoundException columnNotFoundException) {
                    // empty catch block
                }
                if (existingViewColumn != null && view.getViewStatement() != null) {
                    ParseNode viewWhere = new SQLParser(view.getViewStatement()).parseQuery().getWhere();
                    try (PhoenixConnection conn = QueryUtil.getConnectionOnServer((Configuration)this.conf).unwrap(PhoenixConnection.class);){
                        PhoenixStatement statement = new PhoenixStatement(conn);
                        TableRef baseTableRef = new TableRef(view);
                        ColumnResolver columnResolver = FromCompiler.getResolver((TableRef)baseTableRef);
                        StatementContext context = new StatementContext(statement, columnResolver);
                        Expression whereExpression = WhereCompiler.compile((StatementContext)context, (ParseNode)viewWhere);
                        Expression colExpression = new ColumnRef(baseTableRef, existingViewColumn.getPosition()).newColumnExpression();
                        MetaDataEndpointImpl.ColumnFinder columnFinder = new MetaDataEndpointImpl.ColumnFinder(colExpression);
                        whereExpression.accept((ExpressionVisitor)columnFinder);
                        if (columnFinder.getColumnFound()) {
                            MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), table);
                            return metaDataMutationResult;
                        }
                    }
                }
                if (existingViewColumn == null) continue;
                this.tableAndDroppedColPairs.add((Pair<PTable, PColumn>)new Pair((Object)view, (Object)existingViewColumn));
            }
        }
        return null;
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult validateAndAddMetadata(PTable table, byte[][] rowKeyMetaData, List<Mutation> tableMetaData, Region region, List<ImmutableBytesPtr> invalidateList, List<Region.RowLock> locks, long clientTimeStamp, long clientVersion, ExtendedCellBuilder extendedCellBuilder, boolean isDroppingColumns) throws SQLException {
        byte[] tenantId = rowKeyMetaData[0];
        byte[] schemaName = rowKeyMetaData[1];
        byte[] tableName = rowKeyMetaData[2];
        boolean isView = table.getType() == PTableType.VIEW;
        boolean deletePKColumn = false;
        byte[] tableHeaderRowKey = SchemaUtil.getTableKey((byte[])tenantId, (byte[])schemaName, (byte[])tableName);
        ArrayList additionalTableMetaData = Lists.newArrayList();
        ListIterator<Mutation> iterator = tableMetaData.listIterator();
        while (iterator.hasNext()) {
            Mutation mutation = iterator.next();
            byte[] key = mutation.getRow();
            int pkCount = SchemaUtil.getVarChars((byte[])key, (byte[][])rowKeyMetaData);
            if (isView && mutation instanceof Put) {
                PColumn column = null;
                if (Bytes.compareTo((byte[])schemaName, (byte[])rowKeyMetaData[1]) == 0 && Bytes.compareTo((byte[])tableName, (byte[])rowKeyMetaData[2]) == 0) {
                    column = MetaDataUtil.getColumn((int)pkCount, (byte[][])rowKeyMetaData, (PTable)table);
                } else {
                    for (int i = 0; i < table.getIndexes().size(); ++i) {
                        PTableImpl indexTable = (PTableImpl)table.getIndexes().get(i);
                        byte[] indexTableName = indexTable.getTableName().getBytes();
                        byte[] indexSchema = indexTable.getSchemaName().getBytes();
                        if (Bytes.compareTo((byte[])indexSchema, (byte[])rowKeyMetaData[1]) != 0 || Bytes.compareTo((byte[])indexTableName, (byte[])rowKeyMetaData[2]) != 0) continue;
                        column = MetaDataUtil.getColumn((int)pkCount, (byte[][])rowKeyMetaData, (PTable)indexTable);
                        break;
                    }
                }
                if (column == null) continue;
                iterator.remove();
                continue;
            }
            if (!(mutation instanceof Delete) || pkCount <= 3 || Bytes.compareTo((byte[])schemaName, (byte[])rowKeyMetaData[1]) != 0 || Bytes.compareTo((byte[])tableName, (byte[])rowKeyMetaData[2]) != 0) continue;
            PColumn columnToDelete = null;
            try {
                columnToDelete = MetaDataUtil.getColumn((int)pkCount, (byte[][])rowKeyMetaData, (PTable)table);
                if (columnToDelete == null) continue;
                boolean bl = deletePKColumn = columnToDelete.getFamilyName() == null;
                if (isView) {
                    if (columnToDelete.isDerived()) {
                        mutation = MetaDataUtil.cloneDeleteToPutAndAddColumn((Delete)((Delete)mutation), (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.LINK_TYPE_BYTES, (byte[])PTable.LinkType.EXCLUDED_COLUMN.getSerializedValueAsByteArray());
                        iterator.set(mutation);
                    }
                    if (ViewUtil.isViewDiverging((PColumn)columnToDelete, (PTable)table, (long)clientVersion)) {
                        byte[] viewKey = SchemaUtil.getTableKey((byte[])tenantId, (byte[])schemaName, (byte[])tableName);
                        Put updateBaseColumnCountPut = new Put(viewKey);
                        byte[] baseColumnCountPtr = new byte[PInteger.INSTANCE.getByteSize().intValue()];
                        PInteger.INSTANCE.getCodec().encodeInt(-100, baseColumnCountPtr, 0);
                        updateBaseColumnCountPut.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.BASE_COLUMN_COUNT_BYTES, clientTimeStamp, baseColumnCountPtr);
                        additionalTableMetaData.add(updateBaseColumnCountPut);
                    }
                }
                if (columnToDelete.isViewReferenced()) {
                    return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), table, columnToDelete);
                }
                this.tableAndDroppedColPairs.add((Pair<PTable, PColumn>)new Pair((Object)table, (Object)columnToDelete));
            }
            catch (ColumnFamilyNotFoundException | ColumnNotFoundException e) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.COLUMN_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), table, columnToDelete);
            }
        }
        if (MetaDataUtil.isTableDirectlyQueried((PTableType)table.getType())) {
            long serverTimestamp = EnvironmentEdgeManager.currentTimeMillis();
            additionalTableMetaData.add(MetaDataUtil.getLastDDLTimestampUpdate((byte[])tableHeaderRowKey, (long)clientTimeStamp, (long)serverTimestamp));
        }
        tableMetaData.addAll(additionalTableMetaData);
        if (deletePKColumn && table.getPKColumns().size() == 1) {
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.NO_PK_COLUMNS, EnvironmentEdgeManager.currentTimeMillis(), null);
        }
        long currentTime = MetaDataUtil.getClientTimeStamp(tableMetaData);
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, currentTime, null);
    }

    @Override
    public List<Pair<PTable, PColumn>> getTableAndDroppedColumnPairs() {
        return this.tableAndDroppedColPairs;
    }
}

