/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.ScannerContextUtil;
import org.apache.phoenix.util.ScanUtil;

public class DelegateRegionScanner
implements RegionScanner {
    protected RegionScanner delegate;

    public DelegateRegionScanner(RegionScanner scanner) {
        this.delegate = scanner;
    }

    public boolean isFilterDone() throws IOException {
        return this.delegate.isFilterDone();
    }

    public boolean reseek(byte[] row) throws IOException {
        return this.delegate.reseek(row);
    }

    public long getMvccReadPoint() {
        return this.delegate.getMvccReadPoint();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public long getMaxResultSize() {
        return this.delegate.getMaxResultSize();
    }

    public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
        return this.next(result, false, scannerContext);
    }

    public boolean next(List<Cell> result) throws IOException {
        return this.next(result, false, null);
    }

    public boolean nextRaw(List<Cell> result, ScannerContext scannerContext) throws IOException {
        return this.next(result, true, scannerContext);
    }

    public boolean nextRaw(List<Cell> result) throws IOException {
        return this.next(result, true, null);
    }

    public int getBatch() {
        return this.delegate.getBatch();
    }

    public RegionInfo getRegionInfo() {
        return this.delegate.getRegionInfo();
    }

    public RegionScanner getNewRegionScanner(Scan scan) throws IOException {
        try {
            return ((DelegateRegionScanner)this.delegate).getNewRegionScanner(scan);
        }
        catch (ClassCastException e) {
            throw new DoNotRetryIOException((Throwable)e);
        }
    }

    private boolean next(List<Cell> result, boolean raw, ScannerContext scannerContext) throws IOException {
        if (scannerContext != null) {
            boolean hasMore;
            ScannerContext noLimitContext = ScannerContextUtil.copyNoLimitScanner(scannerContext);
            boolean bl = hasMore = raw ? this.delegate.nextRaw(result, noLimitContext) : this.delegate.next(result, noLimitContext);
            if (ScanUtil.isDummy(result)) {
                ScannerContextUtil.setReturnImmediately(scannerContext);
            }
            ScannerContextUtil.updateMetrics(noLimitContext, scannerContext);
            return hasMore;
        }
        return raw ? this.delegate.nextRaw(result) : this.delegate.next(result);
    }
}

