/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilder;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.UncoveredGlobalIndexRegionScanner;
import org.apache.phoenix.coprocessor.generated.CDCInfoProtos;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.SingleCellColumnExpression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.CDCTableInfo;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.CDCChangeBuilder;
import org.apache.phoenix.util.CDCUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.JacksonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDCGlobalIndexRegionScanner
extends UncoveredGlobalIndexRegionScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(CDCGlobalIndexRegionScanner.class);
    private CDCTableInfo cdcDataTableInfo;
    private CDCChangeBuilder changeBuilder;

    public CDCGlobalIndexRegionScanner(RegionScanner innerScanner, Region region, Scan scan, RegionCoprocessorEnvironment env, Scan dataTableScan, TupleProjector tupleProjector, IndexMaintainer indexMaintainer, byte[][] viewConstants, ImmutableBytesWritable ptr, long pageSizeMs, long queryLimit) throws IOException {
        super(innerScanner, region, scan, env, dataTableScan, tupleProjector, indexMaintainer, viewConstants, ptr, pageSizeMs, queryLimit);
        CDCUtil.setupScanForCDC((Scan)dataTableScan);
        this.cdcDataTableInfo = CDCTableInfo.createFromProto((CDCInfoProtos.CDCTableDef)CDCInfoProtos.CDCTableDef.parseFrom((byte[])scan.getAttribute("_CdcDataTableDef")));
        this.changeBuilder = new CDCChangeBuilder(this.cdcDataTableInfo);
    }

    @Override
    protected Scan prepareDataTableScan(Collection<byte[]> dataRowKeys) throws IOException {
        return CDCUtil.setupScanForCDC((Scan)this.prepareDataTableScan(dataRowKeys, true));
    }

    @Override
    protected boolean getNextCoveredIndexRow(List<Cell> result) throws IOException {
        if (this.indexRowIterator.hasNext()) {
            boolean success;
            List indexRow = (List)this.indexRowIterator.next();
            Cell indexCell = (Cell)indexRow.get(0);
            byte[] indexRowKey = ImmutableBytesPtr.cloneCellRowIfNecessary((Cell)indexCell);
            if (indexRow.size() > 1 && (success = this.handlePreImageCDCEvent(indexRow, indexRowKey, indexCell, result))) {
                return true;
            }
            ImmutableBytesPtr dataRowKey = new ImmutableBytesPtr((byte[])this.indexToDataRowKeyMap.get(indexRowKey));
            Result dataRow = (Result)this.dataRows.get(dataRowKey);
            long changeTS = indexCell.getTimestamp();
            TupleProjector dataTableProjector = this.cdcDataTableInfo.getDataTableProjector();
            Expression[] expressions = dataTableProjector != null ? dataTableProjector.getExpressions() : null;
            boolean isSingleCell = dataTableProjector != null;
            byte[] emptyCQ = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo((PTable.QualifierEncodingScheme)this.cdcDataTableInfo.getQualifierEncodingScheme()).getFirst();
            this.changeBuilder.initChange(changeTS);
            try {
                if (dataRow != null) {
                    int curColumnNum = 0;
                    List cdcColumnInfoList = this.cdcDataTableInfo.getColumnInfoList();
                    block2: for (Cell cell : dataRow.rawCells()) {
                        CDCTableInfo.CDCColumnInfo currentColumnInfo;
                        int columnComparisonResult;
                        if (!this.changeBuilder.isChangeRelevant(cell)) continue;
                        byte[] cellFam = ImmutableBytesPtr.cloneCellFamilyIfNecessary((Cell)cell);
                        byte[] cellQual = ImmutableBytesPtr.cloneCellQualifierIfNecessary((Cell)cell);
                        if (cell.getType() == Cell.Type.DeleteFamily) {
                            if (changeTS == cell.getTimestamp()) {
                                this.changeBuilder.markAsDeletionEvent();
                                continue;
                            }
                            if (changeTS <= cell.getTimestamp() || this.changeBuilder.getLastDeletedTimestamp() != 0L) continue;
                            this.changeBuilder.setLastDeletedTimestamp(cell.getTimestamp());
                            continue;
                        }
                        if (cell.getType() != Cell.Type.DeleteColumn && cell.getType() != Cell.Type.Put || Arrays.equals(cellQual, emptyCQ) || !this.changeBuilder.isChangeRelevant(cell)) continue;
                        if (isSingleCell) {
                            while (curColumnNum < cdcColumnInfoList.size()) {
                                boolean hasValue = dataTableProjector.getSchema().extractValue(cell, (SingleCellColumnExpression)expressions[curColumnNum], this.ptr);
                                if (hasValue) {
                                    Object cellValue = this.getColumnValue(this.ptr.get(), this.ptr.getOffset(), this.ptr.getLength(), ((CDCTableInfo.CDCColumnInfo)cdcColumnInfoList.get(curColumnNum)).getColumnType());
                                    this.changeBuilder.registerChange(cell, curColumnNum, cellValue);
                                }
                                ++curColumnNum;
                            }
                            break;
                        }
                        while ((columnComparisonResult = CDCUtil.compareCellFamilyAndQualifier((byte[])cellFam, (byte[])cellQual, (byte[])(currentColumnInfo = (CDCTableInfo.CDCColumnInfo)cdcColumnInfoList.get(curColumnNum)).getColumnFamily(), (byte[])currentColumnInfo.getColumnQualifier())) > 0) {
                            if (++curColumnNum < cdcColumnInfoList.size()) continue;
                            break block2;
                        }
                        if (columnComparisonResult < 0) continue;
                        Object cellValue = cell.getType() == Cell.Type.DeleteColumn ? null : this.getColumnValue(cell, ((CDCTableInfo.CDCColumnInfo)cdcColumnInfoList.get(curColumnNum)).getColumnType());
                        this.changeBuilder.registerChange(cell, curColumnNum, cellValue);
                    }
                    if (this.changeBuilder.isNonEmptyEvent()) {
                        Result cdcRow = this.getCDCImage(indexRowKey, indexCell);
                        if (cdcRow != null && this.tupleProjector != null) {
                            if (indexCell.getType() == Cell.Type.DeleteFamily) {
                                result.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(indexRowKey).setFamily(ImmutableBytesPtr.cloneCellFamilyIfNecessary((Cell)indexCell)).setQualifier(this.indexMaintainer.getEmptyKeyValueQualifier()).setTimestamp(indexCell.getTimestamp()).setType(Cell.Type.Put).setValue(ByteUtil.EMPTY_BYTE_ARRAY).build());
                            } else {
                                result.add(indexCell);
                            }
                            IndexUtil.addTupleAsOneCell(result, (Tuple)new ResultTuple(cdcRow), (TupleProjector)this.tupleProjector, (ImmutableBytesWritable)this.ptr);
                        } else {
                            result.clear();
                        }
                    } else {
                        result.clear();
                    }
                } else {
                    result.clear();
                }
                return true;
            }
            catch (Throwable e) {
                LOGGER.error("Exception in UncoveredIndexRegionScanner for region " + this.region.getRegionInfo().getRegionNameAsString(), e);
                throw e;
            }
        }
        return false;
    }

    private Result getCDCImage(byte[] indexRowKey, Cell firstCell) throws JsonProcessingException {
        byte[] value = JacksonUtil.getObjectWriter(HashMap.class).writeValueAsBytes((Object)this.changeBuilder.buildCDCEvent());
        return this.createCDCResult(indexRowKey, firstCell, this.changeBuilder.getChangeTimestamp(), value);
    }

    private Result createCDCResult(byte[] indexRowKey, Cell firstCell, long timestamp, byte[] value) {
        CellBuilder builder = CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY);
        return Result.create(Collections.singletonList(builder.setRow(indexRowKey).setFamily(ImmutableBytesPtr.cloneCellFamilyIfNecessary((Cell)firstCell)).setQualifier(this.cdcDataTableInfo.getCdcJsonColQualBytes()).setTimestamp(timestamp).setValue(value).setType(Cell.Type.Put).build()));
    }

    private Object getColumnValue(Cell cell, PDataType dataType) {
        return this.getColumnValue(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength(), dataType);
    }

    private Object getColumnValue(byte[] cellValue, int offset, int length, PDataType dataType) {
        Object value = CDCUtil.isBinaryType((PDataType)dataType) ? ImmutableBytesPtr.copyBytesIfNecessary((byte[])cellValue, (int)offset, (int)length) : (Object)dataType.toObject(cellValue, offset, length);
        return CDCUtil.getColumnEncodedValue((Object)value, (PDataType)dataType);
    }

    private boolean handlePreImageCDCEvent(List<Cell> indexRow, byte[] indexRowKey, Cell indexCell, List<Cell> result) throws IOException {
        Cell cdcDataCell = null;
        for (Cell cell : indexRow) {
            if (!Bytes.equals((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])QueryConstants.CDC_IMAGE_CQ_BYTES, (int)0, (int)QueryConstants.CDC_IMAGE_CQ_BYTES.length)) continue;
            cdcDataCell = cell;
            break;
        }
        if (cdcDataCell == null) {
            return false;
        }
        byte[] cdcEventBytes = CellUtil.cloneValue(cdcDataCell);
        if (!this.changeBuilder.isPreImageInScope()) {
            Map cdcJson = (Map)JacksonUtil.getObjectReader(HashMap.class).readValue(cdcEventBytes);
            cdcJson.remove("pre_image");
            cdcEventBytes = JacksonUtil.getObjectWriter(HashMap.class).writeValueAsBytes((Object)cdcJson);
        }
        Result cdcRow = this.createCDCResult(indexRowKey, indexCell, cdcDataCell.getTimestamp(), cdcEventBytes);
        if (this.tupleProjector != null) {
            result.add(indexCell);
            IndexUtil.addTupleAsOneCell(result, (Tuple)new ResultTuple(cdcRow), (TupleProjector)this.tupleProjector, (ImmutableBytesWritable)this.ptr);
        } else {
            result.clear();
        }
        LOGGER.debug("Processed CDC event with embedded data, skipped data table scan for row key: {}", (Object)Bytes.toStringBinary((byte[])indexRowKey));
        return true;
    }
}

