/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanOptions;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.ScannerContextUtil;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.htrace.Span;
import org.apache.htrace.Trace;
import org.apache.phoenix.coprocessor.DelegateRegionScanner;
import org.apache.phoenix.coprocessor.PagingRegionScanner;
import org.apache.phoenix.coprocessor.TTLRegionScanner;
import org.apache.phoenix.coprocessorclient.BaseScannerRegionObserverConstants;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.filter.PagingFilter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.iterate.NonAggregateRegionScannerFactory;
import org.apache.phoenix.schema.StaleRegionBoundaryCacheException;
import org.apache.phoenix.util.CDCUtil;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.ScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseScannerRegionObserver
implements RegionObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseScannerRegionObserver.class);

    public String toString() {
        return this.getClass().getName();
    }

    private static void throwIfScanOutOfRegion(Scan scan, Region region) throws DoNotRetryIOException {
        boolean isStaleRegionBoundaries;
        boolean isLocalIndex = ScanUtil.isLocalIndex((Scan)scan);
        byte[] lowerInclusiveScanKey = scan.getStartRow();
        byte[] upperExclusiveScanKey = scan.getStopRow();
        byte[] lowerInclusiveRegionKey = region.getRegionInfo().getStartKey();
        byte[] upperExclusiveRegionKey = region.getRegionInfo().getEndKey();
        if (isLocalIndex) {
            byte[] expectedUpperRegionKey = scan.getAttribute("_ExpectedUpperRegionKey") == null ? scan.getStopRow() : scan.getAttribute("_ExpectedUpperRegionKey");
            byte[] actualStartRow = scan.getAttribute("_ScanActualStartRow");
            isStaleRegionBoundaries = expectedUpperRegionKey != null && Bytes.compareTo((byte[])upperExclusiveRegionKey, (byte[])expectedUpperRegionKey) != 0 || actualStartRow != null && Bytes.compareTo((byte[])actualStartRow, (byte[])lowerInclusiveRegionKey) < 0;
        } else if (scan.isReversed()) {
            isStaleRegionBoundaries = Bytes.compareTo((byte[])upperExclusiveScanKey, (byte[])lowerInclusiveRegionKey) < 0 || Bytes.compareTo((byte[])lowerInclusiveScanKey, (byte[])upperExclusiveRegionKey) > 0 && upperExclusiveRegionKey.length != 0 || upperExclusiveRegionKey.length != 0 && lowerInclusiveScanKey.length == 0;
        } else {
            boolean bl = isStaleRegionBoundaries = Bytes.compareTo((byte[])lowerInclusiveScanKey, (byte[])lowerInclusiveRegionKey) < 0 || Bytes.compareTo((byte[])upperExclusiveScanKey, (byte[])upperExclusiveRegionKey) > 0 && upperExclusiveRegionKey.length != 0 || upperExclusiveRegionKey.length != 0 && upperExclusiveScanKey.length == 0;
        }
        if (isStaleRegionBoundaries) {
            LOGGER.error("Throwing StaleRegionBoundaryCacheException due to mismatched scan boundaries. Region: {} , lowerInclusiveScanKey: {} , upperExclusiveScanKey: {} , lowerInclusiveRegionKey: {} , upperExclusiveRegionKey: {} , scan reversed: {}", new Object[]{region.getRegionInfo().getRegionNameAsString(), Bytes.toStringBinary((byte[])lowerInclusiveScanKey), Bytes.toStringBinary((byte[])upperExclusiveScanKey), Bytes.toStringBinary((byte[])lowerInclusiveRegionKey), Bytes.toStringBinary((byte[])upperExclusiveRegionKey), scan.isReversed()});
            StaleRegionBoundaryCacheException cause = new StaleRegionBoundaryCacheException(region.getRegionInfo().getTable().getNameAsString());
            throw new DoNotRetryIOException(cause.getMessage(), (Throwable)cause);
        }
        if (isLocalIndex) {
            ScanUtil.setupLocalIndexScan((Scan)scan);
        }
    }

    protected abstract boolean isRegionObserverFor(Scan var1);

    protected abstract RegionScanner doPostScannerOpen(ObserverContext<RegionCoprocessorEnvironment> var1, Scan var2, RegionScanner var3) throws Throwable;

    protected boolean skipRegionBoundaryCheck(Scan scan) {
        byte[] skipCheckBytes = scan.getAttribute("_SKIP_REGION_BOUNDARY_CHECK");
        return skipCheckBytes != null && Bytes.toBoolean((byte[])skipCheckBytes);
    }

    public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan) throws IOException {
        byte[] cdcScan;
        byte[] txnScn = scan.getAttribute("_TxScn");
        if (txnScn != null) {
            TimeRange timeRange = scan.getTimeRange();
            scan.setTimeRange(timeRange.getMin(), Bytes.toLong((byte[])txnScn));
        }
        if (!scan.isRaw() && (cdcScan = scan.getAttribute("_CdcDataTableDef")) != null) {
            CDCUtil.setupScanForCDC((Scan)scan);
            ScanUtil.adjustScanFilterForCDC((Scan)scan);
        }
        if (this.isRegionObserverFor(scan)) {
            byte[] pageSizeMsBytes;
            if (!this.skipRegionBoundaryCheck(scan) || ScanUtil.isLocalIndex((Scan)scan)) {
                BaseScannerRegionObserver.throwIfScanOutOfRegion(scan, ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion());
            }
            ScanUtil.setupReverseScan((Scan)scan);
            if (!(scan.getFilter() instanceof PagingFilter) && (pageSizeMsBytes = scan.getAttribute("_ServerPageSizeMs")) != null) {
                scan.setFilter((Filter)new PagingFilter(scan.getFilter(), ScanUtil.getPageSizeMsForFilter((Scan)scan)));
            }
        }
    }

    public final RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        try {
            if (!this.isRegionObserverFor(scan)) {
                return s;
            }
            byte[] emptyCF = scan.getAttribute("_EmptyCFName");
            byte[] emptyCQ = scan.getAttribute("_EmptyCQName");
            if (s instanceof DelegateRegionScanner) {
                return new RegionScannerHolder(c, scan, s);
            }
            if (emptyCF != null && emptyCQ != null) {
                return new RegionScannerHolder(c, scan, new TTLRegionScanner((RegionCoprocessorEnvironment)c.getEnvironment(), scan, new PagingRegionScanner(((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion(), s, scan)));
            }
            return new RegionScannerHolder(c, scan, new PagingRegionScanner(((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion(), s, scan));
        }
        catch (Throwable t) {
            if (t instanceof NotServingRegionException) {
                LOGGER.error("postScannerOpen error for region {} . Thorwing it as StaleRegionBoundaryCacheException", (Object)s.getRegionInfo().getRegionNameAsString(), (Object)t);
                StaleRegionBoundaryCacheException cause = new StaleRegionBoundaryCacheException(((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getTable().getNameAsString());
                throw new DoNotRetryIOException(cause.getMessage(), (Throwable)cause);
            }
            LOGGER.error("postScannerOpen error for region {}", (Object)s.getRegionInfo().getRegionNameAsString(), (Object)t);
            ClientUtil.throwIOException((String)((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getRegionNameAsString(), (Throwable)t);
            return null;
        }
    }

    RegionScanner getWrappedScanner(ObserverContext<RegionCoprocessorEnvironment> c, RegionScanner s, int offset, Scan scan, ColumnReference[] dataColumns, TupleProjector tupleProjector, Region dataRegion, IndexMaintainer indexMaintainer, byte[][] viewConstants, TupleProjector projector, ImmutableBytesWritable ptr, boolean useQualiferAsListIndex) throws IOException {
        NonAggregateRegionScannerFactory regionScannerFactory = new NonAggregateRegionScannerFactory((RegionCoprocessorEnvironment)c.getEnvironment());
        return regionScannerFactory.getWrappedScanner((RegionCoprocessorEnvironment)c.getEnvironment(), s, null, null, offset, scan, dataColumns, tupleProjector, dataRegion, indexMaintainer, null, viewConstants, null, null, projector, ptr, useQualiferAsListIndex);
    }

    public void setScanOptionsForFlushesAndCompactions(ScanOptions options) {
        options.setKeepDeletedCells(KeepDeletedCells.TTL);
        options.setTTL(Integer.MAX_VALUE);
        options.setMaxVersions(Integer.MAX_VALUE);
        options.setMinVersions(Integer.MAX_VALUE);
    }

    public void preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ScanType scanType, ScanOptions options, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
        Configuration conf = ((RegionCoprocessorEnvironment)c.getEnvironment()).getConfiguration();
        if (BaseScannerRegionObserver.isPhoenixCompactionEnabled(conf)) {
            this.setScanOptionsForFlushesAndCompactions(options);
            return;
        }
        if (BaseScannerRegionObserver.isMaxLookbackTimeEnabled(conf)) {
            this.setScanOptionsForFlushesAndCompactionsWhenPhoenixTTLIsDisabled(conf, options, store, scanType);
        }
    }

    public void preFlushScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ScanOptions options, FlushLifeCycleTracker tracker) throws IOException {
        Configuration conf = ((RegionCoprocessorEnvironment)c.getEnvironment()).getConfiguration();
        if (BaseScannerRegionObserver.isPhoenixCompactionEnabled(conf)) {
            this.setScanOptionsForFlushesAndCompactions(options);
            return;
        }
        if (BaseScannerRegionObserver.isMaxLookbackTimeEnabled(conf)) {
            this.setScanOptionsForFlushesAndCompactionsWhenPhoenixTTLIsDisabled(conf, options, store, ScanType.COMPACT_RETAIN_DELETES);
        }
    }

    public void preMemStoreCompactionCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ScanOptions options) throws IOException {
        Configuration conf = ((RegionCoprocessorEnvironment)c.getEnvironment()).getConfiguration();
        if (BaseScannerRegionObserver.isPhoenixCompactionEnabled(conf)) {
            this.setScanOptionsForFlushesAndCompactions(options);
            return;
        }
        if (BaseScannerRegionObserver.isMaxLookbackTimeEnabled(conf)) {
            MemoryCompactionPolicy inMemPolicy = store.getColumnFamilyDescriptor().getInMemoryCompaction();
            ScanType scanType = inMemPolicy.equals((Object)MemoryCompactionPolicy.EAGER) || inMemPolicy.equals((Object)MemoryCompactionPolicy.ADAPTIVE) ? ScanType.COMPACT_DROP_DELETES : ScanType.COMPACT_RETAIN_DELETES;
            this.setScanOptionsForFlushesAndCompactionsWhenPhoenixTTLIsDisabled(conf, options, store, scanType);
        }
    }

    public void preStoreScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ScanOptions options) throws IOException {
        Configuration conf = ((RegionCoprocessorEnvironment)c.getEnvironment()).getConfiguration();
        if (BaseScannerRegionObserver.isPhoenixCompactionEnabled(conf)) {
            options.setKeepDeletedCells(KeepDeletedCells.TTL);
            options.setTTL(Long.MAX_VALUE);
            return;
        }
        if (!this.storeFileScanDoesntNeedAlteration(options)) {
            options.setMinVersions(options.getMinVersions());
            KeepDeletedCells keepDeletedCells = KeepDeletedCells.TRUE;
            if (store.getColumnFamilyDescriptor().getTimeToLive() != Integer.MAX_VALUE) {
                keepDeletedCells = KeepDeletedCells.TTL;
            }
            options.setKeepDeletedCells(keepDeletedCells);
        }
    }

    private boolean storeFileScanDoesntNeedAlteration(ScanOptions options) {
        Scan scan = options.getScan();
        boolean isRaw = scan.isRaw();
        boolean keepDeletedCells = options.getKeepDeletedCells().equals((Object)KeepDeletedCells.TRUE) || options.getKeepDeletedCells().equals((Object)KeepDeletedCells.TTL);
        boolean timeRangeIsLatest = scan.getTimeRange().getMax() == Long.MAX_VALUE;
        boolean timestampIsTransactional = this.isTransactionalTimestamp(scan.getTimeRange().getMax());
        return isRaw || keepDeletedCells || timeRangeIsLatest || timestampIsTransactional;
    }

    private boolean isTransactionalTimestamp(long ts) {
        return ts > (long)((double)EnvironmentEdgeManager.currentTime() * 1.1);
    }

    public KeepDeletedCells getKeepDeletedCells(ScanOptions options, ScanType scanType) {
        return options.getKeepDeletedCells() == KeepDeletedCells.TRUE || scanType.equals((Object)ScanType.COMPACT_RETAIN_DELETES) ? KeepDeletedCells.TRUE : KeepDeletedCells.TTL;
    }

    public int getMinVersions(ScanOptions options, ColumnFamilyDescriptor cfDescriptor) {
        return cfDescriptor.getTimeToLive() != Integer.MAX_VALUE ? options.getMinVersions() : Math.max(Math.max(options.getMinVersions(), cfDescriptor.getMaxVersions()), 1);
    }

    public long getTimeToLiveForCompactions(Configuration conf, ColumnFamilyDescriptor columnDescriptor, ScanOptions options) {
        long ttlConfigured = columnDescriptor.getTimeToLive();
        long ttlInMillis = ttlConfigured * 1000L;
        long maxLookbackTtl = BaseScannerRegionObserverConstants.getMaxLookbackInMillis((Configuration)conf);
        if (BaseScannerRegionObserver.isMaxLookbackTimeEnabled(maxLookbackTtl)) {
            ttlInMillis = ttlConfigured == Integer.MAX_VALUE && columnDescriptor.getKeepDeletedCells() != KeepDeletedCells.TRUE ? maxLookbackTtl : Math.max(ttlInMillis, maxLookbackTtl);
        }
        return ttlInMillis;
    }

    public void setScanOptionsForFlushesAndCompactionsWhenPhoenixTTLIsDisabled(Configuration conf, ScanOptions options, Store store, ScanType type) {
        ColumnFamilyDescriptor cfDescriptor = store.getColumnFamilyDescriptor();
        options.setTTL(this.getTimeToLiveForCompactions(conf, cfDescriptor, options));
        options.setKeepDeletedCells(this.getKeepDeletedCells(options, type));
        options.setMaxVersions(Integer.MAX_VALUE);
        options.setMinVersions(this.getMinVersions(options, cfDescriptor));
    }

    public static boolean isMaxLookbackTimeEnabled(Configuration conf) {
        return BaseScannerRegionObserver.isMaxLookbackTimeEnabled(conf.getLong("phoenix.max.lookback.age.seconds", 0L));
    }

    public static boolean isMaxLookbackTimeEnabled(long maxLookbackTime) {
        return maxLookbackTime > 0L;
    }

    public static boolean isPhoenixCompactionEnabled(Configuration conf) {
        return conf.getBoolean("phoenix.table.ttl.enabled", true) && conf.getBoolean("phoenix.compaction.enabled", true);
    }

    private class RegionScannerHolder
    extends DelegateRegionScanner {
        private final Scan scan;
        private final ObserverContext<RegionCoprocessorEnvironment> c;
        private boolean wasOverriden;

        public RegionScannerHolder(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner scanner) {
            super(scanner);
            this.c = c;
            this.scan = scan;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void overrideDelegate() throws IOException {
            if (this.wasOverriden) {
                return;
            }
            boolean success = false;
            Span savedSpan = Trace.currentSpan();
            final Span child = Trace.startSpan((String)"Scanner opened on server", (Span)savedSpan).getSpan();
            try {
                RegionScanner scanner = BaseScannerRegionObserver.this.doPostScannerOpen(this.c, this.scan, this.delegate);
                this.delegate = scanner = new DelegateRegionScanner(scanner){

                    @Override
                    public void close() throws IOException {
                        try {
                            this.delegate.close();
                        }
                        finally {
                            if (child != null) {
                                child.stop();
                            }
                        }
                    }
                };
                this.wasOverriden = true;
                success = true;
            }
            catch (Throwable t) {
                ClientUtil.throwIOException((String)((RegionCoprocessorEnvironment)this.c.getEnvironment()).getRegionInfo().getRegionNameAsString(), (Throwable)t);
            }
            finally {
                try {
                    if (!success && child != null) {
                        child.stop();
                    }
                }
                finally {
                    Trace.continueSpan((Span)savedSpan);
                }
            }
        }

        @Override
        public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
            this.overrideDelegate();
            boolean res = super.next(result, scannerContext);
            ScannerContextUtil.incrementSizeProgress(scannerContext, result);
            return res;
        }

        @Override
        public boolean next(List<Cell> result) throws IOException {
            this.overrideDelegate();
            return super.next(result);
        }

        @Override
        public boolean nextRaw(List<Cell> result, ScannerContext scannerContext) throws IOException {
            this.overrideDelegate();
            boolean res = super.nextRaw(result, scannerContext);
            ScannerContextUtil.incrementSizeProgress(scannerContext, result);
            return res;
        }

        @Override
        public boolean nextRaw(List<Cell> result) throws IOException {
            this.overrideDelegate();
            return super.nextRaw(result);
        }

        @Override
        public RegionScanner getNewRegionScanner(Scan scan) throws IOException {
            try {
                return new RegionScannerHolder(this.c, scan, ((DelegateRegionScanner)this.delegate).getNewRegionScanner(scan));
            }
            catch (ClassCastException e) {
                throw new DoNotRetryIOException((Throwable)e);
            }
        }
    }
}

