/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.regionserver.DataTableLocalIndexRegionScanner;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.RepairUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexHalfStoreFileReaderGenerator
implements RegionObserver,
RegionCoprocessor {
    private static final String LOCAL_INDEX_AUTOMATIC_REPAIR = "local.index.automatic.repair";
    public static final Logger LOGGER = LoggerFactory.getLogger(IndexHalfStoreFileReaderGenerator.class);

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    /*
     * Exception decompiling
     */
    public StoreFileReader preStoreFileReaderOpen(ObserverContext<RegionCoprocessorEnvironment> ctx, FileSystem fs, Path p, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Reference r, StoreFileReader reader) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 43[SIMPLE_IF_ELSE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner s, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
        if (!this.isLocalIndexStore(store)) {
            return s;
        }
        if (!store.hasReferences()) {
            InternalScanner repairScanner = null;
            if (request.isMajor() && !RepairUtil.isLocalIndexStoreFilesConsistent((RegionCoprocessorEnvironment)c.getEnvironment(), store)) {
                LOGGER.info("we have found inconsistent data for local index for region:" + ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo());
                if (((RegionCoprocessorEnvironment)c.getEnvironment()).getConfiguration().getBoolean(LOCAL_INDEX_AUTOMATIC_REPAIR, true)) {
                    LOGGER.info("Starting automatic repair of local Index for region:" + ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo());
                    repairScanner = this.getRepairScanner((RegionCoprocessorEnvironment)c.getEnvironment(), store);
                }
            }
            if (repairScanner != null) {
                if (s != null) {
                    s.close();
                }
                return repairScanner;
            }
            return s;
        }
        return s;
    }

    private byte[][] getViewConstants(PTable dataTable) {
        int dataPosOffset = (dataTable.getBucketNum() != null ? 1 : 0) + (dataTable.isMultiTenant() ? 1 : 0);
        Object viewConstants = null;
        int nViewConstants = 0;
        if (dataTable.getType() == PTableType.VIEW) {
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            List dataPkColumns = dataTable.getPKColumns();
            for (int i = dataPosOffset; i < dataPkColumns.size(); ++i) {
                PColumn dataPKColumn = (PColumn)dataPkColumns.get(i);
                if (dataPKColumn.getViewConstant() == null) continue;
                ++nViewConstants;
            }
            if (nViewConstants > 0) {
                viewConstants = new byte[nViewConstants][];
                int j = 0;
                for (int i = dataPosOffset; i < dataPkColumns.size(); ++i) {
                    PColumn dataPkColumn = (PColumn)dataPkColumns.get(i);
                    if (dataPkColumn.getViewConstant() == null) continue;
                    if (IndexUtil.getViewConstantValue((PColumn)dataPkColumn, (ImmutableBytesWritable)ptr)) {
                        viewConstants[j++] = ByteUtil.copyKeyBytesIfNecessary((ImmutableBytesWritable)ptr);
                        continue;
                    }
                    throw new IllegalStateException();
                }
            }
        }
        return viewConstants;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InternalScanner getRepairScanner(RegionCoprocessorEnvironment env, Store store) throws IOException {
        Scan scan = new Scan();
        scan.readVersions(store.getColumnFamilyDescriptor().getMaxVersions());
        for (Store s : env.getRegion().getStores()) {
            if (this.isLocalIndexStore(s)) continue;
            scan.addFamily(s.getColumnFamilyDescriptor().getName());
        }
        try (PhoenixConnection conn = QueryUtil.getConnectionOnServer((Configuration)env.getConfiguration()).unwrap(PhoenixConnection.class);){
            PTable dataPTable = IndexUtil.getPDataTable((PhoenixConnection)conn, (TableDescriptor)env.getRegion().getTableDescriptor());
            ArrayList maintainers = Lists.newArrayListWithExpectedSize((int)dataPTable.getIndexes().size());
            for (PTable index : dataPTable.getIndexes()) {
                if (index.getIndexType() != PTable.IndexType.LOCAL) continue;
                maintainers.add(index.getIndexMaintainer(dataPTable, conn));
            }
            DataTableLocalIndexRegionScanner dataTableLocalIndexRegionScanner = new DataTableLocalIndexRegionScanner(env.getRegion().getScanner(scan), env.getRegion(), maintainers, store.getColumnFamilyDescriptor().getName(), env.getConfiguration());
            return dataTableLocalIndexRegionScanner;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    private boolean isLocalIndexStore(Store store) {
        return store.getColumnFamilyDescriptor().getNameAsString().startsWith("L#");
    }
}

