/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessorclient.TableInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.DropTableStatement;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.TableViewFinderResult;
import org.apache.phoenix.util.ViewUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerViewUtil
extends ViewUtil {
    private static final Logger logger = LoggerFactory.getLogger(ServerViewUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropChildViews(RegionCoprocessorEnvironment env, byte[] tenantIdBytes, byte[] schemaName, byte[] tableOrViewName, byte[] sysCatOrSysChildLink) throws IOException, SQLException {
        TableViewFinderResult childViewsResult;
        Table hTable = null;
        try {
            hTable = ServerUtil.getHTableForCoprocessorScan(env, SchemaUtil.getPhysicalTableName((byte[])sysCatOrSysChildLink, (Configuration)env.getConfiguration()));
        }
        catch (Exception e) {
            logger.error("ServerUtil.getHTableForCoprocessorScan error!", (Throwable)e);
        }
        if (hTable == null) {
            return;
        }
        try {
            childViewsResult = ViewUtil.findImmediateRelatedViews((Table)hTable, (byte[])tenantIdBytes, (byte[])schemaName, (byte[])tableOrViewName, (PTable.LinkType)PTable.LinkType.CHILD_TABLE, (long)Long.MAX_VALUE);
        }
        finally {
            hTable.close();
        }
        for (TableInfo viewInfo : childViewsResult.getLinks()) {
            byte[] viewTenantId = viewInfo.getTenantId();
            byte[] viewSchemaName = viewInfo.getSchemaName();
            byte[] viewName = viewInfo.getTableName();
            if (logger.isDebugEnabled()) {
                logger.debug("dropChildViews : " + Bytes.toString((byte[])schemaName) + "." + Bytes.toString((byte[])tableOrViewName) + " -> " + Bytes.toString((byte[])viewSchemaName) + "." + Bytes.toString((byte[])viewName) + "with tenant id :" + Bytes.toString((byte[])viewTenantId));
            }
            Properties props = new Properties();
            PTable view = null;
            if (viewTenantId != null && viewTenantId.length != 0) {
                props.setProperty("TenantId", Bytes.toString((byte[])viewTenantId));
            }
            PhoenixConnection connection = QueryUtil.getConnectionOnServer((Properties)props, (Configuration)env.getConfiguration()).unwrap(PhoenixConnection.class);
            try {
                try {
                    view = connection.getTableNoCache(SchemaUtil.getTableName((byte[])viewSchemaName, (byte[])viewName));
                }
                catch (TableNotFoundException expected) {
                    logger.info("Found an expected orphan parent->child link keyed by the parent. Parent Tenant Id: '" + Bytes.toString((byte[])tenantIdBytes) + "'. Parent Schema Name: '" + Bytes.toString((byte[])schemaName) + "'. Parent Table/View Name: '" + Bytes.toString((byte[])tableOrViewName) + "'. Will attempt to drop this child view with ViewInfo: '" + viewInfo + "'.");
                }
                if (view != null) {
                    logger.error("Found an orphan parent->child link keyed by this parent or its descendant. Parent Tenant Id: '" + Bytes.toString((byte[])tenantIdBytes) + "'. Parent Schema Name: '" + Bytes.toString((byte[])schemaName) + "'. Parent Table/View Name: '" + Bytes.toString((byte[])tableOrViewName) + "'. There currently exists a legitimate view of the same name whose parent hierarchy exists. View Info: '" + viewInfo + "'. Ignoring this view and not attempting to drop it.");
                    continue;
                }
                MetaDataClient client = new MetaDataClient(connection);
                TableName viewTableName = TableName.create((String)Bytes.toString((byte[])viewSchemaName), (String)Bytes.toString((byte[])viewName));
                try {
                    client.dropTable(new DropTableStatement(viewTableName, PTableType.VIEW, true, true, true));
                }
                catch (TableNotFoundException e) {
                    logger.info("Ignoring view " + viewTableName + " as it has already been dropped");
                }
            }
            finally {
                if (connection == null) continue;
                connection.close();
            }
        }
    }
}

