/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.CoprocessorDescriptor;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.ipc.controller.InterRegionServerIndexRpcControllerFactory;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerUtil.class);
    private static final String FORMAT_FOR_TIMESTAMP = ",serverTimestamp=%d,";

    public static boolean hasCoprocessor(RegionCoprocessorEnvironment env, String CoprocessorClassName) {
        Collection coprocessors = env.getRegion().getTableDescriptor().getCoprocessorDescriptors();
        for (CoprocessorDescriptor coprocessor : coprocessors) {
            if (!coprocessor.getClassName().equals(CoprocessorClassName)) continue;
            return true;
        }
        return false;
    }

    private static Table getTableFromSingletonPool(RegionCoprocessorEnvironment env, TableName tableName) throws IOException {
        Connection conn = ConnectionFactory.getConnection(ConnectionType.DEFAULT_SERVER_CONNECTION, env);
        try {
            return conn.getTable(tableName);
        }
        catch (RuntimeException t) {
            if (t.getCause() instanceof IOException) {
                throw (IOException)t.getCause();
            }
            throw t;
        }
    }

    public static Table getHTableForCoprocessorScan(RegionCoprocessorEnvironment env, Table writerTable) throws IOException {
        return ServerUtil.getTableFromSingletonPool(env, writerTable.getName());
    }

    public static Table getHTableForCoprocessorScan(RegionCoprocessorEnvironment env, TableName tableName) throws IOException {
        return ServerUtil.getTableFromSingletonPool(env, tableName);
    }

    public static DoNotRetryIOException wrapInDoNotRetryIOException(String msg, Throwable t, long timestamp) {
        if (msg == null) {
            msg = "";
        }
        if (t instanceof SQLException) {
            msg = t.getMessage() + " " + (String)msg;
        }
        msg = (String)msg + String.format(FORMAT_FOR_TIMESTAMP, timestamp);
        return new DoNotRetryIOException((String)msg, t);
    }

    public static boolean readyToCommit(int rowCount, long mutationSize, int maxBatchSize, long maxBatchSizeBytes) {
        return maxBatchSize > 0 && rowCount >= maxBatchSize || maxBatchSizeBytes > 0L && mutationSize >= maxBatchSizeBytes;
    }

    public static boolean isKeyInRegion(byte[] key, Region region) {
        byte[] startKey = region.getRegionInfo().getStartKey();
        byte[] endKey = region.getRegionInfo().getEndKey();
        return Bytes.compareTo((byte[])startKey, (byte[])key) <= 0 && (Bytes.compareTo((byte[])HConstants.LAST_ROW, (byte[])endKey) == 0 || Bytes.compareTo((byte[])key, (byte[])endKey) < 0);
    }

    public static Region.RowLock acquireLock(Region region, byte[] key, List<Region.RowLock> locks) throws IOException {
        Region.RowLock rowLock = region.getRowLock(key, false);
        if (rowLock == null) {
            throw new IOException("Failed to acquire lock on " + Bytes.toStringBinary((byte[])key));
        }
        if (locks != null) {
            locks.add(rowLock);
        }
        return rowLock;
    }

    public static void releaseRowLocks(List<Region.RowLock> rowLocks) {
        if (rowLocks != null) {
            for (Region.RowLock rowLock : rowLocks) {
                rowLock.release();
            }
            rowLocks.clear();
        }
    }

    public static byte[] getScanStartRowKeyFromScanOrRegionBoundaries(Scan scan, Region region) {
        return scan.getStartRow().length > 0 ? scan.getStartRow() : (scan.isReversed() ? region.getRegionInfo().getEndKey() : region.getRegionInfo().getStartKey());
    }

    public static Configuration getCompactionConfig(Configuration conf) {
        Configuration compactionConfig = PropertiesUtil.cloneConfig((Configuration)conf);
        compactionConfig.setInt("hbase.client.retries.number", conf.getInt("phoenix.metadata.rpc.retries.number", 20));
        compactionConfig.setInt("hbase.client.pause", conf.getInt("phoenix.metadata.rpc.pause", 100));
        return compactionConfig;
    }

    public static Configuration getIndexWriterConnection(Configuration conf) {
        Configuration clonedConfig = PropertiesUtil.cloneConfig((Configuration)conf);
        clonedConfig.setClass("hbase.rpc.controllerfactory.class", InterRegionServerIndexRpcControllerFactory.class, RpcControllerFactory.class);
        clonedConfig.setInt("hbase.client.retries.number", conf.getInt("phoenix.index.writes.rpc.retries.number", 11));
        clonedConfig.setInt("hbase.client.pause", conf.getInt("phoenix.index.writes.rpc.pause", 100));
        return clonedConfig;
    }

    public static Configuration getIndexWriterConfigurationWithCustomThreads(Configuration conf) {
        Configuration clonedConfig = ServerUtil.getIndexWriterConnection(conf);
        ServerUtil.setHTableThreads(clonedConfig);
        return clonedConfig;
    }

    private static void setHTableThreads(Configuration conf) {
        int htableThreads = conf.getInt("index.writer.threads.pertable.max", Integer.MAX_VALUE);
        IndexManagementUtil.setIfNotSet((Configuration)conf, (String)"hbase.htable.threads.max", (int)htableThreads);
    }

    public static Configuration getNoRetriesIndexWriterConfigurationWithCustomThreads(Configuration conf) {
        Configuration clonedConf = ServerUtil.getIndexWriterConfigurationWithCustomThreads(conf);
        clonedConf.setInt("hbase.client.retries.number", 1);
        return clonedConf;
    }

    public static <T> Throwable getExceptionFromFailedFuture(Future<T> f) {
        Exception t = null;
        try {
            f.get();
        }
        catch (Exception e) {
            t = e;
        }
        return t;
    }

    public static enum ConnectionType {
        COMPACTION_CONNECTION,
        INDEX_WRITER_CONNECTION,
        INDEX_WRITER_CONNECTION_WITH_CUSTOM_THREADS,
        INDEX_WRITER_CONNECTION_WITH_CUSTOM_THREADS_NO_RETRIES,
        DEFAULT_SERVER_CONNECTION;

    }

    public static class ConnectionFactory {
        private static Map<ConnectionType, Connection> connections = new ConcurrentHashMap<ConnectionType, Connection>();

        public static Connection getConnection(ConnectionType connectionType, final RegionCoprocessorEnvironment env) {
            return connections.computeIfAbsent(connectionType, new Function<ConnectionType, Connection>(){

                @Override
                public Connection apply(ConnectionType t) {
                    try {
                        return env.createConnection(ConnectionFactory.getTypeSpecificConfiguration(t, env.getConfiguration()));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public static Configuration getTypeSpecificConfiguration(ConnectionType connectionType, Configuration conf) {
            switch (connectionType) {
                case COMPACTION_CONNECTION: {
                    return ServerUtil.getCompactionConfig(conf);
                }
                case DEFAULT_SERVER_CONNECTION: {
                    return conf;
                }
                case INDEX_WRITER_CONNECTION: {
                    return ServerUtil.getIndexWriterConnection(conf);
                }
                case INDEX_WRITER_CONNECTION_WITH_CUSTOM_THREADS: {
                    return ServerUtil.getIndexWriterConfigurationWithCustomThreads(conf);
                }
                case INDEX_WRITER_CONNECTION_WITH_CUSTOM_THREADS_NO_RETRIES: {
                    return ServerUtil.getNoRetriesIndexWriterConfigurationWithCustomThreads(conf);
                }
            }
            return conf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void shutdown() {
            Class<ConnectionFactory> clazz = ConnectionFactory.class;
            synchronized (ConnectionFactory.class) {
                LOGGER.info("Closing ServerUtil.ConnectionFactory connections");
                for (Connection connection : connections.values()) {
                    try {
                        connection.close();
                    }
                    catch (IOException e) {
                        LOGGER.warn("Unable to close coprocessor connection", (Throwable)e);
                    }
                }
                connections.clear();
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        public static int getConnectionsCount() {
            return connections.size();
        }
    }
}

