/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.RawCell;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.phoenix.hbase.index.OffsetCell;

public class ServerIndexUtil {
    public static void writeLocalUpdates(Region region, List<Mutation> mutations, boolean skipWAL) throws IOException {
        if (skipWAL) {
            for (Mutation m : mutations) {
                m.setDurability(Durability.SKIP_WAL);
            }
        }
        region.batchMutate(mutations.toArray(new Mutation[mutations.size()]));
    }

    public static void wrapResultUsingOffset(List<Cell> result, int offset) throws IOException {
        ListIterator<Cell> itr = result.listIterator();
        while (itr.hasNext()) {
            Cell cell = itr.next();
            OffsetCell newCell = new OffsetCell(cell, offset);
            itr.set((Cell)newCell);
        }
    }

    public static void setDeleteAttributes(MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            byte[] sourceOpAttr;
            Mutation m = (Mutation)miniBatchOp.getOperation(i);
            if (!(m instanceof Delete) || (sourceOpAttr = m.getAttribute("phoenix.source.operation")) == null) continue;
            ArrayBackedTag sourceOpTag = new ArrayBackedTag(65, sourceOpAttr);
            ArrayList<Cell> updatedCells = new ArrayList<Cell>();
            CellScanner cellScanner = m.cellScanner();
            while (cellScanner.advance()) {
                Cell cell = cellScanner.current();
                RawCell rawCell = (RawCell)cell;
                ArrayList<Object> tags = new ArrayList<Object>();
                Iterator tagsIterator = rawCell.getTags();
                while (tagsIterator.hasNext()) {
                    tags.add((Tag)tagsIterator.next());
                }
                tags.add(sourceOpTag);
                Cell updatedCell = PrivateCellUtil.createCell((Cell)cell, tags);
                updatedCells.add(updatedCell);
            }
            m.getFamilyCellMap().clear();
            for (Cell cell : updatedCells) {
                Delete d = (Delete)m;
                d.add(cell);
            }
        }
    }
}

