/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixMRJobUtil {
    private static final String YARN_LEADER_ELECTION = "/yarn-leader-election";
    private static final String ACTIVE_STANDBY_ELECTOR_LOCK = "ActiveStandbyElectorLock";
    private static final String RM_APPS_GET_ENDPOINT = "/ws/v1/cluster/apps";
    public static final String PHOENIX_INDEX_MR_QUEUE_NAME_PROPERTY = "phoenix.index.mr.scheduler.capacity.queuename";
    public static final String PHOENIX_INDEX_MR_MAP_MEMORY_PROPERTY = "phoenix.index.mr.scheduler.capacity.mapMemoryMB";
    public static final String PHOENIX_MR_CONCURRENT_MAP_LIMIT_PROPERTY = "phoenix.mr.concurrent.map.limit";
    public static final String DEFAULT_QUEUE_NAME = "default";
    public static final int DEFAULT_MR_CONCURRENT_MAP_LIMIT = 20;
    public static final int DEFAULT_MAP_MEMROY_MB = 5120;
    public static final String XMX_OPT = "-Xmx";
    public static final String RM_HTTP_SCHEME = "http";
    public static final int RM_CONNECT_TIMEOUT_MILLIS = 10000;
    public static final int RM_READ_TIMEOUT_MILLIS = 600000;
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixMRJobUtil.class);
    public static final String PHOENIX_MR_SCHEDULER_TYPE_NAME = "phoenix.index.mr.scheduler.type";

    public static String getRMWebAddress(Configuration config) {
        return config.get("yarn.resourcemanager.webapp.address", "0.0.0.0:8088");
    }

    public static String getRMWebAddress(Configuration config, String Rmid) {
        return config.get("yarn.resourcemanager.webapp.address." + Rmid, "0.0.0.0:8088");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getActiveResourceManagerAddress(Configuration config, String zkQuorum) throws IOException, InterruptedException, KeeperException, InvalidProtocolBufferException, ZooKeeperConnectionException {
        ZKWatcher zkw = null;
        ZooKeeper zk = null;
        String activeRMHost = null;
        try {
            zkw = new ZKWatcher(config, "get-active-yarnmanager", null);
            zk = new ZooKeeper(zkQuorum, 30000, (Watcher)zkw, false);
            List children = zk.getChildren(YARN_LEADER_ELECTION, (Watcher)zkw);
            for (String subEntry : children) {
                List subChildern = zk.getChildren("/yarn-leader-election/" + subEntry, (Watcher)zkw);
                for (String eachEntry : subChildern) {
                    if (!eachEntry.contains(ACTIVE_STANDBY_ELECTOR_LOCK)) continue;
                    String path = "/yarn-leader-election/" + subEntry + "/ActiveStandbyElectorLock";
                    byte[] data = zk.getData(path, (Watcher)zkw, new Stat());
                    YarnServerResourceManagerServiceProtos.ActiveRMInfoProto proto = YarnServerResourceManagerServiceProtos.ActiveRMInfoProto.parseFrom((byte[])data);
                    String RmId = proto.getRmId();
                    LOGGER.info("Active RmId : " + RmId);
                    activeRMHost = PhoenixMRJobUtil.getRMWebAddress(config, RmId);
                    LOGGER.info("activeResourceManagerHostname = " + activeRMHost);
                }
            }
        }
        finally {
            if (zkw != null) {
                zkw.close();
            }
            if (zk != null) {
                zk.close();
            }
        }
        if (activeRMHost == null) {
            activeRMHost = PhoenixMRJobUtil.getRMWebAddress(config);
            LOGGER.info("ResourceManagerAddress from config = " + activeRMHost);
        }
        return activeRMHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJobsInformationFromRM(String rmAddress, Map<String, String> urlParams) throws MalformedURLException, ProtocolException, UnsupportedEncodingException, IOException {
        HttpURLConnection con = null;
        String response = null;
        String url = null;
        try {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append("http://").append(rmAddress).append(RM_APPS_GET_ENDPOINT);
            if (urlParams != null && urlParams.size() != 0) {
                urlBuilder.append("?");
                for (String key : urlParams.keySet()) {
                    urlBuilder.append(key + "=" + urlParams.get(key) + "&");
                }
                urlBuilder.delete(urlBuilder.length() - 1, urlBuilder.length());
            }
            url = urlBuilder.toString();
            LOGGER.info("Attempt to get running/submitted jobs information from RM URL = " + url);
            URL obj = new URL(url);
            con = (HttpURLConnection)obj.openConnection();
            con.setInstanceFollowRedirects(true);
            con.setRequestMethod("GET");
            con.setConnectTimeout(10000);
            con.setReadTimeout(600000);
            response = PhoenixMRJobUtil.getTextContent(con.getInputStream());
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        LOGGER.info("Result of attempt to get running/submitted jobs from RM - URL=" + url + ",ResponseCode=" + con.getResponseCode() + ",Response=" + response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTextContent(InputStream is) throws IOException {
        BufferedReader in = null;
        StringBuilder response = null;
        try {
            String inputLine;
            in = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine).append("\n");
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return response.toString();
    }

    public static void shutdown(ExecutorService pool) throws InterruptedException {
        pool.shutdown();
        LOGGER.debug("Shutdown called");
        pool.awaitTermination(200L, TimeUnit.MILLISECONDS);
        LOGGER.debug("Await termination called to wait for 200 msec");
        if (!pool.isShutdown()) {
            pool.shutdownNow();
            LOGGER.debug("Await termination called to wait for 200 msec");
            pool.awaitTermination(100L, TimeUnit.MILLISECONDS);
        }
        if (!pool.isShutdown()) {
            LOGGER.warn("Pool did not shutdown");
        }
    }

    public static void updateCapacityQueueInfo(Configuration conf) {
        conf.set("mapreduce.job.queuename", conf.get(PHOENIX_INDEX_MR_QUEUE_NAME_PROPERTY, DEFAULT_QUEUE_NAME));
        conf.setInt("mapreduce.job.running.map.limit", conf.getInt(PHOENIX_MR_CONCURRENT_MAP_LIMIT_PROPERTY, 20));
        int mapMemoryMB = conf.getInt(PHOENIX_INDEX_MR_MAP_MEMORY_PROPERTY, 5120);
        conf.setInt("mapreduce.map.memory.mb", mapMemoryMB);
        conf.set("mapreduce.map.java.opts", XMX_OPT + (int)((double)mapMemoryMB * 0.9) + "m");
        LOGGER.info("Queue Name=" + conf.get("mapreduce.job.queuename") + ";Map Meory MB=" + conf.get("mapreduce.map.memory.mb") + ";Map Java Opts=" + conf.get("mapreduce.map.java.opts"));
    }

    public static enum MR_SCHEDULER_TYPE {
        CAPACITY,
        FAIR,
        NONE;

    }
}

