/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.DefaultParser;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Option;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Options;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.ParseException;
import org.apache.phoenix.util.UpgradeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeViewIndexIdSequencesTool
extends Configured
implements Tool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MergeViewIndexIdSequencesTool.class);
    private static final Option HELP_OPTION = new Option("h", "help", false, "Help");
    private static final Option RUN_OPTION = new Option("r", "run", false, "Run MergeViewIndexIdSequencesTool to avoid view index id collision.");

    private Options getOptions() {
        Options options = new Options();
        options.addOption(RUN_OPTION);
        options.addOption(HELP_OPTION);
        return options;
    }

    private void parseOptions(String[] args) throws Exception {
        Options options = this.getOptions();
        DefaultParser parser = DefaultParser.builder().setAllowPartialMatching(false).setStripLeadingAndTrailingQuotes(Boolean.valueOf(false)).build();
        CommandLine cmdLine = null;
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            this.printHelpAndExit("Error parsing command line options: " + e.getMessage(), options);
        }
        if (cmdLine.hasOption(HELP_OPTION.getOpt())) {
            this.printHelpAndExit(options, 0);
        }
        if (!cmdLine.hasOption(RUN_OPTION.getOpt())) {
            this.printHelpAndExit("Please give at least one param", options);
        }
    }

    private void printHelpAndExit(Options options, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("help", options);
        System.exit(exitCode);
    }

    private void printHelpAndExit(String errorMessage, Options options) {
        System.err.println(errorMessage);
        this.printHelpAndExit(options, 1);
    }

    public int run(String[] args) throws Exception {
        int status = 0;
        this.parseOptions(args);
        Configuration config = HBaseConfiguration.addHbaseResources((Configuration)this.getConf());
        try (PhoenixConnection conn = ConnectionUtil.getInputConnection((Configuration)config).unwrap(PhoenixConnection.class);){
            UpgradeUtil.mergeViewIndexIdSequences((PhoenixConnection)conn);
        }
        catch (Exception e) {
            LOGGER.error("Get an error while running MergeViewIndexIdSequencesTool, " + e.getMessage());
            status = 1;
        }
        return status;
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run((Tool)new MergeViewIndexIdSequencesTool(), (String[])args);
        System.exit(result);
    }
}

