/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.transform;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessorclient.TableInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTool;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.schema.ColumnMetaDataOps;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.transform.SystemTransformRecord;
import org.apache.phoenix.schema.transform.TransformClient;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TableViewFinderResult;
import org.apache.phoenix.util.UpgradeUtil;
import org.apache.phoenix.util.ViewUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transform
extends TransformClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(Transform.class);

    public static PTable getTransformingNewTable(PhoenixConnection connection, PTable oldTable) throws SQLException {
        PName newTableNameWithoutSchema;
        SystemTransformRecord transformRecord = TransformClient.getTransformRecord((PhoenixConnection)connection, (PTableType)oldTable.getType(), (PName)oldTable.getSchemaName(), (PName)oldTable.getTableName(), (PName)(oldTable.getType() == PTableType.INDEX ? oldTable.getParentTableName() : null), (PName)oldTable.getTenantId(), (PName)oldTable.getBaseTableLogicalName());
        PTable transformingNewTable = null;
        if (transformRecord != null && transformRecord.isActive() && !(newTableNameWithoutSchema = PNameFactory.newName((String)SchemaUtil.getTableNameFromFullName((String)transformRecord.getNewPhysicalTableName()))).equals(oldTable.getPhysicalName(true))) {
            transformingNewTable = connection.getTableNoCache(transformRecord.getNewPhysicalTableName());
        }
        return transformingNewTable;
    }

    public static void updateNewTableState(PhoenixConnection connection, SystemTransformRecord systemTransformRecord, PIndexState state2) throws SQLException {
        String schema = SchemaUtil.getSchemaNameFromFullName((String)systemTransformRecord.getNewPhysicalTableName());
        String tableName = SchemaUtil.getTableNameFromFullName((String)systemTransformRecord.getNewPhysicalTableName());
        try (PreparedStatement tableUpsert = connection.prepareStatement(MetaDataClient.UPDATE_INDEX_STATE_TO_ACTIVE);){
            tableUpsert.setString(1, systemTransformRecord.getTenantId() == null ? null : systemTransformRecord.getTenantId());
            tableUpsert.setString(2, schema);
            tableUpsert.setString(3, tableName);
            tableUpsert.setString(4, state2.getSerializedValue());
            tableUpsert.setLong(5, 0L);
            tableUpsert.setLong(6, 0L);
            tableUpsert.execute();
        }
        UpgradeUtil.clearCache((PhoenixConnection)connection, (PName)connection.getTenantId(), (String)schema, (String)tableName, (String)systemTransformRecord.getLogicalParentName(), (long)0L);
    }

    public static void removeTransformRecord(SystemTransformRecord transformRecord, PhoenixConnection connection) throws SQLException {
        connection.prepareStatement("DELETE FROM  " + PhoenixDatabaseMetaData.SYSTEM_TRANSFORM_NAME + " WHERE " + (String)(Strings.isNullOrEmpty((String)transformRecord.getSchemaName()) ? "" : "TABLE_SCHEM ='" + transformRecord.getSchemaName() + "' AND ") + "LOGICAL_TABLE_NAME ='" + transformRecord.getLogicalTableName() + "' AND NEW_PHYS_TABLE_NAME ='" + transformRecord.getNewPhysicalTableName() + "' AND TRANSFORM_TYPE =" + transformRecord.getTransformType().getSerializedValue()).execute();
    }

    public static void doCutover(PhoenixConnection connection, SystemTransformRecord systemTransformRecord) throws Exception {
        String tenantId = systemTransformRecord.getTenantId();
        String schema = systemTransformRecord.getSchemaName();
        String tableName = systemTransformRecord.getLogicalTableName();
        String newTableName = SchemaUtil.getTableNameFromFullName((String)systemTransformRecord.getNewPhysicalTableName());
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<String> columnValues = new ArrayList<String>();
        Transform.getMetadataDifference(connection, systemTransformRecord, columnNames, columnValues);
        String changeViewStmt = "UPSERT INTO SYSTEM.CATALOG (TENANT_ID, TABLE_SCHEM, TABLE_NAME %s) VALUES (?, ?, ? %s)";
        String changeTable = String.format("UPSERT INTO SYSTEM.CATALOG (TENANT_ID, TABLE_SCHEM, TABLE_NAME, PHYSICAL_TABLE_NAME %s ) VALUES(?, ?, ?, ? %s)", columnNames.size() > 0 ? "," + String.join((CharSequence)",", columnNames) : "", columnNames.size() > 0 ? "," + QueryUtil.generateInListParams((int)columnValues.size()) : "");
        LOGGER.info("About to do cutover via " + changeTable);
        TableViewFinderResult childViewsResult = ViewUtil.findChildViews((PhoenixConnection)connection, (String)tenantId, (String)schema, (String)tableName);
        boolean wasCommit = connection.getAutoCommit();
        connection.setAutoCommit(false);
        ArrayList<TableInfo> viewsToUpdateCache = new ArrayList<TableInfo>();
        try {
            try (PreparedStatement stmt = connection.prepareStatement(changeTable);){
                int param = 0;
                if (tenantId == null) {
                    stmt.setNull(++param, 12);
                } else {
                    stmt.setString(++param, tenantId);
                }
                if (schema == null) {
                    stmt.setNull(++param, 12);
                } else {
                    stmt.setString(++param, schema);
                }
                stmt.setString(++param, tableName);
                stmt.setString(++param, newTableName);
                for (int i = 0; i < columnValues.size(); ++i) {
                    stmt.setInt(++param, Integer.parseInt((String)columnValues.get(i)));
                }
                stmt.execute();
            }
            PTable pNewTable = connection.getTable(systemTransformRecord.getNewPhysicalTableName());
            PTable pOldTable = connection.getTable(SchemaUtil.getTableName((String)schema, (String)tableName));
            if (pOldTable.getImmutableStorageScheme() != pNewTable.getImmutableStorageScheme() || pOldTable.getEncodingScheme() != pNewTable.getEncodingScheme()) {
                MetaDataClient.mutateTransformProperties((Connection)connection, (String)tenantId, (String)schema, (String)tableName, (String)newTableName, (PTable.ImmutableStorageScheme)pNewTable.getImmutableStorageScheme(), (PTable.QualifierEncodingScheme)pNewTable.getEncodingScheme());
                Transform.mutateColumns((PhoenixConnection)connection.unwrap(PhoenixConnection.class), pOldTable, pNewTable);
                HashMap<String, PColumn> columnMap = new HashMap<String, PColumn>();
                for (PColumn column : pNewTable.getColumns()) {
                    columnMap.put(column.getName().getString(), column);
                }
                for (TableInfo view : childViewsResult.getLinks()) {
                    PTable pView = connection.getTable(view.getTenantId() == null ? null : Bytes.toString((byte[])view.getTenantId()), SchemaUtil.getTableName((byte[])view.getSchemaName(), (byte[])view.getTableName()));
                    Transform.mutateViewColumns((PhoenixConnection)connection.unwrap(PhoenixConnection.class), pView, pNewTable, columnMap);
                }
            }
            connection.commit();
            int maxBatchSize = connection.getQueryServices().getConfiguration().getInt("phoenix.mutate.batchSize", 100);
            int batchSize = 0;
            for (TableInfo view : childViewsResult.getLinks()) {
                String changeView = String.format(changeViewStmt, columnNames.size() > 0 ? "," + String.join((CharSequence)",", columnNames) : "", columnNames.size() > 0 ? "," + QueryUtil.generateInListParams((int)columnValues.size()) : "");
                LOGGER.info("Cutover changing view via " + changeView);
                try (PreparedStatement stmt = connection.prepareStatement(changeView);){
                    int param = 0;
                    if (view.getTenantId() == null || view.getTenantId().length == 0) {
                        stmt.setNull(++param, 12);
                    } else {
                        stmt.setString(++param, Bytes.toString((byte[])view.getTenantId()));
                    }
                    if (view.getSchemaName() == null || view.getSchemaName().length == 0) {
                        stmt.setNull(++param, 12);
                    } else {
                        stmt.setString(++param, Bytes.toString((byte[])view.getSchemaName()));
                    }
                    stmt.setString(++param, Bytes.toString((byte[])view.getTableName()));
                    for (int i = 0; i < columnValues.size(); ++i) {
                        stmt.setInt(++param, Integer.parseInt((String)columnValues.get(i)));
                    }
                    stmt.execute();
                }
                viewsToUpdateCache.add(view);
                if (++batchSize < maxBatchSize) continue;
                connection.commit();
                batchSize = 0;
            }
            if (batchSize > 0) {
                connection.commit();
                batchSize = 0;
            }
            ((PhoenixConnection)connection.unwrap(PhoenixConnection.class)).getQueryServices().clearCache();
            UpgradeUtil.clearCacheAndGetNewTable((PhoenixConnection)((PhoenixConnection)connection.unwrap(PhoenixConnection.class)), (PName)connection.getTenantId(), (String)schema, (String)tableName, (String)systemTransformRecord.getLogicalParentName(), (long)0L);
            for (TableInfo view : viewsToUpdateCache) {
                UpgradeUtil.clearCache((PhoenixConnection)((PhoenixConnection)connection.unwrap(PhoenixConnection.class)), (PName)PNameFactory.newName((byte[])view.getTenantId()), (String)PNameFactory.newName((byte[])view.getSchemaName()).getString(), (String)Bytes.toString((byte[])view.getTableName()), (String)tableName, (long)0L);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error happened during cutover ", (Throwable)e);
            connection.rollback();
            throw e;
        }
        finally {
            connection.setAutoCommit(wasCommit);
        }
    }

    private static void getMetadataDifference(PhoenixConnection connection, SystemTransformRecord systemTransformRecord, List<String> columnNames, List<String> columnValues) throws SQLException {
        PTable pOldTable = connection.getTable(SchemaUtil.getQualifiedTableName((String)systemTransformRecord.getSchemaName(), (String)systemTransformRecord.getLogicalTableName()));
        PTable pNewTable = connection.getTable(SchemaUtil.getQualifiedTableName((String)SchemaUtil.getSchemaNameFromFullName((String)systemTransformRecord.getNewPhysicalTableName()), (String)SchemaUtil.getTableNameFromFullName((String)systemTransformRecord.getNewPhysicalTableName())));
        Map map = pOldTable.getPropertyValues();
        for (Map.Entry entry : map.entrySet()) {
            String oldKey = (String)entry.getKey();
            String oldValue = (String)entry.getValue();
            if (!pNewTable.getPropertyValues().containsKey(oldKey) || "PHYSICAL_TABLE_NAME".equals(oldKey)) continue;
            Object newValue = (String)pNewTable.getPropertyValues().get(oldKey);
            if (Strings.nullToEmpty((String)oldValue).equals(Strings.nullToEmpty((String)newValue))) continue;
            columnNames.add(oldKey);
            if (!(Strings.isNullOrEmpty((String)newValue) || StringUtils.isNumeric((CharSequence)newValue) || ((String)newValue).equalsIgnoreCase(Boolean.TRUE.toString()) || ((String)newValue).equalsIgnoreCase(Boolean.FALSE.toString()))) {
                newValue = "ENCODING_SCHEME".equals(oldKey) ? String.valueOf(PTable.QualifierEncodingScheme.valueOf((String)newValue).getSerializedMetadataValue()) : ("IMMUTABLE_STORAGE_SCHEME".equals(oldKey) ? String.valueOf(PTable.ImmutableStorageScheme.valueOf((String)newValue).getSerializedMetadataValue()) : "'" + (String)newValue + "'");
            }
            columnValues.add((String)newValue);
        }
    }

    public static void completeTransform(Connection connection, Configuration configuration) throws Exception {
        SystemTransformRecord transformRecord;
        String tenantId = configuration.get("phoenix.mapreduce.tenantid", null);
        String fullOldTableName = PhoenixConfigurationUtil.getInputTableName(configuration);
        String schemaName = SchemaUtil.getSchemaNameFromFullName((String)fullOldTableName);
        String oldTableLogicalName = SchemaUtil.getTableNameFromFullName((String)fullOldTableName);
        String indexTableName = SchemaUtil.getTableNameFromFullName((String)PhoenixConfigurationUtil.getIndexToolIndexTableName(configuration));
        String logicaTableName = oldTableLogicalName;
        String logicalParentName = null;
        if (PhoenixConfigurationUtil.getTransformingTableType(configuration) == IndexScrutinyTool.SourceTable.INDEX_TABLE_SOURCE && !Strings.isNullOrEmpty((String)indexTableName)) {
            logicaTableName = indexTableName;
            logicalParentName = SchemaUtil.getTableName((String)schemaName, (String)oldTableLogicalName);
        }
        if (!PTable.TransformType.isPartialTransform((PTable.TransformType)(transformRecord = Transform.getTransformRecord((String)schemaName, (String)logicaTableName, (String)logicalParentName, (String)tenantId, (PhoenixConnection)connection.unwrap(PhoenixConnection.class))).getTransformType())) {
            Transform.updateTransformRecord(connection.unwrap(PhoenixConnection.class), transformRecord, PTable.TransformStatus.PENDING_CUTOVER);
            connection.commit();
        } else {
            Transform.updateTransformRecord(connection.unwrap(PhoenixConnection.class), transformRecord, PTable.TransformStatus.COMPLETED);
            connection.commit();
        }
    }

    public static void updateTransformRecord(PhoenixConnection connection, SystemTransformRecord transformRecord, PTable.TransformStatus newStatus) throws SQLException {
        SystemTransformRecord.SystemTransformBuilder builder = new SystemTransformRecord.SystemTransformBuilder(transformRecord);
        builder.setTransformStatus(newStatus.name());
        builder.setLastStateTs(new Timestamp(EnvironmentEdgeManager.currentTimeMillis()));
        if (newStatus == PTable.TransformStatus.STARTED) {
            builder.setTransformRetryCount(transformRecord.getTransformRetryCount() + 1);
        }
        Transform.upsertTransform((SystemTransformRecord)builder.build(), (PhoenixConnection)connection);
    }

    private static void mutateColumns(PhoenixConnection connection, PTable pOldTable, PTable pNewTable) throws SQLException {
        if (pOldTable.getEncodingScheme() != pNewTable.getEncodingScheme()) {
            Short nextKeySeq = 0;
            for (PColumn column : pNewTable.getColumns()) {
                boolean isPk = SchemaUtil.isPKColumn((PColumn)column);
                Short keySeq = isPk ? Short.valueOf((short)(nextKeySeq + 1)) : null;
                PColumnImpl newCol = new PColumnImpl(column.getName(), column.getFamilyName(), column.getDataType(), column.getMaxLength(), column.getScale(), column.isNullable(), column.getPosition(), column.getSortOrder(), column.getArraySize(), column.getViewConstant(), column.isViewReferenced(), column.getExpressionStr(), column.isRowTimestamp(), column.isDynamic(), column.getColumnQualifierBytes(), EnvironmentEdgeManager.currentTimeMillis());
                ColumnMetaDataOps.addColumnMutation((PhoenixConnection)connection, (String)(pOldTable.getSchemaName() == null ? null : pOldTable.getSchemaName().getString()), (String)pOldTable.getTableName().getString(), (PColumn)newCol, (String)(pNewTable.getParentTableName() == null ? null : pNewTable.getParentTableName().getString()), (String)(pNewTable.getPKName() == null ? null : pNewTable.getPKName().getString()), (Short)keySeq, (pNewTable.getBucketNum() != null ? 1 : 0) != 0);
            }
        }
    }

    public static PTable getTransformedView(PTable pOldView, PTable pNewTable, HashMap<String, PColumn> columnMap, boolean withDerivedColumns) throws SQLException {
        ArrayList<PColumnImpl> newColumns = new ArrayList<PColumnImpl>();
        PTableImpl pNewView = null;
        if (pOldView.getEncodingScheme() != pNewTable.getEncodingScheme()) {
            Short nextKeySeq = 0;
            PTable.EncodedCQCounter cqCounterToUse = pNewTable.getEncodedCQCounter();
            String defaultColumnFamily = pNewTable.getDefaultFamilyName() != null && !Strings.isNullOrEmpty((String)pNewTable.getDefaultFamilyName().getString()) ? pNewTable.getDefaultFamilyName().getString() : "0";
            for (PColumn column : pOldView.getColumns()) {
                Short keySeq;
                boolean isPk = SchemaUtil.isPKColumn((PColumn)column);
                Short s = keySeq = isPk ? Short.valueOf((short)(nextKeySeq + 1)) : null;
                if (isPk) continue;
                String familyName = null;
                familyName = pNewTable.getImmutableStorageScheme() == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS ? (column.getFamilyName() != null ? column.getFamilyName().getString() : defaultColumnFamily) : defaultColumnFamily;
                int encodedCQ = pOldView.isAppendOnlySchema() ? Integer.valueOf(11 + keySeq) : cqCounterToUse.getNextQualifier(familyName);
                byte[] colQualifierBytes = EncodedColumnsUtil.getColumnQualifierBytes((String)column.getName().getString(), (Integer)encodedCQ, (PTable)pNewTable, (boolean)isPk);
                if (columnMap.containsKey(column.getName().getString())) {
                    colQualifierBytes = columnMap.get(column.getName().getString()).getColumnQualifierBytes();
                } else if (!column.isDerived()) {
                    cqCounterToUse.increment(familyName);
                }
                if (!withDerivedColumns && column.isDerived()) continue;
                PColumnImpl newCol = new PColumnImpl(column.getName(), PNameFactory.newName((String)familyName), column.getDataType(), column.getMaxLength(), column.getScale(), column.isNullable(), column.getPosition(), column.getSortOrder(), column.getArraySize(), column.getViewConstant(), column.isViewReferenced(), column.getExpressionStr(), column.isRowTimestamp(), column.isDynamic(), colQualifierBytes, EnvironmentEdgeManager.currentTimeMillis());
                newColumns.add(newCol);
                if (columnMap.containsKey(newCol.getName().getString())) continue;
                columnMap.put(newCol.getName().getString(), (PColumn)newCol);
            }
            pNewView = PTableImpl.builderWithColumns((PTable)pOldView, newColumns).setQualifierEncodingScheme(pNewTable.getEncodingScheme()).setImmutableStorageScheme(pNewTable.getImmutableStorageScheme()).setPhysicalNames(Collections.singletonList(SchemaUtil.getPhysicalHBaseTableName((PName)pNewTable.getSchemaName(), (PName)pNewTable.getTableName(), (boolean)pNewTable.isNamespaceMapped()))).build();
        }
        return pNewView;
    }

    private static void mutateViewColumns(PhoenixConnection connection, PTable pView, PTable pNewTable, HashMap<String, PColumn> columnMap) throws SQLException {
        if (pView.getEncodingScheme() != pNewTable.getEncodingScheme()) {
            Short nextKeySeq = 0;
            PTable newView = Transform.getTransformedView(pView, pNewTable, columnMap, false);
            for (PColumn newCol : newView.getColumns()) {
                Short keySeq;
                boolean isPk = SchemaUtil.isPKColumn((PColumn)newCol);
                Short s = keySeq = isPk ? Short.valueOf((short)(nextKeySeq + 1)) : null;
                if (isPk) continue;
                String tenantId = pView.getTenantId() == null ? null : pView.getTenantId().getString();
                ColumnMetaDataOps.addColumnMutation((PhoenixConnection)connection, (String)tenantId, (String)(pView.getSchemaName() == null ? null : pView.getSchemaName().getString()), (String)pView.getTableName().getString(), (PColumn)newCol, (String)(pView.getParentTableName() == null ? null : pView.getParentTableName().getString()), (String)(pView.getPKName() == null ? null : pView.getPKName().getString()), (Short)keySeq, (pView.getBucketNum() != null ? 1 : 0) != 0);
            }
        }
    }

    public static void doForceCutover(Connection connection, Configuration configuration) throws Exception {
        PhoenixConnection phoenixConnection = connection.unwrap(PhoenixConnection.class);
        String tenantId = configuration.get("phoenix.mapreduce.tenantid", null);
        String fullOldTableName = PhoenixConfigurationUtil.getInputTableName(configuration);
        String schemaName = SchemaUtil.getSchemaNameFromFullName((String)fullOldTableName);
        String oldTableLogicalName = SchemaUtil.getTableNameFromFullName((String)fullOldTableName);
        String indexTableName = SchemaUtil.getTableNameFromFullName((String)PhoenixConfigurationUtil.getIndexToolIndexTableName(configuration));
        String logicaTableName = oldTableLogicalName;
        String logicalParentName = null;
        if (PhoenixConfigurationUtil.getTransformingTableType(configuration) == IndexScrutinyTool.SourceTable.INDEX_TABLE_SOURCE && !Strings.isNullOrEmpty((String)indexTableName)) {
            logicaTableName = indexTableName;
            logicalParentName = SchemaUtil.getTableName((String)schemaName, (String)oldTableLogicalName);
        }
        SystemTransformRecord transformRecord = Transform.getTransformRecord((String)schemaName, (String)logicaTableName, logicalParentName, (String)tenantId, (PhoenixConnection)phoenixConnection);
        Transform.doCutover(phoenixConnection, transformRecord);
        Transform.updateTransformRecord(phoenixConnection, transformRecord, PTable.TransformStatus.COMPLETED);
        phoenixConnection.commit();
    }
}

