/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.task;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.task.SystemTaskParams;
import org.apache.phoenix.schema.task.Task;

public class ServerTask
extends Task {
    private static void mutateSystemTaskTable(final PhoenixConnection conn, final PreparedStatement stmt, boolean accessCheckEnabled) throws IOException {
        if (accessCheckEnabled) {
            User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    RpcCall rpcContext = RpcUtil.getRpcContext();
                    try {
                        RpcUtil.setRpcContext(null);
                        stmt.execute();
                        conn.commit();
                    }
                    catch (SQLException e) {
                        throw new IOException(e);
                    }
                    finally {
                        RpcUtil.setRpcContext(rpcContext);
                    }
                    return null;
                }
            });
        } else {
            try {
                stmt.execute();
                conn.commit();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
    }

    public static void addTask(SystemTaskParams systemTaskParams) throws IOException {
        ServerTask.addTaskAndGetStatement(systemTaskParams, systemTaskParams.getConn(), true);
    }

    private static PreparedStatement addTaskAndGetStatement(SystemTaskParams systemTaskParams, PhoenixConnection connection, boolean shouldCommit) throws IOException {
        PreparedStatement stmt = ServerTask.addTaskAndGetStatement((SystemTaskParams)systemTaskParams, (PhoenixConnection)connection);
        if (shouldCommit) {
            ServerTask.mutateSystemTaskTable(connection, stmt, systemTaskParams.isAccessCheckEnabled());
        }
        return stmt;
    }

    public static void deleteTask(PhoenixConnection conn, PTable.TaskType taskType, Timestamp ts, String tenantId, String schemaName, String tableName, boolean accessCheckEnabled) throws IOException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("DELETE FROM " + PhoenixDatabaseMetaData.SYSTEM_TASK_NAME + " WHERE TASK_TYPE = ? AND TASK_TS = ? AND TENANT_ID" + (String)(tenantId == null ? " IS NULL " : " = '" + tenantId + "'") + " AND TABLE_SCHEM" + (String)(schemaName == null ? " IS NULL " : " = '" + schemaName + "'") + " AND TABLE_NAME = ?");
            stmt.setByte(1, taskType.getSerializedValue());
            stmt.setTimestamp(2, ts);
            stmt.setString(3, tableName);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        ServerTask.mutateSystemTaskTable(conn, stmt, accessCheckEnabled);
    }
}

