/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.schema.SplitOnLeadingVarCharColumnsPolicy;

public class MetaDataSplitPolicy
extends SplitOnLeadingVarCharColumnsPolicy {
    private boolean allowSystemCatalogToSplit() {
        Configuration conf = this.getConf();
        return MetaDataSplitPolicy.isSystemCatalogSplittable(conf);
    }

    public static boolean isSystemCatalogSplittable(Configuration conf) {
        boolean allowSplittableSystemCatalogRollback = conf.getBoolean("phoenix.allow.system.catalog.rollback", false);
        boolean allowSystemCatalogToSplit = conf.getBoolean("phoenix.system.catalog.splittable", true);
        return allowSystemCatalogToSplit && !allowSplittableSystemCatalogRollback;
    }

    protected boolean canSplit() {
        return super.canSplit() && this.allowSystemCatalogToSplit();
    }

    protected boolean shouldSplit() {
        return super.shouldSplit() && this.allowSystemCatalogToSplit();
    }

    @Override
    protected int getColumnToSplitAt() {
        return 2;
    }
}

