/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ColumnInfo;

public class ColumnInfoToStringEncoderDecoder {
    static final String CONFIGURATION_VALUE_PREFIX = "phoenix.colinfo.encoder.decoeder.value";
    static final String CONFIGURATION_COUNT = "phoenix.colinfo.encoder.decoder.count";

    private ColumnInfoToStringEncoderDecoder() {
    }

    public static void encode(Configuration configuration, List<ColumnInfo> columnInfos) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull(columnInfos);
        int count = 0;
        for (int i = 0; i < columnInfos.size(); ++i) {
            if (columnInfos.get(i) == null) continue;
            configuration.set(String.format("%s_%d", CONFIGURATION_VALUE_PREFIX, i), columnInfos.get(i).toString());
            ++count;
        }
        configuration.setInt(CONFIGURATION_COUNT, count);
    }

    public static List<ColumnInfo> decode(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        int numCols = configuration.getInt(CONFIGURATION_COUNT, 0);
        ArrayList columnInfos = Lists.newArrayListWithExpectedSize((int)numCols);
        for (int i = 0; i < numCols; ++i) {
            columnInfos.add(ColumnInfo.fromString((String)configuration.get(String.format("%s_%d", CONFIGURATION_VALUE_PREFIX, i))));
        }
        return columnInfos;
    }
}

