/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.transform;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobPriority;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.compile.PostIndexDDLCompiler;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.mapreduce.CsvBulkImportUtil;
import org.apache.phoenix.mapreduce.PhoenixServerBuildIndexInputFormat;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTool;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.PhoenixServerBuildIndexDBWritable;
import org.apache.phoenix.mapreduce.index.PhoenixServerBuildIndexMapper;
import org.apache.phoenix.mapreduce.transform.PhoenixTransformReducer;
import org.apache.phoenix.mapreduce.transform.PhoenixTransformRepairMapper;
import org.apache.phoenix.mapreduce.transform.PhoenixTransformWithViewsInputFormat;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.mapreduce.util.PhoenixMapReduceUtil;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.task.ServerTask;
import org.apache.phoenix.schema.task.Task;
import org.apache.phoenix.schema.transform.SystemTransformRecord;
import org.apache.phoenix.schema.transform.Transform;
import org.apache.phoenix.schema.transform.TransformClient;
import org.apache.phoenix.schema.transform.TransformMaintainer;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Option;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Options;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.ParseException;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.PosixParser;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TransactionUtil;
import org.apache.phoenix.util.ViewUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformTool
extends Configured
implements Tool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformTool.class);
    private static final Option OUTPUT_PATH_OPTION = new Option("op", "output-path", true, "Output path where the files are written");
    private static final Option SCHEMA_NAME_OPTION = new Option("s", "schema", true, "Phoenix schema name (optional)");
    private static final Option DATA_TABLE_OPTION = new Option("dt", "data-table", true, "Data table name (mandatory)");
    private static final Option INDEX_TABLE_OPTION = new Option("it", "index-table", true, "Index table name(not required in case of partial rebuilding)");
    private static final Option FIX_UNVERIFIED_TRANSFORM_OPTION = new Option("fu", "fix-unverified", false, "To fix unverified transform records");
    private static final Option FORCE_CUTOVER_OPTION = new Option("fco", "force-cutover", false, "Updated to old table to point to new table. New table will be active and reads will start serving from the new table");
    private static final Option USE_NEW_TABLE_AS_SOURCE_OPTION = new Option("fn", "from-new", false, "To verify every row in the new table has a corresponding row in the old table. ");
    private static final Option PARTIAL_TRANSFORM_OPTION = new Option("pt", "partial-transform", false, "To transform a data table from a start timestamp");
    private static final Option ABORT_TRANSFORM_OPTION = new Option("abort", "abort", false, "Aborts the ongoing transform");
    private static final Option PAUSE_TRANSFORM_OPTION = new Option("pause", "pause", false, "Pauses the ongoing transform. If the ongoing transform fails, it will not be retried");
    private static final Option RESUME_TRANSFORM_OPTION = new Option("resume", "resume", false, "Resumes the ongoing transform");
    private static final Option JOB_PRIORITY_OPTION = new Option("p", "job-priority", true, "Define job priority from 0(highest) to 4. Default is 2(normal)");
    private static final int DEFAULT_AUTOSPLIT_NUM_REGIONS = 20;
    private static final Option AUTO_SPLIT_OPTION = new Option("spa", "autosplit", true, "Automatically split the new table if the # of data table regions is greater than N. Takes an optional argument specifying N, otherwise defaults to 20");
    private static final Option RUN_FOREGROUND_OPTION = new Option("runfg", "run-foreground", false, "If specified, runs transform in Foreground. Default - Runs the transform in background.");
    private static final Option TENANT_ID_OPTION = new Option("tenant", "tenant-id", true, "If specified, uses Tenant connection for tenant index transform (optional)");
    private static final Option HELP_OPTION = new Option("h", "help", false, "Help");
    private static final Option START_TIME_OPTION = new Option("st", "start-time", true, "Start time for transform");
    private static final Option END_TIME_OPTION = new Option("et", "end-time", true, "End time for transform");
    private static final Option SPLIT_SIZE_OPTION = new Option("ms", "split-size-per-mapper", true, "Define split size for each mapper.");
    public static final String TRANSFORM_JOB_NAME_TEMPLATE = "PHOENIX_TRANS_%s.%s.%s";
    public static final String PARTIAL_TRANSFORM_NOT_APPLICABLE = "Partial transform accepts non-zero ts set in the past as start-time(st) option and that ts must be present in SYSTEM.TRANSFORM table";
    public static final String TRANSFORM_NOT_APPLICABLE = "Transform is not applicable for local indexes or views or transactional tables";
    public static final String PARTIAL_TRANSFORM_NOT_COMPATIBLE = "Can't abort/pause/resume/split during partial transform";
    public static final String FORCE_CUTOVER_NOT_COMPATIBLE = "Force cutover is not applicable with the other parameters";
    private static final Option VERIFY_OPTION = new Option("v", "verify", true, "To verify every data row in the old table has a corresponding row in the new table. The accepted values are NONE, ONLY, BEFORE,  AFTER, and BOTH. NONE is for no inline verification, which is also the default for this option. ONLY is for verifying without rebuilding the new table rows. The rest for verifying before, after, and both before and after rebuilding row. If the verification is done before rebuilding rows and the correct new table rows will not be rebuilt");
    private Configuration configuration;
    private java.sql.Connection connection;
    private String tenantId;
    private String dataTable;
    private String logicalParentName;
    private String basePath;
    private String logicalTableName;
    private String schemaName;
    private String indexTable;
    private String qDataTable;
    private PTable pIndexTable = null;
    private PTable pDataTable;
    private PTable pOldTable;
    private PTable pNewTable;
    private String oldTableWithSchema;
    private String newTableWithSchema;
    private JobPriority jobPriority;
    private IndexTool.IndexVerifyType verifyType = IndexTool.IndexVerifyType.NONE;
    private String jobName;
    private boolean isForeground;
    private Long startTime;
    private Long endTime;
    private Long lastTransformTime;
    private boolean isPartialTransform;
    private boolean shouldFixUnverified;
    private boolean shouldUseNewTableAsSource;
    private boolean shouldForceCutover;
    private int splitSize;
    private Job job;

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public CommandLine parseOptions(String[] args) {
        Options options = this.getOptions();
        PosixParser parser = new PosixParser();
        CommandLine cmdLine = null;
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            this.printHelpAndExit("Error parsing command line options: " + e.getMessage(), options);
        }
        if (cmdLine.hasOption(HELP_OPTION.getOpt())) {
            this.printHelpAndExit(options, 0);
        }
        this.jobPriority = this.getJobPriority(cmdLine);
        boolean dataTableProvided = cmdLine.hasOption(DATA_TABLE_OPTION.getOpt());
        if (!dataTableProvided) {
            throw new IllegalStateException(DATA_TABLE_OPTION.getLongOpt() + " is a mandatory parameter");
        }
        return cmdLine;
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption(OUTPUT_PATH_OPTION);
        options.addOption(SCHEMA_NAME_OPTION);
        options.addOption(DATA_TABLE_OPTION);
        options.addOption(INDEX_TABLE_OPTION);
        options.addOption(TENANT_ID_OPTION);
        options.addOption(HELP_OPTION);
        options.addOption(JOB_PRIORITY_OPTION);
        options.addOption(RUN_FOREGROUND_OPTION);
        options.addOption(PARTIAL_TRANSFORM_OPTION);
        options.addOption(START_TIME_OPTION);
        options.addOption(END_TIME_OPTION);
        options.addOption(SPLIT_SIZE_OPTION);
        options.addOption(FIX_UNVERIFIED_TRANSFORM_OPTION);
        options.addOption(FORCE_CUTOVER_OPTION);
        options.addOption(USE_NEW_TABLE_AS_SOURCE_OPTION);
        options.addOption(AUTO_SPLIT_OPTION);
        options.addOption(ABORT_TRANSFORM_OPTION);
        options.addOption(PAUSE_TRANSFORM_OPTION);
        options.addOption(RESUME_TRANSFORM_OPTION);
        options.addOption(VERIFY_OPTION);
        START_TIME_OPTION.setOptionalArg(true);
        END_TIME_OPTION.setOptionalArg(true);
        return options;
    }

    private void printHelpAndExit(String errorMessage, Options options) {
        System.err.println(errorMessage);
        LOGGER.error(errorMessage);
        this.printHelpAndExit(options, 1);
    }

    private void printHelpAndExit(Options options, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("help", options);
        System.exit(exitCode);
    }

    public CommandLine parseArgs(String[] args) throws Exception {
        CommandLine cmdLine;
        try {
            cmdLine = this.parseOptions(args);
        }
        catch (IllegalStateException e) {
            this.printHelpAndExit(e.getMessage(), this.getOptions());
            throw e;
        }
        if (this.getConf() == null) {
            this.setConf(HBaseConfiguration.create());
        }
        return cmdLine;
    }

    @VisibleForTesting
    public int populateTransformToolAttributesAndValidate(CommandLine cmdLine) throws Exception {
        boolean useStartTime = cmdLine.hasOption(START_TIME_OPTION.getOpt());
        boolean useEndTime = cmdLine.hasOption(END_TIME_OPTION.getOpt());
        this.shouldFixUnverified = cmdLine.hasOption(FIX_UNVERIFIED_TRANSFORM_OPTION.getOpt());
        this.shouldUseNewTableAsSource = cmdLine.hasOption(USE_NEW_TABLE_AS_SOURCE_OPTION.getOpt());
        this.shouldForceCutover = cmdLine.hasOption(FORCE_CUTOVER_OPTION.getOpt());
        this.basePath = cmdLine.getOptionValue(OUTPUT_PATH_OPTION.getOpt());
        this.isPartialTransform = cmdLine.hasOption(PARTIAL_TRANSFORM_OPTION.getOpt());
        if (this.shouldForceCutover) {
            LOGGER.info("TransformTool will fix the unverified rows before cutover");
            this.shouldFixUnverified = true;
        }
        if (useStartTime) {
            this.startTime = new Long(cmdLine.getOptionValue(START_TIME_OPTION.getOpt()));
        }
        if (useEndTime) {
            this.endTime = new Long(cmdLine.getOptionValue(END_TIME_OPTION.getOpt()));
        }
        if (IndexTool.isTimeRangeSet(this.startTime, this.endTime)) {
            IndexTool.validateTimeRange(this.startTime, this.endTime);
        }
        if ((this.isPartialTransform || this.shouldFixUnverified) && cmdLine.hasOption(AUTO_SPLIT_OPTION.getOpt())) {
            throw new IllegalArgumentException(PARTIAL_TRANSFORM_NOT_COMPATIBLE);
        }
        if ((this.isPartialTransform || this.shouldFixUnverified) && (cmdLine.hasOption(ABORT_TRANSFORM_OPTION.getOpt()) || cmdLine.hasOption(PAUSE_TRANSFORM_OPTION.getOpt()) || cmdLine.hasOption(RESUME_TRANSFORM_OPTION.getOpt()))) {
            throw new IllegalArgumentException(PARTIAL_TRANSFORM_NOT_COMPATIBLE);
        }
        if (this.shouldForceCutover && (this.isPartialTransform || useStartTime || useEndTime || this.shouldUseNewTableAsSource || cmdLine.hasOption(AUTO_SPLIT_OPTION.getOpt()))) {
            throw new IllegalArgumentException(FORCE_CUTOVER_NOT_COMPATIBLE);
        }
        this.schemaName = cmdLine.getOptionValue(SCHEMA_NAME_OPTION.getOpt());
        this.dataTable = cmdLine.getOptionValue(DATA_TABLE_OPTION.getOpt());
        this.indexTable = cmdLine.getOptionValue(INDEX_TABLE_OPTION.getOpt());
        this.qDataTable = SchemaUtil.getQualifiedTableName((String)this.schemaName, (String)this.dataTable);
        this.isForeground = cmdLine.hasOption(RUN_FOREGROUND_OPTION.getOpt());
        this.splitSize = cmdLine.hasOption(SPLIT_SIZE_OPTION.getOpt()) ? Integer.parseInt(cmdLine.getOptionValue(SPLIT_SIZE_OPTION.getOpt())) : 10;
        this.logicalTableName = this.dataTable;
        this.logicalParentName = null;
        if (!Strings.isNullOrEmpty((String)this.indexTable)) {
            this.logicalTableName = this.indexTable;
            this.logicalParentName = SchemaUtil.getTableName((String)this.schemaName, (String)this.dataTable);
        }
        if (this.isPartialTransform) {
            if (!cmdLine.hasOption(START_TIME_OPTION.getOpt())) {
                throw new IllegalArgumentException(PARTIAL_TRANSFORM_NOT_APPLICABLE);
            }
            this.lastTransformTime = new Long(cmdLine.getOptionValue(START_TIME_OPTION.getOpt()));
            SystemTransformRecord transformRecord = this.getTransformRecord(null);
            if (transformRecord == null) {
                throw new IllegalArgumentException(PARTIAL_TRANSFORM_NOT_APPLICABLE);
            }
            if (this.lastTransformTime == null) {
                this.lastTransformTime = transformRecord.getTransformLastStateTs().getTime();
            } else {
                this.validateLastTransformTime();
            }
        }
        PhoenixConnection phoenixConnection = this.connection.unwrap(PhoenixConnection.class);
        this.pDataTable = phoenixConnection.getTable(SchemaUtil.getQualifiedTableName((String)this.schemaName, (String)this.dataTable));
        this.pOldTable = this.indexTable != null ? (this.pIndexTable = phoenixConnection.getTable(SchemaUtil.getQualifiedTableName((String)this.schemaName, (String)this.indexTable))) : this.pDataTable;
        SystemTransformRecord transformRecord = this.getTransformRecord(this.connection.unwrap(PhoenixConnection.class));
        this.validateTransform(this.pDataTable, this.pIndexTable, transformRecord);
        String newTableName = SchemaUtil.getTableNameFromFullName((String)transformRecord.getNewPhysicalTableName());
        this.pNewTable = phoenixConnection.getTableNoCache(SchemaUtil.getQualifiedTableName((String)this.schemaName, (String)newTableName));
        this.oldTableWithSchema = SchemaUtil.getQualifiedPhoenixTableName((String)this.schemaName, (String)SchemaUtil.getTableNameFromFullName((String)this.pOldTable.getName().getString()));
        this.newTableWithSchema = SchemaUtil.getQualifiedPhoenixTableName((String)this.schemaName, (String)SchemaUtil.getTableNameFromFullName((String)this.pNewTable.getName().getString()));
        if (cmdLine.hasOption(VERIFY_OPTION.getOpt())) {
            String value = cmdLine.getOptionValue(VERIFY_OPTION.getOpt());
            this.verifyType = IndexTool.IndexVerifyType.fromValue(value);
        }
        return 0;
    }

    public void validateTransform(PTable argPDataTable, PTable argIndexTable, SystemTransformRecord transformRecord) throws Exception {
        if (argPDataTable.getType() != PTableType.TABLE) {
            throw new IllegalArgumentException(TRANSFORM_NOT_APPLICABLE);
        }
        if (argIndexTable != null && argIndexTable.getType() != PTableType.INDEX) {
            throw new IllegalArgumentException(TRANSFORM_NOT_APPLICABLE);
        }
        if (argPDataTable.isTransactional()) {
            throw new IllegalArgumentException(TRANSFORM_NOT_APPLICABLE);
        }
        if (transformRecord == null) {
            throw new IllegalStateException("ALTER statement has not been run and the transform has not been created for this table");
        }
        if (this.pDataTable != null && this.pIndexTable != null) {
            if (!IndexTool.isValidIndexTable(this.connection, this.qDataTable, this.indexTable, this.tenantId)) {
                throw new IllegalArgumentException(String.format(" %s is not an index table for %s for this connection", this.indexTable, this.qDataTable));
            }
            PTable.IndexType indexType = argIndexTable.getIndexType();
            if (PTable.IndexType.LOCAL.equals((Object)indexType)) {
                throw new IllegalArgumentException(TRANSFORM_NOT_APPLICABLE);
            }
        }
    }

    public int validateLastTransformTime() throws Exception {
        Long currentTime = EnvironmentEdgeManager.currentTimeMillis();
        if (this.lastTransformTime.compareTo(currentTime) > 0 || this.lastTransformTime == 0L) {
            throw new RuntimeException(PARTIAL_TRANSFORM_NOT_APPLICABLE);
        }
        return 0;
    }

    public SystemTransformRecord getTransformRecord(PhoenixConnection connection) throws Exception {
        if (connection == null) {
            try (java.sql.Connection conn = QueryUtil.getConnection((Configuration)this.configuration);){
                SystemTransformRecord transformRecord;
                SystemTransformRecord systemTransformRecord = transformRecord = Transform.getTransformRecord((String)this.schemaName, (String)this.logicalTableName, (String)this.logicalParentName, (String)this.tenantId, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
                return systemTransformRecord;
            }
        }
        return Transform.getTransformRecord((String)this.schemaName, (String)this.logicalTableName, (String)this.logicalParentName, (String)this.tenantId, (PhoenixConnection)connection);
    }

    public String getJobPriority() {
        return this.jobPriority.toString();
    }

    private JobPriority getJobPriority(CommandLine cmdLine) {
        String jobPriorityOption = cmdLine.getOptionValue(JOB_PRIORITY_OPTION.getOpt());
        if (jobPriorityOption == null) {
            return JobPriority.NORMAL;
        }
        switch (jobPriorityOption) {
            case "0": {
                return JobPriority.VERY_HIGH;
            }
            case "1": {
                return JobPriority.HIGH;
            }
            case "2": {
                return JobPriority.NORMAL;
            }
            case "3": {
                return JobPriority.LOW;
            }
            case "4": {
                return JobPriority.VERY_LOW;
            }
        }
        return JobPriority.NORMAL;
    }

    public Job getJob() {
        return this.job;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public Job configureJob() throws Exception {
        if (this.pNewTable.isTransactional()) {
            this.configuration.set("phoenix.mr.txscn.value", Long.toString(TransactionUtil.convertToNanoseconds((long)(this.pOldTable.getTimeStamp() + 1L))));
            this.configuration.set("phoenix.mr.txprovider", this.pNewTable.getTransactionProvider().name());
        } else if (this.lastTransformTime != null) {
            PhoenixConfigurationUtil.setCurrentScnValue(this.configuration, this.lastTransformTime);
        } else if (this.endTime != null) {
            PhoenixConfigurationUtil.setCurrentScnValue(this.configuration, this.endTime);
        } else {
            PhoenixConfigurationUtil.setCurrentScnValue(this.configuration, EnvironmentEdgeManager.currentTimeMillis());
        }
        String jobName = String.format(TRANSFORM_JOB_NAME_TEMPLATE, this.schemaName, this.dataTable, this.indexTable == null ? null : this.pNewTable.getName(), this.shouldFixUnverified ? "Unverified" : "Full");
        if (this.shouldUseNewTableAsSource) {
            jobName = String.format(TRANSFORM_JOB_NAME_TEMPLATE, this.schemaName, this.dataTable, this.indexTable == null ? null : this.pNewTable.getName(), "NewTableSource_" + this.pNewTable.getName());
        }
        PhoenixConnection pConnection = this.connection.unwrap(PhoenixConnection.class);
        PostIndexDDLCompiler ddlCompiler = new PostIndexDDLCompiler(pConnection, new TableRef(this.pOldTable), true);
        ddlCompiler.compile(this.pNewTable);
        List newColumns = ddlCompiler.getDataColumnNames();
        String upsertQuery = QueryUtil.constructUpsertStatement((String)this.newTableWithSchema, (List)newColumns, (HintNode.Hint)HintNode.Hint.NO_INDEX);
        this.configuration.set("phoenix.upsert.stmt", upsertQuery);
        PhoenixConfigurationUtil.setUpsertColumnNames(this.configuration, ddlCompiler.getIndexColumnNames().toArray(new String[ddlCompiler.getIndexColumnNames().size()]));
        if (this.tenantId != null) {
            PhoenixConfigurationUtil.setTenantId(this.configuration, this.tenantId);
        }
        PhoenixConfigurationUtil.setIndexVerifyType(this.configuration, this.verifyType);
        long indexRebuildQueryTimeoutMs = this.configuration.getLong("phoenix.index.rebuild.query.timeout", 9002100L);
        long indexRebuildRPCTimeoutMs = this.configuration.getLong("phoenix.index.rebuild.rpc.timeout", 1800000L);
        long indexRebuildClientScannerTimeOutMs = this.configuration.getLong("phoenix.index.rebuild.client.scanner.timeout", 1800000L);
        int indexRebuildRpcRetriesCounter = this.configuration.getInt("phoenix.index.rebuild.rpc.retries.counter", 5);
        this.configuration.set("phoenix.query.timeoutMs", Long.toString(indexRebuildQueryTimeoutMs));
        this.configuration.set("hbase.client.scanner.timeout.period", Long.toString(indexRebuildClientScannerTimeOutMs));
        this.configuration.set("hbase.rpc.timeout", Long.toString(indexRebuildRPCTimeoutMs));
        this.configuration.set("hbase.client.retries.number", Long.toString(indexRebuildRpcRetriesCounter));
        this.configuration.set("mapreduce.task.timeout", Long.toString(indexRebuildQueryTimeoutMs));
        PhoenixConfigurationUtil.setIndexToolDataTableName(this.configuration, this.oldTableWithSchema);
        PhoenixConfigurationUtil.setIndexToolIndexTableName(this.configuration, this.newTableWithSchema);
        PhoenixConfigurationUtil.setShouldFixUnverifiedTransform(this.configuration, this.shouldFixUnverified);
        if (this.shouldFixUnverified || this.shouldUseNewTableAsSource) {
            PhoenixConfigurationUtil.setIndexToolSourceTable(this.configuration, IndexScrutinyTool.SourceTable.INDEX_TABLE_SOURCE);
        } else {
            PhoenixConfigurationUtil.setIndexToolSourceTable(this.configuration, IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE);
        }
        if (this.startTime != null) {
            PhoenixConfigurationUtil.setIndexToolStartTime(this.configuration, this.startTime);
        }
        PhoenixConfigurationUtil.setPhysicalTableName(this.configuration, this.pNewTable.getPhysicalName().getString());
        PhoenixConfigurationUtil.setIsTransforming(this.configuration, true);
        Path outputPath = null;
        if (this.basePath != null) {
            outputPath = CsvBulkImportUtil.getOutputPath(new Path(this.basePath), this.pIndexTable == null ? this.pDataTable.getPhysicalName().getString() : this.pIndexTable.getPhysicalName().getString());
            FileSystem fs = outputPath.getFileSystem(this.configuration);
            fs.delete(outputPath, true);
        }
        this.job = Job.getInstance((Configuration)this.getConf(), (String)jobName);
        this.job.setJarByClass(TransformTool.class);
        this.job.setPriority(this.jobPriority);
        boolean hasChildViews = false;
        try (Table hTable = this.connection.unwrap(PhoenixConnection.class).getQueryServices().getTable(SchemaUtil.getPhysicalTableName((byte[])PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES, (Configuration)this.configuration).toBytes());){
            byte[] tenantIdBytes = Strings.isNullOrEmpty((String)this.tenantId) ? null : this.tenantId.getBytes();
            byte[] schemaNameBytes = Strings.isNullOrEmpty((String)this.schemaName) ? null : this.schemaName.getBytes();
            hasChildViews = ViewUtil.hasChildViews((Table)hTable, (byte[])tenantIdBytes, (byte[])schemaNameBytes, (byte[])this.pOldTable.getTableName().getBytes(), (long)Long.MAX_VALUE);
        }
        if (hasChildViews && Strings.isNullOrEmpty((String)this.tenantId)) {
            PhoenixMapReduceUtil.setInput(this.job, PhoenixServerBuildIndexDBWritable.class, PhoenixTransformWithViewsInputFormat.class, this.oldTableWithSchema, "");
        } else {
            PhoenixMapReduceUtil.setInput(this.job, PhoenixServerBuildIndexDBWritable.class, PhoenixServerBuildIndexInputFormat.class, this.oldTableWithSchema, "");
        }
        if (outputPath != null) {
            FileOutputFormat.setOutputPath((Job)this.job, (Path)outputPath);
        }
        this.job.setNumReduceTasks(1);
        this.job.setMapOutputKeyClass(ImmutableBytesWritable.class);
        if (this.shouldFixUnverified) {
            this.configureUnverifiedFromNewToOld();
        } else {
            this.configureFromOldToNew();
        }
        this.job.setMapOutputValueClass(IntWritable.class);
        this.job.setOutputKeyClass(NullWritable.class);
        this.job.setOutputValueClass(NullWritable.class);
        TableMapReduceUtil.addDependencyJars((Job)this.job);
        this.job.setReducerClass(PhoenixTransformReducer.class);
        TableMapReduceUtil.initCredentials((Job)this.job);
        LOGGER.info("TransformTool is running for " + this.job.getJobName());
        return this.job;
    }

    private void configureFromOldToNew() {
        this.job.setMapperClass(PhoenixServerBuildIndexMapper.class);
    }

    private void configureUnverifiedFromNewToOld() throws IOException, SQLException {
        ArrayList maintainers = Lists.newArrayListWithExpectedSize((int)1);
        TransformMaintainer transformMaintainer = this.pNewTable.getTransformMaintainer(this.pOldTable, this.connection.unwrap(PhoenixConnection.class));
        maintainers.add(transformMaintainer);
        Scan scan = IndexManagementUtil.newLocalStateScan((List)maintainers);
        if (this.startTime != null) {
            scan.setTimeRange(this.startTime - 1L, Long.MAX_VALUE);
        }
        scan.setRaw(true);
        scan.setCacheBlocks(false);
        SingleColumnValueFilter filter = new SingleColumnValueFilter(transformMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), transformMaintainer.getEmptyKeyValueQualifier(), CompareOperator.EQUAL, QueryConstants.UNVERIFIED_BYTES);
        scan.setFilter((Filter)filter);
        Configuration conf = this.job.getConfiguration();
        HBaseConfiguration.merge((Configuration)conf, (Configuration)HBaseConfiguration.create((Configuration)conf));
        conf.set("hbase.mapred.outputtable", PhoenixConfigurationUtil.getPhysicalTableName(this.job.getConfiguration()));
        ImmutableBytesWritable indexMetaDataPtr = new ImmutableBytesWritable(ByteUtil.EMPTY_BYTE_ARRAY);
        TransformMaintainer.serialize((PTable)this.pDataTable, (ImmutableBytesWritable)indexMetaDataPtr, (PTable)this.pNewTable, (PhoenixConnection)this.connection.unwrap(PhoenixConnection.class));
        PhoenixConfigurationUtil.setIndexMaintainers(conf, indexMetaDataPtr);
        TableMapReduceUtil.initTableMapperJob((String)this.pNewTable.getPhysicalName().getString(), (Scan)scan, PhoenixTransformRepairMapper.class, null, null, (Job)this.job);
    }

    public int runJob() throws IOException {
        try {
            if (this.isForeground) {
                LOGGER.info("Running TransformTool in foreground. Runs full table scans. This may take a long time!");
                return this.job.waitForCompletion(true) ? 0 : 1;
            }
            LOGGER.info("Running TransformTool in Background - Submit async and exit");
            this.job.submit();
            return 0;
        }
        catch (Exception e) {
            LOGGER.error("Caught exception " + e + " trying to run TransformTool.", (Throwable)e);
            return 1;
        }
    }

    private void preSplitTable(CommandLine cmdLine, java.sql.Connection connection, Configuration configuration, PTable newTable, PTable oldTable) throws SQLException, IOException {
        boolean autosplit = cmdLine.hasOption(AUTO_SPLIT_OPTION.getOpt());
        if (autosplit) {
            String nOpt = cmdLine.getOptionValue(AUTO_SPLIT_OPTION.getOpt());
            int autosplitNumRegions = nOpt == null ? 20 : Integer.parseInt(nOpt);
            LOGGER.info(String.format("Will split table %s , autosplit=%s , autoSplitNumRegions=%s", newTable.getPhysicalName(), autosplit, autosplitNumRegions));
            this.splitTable(connection.unwrap(PhoenixConnection.class), autosplit, autosplitNumRegions, newTable, oldTable);
        }
    }

    private void splitTable(PhoenixConnection pConnection, boolean autosplit, int autosplitNumRegions, PTable newTable, PTable oldTable) throws SQLException, IOException, IllegalArgumentException {
        byte[][] oldSplitPoints = null;
        byte[][] newSplitPoints = null;
        try (Table hDataTable = pConnection.getQueryServices().getTable(oldTable.getPhysicalName().getBytes());
             Connection connection = HBaseFactoryProvider.getHConnectionFactory().createConnection(this.configuration);){
            oldSplitPoints = connection.getRegionLocator(hDataTable.getName()).getStartKeys();
            Arrays.sort(oldSplitPoints, Bytes.BYTES_COMPARATOR);
            int numSplits = oldSplitPoints.length;
            ArrayList<byte[]> splitList = new ArrayList<byte[]>();
            byte[] lastKey = null;
            for (byte[] keyBytes : oldSplitPoints) {
                if (Bytes.compareTo((byte[])keyBytes, (byte[])HConstants.EMPTY_BYTE_ARRAY) != 0 && lastKey != null && !Bytes.equals((byte[])keyBytes, (byte[])lastKey)) {
                    splitList.add(keyBytes);
                }
                lastKey = keyBytes;
            }
            newSplitPoints = new byte[splitList.size()][];
            for (int i = 0; i < splitList.size(); ++i) {
                newSplitPoints[i] = (byte[])splitList.get(i);
            }
            int numRegions = newSplitPoints.length;
            if (autosplit && numRegions <= autosplitNumRegions) {
                LOGGER.info(String.format("Will not split %s because the data table only has %s regions, autoSplitNumRegions=%s", newTable.getPhysicalName(), numRegions, autosplitNumRegions));
                return;
            }
        }
        try (Admin admin = pConnection.getQueryServices().getAdmin();){
            TableName newTableSplitted = TableName.valueOf((byte[])newTable.getPhysicalName().getBytes());
            TableDescriptor descriptor = admin.getDescriptor(newTableSplitted);
            admin.disableTable(newTableSplitted);
            admin.deleteTable(newTableSplitted);
            admin.createTable(descriptor, (byte[][])newSplitPoints);
        }
    }

    public void updateTransformRecord(PhoenixConnection connection, PTable.TransformStatus newStatus) throws Exception {
        if (this.verifyType == IndexTool.IndexVerifyType.ONLY) {
            return;
        }
        SystemTransformRecord transformRecord = this.getTransformRecord(connection);
        Transform.updateTransformRecord(connection, transformRecord, newStatus);
    }

    protected void updateTransformRecord(Job job) throws Exception {
        if (job == null) {
            return;
        }
        if (this.verifyType == IndexTool.IndexVerifyType.ONLY) {
            return;
        }
        SystemTransformRecord transformRecord = this.getTransformRecord(this.connection.unwrap(PhoenixConnection.class));
        SystemTransformRecord.SystemTransformBuilder builder = new SystemTransformRecord.SystemTransformBuilder(transformRecord);
        builder.setTransformJobId(job.getJobID().toString());
        builder.setStartTs(new Timestamp(EnvironmentEdgeManager.currentTimeMillis()));
        Transform.upsertTransform((SystemTransformRecord)builder.build(), (PhoenixConnection)this.connection.unwrap(PhoenixConnection.class));
    }

    public void killJob(SystemTransformRecord transformRecord) throws Exception {
        JobClient jobClient;
        RunningJob runningJob;
        String jobId = transformRecord.getTransformJobId();
        if (!Strings.isNullOrEmpty((String)jobId) && (runningJob = (jobClient = new JobClient()).getJob(jobId)) != null) {
            try {
                runningJob.killJob();
            }
            catch (IOException ex) {
                LOGGER.warn("Transform abort could not kill the job. ", (Throwable)ex);
            }
        }
    }

    public void abortTransform() throws Exception {
        SystemTransformRecord transformRecord = this.getTransformRecord(this.connection.unwrap(PhoenixConnection.class));
        if (transformRecord.getTransformStatus().equals(PTable.TransformStatus.COMPLETED.name())) {
            throw new IllegalStateException("A completed transform cannot be aborted");
        }
        this.killJob(transformRecord);
        Transform.removeTransformRecord(transformRecord, this.connection.unwrap(PhoenixConnection.class));
        try (Statement stmt = this.connection.createStatement();){
            if (this.pIndexTable != null) {
                stmt.execute("DROP INDEX " + transformRecord.getNewPhysicalTableName());
            } else {
                stmt.execute("DROP TABLE " + transformRecord.getNewPhysicalTableName());
            }
        }
        catch (SQLException ex) {
            LOGGER.warn("Transform abort could not drop the table " + transformRecord.getNewPhysicalTableName());
        }
    }

    public void pauseTransform() throws Exception {
        SystemTransformRecord transformRecord = this.getTransformRecord(this.connection.unwrap(PhoenixConnection.class));
        if (transformRecord.getTransformStatus().equals(PTable.TransformStatus.COMPLETED.name())) {
            throw new IllegalStateException("A completed transform cannot be paused");
        }
        this.updateTransformRecord(this.connection.unwrap(PhoenixConnection.class), PTable.TransformStatus.PAUSED);
        this.killJob(transformRecord);
    }

    public void resumeTransform(String[] args, CommandLine cmdLine) throws Exception {
        SystemTransformRecord transformRecord = this.getTransformRecord(this.connection.unwrap(PhoenixConnection.class));
        if (!transformRecord.getTransformStatus().equals(PTable.TransformStatus.PAUSED.name())) {
            throw new IllegalStateException("Only a paused transform can be resumed");
        }
        Transform.updateNewTableState(this.connection.unwrap(PhoenixConnection.class), transformRecord, PIndexState.ACTIVE);
        this.runTransform(args, cmdLine);
        List taskRecordList = Task.queryTaskTable((java.sql.Connection)this.connection, null);
        for (Task.TaskRecord taskRecord : taskRecordList) {
            if (!taskRecord.isMatchingTask(transformRecord)) continue;
            ServerTask.deleteTask(this.connection.unwrap(PhoenixConnection.class), PTable.TaskType.TRANSFORM_MONITOR, taskRecord.getTimeStamp(), taskRecord.getTenantId(), taskRecord.getSchemaName(), taskRecord.getTableName(), this.configuration.getBoolean("phoenix.acls.enabled", false));
        }
        TransformClient.addTransformMonitorTask((PhoenixConnection)this.connection.unwrap(PhoenixConnection.class), (Configuration)this.configuration, (SystemTransformRecord)transformRecord, (PTable.TaskStatus)PTable.TaskStatus.CREATED, (Timestamp)new Timestamp(EnvironmentEdgeManager.currentTimeMillis()), null);
    }

    public int runTransform(String[] args, CommandLine cmdLine) throws Exception {
        int status = 0;
        this.updateTransformRecord(this.connection.unwrap(PhoenixConnection.class), PTable.TransformStatus.STARTED);
        PhoenixConfigurationUtil.setIsPartialTransform(this.configuration, this.isPartialTransform);
        PhoenixConfigurationUtil.setIsTransforming(this.configuration, true);
        PhoenixConfigurationUtil.setForceCutover(this.configuration, this.shouldForceCutover);
        if (!Strings.isNullOrEmpty((String)this.indexTable)) {
            PhoenixConfigurationUtil.setTransformingTableType(this.configuration, IndexScrutinyTool.SourceTable.INDEX_TABLE_SOURCE);
            IndexTool indexTool = new IndexTool();
            indexTool.setConf(this.configuration);
            if (this.shouldForceCutover) {
                ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
                argsList.remove("-" + FORCE_CUTOVER_OPTION.getOpt());
                argsList.remove("--" + FORCE_CUTOVER_OPTION.getLongOpt());
                args = argsList.toArray(new String[0]);
            }
            status = indexTool.run(args);
            Job job = indexTool.getJob();
            if (status == 0) {
                this.updateTransformRecord(job);
            }
        } else {
            PhoenixConfigurationUtil.setTransformingTableType(this.configuration, IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE);
            if (!this.isPartialTransform) {
                this.preSplitTable(cmdLine, this.connection, this.configuration, this.pNewTable, this.pOldTable);
            }
            this.configureJob();
            status = this.runJob();
            if (status == 0) {
                this.updateTransformRecord(this.job);
            }
        }
        if (status != 0) {
            LOGGER.error("TransformTool/IndexTool job failed! Check logs for errors..");
            this.updateTransformRecord(this.connection.unwrap(PhoenixConnection.class), PTable.TransformStatus.FAILED);
            return -1;
        }
        return status;
    }

    public int run(String[] args) throws Exception {
        int n;
        block19: {
            this.connection = null;
            int ret = 0;
            CommandLine cmdLine = null;
            this.configuration = HBaseConfiguration.addHbaseResources((Configuration)this.getConf());
            cmdLine = this.parseArgs(args);
            if (cmdLine.hasOption(TENANT_ID_OPTION.getOpt())) {
                this.tenantId = cmdLine.getOptionValue(TENANT_ID_OPTION.getOpt());
                if (!Strings.isNullOrEmpty((String)this.tenantId)) {
                    this.configuration.set("TenantId", this.tenantId);
                }
            }
            java.sql.Connection conn = QueryUtil.getConnection((Configuration)this.configuration);
            try {
                this.connection = conn;
                this.connection.setAutoCommit(true);
                IndexTool.createIndexToolTables(conn);
                this.populateTransformToolAttributesAndValidate(cmdLine);
                if (cmdLine.hasOption(ABORT_TRANSFORM_OPTION.getOpt())) {
                    this.abortTransform();
                } else if (cmdLine.hasOption(PAUSE_TRANSFORM_OPTION.getOpt())) {
                    this.pauseTransform();
                } else if (cmdLine.hasOption(RESUME_TRANSFORM_OPTION.getOpt())) {
                    this.resumeTransform(args, cmdLine);
                } else {
                    ret = this.runTransform(args, cmdLine);
                }
                n = ret;
                if (conn == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        LOGGER.error("An error occurred while transforming " + ExceptionUtils.getMessage((Throwable)ex) + " at:\n" + ExceptionUtils.getStackTrace((Throwable)ex));
                        return -1;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.printHelpAndExit(e.toString(), this.getOptions());
                    return -1;
                }
            }
            conn.close();
        }
        return n;
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run((Tool)new TransformTool(), (String[])args);
        System.exit(result);
    }

    public static TransformTool runTransformTool(SystemTransformRecord systemTransformRecord, Configuration configuration, boolean isPartial, Long startTime, Long endTime, boolean shouldFixUnverified, boolean doValidation) throws Exception {
        ArrayList args = Lists.newArrayList();
        if (!Strings.isNullOrEmpty((String)systemTransformRecord.getSchemaName())) {
            args.add("--schema=" + systemTransformRecord.getSchemaName());
        }
        String oldTableName = systemTransformRecord.getLogicalTableName();
        boolean isIndex = false;
        if (!Strings.isNullOrEmpty((String)systemTransformRecord.getLogicalParentName())) {
            isIndex = true;
            args.add("--index-table=" + oldTableName);
            args.add("--data-table=" + SchemaUtil.getTableNameFromFullName((String)systemTransformRecord.getLogicalParentName()));
        } else {
            args.add("--data-table=" + oldTableName);
        }
        args.add("-op");
        args.add("/tmp/" + UUID.randomUUID().toString());
        if (!Strings.isNullOrEmpty((String)systemTransformRecord.getTenantId())) {
            args.add("-tenant");
            args.add(systemTransformRecord.getTenantId());
        }
        if (startTime != null) {
            args.add("-st");
            args.add(String.valueOf(startTime));
        }
        if (endTime != null) {
            args.add("-et");
            args.add(String.valueOf(endTime));
        }
        if (isPartial && !isIndex) {
            args.add("-pt");
        }
        if (shouldFixUnverified && !isIndex) {
            args.add("-fu");
        }
        if (doValidation) {
            args.add("-v");
            args.add(IndexTool.IndexVerifyType.ONLY.getValue());
        }
        Object[] cmdArgs = args.toArray(new String[0]);
        TransformTool tt = new TransformTool();
        Configuration conf = new Configuration(configuration);
        tt.setConf(conf);
        LOGGER.info("Running TransformTool with {}", (Object)Arrays.toString(cmdArgs), (Object)new Exception("Stack Trace"));
        int status = tt.run((String[])cmdArgs);
        LOGGER.info("TransformTool with {} status is ", (Object)Arrays.toString(cmdArgs), (Object)status);
        if (status != 0) {
            return null;
        }
        return tt;
    }

    public static enum MR_COUNTER_METRICS {
        TRANSFORM_FAILED,
        TRANSFORM_SUCCEED;

    }
}

