/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.transform;

import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.ServerBuildTransformingTableCompiler;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.mapreduce.PhoenixServerBuildIndexInputFormat;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.transform.Transform;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ViewUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixTransformWithViewsInputFormat<T extends DBWritable>
extends PhoenixServerBuildIndexInputFormat {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixTransformWithViewsInputFormat.class);

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        try (PhoenixConnection connection = (PhoenixConnection)ConnectionUtil.getInputConnection((Configuration)configuration);){
            ArrayList<InputSplit> arrayList;
            block17: {
                Table hTable = ((PhoenixConnection)connection.unwrap(PhoenixConnection.class)).getQueryServices().getTable(SchemaUtil.getPhysicalTableName((byte[])PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES, (Configuration)configuration).toBytes());
                try {
                    String oldDataTableFullName = PhoenixConfigurationUtil.getIndexToolDataTableName(configuration);
                    String newDataTableFullName = PhoenixConfigurationUtil.getIndexToolIndexTableName(configuration);
                    PTable newDataTable = connection.getTableNoCache(newDataTableFullName);
                    String schemaName = SchemaUtil.getSchemaNameFromFullName((String)oldDataTableFullName);
                    String tableName = SchemaUtil.getTableNameFromFullName((String)oldDataTableFullName);
                    byte[] schemaNameBytes = Strings.isNullOrEmpty((String)schemaName) ? null : schemaName.getBytes();
                    Pair allDescendantViews = ViewUtil.findAllDescendantViews((Table)hTable, (Configuration)configuration, null, (byte[])schemaNameBytes, (byte[])tableName.getBytes(), (long)EnvironmentEdgeManager.currentTimeMillis(), (boolean)false, (boolean)true);
                    List legitimateDecendants = (List)allDescendantViews.getFirst();
                    ArrayList<InputSplit> inputSplits = new ArrayList<InputSplit>();
                    HashMap<String, PColumn> columnMap = new HashMap<String, PColumn>();
                    for (PColumn column : newDataTable.getColumns()) {
                        columnMap.put(column.getName().getString(), column);
                    }
                    for (PTable decendant : legitimateDecendants) {
                        if (decendant.getViewType() == PTable.ViewType.READ_ONLY) continue;
                        PTable newView = Transform.getTransformedView(decendant, newDataTable, columnMap, true);
                        QueryPlan queryPlan = this.getQueryPlan(newView, decendant, connection);
                        inputSplits.addAll(this.generateSplits(queryPlan, configuration));
                    }
                    if (inputSplits.size() == 0) {
                        ServerBuildTransformingTableCompiler compiler = new ServerBuildTransformingTableCompiler(connection, oldDataTableFullName);
                        MutationPlan plan = compiler.compile(newDataTable);
                        inputSplits.addAll(this.generateSplits(plan.getQueryPlan(), configuration));
                    }
                    arrayList = inputSplits;
                    if (hTable == null) break block17;
                }
                catch (Throwable throwable) {
                    if (hTable != null) {
                        try {
                            hTable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                hTable.close();
            }
            return arrayList;
        }
        catch (Exception e) {
            LOGGER.error("PhoenixTransformWithViewsInputFormat failed with: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private QueryPlan getQueryPlan(PTable newTable, PTable oldTable, PhoenixConnection phoenixConnection) throws SQLException {
        String connTenantId;
        String tableTenantId = oldTable.getTenantId() == null ? null : oldTable.getTenantId().getString();
        String string = connTenantId = phoenixConnection.getTenantId() == null ? null : phoenixConnection.getTenantId().getString();
        if (!Strings.isNullOrEmpty((String)tableTenantId) && !StringUtils.equals((CharSequence)tableTenantId, (CharSequence)connTenantId)) {
            Properties props = new Properties();
            props.setProperty("TenantId", tableTenantId);
            try (PhoenixConnection tenantConnection = (PhoenixConnection)DriverManager.getConnection(phoenixConnection.getURL(), props);){
                QueryPlan queryPlan = this.getQueryPlanInternal(newTable, oldTable, tenantConnection);
                return queryPlan;
            }
        }
        return this.getQueryPlanInternal(newTable, oldTable, phoenixConnection);
    }

    private QueryPlan getQueryPlanInternal(PTable newTable, PTable decendant, PhoenixConnection phoenixConnection) throws SQLException {
        ServerBuildTransformingTableCompiler compiler = new ServerBuildTransformingTableCompiler(phoenixConnection, SchemaUtil.getTableName((PName)decendant.getSchemaName(), (PName)decendant.getTableName()).getString());
        MutationPlan plan = compiler.compile(newTable);
        return plan.getQueryPlan();
    }
}

