/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.transform;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.GlobalIndexChecker;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.PhoenixJobCounters;
import org.apache.phoenix.mapreduce.index.DirectHTableWriter;
import org.apache.phoenix.mapreduce.index.PhoenixIndexToolJobCounters;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.transform.TransformMaintainer;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ClientUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixTransformRepairMapper
extends TableMapper<ImmutableBytesWritable, IntWritable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixTransformRepairMapper.class);
    private DirectHTableWriter writer;
    private PhoenixConnection connection;
    private ImmutableBytesPtr maintainers;
    private int batchSize;
    private List<Mutation> mutations;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration configuration = context.getConfiguration();
        this.writer = new DirectHTableWriter(configuration);
        try {
            Properties overrideProps = new Properties();
            String scn = configuration.get("phoenix.mr.currentscn.value");
            String txScnValue = configuration.get("phoenix.mr.txscn.value");
            if (txScnValue == null && scn != null) {
                overrideProps.put("BuildIndexAt", scn);
            }
            this.connection = ConnectionUtil.getOutputConnection((Configuration)configuration, (Properties)overrideProps).unwrap(PhoenixConnection.class);
            this.maintainers = new ImmutableBytesPtr(PhoenixConfigurationUtil.getIndexMaintainers(configuration));
            int maxSize = this.connection.getQueryServices().getProps().getInt("phoenix.mutate.maxSize", 500000);
            this.batchSize = Math.min(this.connection.getMutateBatchSize(), maxSize);
            this.mutations = Lists.newArrayListWithExpectedSize((int)this.batchSize);
            LOGGER.info("Mutation Batch Size = " + this.batchSize);
        }
        catch (SQLException e) {
            this.tryClosingResources();
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void map(ImmutableBytesWritable row, Result value, Mapper.Context context) throws IOException, InterruptedException {
        context.getCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).increment(1L);
        String oldTableName = PhoenixConfigurationUtil.getIndexToolDataTableName(context.getConfiguration());
        HashSet<byte[]> extraRowsInNewTable = new HashSet<byte[]>();
        try (Table oldHTable = this.connection.getQueryServices().getTable(Bytes.toBytes((String)oldTableName));){
            for (Cell cell : value.rawCells()) {
                Scan buildNewTableScan = new Scan();
                buildNewTableScan.setAttribute("_UngroupedAgg", PDataType.TRUE_BYTES);
                buildNewTableScan.setAttribute("IdxProtoMD", this.maintainers.get());
                buildNewTableScan.setAttribute("_RebuildIndexes", PDataType.TRUE_BYTES);
                buildNewTableScan.setAttribute("_SKIP_REGION_BOUNDARY_CHECK", Bytes.toBytes((boolean)true));
                IndexMaintainer transformMaintainer = (IndexMaintainer)TransformMaintainer.deserialize((byte[])this.maintainers.get()).get(0);
                byte[] newRowKey = CellUtil.cloneRow((Cell)cell);
                buildNewTableScan.withStartRow(newRowKey, true);
                buildNewTableScan.withStopRow(newRowKey, true);
                buildNewTableScan.setTimeRange(0L, cell.getTimestamp() + 1L);
                buildNewTableScan.setAttribute("_IndexRowKey", newRowKey);
                Result result = null;
                try (ResultScanner resultScanner = oldHTable.getScanner(buildNewTableScan);){
                    result = resultScanner.next();
                }
                catch (Throwable t) {
                    ClientUtil.throwIOException((String)oldTableName, (Throwable)t);
                }
                byte[] scanVal = result.value();
                long code = PLong.INSTANCE.getCodec().decodeLong(new ImmutableBytesWritable(scanVal), SortOrder.getDefault());
                if (code == (long)GlobalIndexChecker.RebuildReturnCode.NO_DATA_ROW.getValue()) {
                    if (!extraRowsInNewTable.contains(newRowKey)) {
                        extraRowsInNewTable.add(newRowKey);
                    }
                    Delete del = transformMaintainer.buildRowDeleteMutation(newRowKey, IndexMaintainer.DeleteType.ALL_VERSIONS, cell.getTimestamp());
                    this.mutations.add((Mutation)del);
                }
                if (context.getCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue() % (long)this.batchSize == 0L) {
                    this.writeBatch(this.mutations, context);
                    this.mutations.clear();
                }
                context.getCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT).setValue((long)extraRowsInNewTable.size());
                context.progress();
            }
        }
        catch (SQLException e) {
            LOGGER.error(" Error {}  while read/write of a record ", (Object)e.getMessage());
            context.getCounter((Enum)PhoenixJobCounters.FAILED_RECORDS).increment(1L);
            throw new RuntimeException(e);
        }
    }

    private void writeBatch(List<Mutation> mutations, Mapper.Context context) throws IOException, SQLException, InterruptedException {
        this.writer.write(mutations);
        context.getCounter((Enum)PhoenixJobCounters.OUTPUT_RECORDS).increment((long)mutations.size());
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        try {
            if (!this.mutations.isEmpty()) {
                this.writeBatch(this.mutations, context);
            }
            context.write((Object)new ImmutableBytesWritable(UUID.randomUUID().toString().getBytes()), (Object)new IntWritable(0));
            super.cleanup(context);
        }
        catch (SQLException e) {
            LOGGER.error(" Error {}  while read/write of a record ", (Object)e.getMessage());
            context.getCounter((Enum)PhoenixJobCounters.FAILED_RECORDS).increment(1L);
            throw new RuntimeException(e);
        }
        finally {
            this.tryClosingResources();
        }
    }

    private void tryClosingResources() throws IOException {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                LOGGER.error("Error while closing connection in the PhoenixIndexMapper class ", (Throwable)e);
            }
        }
        if (this.writer != null) {
            this.writer.close();
        }
    }
}

