/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.transform;

import java.io.IOException;
import java.sql.Connection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.PhoenixIndexImportDirectReducer;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.schema.transform.Transform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixTransformReducer
extends PhoenixIndexImportDirectReducer {
    private AtomicBoolean calledOnce = new AtomicBoolean(false);
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixTransformReducer.class);

    @Override
    protected void reduce(ImmutableBytesWritable arg0, Iterable<IntWritable> arg1, Reducer.Context context) throws IOException, InterruptedException {
        if (!this.calledOnce.compareAndSet(false, true)) {
            return;
        }
        IndexTool.IndexVerifyType verifyType = PhoenixConfigurationUtil.getIndexVerifyType(context.getConfiguration());
        if (verifyType != IndexTool.IndexVerifyType.NONE) {
            this.updateCounters(verifyType, context);
        }
        if (verifyType != IndexTool.IndexVerifyType.ONLY) {
            try (Connection connection = ConnectionUtil.getInputConnection((Configuration)context.getConfiguration());){
                Transform.completeTransform(connection, context.getConfiguration());
                if (PhoenixConfigurationUtil.getForceCutover(context.getConfiguration()).booleanValue()) {
                    Transform.doForceCutover(connection, context.getConfiguration());
                }
            }
            catch (Exception e) {
                LOGGER.error(" Failed to complete transform", (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

