/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index.automation;

import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.automation.PhoenixAsyncIndex;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;

public class PhoenixMRJobCallable
implements Callable<Boolean> {
    private PhoenixAsyncIndex indexInfo;
    private String basePath;
    private Configuration conf;

    public PhoenixMRJobCallable(Configuration conf, PhoenixAsyncIndex indexInfo, String basePath) {
        this.conf = conf;
        this.indexInfo = indexInfo;
        this.basePath = basePath;
    }

    @Override
    public Boolean call() throws Exception {
        String qIndexTable;
        StringBuilder commandLineArgBuilder = new StringBuilder();
        commandLineArgBuilder.append(" -dt " + this.indexInfo.getDataTableName());
        commandLineArgBuilder.append(" -it " + this.indexInfo.getTableName());
        commandLineArgBuilder.append(" -direct");
        commandLineArgBuilder.append(" -op " + (String)(this.basePath.endsWith("/") ? this.basePath : this.basePath + "/") + this.indexInfo.getTableName());
        if (this.indexInfo.getTableSchem() != null && this.indexInfo.getTableSchem().trim().length() > 0) {
            commandLineArgBuilder.append(" -s " + this.indexInfo.getTableSchem());
        }
        String qDataTable = SchemaUtil.getTableName((String)this.indexInfo.getTableSchem(), (String)this.indexInfo.getDataTableName());
        String physicalIndexTable = qIndexTable = SchemaUtil.getTableName((String)this.indexInfo.getTableSchem(), (String)this.indexInfo.getTableName());
        if (PTable.IndexType.LOCAL.equals((Object)this.indexInfo.getIndexType())) {
            physicalIndexTable = MetaDataUtil.getLocalIndexTableName((String)qDataTable);
        }
        this.conf.set("hbase.mapred.outputtable", physicalIndexTable);
        IndexTool tool = new IndexTool();
        tool.setConf(this.conf);
        int result = tool.run(commandLineArgBuilder.toString().split(" "));
        return result == 0;
    }
}

