/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.phoenix.coprocessorclient.BaseScannerRegionObserverConstants;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.mapreduce.PhoenixJobCounters;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTool;
import org.apache.phoenix.mapreduce.index.PhoenixIndexDBWritable;
import org.apache.phoenix.mapreduce.index.PhoenixScrutinyJobCounters;
import org.apache.phoenix.mapreduce.index.SourceTargetColumnNames;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.IndexColumnNames;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TTLExpression;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexScrutinyMapper
extends Mapper<NullWritable, PhoenixIndexDBWritable, Text, Text> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexScrutinyMapper.class);
    protected Connection connection;
    private List<ColumnInfo> targetTblColumnMetadata;
    private long batchSize;
    protected List<Pair<Long, List<Object>>> currentBatchValues = new ArrayList<Pair<Long, List<Object>>>();
    protected String targetTableQuery;
    protected int numTargetPkCols;
    protected boolean outputInvalidRows;
    protected IndexScrutinyTool.OutputFormat outputFormat = IndexScrutinyTool.OutputFormat.FILE;
    private String qSourceTable;
    private String qTargetTable;
    private long executeTimestamp;
    private int numSourcePkCols;
    private final PhoenixIndexDBWritable indxWritable = new PhoenixIndexDBWritable();
    private List<ColumnInfo> sourceTblColumnMetadata;
    protected Connection outputConn;
    protected PreparedStatement outputUpsertStmt;
    private long outputMaxRows;
    private MessageDigest md5;
    private long ttl;
    private long scnTimestamp;
    private long maxLookbackAgeMillis;

    protected long getScrutinyTs() {
        return this.scnTimestamp;
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration configuration = context.getConfiguration();
        try {
            Properties overrideProps = new Properties();
            String scn = configuration.get("phoenix.mr.currentscn.value");
            overrideProps.put("CurrentSCN", scn);
            this.scnTimestamp = Long.parseLong(scn);
            this.connection = ConnectionUtil.getOutputConnection((Configuration)configuration, (Properties)overrideProps);
            PhoenixConnection phoenixConnection = this.connection.unwrap(PhoenixConnection.class);
            this.connection.setAutoCommit(false);
            this.batchSize = PhoenixConfigurationUtil.getScrutinyBatchSize(configuration);
            this.outputInvalidRows = PhoenixConfigurationUtil.getScrutinyOutputInvalidRows(configuration);
            this.outputFormat = PhoenixConfigurationUtil.getScrutinyOutputFormat(configuration);
            this.executeTimestamp = PhoenixConfigurationUtil.getScrutinyExecuteTimestamp(configuration);
            String qDataTable = PhoenixConfigurationUtil.getScrutinyDataTableName(configuration);
            PTable pdataTable = phoenixConnection.getTable(qDataTable);
            String qIndexTable = PhoenixConfigurationUtil.getScrutinyIndexTableName(configuration);
            PTable pindexTable = phoenixConnection.getTable(qIndexTable);
            IndexScrutinyTool.SourceTable sourceTable = PhoenixConfigurationUtil.getScrutinySourceTable(configuration);
            IndexColumnNames columnNames = IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE.equals((Object)sourceTable) ? new SourceTargetColumnNames.DataSourceColNames(pdataTable, pindexTable) : new SourceTargetColumnNames.IndexSourceColNames(pdataTable, pindexTable);
            this.qSourceTable = columnNames.getQualifiedSourceTableName();
            this.qTargetTable = columnNames.getQualifiedTargetTableName();
            List<String> targetColNames = columnNames.getTargetColNames();
            List<String> sourceColNames = columnNames.getSourceColNames();
            List<String> targetPkColNames = columnNames.getTargetPkColNames();
            String targetPksCsv = Joiner.on((String)",").join((Iterable)SchemaUtil.getEscapedFullColumnNames(targetPkColNames));
            this.numSourcePkCols = columnNames.getSourcePkColNames().size();
            this.numTargetPkCols = targetPkColNames.size();
            if (this.outputInvalidRows && IndexScrutinyTool.OutputFormat.TABLE.equals((Object)this.outputFormat)) {
                this.outputConn = ConnectionUtil.getOutputConnection((Configuration)configuration, (Properties)new Properties());
                String upsertQuery = PhoenixConfigurationUtil.getUpsertStatement(configuration);
                this.outputUpsertStmt = this.outputConn.prepareStatement(upsertQuery);
            }
            this.outputMaxRows = PhoenixConfigurationUtil.getScrutinyOutputMax(configuration);
            this.targetTableQuery = QueryUtil.constructSelectStatement((String)this.qTargetTable, columnNames.getCastedTargetColNames(), (String)targetPksCsv, (HintNode.Hint)HintNode.Hint.NO_INDEX, (boolean)false) + " IN ";
            this.targetTblColumnMetadata = PhoenixRuntime.generateColumnInfo((Connection)phoenixConnection, (String)this.qTargetTable, targetColNames);
            this.sourceTblColumnMetadata = PhoenixRuntime.generateColumnInfo((Connection)phoenixConnection, (String)this.qSourceTable, sourceColNames);
            LOGGER.info("Target table base query: " + this.targetTableQuery);
            this.md5 = MessageDigest.getInstance("MD5");
            this.ttl = this.getTableTTL(configuration);
            this.maxLookbackAgeMillis = BaseScannerRegionObserverConstants.getMaxLookbackInMillis((Configuration)configuration);
        }
        catch (NoSuchAlgorithmException | SQLException e) {
            IndexScrutinyMapper.tryClosingResourceSilently(this.outputUpsertStmt);
            IndexScrutinyMapper.tryClosingResourceSilently(this.connection);
            IndexScrutinyMapper.tryClosingResourceSilently(this.outputConn);
            throw new RuntimeException(e);
        }
        this.postSetup();
    }

    protected void postSetup() {
    }

    private static void tryClosingResourceSilently(AutoCloseable res) {
        if (res != null) {
            try {
                res.close();
            }
            catch (Exception e) {
                LOGGER.error("Closing resource: " + res + " failed :", (Throwable)e);
            }
        }
    }

    protected void map(NullWritable key, PhoenixIndexDBWritable record, Mapper.Context context) throws IOException, InterruptedException {
        try {
            List<Object> values = record.getValues();
            context.getCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).increment(1L);
            this.currentBatchValues.add((Pair<Long, List<Object>>)new Pair((Object)record.getRowTs(), values));
            if (context.getCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue() % this.batchSize != 0L) {
                context.progress();
                return;
            }
            this.processBatch(context);
            context.progress();
        }
        catch (IllegalArgumentException | SQLException e) {
            LOGGER.error(" Error while read/write of a record ", (Throwable)e);
            context.getCounter((Enum)PhoenixJobCounters.FAILED_RECORDS).increment(1L);
            throw new IOException(e);
        }
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
        IndexScrutinyMapper.tryClosingResourceSilently(this.outputUpsertStmt);
        IOException throwException = null;
        if (this.connection != null) {
            try {
                this.processBatch(context);
                this.connection.close();
            }
            catch (SQLException e) {
                LOGGER.error("Error while closing connection in the PhoenixIndexMapper class ", (Throwable)e);
                throwException = new IOException(e);
            }
        }
        IndexScrutinyMapper.tryClosingResourceSilently(this.outputConn);
        if (throwException != null) {
            throw throwException;
        }
    }

    protected void processBatch(Mapper.Context context) throws SQLException, IOException, InterruptedException {
        if (this.currentBatchValues.size() == 0) {
            return;
        }
        context.getCounter((Enum)PhoenixScrutinyJobCounters.BATCHES_PROCESSED_COUNT).increment(1L);
        String inClause = QueryUtil.constructParameterizedInClause((int)this.numTargetPkCols, (int)this.currentBatchValues.size());
        String indexQuery = this.targetTableQuery + inClause;
        try (PreparedStatement targetStatement = this.connection.prepareStatement(indexQuery);){
            Map<String, Pair<Long, List<Object>>> targetPkToSourceValues = this.buildTargetStatement(targetStatement);
            this.preQueryTargetTable();
            this.queryTargetTable(context, targetStatement, targetPkToSourceValues);
            this.categorizeInvalidRows(context, targetPkToSourceValues);
            if (this.outputInvalidRows) {
                for (Pair<Long, List<Object>> sourceRowWithoutTargetRow : targetPkToSourceValues.values()) {
                    List valuesWithoutTarget = (List)sourceRowWithoutTargetRow.getSecond();
                    if (IndexScrutinyTool.OutputFormat.FILE.equals((Object)this.outputFormat)) {
                        context.write((Object)new Text(Arrays.toString(valuesWithoutTarget.toArray())), (Object)new Text("Target row not found"));
                        continue;
                    }
                    if (!IndexScrutinyTool.OutputFormat.TABLE.equals((Object)this.outputFormat)) continue;
                    this.writeToOutputTable(context, valuesWithoutTarget, null, (Long)sourceRowWithoutTargetRow.getFirst(), -1L);
                }
            }
            if (this.outputInvalidRows && IndexScrutinyTool.OutputFormat.TABLE.equals((Object)this.outputFormat)) {
                this.outputUpsertStmt.executeBatch();
                this.outputConn.commit();
            }
            this.currentBatchValues.clear();
        }
    }

    protected void preQueryTargetTable() {
    }

    protected void categorizeInvalidRows(Mapper.Context context, Map<String, Pair<Long, List<Object>>> targetPkToSourceValues) {
        Set<Map.Entry<String, Pair<Long, List<Object>>>> entrySet = targetPkToSourceValues.entrySet();
        Iterator<Map.Entry<String, Pair<Long, List<Object>>>> itr = entrySet.iterator();
        while (itr.hasNext()) {
            Map.Entry<String, Pair<Long, List<Object>>> entry = itr.next();
            Pair<Long, List<Object>> sourceValues = entry.getValue();
            Long sourceTS = (Long)sourceValues.getFirst();
            if (this.hasRowExpiredOnSource(sourceTS, this.ttl)) {
                context.getCounter((Enum)PhoenixScrutinyJobCounters.EXPIRED_ROW_COUNT).increment(1L);
                itr.remove();
                continue;
            }
            if (this.isRowOlderThanMaxLookback(sourceTS)) {
                context.getCounter((Enum)PhoenixScrutinyJobCounters.BEYOND_MAX_LOOKBACK_COUNT).increment(1L);
                continue;
            }
            context.getCounter((Enum)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT).increment(1L);
        }
    }

    protected boolean hasRowExpiredOnSource(Long sourceTS, Long ttl) {
        long currentTS = EnvironmentEdgeManager.currentTimeMillis();
        return ttl != Integer.MAX_VALUE && sourceTS + ttl * 1000L < currentTS;
    }

    protected boolean isRowOlderThanMaxLookback(Long sourceTS) {
        if (this.maxLookbackAgeMillis == 0L) {
            return false;
        }
        long now = EnvironmentEdgeManager.currentTimeMillis();
        long maxLookBackTimeMillis = now - this.maxLookbackAgeMillis;
        return sourceTS <= maxLookBackTimeMillis;
    }

    private int getTableTTL(Configuration configuration) throws SQLException, IOException {
        TableDescriptor tableDesc;
        PTable pSourceTable = PhoenixRuntime.getTable((Connection)this.connection, (String)this.qSourceTable);
        if (pSourceTable.getType() == PTableType.INDEX && pSourceTable.getIndexType() == PTable.IndexType.LOCAL) {
            return Integer.MAX_VALUE;
        }
        ConnectionQueryServices cqsi = this.connection.unwrap(PhoenixConnection.class).getQueryServices();
        String physicalTable = IndexScrutinyMapper.getSourceTableName(pSourceTable, SchemaUtil.isNamespaceMappingEnabled(null, (ReadOnlyProps)cqsi.getProps()));
        TTLExpression ttlExpression = pSourceTable.getTTLExpression();
        if (ttlExpression == null) {
            return Integer.MAX_VALUE;
        }
        if (!ttlExpression.equals(LiteralTTLExpression.TTL_EXPRESSION_DEFINED_IN_TABLE_DESCRIPTOR)) {
            return ttlExpression.equals(LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED) ? Integer.MAX_VALUE : ((LiteralTTLExpression)ttlExpression).getTTLValue();
        }
        try (Admin admin = cqsi.getAdmin();){
            tableDesc = admin.getDescriptor(TableName.valueOf((String)physicalTable));
        }
        return tableDesc.getColumnFamily(SchemaUtil.getEmptyColumnFamily((PTable)pSourceTable)).getTimeToLive();
    }

    @VisibleForTesting
    public static String getSourceTableName(PTable pSourceTable, boolean isNamespaceEnabled) {
        String physicalTable;
        String sourcePhysicalName = pSourceTable.getPhysicalName().getString();
        if (pSourceTable.getType() == PTableType.VIEW || MetaDataUtil.isViewIndex((String)sourcePhysicalName)) {
            physicalTable = sourcePhysicalName;
        } else {
            String schema = pSourceTable.getSchemaName().toString();
            String table = SchemaUtil.getTableNameFromFullName((String)pSourceTable.getPhysicalName().getString());
            physicalTable = SchemaUtil.getPhysicalHBaseTableName((String)schema, (String)table, (boolean)isNamespaceEnabled).toString();
        }
        return physicalTable;
    }

    protected Map<String, Pair<Long, List<Object>>> buildTargetStatement(PreparedStatement targetStatement) throws SQLException {
        HashMap<String, Pair<Long, List<Object>>> targetPkToSourceValues = new HashMap<String, Pair<Long, List<Object>>>(this.currentBatchValues.size());
        int rsIndex = 1;
        for (Pair<Long, List<Object>> batchTsRow : this.currentBatchValues) {
            List batchRow = (List)batchTsRow.getSecond();
            String targetPkHash = this.getPkHash(batchRow.subList(0, this.numTargetPkCols));
            targetPkToSourceValues.put(targetPkHash, batchTsRow);
            for (int i = 0; i < this.numTargetPkCols; ++i) {
                ColumnInfo targetPkInfo = this.targetTblColumnMetadata.get(i);
                Object value = batchRow.get(i);
                if (value == null) {
                    targetStatement.setNull(rsIndex++, targetPkInfo.getSqlType());
                    continue;
                }
                targetStatement.setObject(rsIndex++, value, targetPkInfo.getSqlType());
            }
        }
        return targetPkToSourceValues;
    }

    protected void queryTargetTable(Mapper.Context context, PreparedStatement targetStatement, Map<String, Pair<Long, List<Object>>> targetPkToSourceValues) throws SQLException, IOException, InterruptedException {
        ResultSet targetResultSet = targetStatement.executeQuery();
        while (targetResultSet.next()) {
            this.indxWritable.readFields(targetResultSet);
            List<Object> targetValues = this.indxWritable.getValues();
            ArrayList<Object> pkObjects = new ArrayList<Object>(this.numTargetPkCols);
            for (int i = 0; i < this.numTargetPkCols; ++i) {
                Object pkPart = targetResultSet.getObject(i + 1);
                pkObjects.add(pkPart);
            }
            Long targetTS = targetResultSet.unwrap(PhoenixResultSet.class).getCurrentRow().getValue(0).getTimestamp();
            String targetPk = this.getPkHash(pkObjects);
            Pair<Long, List<Object>> sourceTsValues = targetPkToSourceValues.get(targetPk);
            Long sourceTS = (Long)sourceTsValues.getFirst();
            List sourceValues = (List)sourceTsValues.getSecond();
            boolean isIndexedCorrectly = this.compareValues(this.numTargetPkCols, targetValues, sourceValues, context);
            if (isIndexedCorrectly) {
                context.getCounter((Enum)PhoenixScrutinyJobCounters.VALID_ROW_COUNT).increment(1L);
            } else {
                context.getCounter((Enum)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT).increment(1L);
                if (this.outputInvalidRows) {
                    this.outputInvalidRow(context, sourceValues, targetValues, sourceTS, targetTS);
                }
            }
            targetPkToSourceValues.remove(targetPk);
        }
    }

    private void outputInvalidRow(Mapper.Context context, List<Object> sourceValues, List<Object> targetValues, long sourceTS, long targetTS) throws SQLException, IOException, InterruptedException {
        if (IndexScrutinyTool.OutputFormat.FILE.equals((Object)this.outputFormat)) {
            context.write((Object)new Text(Arrays.toString(sourceValues.toArray())), (Object)new Text(Arrays.toString(targetValues.toArray())));
        } else if (IndexScrutinyTool.OutputFormat.TABLE.equals((Object)this.outputFormat)) {
            this.writeToOutputTable(context, sourceValues, targetValues, sourceTS, targetTS);
        }
    }

    protected void writeToOutputTable(Mapper.Context context, List<Object> sourceValues, List<Object> targetValues, long sourceTS, long targetTS) throws SQLException {
        if (context.getCounter((Enum)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT).getValue() > this.outputMaxRows) {
            return;
        }
        int index = 1;
        this.outputUpsertStmt.setString(index++, this.qSourceTable);
        this.outputUpsertStmt.setString(index++, this.qTargetTable);
        this.outputUpsertStmt.setLong(index++, this.executeTimestamp);
        this.outputUpsertStmt.setString(index++, this.getPkHash(sourceValues.subList(0, this.numSourcePkCols)));
        this.outputUpsertStmt.setLong(index++, sourceTS);
        this.outputUpsertStmt.setLong(index++, targetTS);
        this.outputUpsertStmt.setBoolean(index++, targetValues != null);
        this.outputUpsertStmt.setBoolean(index++, this.isRowOlderThanMaxLookback(sourceTS));
        index = this.setStatementObjects(sourceValues, index, this.sourceTblColumnMetadata);
        if (targetValues != null) {
            index = this.setStatementObjects(targetValues, index, this.targetTblColumnMetadata);
        } else {
            for (int i = 0; i < sourceValues.size(); ++i) {
                this.outputUpsertStmt.setNull(index++, this.targetTblColumnMetadata.get(i).getSqlType());
            }
        }
        this.outputUpsertStmt.addBatch();
    }

    private int setStatementObjects(List<Object> values, int index, List<ColumnInfo> colMetadata) throws SQLException {
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            ColumnInfo colInfo = colMetadata.get(i);
            if (value != null) {
                this.outputUpsertStmt.setObject(index++, value, colInfo.getSqlType());
                continue;
            }
            this.outputUpsertStmt.setNull(index++, colInfo.getSqlType());
        }
        return index;
    }

    private boolean compareValues(int startIndex, List<Object> targetValues, List<Object> sourceValues, Mapper.Context context) throws SQLException {
        if (targetValues == null || sourceValues == null) {
            return false;
        }
        for (int i = startIndex; i < sourceValues.size(); ++i) {
            Object targetValue = targetValues.get(i);
            Object sourceValue = sourceValues.get(i);
            if (sourceValue == null && targetValue == null || sourceValue != null && targetValue != null && (sourceValue.getClass().isArray() ? this.compareArrayTypes(sourceValue, targetValue) : targetValue.equals(sourceValue))) continue;
            context.getCounter((Enum)PhoenixScrutinyJobCounters.BAD_COVERED_COL_VAL_COUNT).increment(1L);
            return false;
        }
        return true;
    }

    private boolean compareArrayTypes(Object sourceValue, Object targetValue) {
        if (sourceValue.getClass().getComponentType().equals(Byte.TYPE)) {
            return Arrays.equals((byte[])sourceValue, (byte[])targetValue);
        }
        if (sourceValue.getClass().getComponentType().equals(Character.TYPE)) {
            return Arrays.equals((char[])sourceValue, (char[])targetValue);
        }
        if (sourceValue.getClass().getComponentType().equals(Boolean.TYPE)) {
            return Arrays.equals((boolean[])sourceValue, (boolean[])targetValue);
        }
        if (sourceValue.getClass().getComponentType().equals(Double.TYPE)) {
            return Arrays.equals((double[])sourceValue, (double[])targetValue);
        }
        if (sourceValue.getClass().getComponentType().equals(Integer.TYPE)) {
            return Arrays.equals((int[])sourceValue, (int[])targetValue);
        }
        if (sourceValue.getClass().getComponentType().equals(Short.TYPE)) {
            return Arrays.equals((short[])sourceValue, (short[])targetValue);
        }
        if (sourceValue.getClass().getComponentType().equals(Long.TYPE)) {
            return Arrays.equals((long[])sourceValue, (long[])targetValue);
        }
        if (sourceValue.getClass().getComponentType().equals(Float.TYPE)) {
            return Arrays.equals((float[])sourceValue, (float[])targetValue);
        }
        return false;
    }

    private String getPkHash(List<Object> pkObjects) {
        try {
            for (int i = 0; i < pkObjects.size(); ++i) {
                this.md5.update(this.sourceTblColumnMetadata.get(i).getPDataType().toBytes(pkObjects.get(i)));
            }
            String string = Hex.encodeHexString((byte[])this.md5.digest());
            return string;
        }
        finally {
            this.md5.reset();
        }
    }
}

