/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.IOException;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.phoenix.mapreduce.FormatToBytesWritableMapper;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.UpsertExecutor;
import org.apache.phoenix.util.regex.RegexUpsertExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexToKeyValueMapper
extends FormatToBytesWritableMapper<Map<?, ?>> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RegexToKeyValueMapper.class);
    public static final String REGEX_CONFKEY = "phoenix.mapreduce.import.regex";
    public static final String ARRAY_DELIMITER_CONFKEY = "phoenix.mapreduce.import.arraydelimiter";
    public static final String ARRAY_DELIMITER_DEFAULT = ",";
    private FormatToBytesWritableMapper.LineParser<Map<?, ?>> lineParser;

    @Override
    protected FormatToBytesWritableMapper.LineParser<Map<?, ?>> getLineParser() {
        return this.lineParser;
    }

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
    }

    @Override
    @VisibleForTesting
    protected UpsertExecutor<Map<?, ?>, ?> buildUpsertExecutor(Configuration conf) {
        String tableName = conf.get("phoenix.mapreduce.import.tablename");
        Preconditions.checkNotNull((Object)tableName, (Object)"table name is not configured");
        String regex = conf.get(REGEX_CONFKEY);
        Preconditions.checkNotNull((Object)regex, (Object)"regex is not configured");
        List<ColumnInfo> columnInfoList = RegexToKeyValueMapper.buildColumnInfoList(conf);
        String arraySeparator = conf.get(ARRAY_DELIMITER_CONFKEY, ARRAY_DELIMITER_DEFAULT);
        this.lineParser = new RegexLineParser(regex, columnInfoList, arraySeparator);
        return new RegexUpsertExecutor((Connection)this.conn, tableName, columnInfoList, (UpsertExecutor.UpsertListener)this.upsertListener);
    }

    @VisibleForTesting
    static class RegexLineParser
    implements FormatToBytesWritableMapper.LineParser<Map<?, ?>> {
        private Pattern inputPattern;
        private List<ColumnInfo> columnInfoList;
        private String arraySeparator;

        public RegexLineParser(String regex, List<ColumnInfo> columnInfo, String arraySep) {
            this.inputPattern = Pattern.compile(regex);
            this.columnInfoList = columnInfo;
            this.arraySeparator = arraySep;
        }

        @Override
        public Map<?, ?> parse(String input) throws IOException {
            HashMap<String, Object> data = new HashMap<String, Object>();
            Matcher m = this.inputPattern.matcher(input);
            if (m.groupCount() != this.columnInfoList.size()) {
                LOGGER.debug(String.format("based on the regex and input, input fileds %s size doesn't match the table columns %s size", m.groupCount(), this.columnInfoList.size()));
                return data;
            }
            if (m.find()) {
                for (int i = 0; i < this.columnInfoList.size(); ++i) {
                    ColumnInfo columnInfo = this.columnInfoList.get(i);
                    String colName = columnInfo.getColumnName();
                    String value = m.group(i + 1);
                    PDataType pDataType = PDataType.fromTypeId((int)columnInfo.getSqlType());
                    if (pDataType.isArrayType()) {
                        data.put(colName, Arrays.asList(value.split(this.arraySeparator)));
                        continue;
                    }
                    if (pDataType.isCoercibleTo((PDataType)PTimestamp.INSTANCE)) {
                        data.put(colName, value);
                        continue;
                    }
                    data.put(colName, pDataType.toObject(value));
                }
            }
            return data;
        }
    }
}

