/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixRecordWriter<T extends DBWritable>
extends RecordWriter<NullWritable, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixRecordWriter.class);
    private final Connection conn;
    private final PreparedStatement statement;
    private final long batchSize;
    private long numRecords = 0L;

    public PhoenixRecordWriter(Configuration configuration) throws SQLException {
        this(configuration, Collections.emptySet());
    }

    public PhoenixRecordWriter(Configuration configuration, Set<String> propsToIgnore) throws SQLException {
        Connection connection = null;
        try {
            connection = ConnectionUtil.getOutputConnection((Configuration)configuration);
            this.batchSize = PhoenixConfigurationUtil.getBatchSize(configuration);
            String upsertQuery = PhoenixConfigurationUtil.getUpsertStatement(configuration);
            this.statement = connection.prepareStatement(upsertQuery);
            this.conn = connection;
        }
        catch (Exception e) {
            if (connection != null) {
                connection.close();
            }
            throw e;
        }
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            LOGGER.error("SQLException while performing the commit for the task.");
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.statement.close();
                this.conn.close();
            }
            catch (SQLException ex) {
                LOGGER.error("SQLException while closing the connection for the task.");
                throw new RuntimeException(ex);
            }
        }
    }

    public void write(NullWritable n, T record) throws IOException, InterruptedException {
        try {
            record.write(this.statement);
            ++this.numRecords;
            this.statement.execute();
            if (this.numRecords % this.batchSize == 0L) {
                LOGGER.debug("commit called on a batch of size : " + this.batchSize);
                this.conn.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Exception while committing to database.", e);
        }
    }
}

