/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.sql.Array;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.util.ColumnInfo;
import org.joda.time.DateTime;

public class PhoenixRecordWritable
implements DBWritable {
    private final List<Object> upsertValues = new ArrayList<Object>();
    private final Map<String, Object> resultMap = new LinkedHashMap<String, Object>();
    private List<ColumnInfo> columnMetaDataList;

    public PhoenixRecordWritable() {
        this(new ArrayList<ColumnInfo>());
    }

    public PhoenixRecordWritable(List<ColumnInfo> columnMetaDataList) {
        this.columnMetaDataList = columnMetaDataList;
    }

    private static void setArrayInStatement(PreparedStatement stmt, PDataType<?> type, Object[] obj, int position) throws SQLException {
        Array sqlArray = stmt.getConnection().createArrayOf(PDataType.arrayBaseType(type).getSqlTypeName(), obj);
        stmt.setArray(position, sqlArray);
    }

    private static Object[] primativeArrayToObjectArray(byte[] a) {
        Object[] ret = new Byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = a[i];
        }
        return ret;
    }

    private static Object[] primativeArrayToObjectArray(short[] a) {
        Object[] ret = new Short[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = a[i];
        }
        return ret;
    }

    private static Object[] primativeArrayToObjectArray(int[] a) {
        Object[] ret = new Integer[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = a[i];
        }
        return ret;
    }

    private static Object[] primativeArrayToObjectArray(float[] a) {
        Object[] ret = new Float[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = Float.valueOf(a[i]);
        }
        return ret;
    }

    private static Object[] primativeArrayToObjectArray(double[] a) {
        Object[] ret = new Double[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = a[i];
        }
        return ret;
    }

    private static Object[] primativeArrayToObjectArray(long[] a) {
        Object[] ret = new Long[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = a[i];
        }
        return ret;
    }

    public void write(PreparedStatement statement) throws SQLException {
        if (this.upsertValues.size() != this.columnMetaDataList.size()) {
            throw new UnsupportedOperationException("Provided " + this.upsertValues.size() + " upsert values, but column metadata expects " + this.columnMetaDataList.size() + " columns.");
        }
        for (int i = 0; i < this.upsertValues.size(); ++i) {
            PDataType finalType;
            Object finalObj;
            Object v = this.upsertValues.get(i);
            ColumnInfo c = this.columnMetaDataList.get(i);
            if (v == null) {
                statement.setNull(i + 1, c.getSqlType());
                continue;
            }
            if (v instanceof DateTime) {
                finalObj = new Date(((DateTime)v).getMillis());
                finalType = PDate.INSTANCE;
            } else if (v instanceof java.util.Date) {
                finalObj = new Date(((java.util.Date)v).getTime());
                finalType = PDate.INSTANCE;
            } else {
                finalObj = v;
                finalType = c.getPDataType();
            }
            if (finalObj instanceof Object[]) {
                PhoenixRecordWritable.setArrayInStatement(statement, finalType, (Object[])finalObj, i + 1);
                continue;
            }
            if (finalObj instanceof byte[]) {
                if (PDataType.equalsAny((PDataType)finalType, (PDataType[])new PDataType[]{PVarbinary.INSTANCE, PBinary.INSTANCE})) {
                    statement.setObject(i + 1, finalObj);
                    continue;
                }
                PhoenixRecordWritable.setArrayInStatement(statement, finalType, PhoenixRecordWritable.primativeArrayToObjectArray((byte[])finalObj), i + 1);
                continue;
            }
            if (finalObj instanceof short[]) {
                PhoenixRecordWritable.setArrayInStatement(statement, finalType, PhoenixRecordWritable.primativeArrayToObjectArray((short[])finalObj), i + 1);
                continue;
            }
            if (finalObj instanceof int[]) {
                PhoenixRecordWritable.setArrayInStatement(statement, finalType, PhoenixRecordWritable.primativeArrayToObjectArray((int[])finalObj), i + 1);
                continue;
            }
            if (finalObj instanceof long[]) {
                PhoenixRecordWritable.setArrayInStatement(statement, finalType, PhoenixRecordWritable.primativeArrayToObjectArray((long[])finalObj), i + 1);
                continue;
            }
            if (finalObj instanceof float[]) {
                PhoenixRecordWritable.setArrayInStatement(statement, finalType, PhoenixRecordWritable.primativeArrayToObjectArray((float[])finalObj), i + 1);
                continue;
            }
            if (finalObj instanceof double[]) {
                PhoenixRecordWritable.setArrayInStatement(statement, finalType, PhoenixRecordWritable.primativeArrayToObjectArray((double[])finalObj), i + 1);
                continue;
            }
            statement.setObject(i + 1, finalObj);
        }
    }

    public void readFields(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            Object value = resultSet.getObject(i);
            this.resultMap.put(metaData.getColumnLabel(i), value);
        }
    }

    public void add(Object value) {
        this.upsertValues.add(value);
    }

    public Map<String, Object> getResultMap() {
        return Collections.unmodifiableMap(this.resultMap);
    }
}

