/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.RegionSizeCalculator;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.iterate.MapReduceParallelScanGrouper;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.mapreduce.PhoenixInputSplit;
import org.apache.phoenix.mapreduce.PhoenixRecordReader;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.schema.stats.StatisticsUtil;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixInputFormat<T extends DBWritable>
extends InputFormat<NullWritable, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixInputFormat.class);

    public RecordReader<NullWritable, T> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        QueryPlan queryPlan = this.getQueryPlan((JobContext)context, configuration);
        Class<?> inputClass = PhoenixConfigurationUtil.getInputClass(configuration);
        return this.getPhoenixRecordReader(inputClass, configuration, queryPlan);
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        QueryPlan queryPlan = this.getQueryPlan(context, configuration);
        return this.generateSplits(queryPlan, configuration);
    }

    protected void randomizeSplitLength(List<InputSplit> splits) {
        LOGGER.info("Randomizing split size");
        if (splits.size() == 0) {
            return;
        }
        double defaultLength = 1000000.0;
        double totalLength = splits.stream().mapToDouble(s -> {
            try {
                return s.getLength();
            }
            catch (IOException | InterruptedException e1) {
                return defaultLength;
            }
        }).sum();
        long avgLength = (long)(totalLength / (double)splits.size());
        splits.stream().forEach(s -> ((PhoenixInputSplit)((Object)s)).setLength(avgLength + (long)ThreadLocalRandom.current().nextInt(10000)));
    }

    protected List<InputSplit> generateSplits(QueryPlan qplan, Configuration config) throws IOException {
        this.setupParallelScansFromQueryPlan(qplan);
        List splits = qplan.getSplits();
        Preconditions.checkNotNull((Object)splits);
        try (Connection connection = HBaseFactoryProvider.getHConnectionFactory().createConnection(config);){
            RegionLocator regionLocator = connection.getRegionLocator(TableName.valueOf((String)qplan.getTableRef().getTable().getPhysicalName().toString()));
            RegionSizeCalculator sizeCalculator = new RegionSizeCalculator(regionLocator, connection.getAdmin());
            ArrayList psplits = Lists.newArrayListWithExpectedSize((int)splits.size());
            for (List scans : qplan.getScans()) {
                HRegionLocation location = regionLocator.getRegionLocation(((Scan)scans.get(0)).getStartRow(), false);
                String regionLocation = location.getHostname();
                long regionSize = sizeCalculator.getRegionSize(location.getRegion().getRegionName());
                boolean splitByStats = PhoenixConfigurationUtil.getSplitByStats(config);
                if (splitByStats) {
                    for (Scan aScan : scans) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Split for  scan : " + aScan + "with scanAttribute : " + aScan.getAttributesMap() + " [scanCache, cacheBlock, scanBatch] : [" + aScan.getCaching() + ", " + aScan.getCacheBlocks() + ", " + aScan.getBatch() + "] and  regionLocation : " + regionLocation);
                        }
                        psplits.add(new PhoenixInputSplit(Collections.singletonList(aScan), regionSize, regionLocation));
                    }
                    continue;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Scan count[" + scans.size() + "] : " + Bytes.toStringBinary((byte[])((Scan)scans.get(0)).getStartRow()) + " ~ " + Bytes.toStringBinary((byte[])((Scan)scans.get(scans.size() - 1)).getStopRow()));
                    LOGGER.debug("First scan : " + scans.get(0) + "with scanAttribute : " + ((Scan)scans.get(0)).getAttributesMap() + " [scanCache, cacheBlock, scanBatch] : [" + ((Scan)scans.get(0)).getCaching() + ", " + ((Scan)scans.get(0)).getCacheBlocks() + ", " + ((Scan)scans.get(0)).getBatch() + "] and  regionLocation : " + regionLocation);
                    int limit = scans.size();
                    for (int i = 0; i < limit; ++i) {
                        LOGGER.debug("EXPECTED_UPPER_REGION_KEY[" + i + "] : " + Bytes.toStringBinary((byte[])((Scan)scans.get(i)).getAttribute("_ExpectedUpperRegionKey")));
                    }
                }
                psplits.add(new PhoenixInputSplit(scans, regionSize, regionLocation));
            }
            if (PhoenixConfigurationUtil.isMRRandomizeMapperExecutionOrder(config)) {
                this.randomizeSplitLength(psplits);
            }
            ArrayList arrayList = psplits;
            return arrayList;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected QueryPlan getQueryPlan(JobContext context, Configuration configuration) throws IOException {
        Preconditions.checkNotNull((Object)context);
        try {
            String txnScnValue = configuration.get("phoenix.mr.txscn.value");
            String currentScnValue = configuration.get("phoenix.mr.currentscn.value");
            String tenantId = configuration.get("phoenix.mapreduce.tenantid");
            Properties overridingProps = new Properties();
            if (txnScnValue == null && currentScnValue != null) {
                overridingProps.put("CurrentSCN", currentScnValue);
            }
            if (tenantId != null && configuration.get("TenantId") == null) {
                overridingProps.put("TenantId", tenantId);
            }
            try (java.sql.Connection connection = ConnectionUtil.getInputConnection((Configuration)configuration, (Properties)overridingProps);){
                QueryPlan queryPlan;
                block23: {
                    Statement statement = connection.createStatement();
                    try {
                        PhoenixConfigurationUtil.MRJobType mrJobType = PhoenixConfigurationUtil.getMRJobType(configuration, PhoenixConfigurationUtil.MRJobType.QUERY.name());
                        Object selectStatement = switch (mrJobType) {
                            case PhoenixConfigurationUtil.MRJobType.UPDATE_STATS -> "SELECT * FROM " + PhoenixConfigurationUtil.getInputTableName(configuration);
                            default -> PhoenixConfigurationUtil.getSelectStatement(configuration);
                        };
                        Preconditions.checkNotNull((Object)selectStatement);
                        PhoenixStatement pstmt = statement.unwrap(PhoenixStatement.class);
                        QueryPlan queryPlan2 = pstmt.optimizeQuery((String)selectStatement);
                        Scan scan = queryPlan2.getContext().getScan();
                        if (mrJobType == PhoenixConfigurationUtil.MRJobType.UPDATE_STATS) {
                            StatisticsUtil.setScanAttributes((Scan)scan, null);
                        }
                        if (txnScnValue != null) {
                            scan.setAttribute("_TxScn", Bytes.toBytes((long)Long.parseLong(txnScnValue)));
                        }
                        String snapshotName = configuration.get("phoenix.mapreduce.snapshot.name");
                        String restoreDir = configuration.get("phoenix.tableSnapshot.restore.dir");
                        boolean isSnapshotRestoreManagedExternally = PhoenixConfigurationUtil.isMRSnapshotManagedExternally(configuration);
                        Configuration config = queryPlan2.getContext().getConnection().getQueryServices().getConfiguration();
                        if (snapshotName != null) {
                            PhoenixConfigurationUtil.setSnapshotNameKey(config, snapshotName);
                            PhoenixConfigurationUtil.setRestoreDirKey(config, restoreDir);
                            PhoenixConfigurationUtil.setMRSnapshotManagedExternally(config, isSnapshotRestoreManagedExternally);
                        } else {
                            config.unset("phoenix.mapreduce.snapshot.name");
                            config.unset("phoenix.tableSnapshot.restore.dir");
                            config.unset("phoenix.mapreduce.external.snapshot.restore");
                        }
                        queryPlan = queryPlan2;
                        if (statement == null) break block23;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    statement.close();
                }
                return queryPlan;
            }
        }
        catch (Exception exception) {
            LOGGER.error(String.format("Failed to get the query plan with error [%s]", exception.getMessage()));
            throw new RuntimeException(exception);
        }
    }

    void setupParallelScansFromQueryPlan(QueryPlan queryPlan) {
        this.setupParallelScansWithScanGrouper(queryPlan, MapReduceParallelScanGrouper.getInstance());
    }

    RecordReader<NullWritable, T> getPhoenixRecordReader(Class<T> inputClass, Configuration configuration, QueryPlan queryPlan) {
        return new PhoenixRecordReader<T>(inputClass, configuration, queryPlan, MapReduceParallelScanGrouper.getInstance());
    }

    void setupParallelScansWithScanGrouper(QueryPlan queryPlan, ParallelScanGrouper scanGrouper) {
        Preconditions.checkNotNull((Object)queryPlan);
        try {
            queryPlan.iterator(scanGrouper);
        }
        catch (SQLException e) {
            LOGGER.error(String.format("Setting up parallel scans for the query plan failed with error [%s]", e.getMessage()));
            throw new RuntimeException(e);
        }
    }
}

