/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.parse.DropTableStatement;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.DefaultParser;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Option;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Options;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.ParseException;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrphanViewTool
extends Configured
implements Tool {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrphanViewTool.class);
    private static final String viewQuery = "SELECT TENANT_ID, TABLE_SCHEM,TABLE_NAME FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE TABLE_TYPE = '" + PTableType.VIEW.getSerializedValue() + "' AND NOT VIEW_TYPE = " + PTable.ViewType.MAPPED.getSerializedValue();
    private static final String physicalLinkQuery = "SELECT TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME AS PHYSICAL_TABLE_TENANT_ID, COLUMN_FAMILY AS PHYSICAL_TABLE_FULL_NAME  FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE LINK_TYPE = " + PTable.LinkType.PHYSICAL_TABLE.getSerializedValue();
    private static final String childParentLinkQuery = "SELECT TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME AS PARENT_VIEW_TENANT_ID, COLUMN_FAMILY AS PARENT_VIEW_FULL_NAME  FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE LINK_TYPE = " + PTable.LinkType.PARENT_TABLE.getSerializedValue();
    private static final String parentChildLinkQuery = "SELECT TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME AS CHILD_VIEW_TENANT_ID, COLUMN_FAMILY AS CHILD_VIEW_FULL_NAME  FROM " + PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME + " WHERE LINK_TYPE = " + PTable.LinkType.CHILD_TABLE.getSerializedValue();
    private static final String candidateBaseTableQuery = "SELECT TENANT_ID, TABLE_SCHEM, TABLE_NAME FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE TABLE_TYPE != '" + PTableType.VIEW.getSerializedValue() + "' AND TABLE_TYPE != '" + PTableType.INDEX.getSerializedValue() + "'";
    private String outputPath;
    private String inputPath;
    private boolean clean = false;
    private int maxViewLevel = 0;
    private static final long defaultAgeMs = 86400000L;
    private long ageMs = 0L;
    public static final byte VIEW = 0;
    public static final byte PHYSICAL_TABLE_LINK = 1;
    public static final byte PARENT_TABLE_LINK = 2;
    public static final byte CHILD_TABLE_LINK = 3;
    public static final byte ORPHAN_TYPE_COUNT = 4;
    BufferedWriter[] writer = new BufferedWriter[4];
    BufferedReader[] reader = new BufferedReader[4];
    HashMap<Key, View> orphanViewSet = new HashMap();
    List<HashMap<Key, View>> viewSetArray = new ArrayList<HashMap<Key, View>>();
    HashMap<Key, Base> baseSet = new HashMap();
    HashSet<Link> orphanLinkSet = new HashSet();
    public static final String[] fileName = new String[]{"OrphanView.txt", "OrphanPhysicalTableLink.txt", "OrphanParentTableLink.txt", "OrphanChildTableLink.txt"};
    private static final Option OUTPUT_PATH_OPTION = new Option("op", "output-path", true, "Output path where the files listing orphan views and links are written");
    private static final Option INPUT_PATH_OPTION = new Option("ip", "input-path", true, "Input path where the files listing orphan views and links are read");
    private static final Option CLEAN_ORPHAN_VIEWS_OPTION = new Option("c", "clean", false, "If specified, cleans orphan views and links");
    private static final Option IDENTIFY_ORPHAN_VIEWS_OPTION = new Option("i", "identify", false, "If specified, identifies orphan views and links");
    private static final Option AGE_OPTION = new Option("a", "age", true, "The minimum age (in milliseconds) for the views (default value is " + Long.toString(86400000L) + ", i.e. 1 day)");
    private static final Option HELP_OPTION = new Option("h", "help", false, "Help");

    private Options getOptions() {
        Options options = new Options();
        options.addOption(OUTPUT_PATH_OPTION);
        options.addOption(INPUT_PATH_OPTION);
        options.addOption(CLEAN_ORPHAN_VIEWS_OPTION);
        options.addOption(IDENTIFY_ORPHAN_VIEWS_OPTION);
        options.addOption(AGE_OPTION);
        options.addOption(HELP_OPTION);
        return options;
    }

    private void parseOptions(String[] args) throws Exception {
        Options options = this.getOptions();
        DefaultParser parser = DefaultParser.builder().setAllowPartialMatching(false).setStripLeadingAndTrailingQuotes(Boolean.valueOf(false)).build();
        CommandLine cmdLine = null;
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            this.printHelpAndExit("Error parsing command line options: " + e.getMessage(), options);
        }
        if (cmdLine.hasOption(HELP_OPTION.getOpt())) {
            this.printHelpAndExit(options, 0);
        }
        if (cmdLine.hasOption(OUTPUT_PATH_OPTION.getOpt()) && cmdLine.hasOption(INPUT_PATH_OPTION.getOpt())) {
            throw new IllegalStateException("Specify either " + OUTPUT_PATH_OPTION.getLongOpt() + " or " + INPUT_PATH_OPTION.getOpt());
        }
        if (cmdLine.hasOption(INPUT_PATH_OPTION.getOpt()) && !cmdLine.hasOption(CLEAN_ORPHAN_VIEWS_OPTION.getOpt())) {
            throw new IllegalStateException(INPUT_PATH_OPTION.getLongOpt() + " is only used with " + IDENTIFY_ORPHAN_VIEWS_OPTION.getOpt());
        }
        if (cmdLine.hasOption(IDENTIFY_ORPHAN_VIEWS_OPTION.getOpt()) && cmdLine.hasOption(CLEAN_ORPHAN_VIEWS_OPTION.getOpt())) {
            throw new IllegalStateException("Specify either " + IDENTIFY_ORPHAN_VIEWS_OPTION.getLongOpt() + " or " + IDENTIFY_ORPHAN_VIEWS_OPTION.getOpt());
        }
        if (cmdLine.hasOption(OUTPUT_PATH_OPTION.getOpt()) && !cmdLine.hasOption(IDENTIFY_ORPHAN_VIEWS_OPTION.getOpt()) && !cmdLine.hasOption(CLEAN_ORPHAN_VIEWS_OPTION.getOpt())) {
            throw new IllegalStateException(OUTPUT_PATH_OPTION.getLongOpt() + " requires either " + IDENTIFY_ORPHAN_VIEWS_OPTION.getOpt() + " or " + CLEAN_ORPHAN_VIEWS_OPTION.getOpt());
        }
        if (cmdLine.hasOption(CLEAN_ORPHAN_VIEWS_OPTION.getOpt())) {
            this.clean = true;
        } else if (!cmdLine.hasOption(IDENTIFY_ORPHAN_VIEWS_OPTION.getOpt())) {
            throw new IllegalStateException("Specify either " + IDENTIFY_ORPHAN_VIEWS_OPTION.getOpt() + " or " + CLEAN_ORPHAN_VIEWS_OPTION.getOpt());
        }
        if (cmdLine.hasOption(AGE_OPTION.getOpt())) {
            this.ageMs = Long.parseLong(cmdLine.getOptionValue(AGE_OPTION.getOpt()));
        }
        this.outputPath = cmdLine.getOptionValue(OUTPUT_PATH_OPTION.getOpt());
        this.inputPath = cmdLine.getOptionValue(INPUT_PATH_OPTION.getOpt());
    }

    private void printHelpAndExit(String errorMessage, Options options) {
        System.err.println(errorMessage);
        this.printHelpAndExit(options, 1);
    }

    private void printHelpAndExit(Options options, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("help", options);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gracefullyDropView(PhoenixConnection phoenixConnection, Configuration configuration, Key key) throws Exception {
        PhoenixConnection tenantConnection = null;
        boolean newConn = false;
        try {
            if (key.getTenantId() != null) {
                Properties tenantProps = new Properties();
                tenantProps.setProperty("TenantId", key.getTenantId());
                tenantConnection = ConnectionUtil.getInputConnection((Configuration)configuration, (Properties)tenantProps).unwrap(PhoenixConnection.class);
                newConn = true;
            } else {
                tenantConnection = phoenixConnection;
            }
            MetaDataClient client = new MetaDataClient(tenantConnection);
            org.apache.phoenix.parse.TableName pTableName = org.apache.phoenix.parse.TableName.create((String)key.getSchemaName(), (String)key.getTableName());
            try {
                client.dropTable(new DropTableStatement(pTableName, PTableType.VIEW, false, true, true));
            }
            catch (TableNotFoundException e) {
                LOGGER.info("Ignoring view " + pTableName + " as it has already been dropped");
            }
        }
        finally {
            if (newConn) {
                this.tryClosingConnection((Connection)tenantConnection);
            }
        }
    }

    private void removeLink(PhoenixConnection phoenixConnection, Key src, Key dst, PTable.LinkType linkType) throws Exception {
        String delTable = linkType == PTable.LinkType.PHYSICAL_TABLE || linkType == PTable.LinkType.PARENT_TABLE ? PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME : PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME;
        String deleteQuery = String.format(" DELETE FROM %s WHERE TENANT_ID %s  AND TABLE_SCHEM %s AND TABLE_NAME = ? AND COLUMN_NAME %s AND COLUMN_FAMILY = ? ", delTable, src.getTenantId() == null ? " IS NULL" : " = ? ", src.getSchemaName() == null ? " IS NULL " : " = ? ", dst.getTenantId() == null ? " IS NULL" : " = ?");
        try (PreparedStatement delStmt = phoenixConnection.prepareStatement(deleteQuery);){
            int param = 0;
            if (src.getTenantId() != null) {
                delStmt.setString(++param, src.getTenantId());
            }
            if (src.getSchemaName() != null) {
                delStmt.setString(++param, src.getSchemaName());
            }
            delStmt.setString(++param, src.getTableName());
            if (dst.getTenantId() != null) {
                delStmt.setString(++param, dst.getTenantId());
            }
            if (dst.getSchemaName() == null) {
                delStmt.setString(++param, dst.getTableName());
            } else {
                delStmt.setString(++param, dst.getSchemaName() + "." + dst.getTableName());
            }
            delStmt.execute();
            phoenixConnection.commit();
        }
    }

    private byte getLinkType(PTable.LinkType linkType) {
        int type;
        if (linkType == PTable.LinkType.PHYSICAL_TABLE) {
            type = 1;
        } else if (linkType == PTable.LinkType.PARENT_TABLE) {
            type = 2;
        } else if (linkType == PTable.LinkType.CHILD_TABLE) {
            type = 3;
        } else {
            throw new AssertionError((Object)"Unknown Link Type");
        }
        return (byte)type;
    }

    private PTable.LinkType getLinkType(byte linkType) {
        PTable.LinkType type;
        if (linkType == 1) {
            type = PTable.LinkType.PHYSICAL_TABLE;
        } else if (linkType == 2) {
            type = PTable.LinkType.PARENT_TABLE;
        } else if (linkType == 3) {
            type = PTable.LinkType.CHILD_TABLE;
        } else {
            throw new AssertionError((Object)"Unknown Link Type");
        }
        return type;
    }

    private void removeOrLogOrphanLinks(PhoenixConnection phoenixConnection) {
        for (Link link : this.orphanLinkSet) {
            try {
                byte linkType = this.getLinkType(link.type);
                if (this.outputPath != null) {
                    this.writer[linkType].write(link.src.getSerializedValue() + "-->" + link.dst.getSerializedValue());
                    this.writer[linkType].newLine();
                } else if (!this.clean) {
                    System.out.println(link.src.getSerializedValue() + "-(" + link.type + ")->" + link.dst.getSerializedValue());
                }
                if (!this.clean) continue;
                this.removeLink(phoenixConnection, link.src, link.dst, link.type);
            }
            catch (Exception exception) {}
        }
    }

    private void forcefullyDropView(PhoenixConnection phoenixConnection, Key key) throws Exception {
        String deleteRowsFromCatalog = String.format("DELETE FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE TENANT_ID %s  AND TABLE_SCHEM %s  AND TABLE_NAME =  ? ", key.getTenantId() == null ? " IS NULL" : " = ? ", key.getSchemaName() == null ? " IS NULL " : " = ? ");
        String deleteRowsFromChildLink = String.format("DELETE FROM " + PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME + " WHERE COLUMN_NAME %s  AND COLUMN_FAMILY = ? ", key.getTenantId() == null ? " IS NULL" : " = ? ");
        try {
            int param;
            try (PreparedStatement delSysCat = phoenixConnection.prepareStatement(deleteRowsFromCatalog);){
                param = 0;
                if (key.getTenantId() != null) {
                    delSysCat.setString(++param, key.getTenantId());
                }
                if (key.getSchemaName() != null) {
                    delSysCat.setString(++param, key.getSchemaName());
                }
                delSysCat.setString(++param, key.getTableName());
                delSysCat.execute();
            }
            try (PreparedStatement delChLink = phoenixConnection.prepareStatement(deleteRowsFromChildLink);){
                param = 0;
                if (key.getTenantId() != null) {
                    delChLink.setString(++param, key.getTenantId());
                }
                delChLink.setString(++param, (String)(key.getSchemaName() == null ? key.getTableName() : key.getSchemaName() + "." + key.getTableName()));
                delChLink.execute();
            }
            phoenixConnection.commit();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    private void dropOrLogOrphanViews(PhoenixConnection phoenixConnection, Configuration configuration, Key key) throws Exception {
        if (this.outputPath != null) {
            this.writer[0].write(key.getSerializedValue());
            this.writer[0].newLine();
        } else if (!this.clean) {
            System.out.println(key.getSerializedValue());
            return;
        }
        if (!this.clean) {
            return;
        }
        this.gracefullyDropView(phoenixConnection, configuration, key);
    }

    private void populateOrphanViewSet(PhoenixConnection phoenixConnection) throws Exception {
        ResultSet viewRS = phoenixConnection.createStatement().executeQuery(viewQuery);
        while (viewRS.next()) {
            String tenantId = viewRS.getString(1);
            String schemaName = viewRS.getString(2);
            String tableName = viewRS.getString(3);
            Key key = new Key(tenantId, schemaName, tableName);
            View view = new View(key);
            this.orphanViewSet.put(key, view);
        }
    }

    private void populateBaseSet(PhoenixConnection phoenixConnection) throws Exception {
        ResultSet baseTableRS = phoenixConnection.createStatement().executeQuery(candidateBaseTableQuery);
        while (baseTableRS.next()) {
            String tenantId = baseTableRS.getString(1);
            String schemaName = baseTableRS.getString(2);
            String tableName = baseTableRS.getString(3);
            Key key = new Key(tenantId, schemaName, tableName);
            Base base = new Base(key);
            this.baseSet.put(key, base);
        }
    }

    private void processPhysicalLinks(PhoenixConnection phoenixConnection) throws Exception {
        ResultSet physicalLinkRS = phoenixConnection.createStatement().executeQuery(physicalLinkQuery);
        while (physicalLinkRS.next()) {
            String tenantId = physicalLinkRS.getString(1);
            String schemaName = physicalLinkRS.getString(2);
            String tableName = physicalLinkRS.getString(3);
            Key viewKey = new Key(tenantId, schemaName, tableName);
            View view = this.orphanViewSet.get(viewKey);
            String baseTenantId = physicalLinkRS.getString(4);
            String baseFullTableName = physicalLinkRS.getString(5);
            Key baseKey = new Key(baseTenantId, baseFullTableName);
            Base base = this.baseSet.get(baseKey);
            if (view == null || base == null) {
                this.orphanLinkSet.add(new Link(viewKey, baseKey, PTable.LinkType.PHYSICAL_TABLE));
                continue;
            }
            view.setBase(baseKey);
        }
    }

    private void processChildParentLinks(PhoenixConnection phoenixConnection) throws Exception {
        ResultSet childParentLinkRS = phoenixConnection.createStatement().executeQuery(childParentLinkQuery);
        while (childParentLinkRS.next()) {
            Key anotherParentKey;
            String childTenantId = childParentLinkRS.getString(1);
            String childSchemaName = childParentLinkRS.getString(2);
            String childTableName = childParentLinkRS.getString(3);
            Key childKey = new Key(childTenantId, childSchemaName, childTableName);
            View childView = this.orphanViewSet.get(childKey);
            String parentTenantId = childParentLinkRS.getString(4);
            String parentFullTableName = childParentLinkRS.getString(5);
            Key parentKey = new Key(parentTenantId, parentFullTableName);
            View parentView = this.orphanViewSet.get(parentKey);
            if (childView != null && parentView == null && parentTenantId == null && childTenantId != null && (parentView = this.orphanViewSet.get(anotherParentKey = new Key(childTenantId, parentFullTableName))) != null) {
                parentKey = anotherParentKey;
            }
            if (childView == null || parentView == null) {
                this.orphanLinkSet.add(new Link(childKey, parentKey, PTable.LinkType.PARENT_TABLE));
                continue;
            }
            childView.setParent(parentKey);
        }
    }

    private void processParentChildLinks(PhoenixConnection phoenixConnection) throws Exception {
        ResultSet parentChildLinkRS = phoenixConnection.createStatement().executeQuery(parentChildLinkQuery);
        while (parentChildLinkRS.next()) {
            String childFullTableName;
            String tenantId = parentChildLinkRS.getString(1);
            String schemaName = parentChildLinkRS.getString(2);
            String tableName = parentChildLinkRS.getString(3);
            Key parentKey = new Key(tenantId, schemaName, tableName);
            Base base = this.baseSet.get(parentKey);
            View parentView = this.orphanViewSet.get(parentKey);
            String childTenantId = parentChildLinkRS.getString(4);
            Key childKey = new Key(childTenantId, childFullTableName = parentChildLinkRS.getString(5));
            View childView = this.orphanViewSet.get(childKey);
            if (childView == null) {
                this.orphanLinkSet.add(new Link(parentKey, childKey, PTable.LinkType.CHILD_TABLE));
                continue;
            }
            if (base != null) {
                base.addChild(childKey);
                continue;
            }
            if (parentView != null) {
                parentView.addChild(childKey);
                continue;
            }
            this.orphanLinkSet.add(new Link(parentKey, childKey, PTable.LinkType.CHILD_TABLE));
        }
    }

    private void removeBaseTablesWithNoChildViewFromBaseSet() {
        Iterator<Map.Entry<Key, Base>> iterator = this.baseSet.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Key, Base> entry = iterator.next();
            if (entry.getValue().childViews != null && !entry.getValue().childViews.isEmpty()) continue;
            iterator.remove();
        }
    }

    private void visitViewsLevelByLevelAndIdentifyOrphanViews() {
        if (this.baseSet.isEmpty()) {
            return;
        }
        HashMap<Key, View> viewSet = new HashMap<Key, View>();
        this.viewSetArray.add(0, viewSet);
        for (Map.Entry<Key, Base> baseEntry : this.baseSet.entrySet()) {
            for (Key child : baseEntry.getValue().childViews) {
                View childView = this.orphanViewSet.get(child);
                if (childView == null || childView.base == null || !childView.base.equals(baseEntry.getKey())) continue;
                this.orphanViewSet.remove(child);
                viewSet.put(child, childView);
            }
        }
        HashMap<Key, View> parentViewSet = viewSet;
        this.maxViewLevel = 1;
        int i = 1;
        while (!parentViewSet.isEmpty()) {
            HashMap<Key, View> childViewSet = new HashMap<Key, View>();
            this.viewSetArray.add(i, childViewSet);
            for (Map.Entry viewEntry : parentViewSet.entrySet()) {
                View parentView = (View)viewEntry.getValue();
                Key parentKey = (Key)viewEntry.getKey();
                if (!parentView.isParent()) continue;
                for (Key child : parentView.childViews) {
                    View childView = this.orphanViewSet.get(child);
                    if (childView == null || childView.parent == null || !childView.parent.equals(parentKey) || childView.base == null || !childView.base.equals(parentView.base)) continue;
                    this.orphanViewSet.remove(child);
                    childViewSet.put(child, childView);
                }
            }
            parentViewSet = childViewSet;
            ++this.maxViewLevel;
            ++i;
        }
    }

    private void identifyOrphanViews(PhoenixConnection phoenixConnection) throws Exception {
        if (this.inputPath != null) {
            this.readOrphanViews();
            return;
        }
        this.populateOrphanViewSet(phoenixConnection);
        this.populateBaseSet(phoenixConnection);
        this.processPhysicalLinks(phoenixConnection);
        this.processParentChildLinks(phoenixConnection);
        this.processChildParentLinks(phoenixConnection);
        if (this.baseSet == null) {
            return;
        }
        this.removeBaseTablesWithNoChildViewFromBaseSet();
        this.visitViewsLevelByLevelAndIdentifyOrphanViews();
    }

    private void createSnapshot(PhoenixConnection phoenixConnection, long scn) throws Exception {
        try (Admin admin = phoenixConnection.getQueryServices().getAdmin();){
            admin.snapshot("OrphanViewTool." + scn, TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME));
            admin.snapshot("OrphanViewTool." + (scn + 1L), TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME));
        }
    }

    private void readOrphanViews() throws Exception {
        String aLine;
        this.reader[0] = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(Paths.get(this.inputPath, fileName[0]).toFile()), StandardCharsets.UTF_8));
        while ((aLine = this.reader[0].readLine()) != null) {
            Key key = new Key(aLine);
            this.orphanViewSet.put(key, new View(key));
        }
    }

    private void readAndRemoveOrphanLinks(PhoenixConnection phoenixConnection) throws Exception {
        for (byte i = 1; i < 4; i = (byte)((byte)(i + 1))) {
            String aLine;
            this.reader[i] = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(Paths.get(this.inputPath, fileName[i]).toFile()), StandardCharsets.UTF_8));
            while ((aLine = this.reader[i].readLine()) != null) {
                String[] ends = aLine.split("-->");
                this.removeLink(phoenixConnection, new Key(ends[0]), new Key(ends[1]), this.getLinkType(i));
            }
        }
    }

    private void closeConnectionAndFiles(Connection connection) throws IOException {
        this.tryClosingConnection(connection);
        for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
            if (this.writer[i] != null) {
                this.writer[i].close();
            }
            if (this.reader[i] == null) continue;
            this.reader[i].close();
        }
    }

    private void tryClosingConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sqlE) {
            LOGGER.error("Failed to close connection: ", (Throwable)sqlE);
            throw new RuntimeException("Failed to close connection with exception: ", sqlE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        Connection connection = null;
        try {
            Configuration configuration = HBaseConfiguration.addHbaseResources((Configuration)this.getConf());
            try {
                this.parseOptions(args);
            }
            catch (IllegalStateException e) {
                this.printHelpAndExit(e.getMessage(), this.getOptions());
            }
            if (this.outputPath != null) {
                for (int i = 0; i < 4; ++i) {
                    File file = Paths.get(this.outputPath, fileName[i]).toFile();
                    if (file.exists()) {
                        file.delete();
                    }
                    file.createNewFile();
                    this.writer[i] = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
                }
            }
            Properties props = new Properties();
            long scn = EnvironmentEdgeManager.currentTimeMillis() - this.ageMs;
            props.setProperty("CurrentSCN", Long.toString(scn));
            connection = ConnectionUtil.getInputConnection((Configuration)configuration, (Properties)props);
            PhoenixConnection phoenixConnection = connection.unwrap(PhoenixConnection.class);
            this.identifyOrphanViews(phoenixConnection);
            if (this.clean) {
                phoenixConnection.close();
                connection = ConnectionUtil.getInputConnection((Configuration)configuration);
                phoenixConnection = connection.unwrap(PhoenixConnection.class);
                this.createSnapshot(phoenixConnection, scn);
            }
            for (Map.Entry<Key, View> entry : this.orphanViewSet.entrySet()) {
                try {
                    this.dropOrLogOrphanViews(phoenixConnection, configuration, entry.getKey());
                }
                catch (Exception exception) {}
            }
            if (this.clean) {
                long timeInterval = configuration.getLong("phoenix.task.handling.interval.ms", 60000L);
                Thread.sleep((long)this.maxViewLevel * timeInterval);
                for (Map.Entry<Key, View> entry : this.orphanViewSet.entrySet()) {
                    try {
                        this.forcefullyDropView(phoenixConnection, entry.getKey());
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.inputPath == null) {
                this.removeOrLogOrphanLinks(phoenixConnection);
            } else {
                this.readAndRemoveOrphanLinks(phoenixConnection);
            }
            int n = 0;
            this.closeConnectionAndFiles(connection);
            return n;
        }
        catch (Exception ex) {
            LOGGER.error("Orphan View Tool : An exception occurred " + ExceptionUtils.getMessage((Throwable)ex) + " at:\n" + ExceptionUtils.getStackTrace((Throwable)ex));
            int n = -1;
            return n;
        }
        finally {
            this.closeConnectionAndFiles(connection);
        }
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run((Tool)new OrphanViewTool(), (String[])args);
        System.exit(result);
    }

    private static class Key {
        private String serializedValue;

        public Key(String tenantId, String schemaName, String tableName) throws IllegalArgumentException {
            if (tableName == null) {
                throw new IllegalArgumentException();
            }
            this.serializedValue = (String)(tenantId != null ? tenantId + "," : ",") + (String)(schemaName != null ? schemaName + "," : ",") + tableName;
        }

        public Key(String tenantId, String fullTableName) {
            String tableName;
            String schemaName;
            String[] columns = fullTableName.split("\\.");
            if (columns.length == 1) {
                schemaName = null;
                tableName = fullTableName;
            } else {
                schemaName = columns[0];
                tableName = columns[1];
            }
            if (tableName == null || tableName.compareTo("") == 0) {
                throw new IllegalArgumentException();
            }
            this.serializedValue = (String)(tenantId != null ? tenantId + "," : ",") + (String)(schemaName != null ? schemaName + "," : ",") + tableName;
        }

        public Key(String serializedKey) {
            this.serializedValue = serializedKey;
            if (this.getTableName() == null || this.getTableName().compareTo("") == 0) {
                throw new IllegalArgumentException();
            }
        }

        public String getTenantId() {
            String[] columns = this.serializedValue.split(",");
            return columns[0].compareTo("") == 0 ? null : columns[0];
        }

        public String getSchemaName() {
            String[] columns = this.serializedValue.split(",");
            return columns[1].compareTo("") == 0 ? null : columns[1];
        }

        public String getTableName() {
            String[] columns = this.serializedValue.split(",");
            return columns[2];
        }

        public String getSerializedValue() {
            return this.serializedValue;
        }

        public int hashCode() {
            return Objects.hash(this.getSerializedValue());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return this.getSerializedValue().compareTo(other.getSerializedValue()) == 0;
        }
    }

    private static class Link {
        Key src;
        Key dst;
        PTable.LinkType type;

        public Link(Key src, Key dst, PTable.LinkType type) {
            this.src = src;
            this.dst = dst;
            this.type = type;
        }

        public String serialize() {
            return this.src.getSerializedValue() + "," + this.dst.getSerializedValue() + "," + this.type.toString();
        }

        public int hashCode() {
            return Objects.hash(this.serialize());
        }
    }

    private static class View
    extends Table {
        Key parent;
        Key base;

        public View(Key key) {
            this.key = key;
        }

        public void setParent(Key parent) {
            this.parent = parent;
        }

        public void setBase(Key base) {
            this.base = base;
        }
    }

    private static class Base
    extends Table {
        public Base(Key key) {
            this.key = key;
        }
    }

    private static abstract class Table {
        protected Key key;
        protected List<Key> childViews;

        private Table() {
        }

        public void addChild(Key childView) {
            if (this.childViews == null) {
                this.childViews = new LinkedList<Key>();
            }
            this.childViews.add(childView);
        }

        public boolean isParent() {
            return this.childViews != null && !this.childViews.isEmpty();
        }
    }
}

