/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileWriterImpl;
import org.apache.hadoop.hbase.mapreduce.CellSerialization;
import org.apache.hadoop.hbase.mapreduce.MutationSerialization;
import org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitter;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.apache.phoenix.mapreduce.CsvBulkImportUtil;
import org.apache.phoenix.mapreduce.bulkload.TableRowkeyPair;
import org.apache.phoenix.mapreduce.bulkload.TargetTableRef;
import org.apache.phoenix.mapreduce.bulkload.TargetTableRefFunctions;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiHfileOutputFormat
extends FileOutputFormat<TableRowkeyPair, Cell> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiHfileOutputFormat.class);
    private static final String COMPRESSION_FAMILIES_CONF_KEY = "hbase.hfileoutputformat.families.compression";
    private static final String BLOOM_TYPE_FAMILIES_CONF_KEY = "hbase.hfileoutputformat.families.bloomtype";
    private static final String BLOCK_SIZE_FAMILIES_CONF_KEY = "hbase.mapreduce.hfileoutputformat.blocksize";
    private static final String DATABLOCK_ENCODING_FAMILIES_CONF_KEY = "hbase.mapreduce.hfileoutputformat.families.datablock.encoding";
    public static final String DATABLOCK_ENCODING_OVERRIDE_CONF_KEY = "hbase.mapreduce.hfileoutputformat.datablock.encoding";
    private static final String AT_DELIMITER = "@";

    public RecordWriter<TableRowkeyPair, Cell> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return MultiHfileOutputFormat.createRecordWriter(context, this.getOutputCommitter(context));
    }

    static <V extends Cell> RecordWriter<TableRowkeyPair, V> createRecordWriter(final TaskAttemptContext context, OutputCommitter committer) throws IOException {
        final Path outputdir = ((PathOutputCommitter)committer).getWorkPath();
        final Configuration conf = context.getConfiguration();
        final FileSystem fs = outputdir.getFileSystem(conf);
        final long maxsize = conf.getLongBytes("hbase.hregion.max.filesize", 0x280000000L);
        String defaultCompressionStr = conf.get("hfile.compression", Compression.Algorithm.NONE.getName());
        final Compression.Algorithm defaultCompression = HFileWriterImpl.compressionByName((String)defaultCompressionStr);
        final boolean compactionExclude = conf.getBoolean("hbase.mapreduce.hfileoutputformat.compaction.exclude", false);
        return new RecordWriter<TableRowkeyPair, V>(){
            private final Map<byte[], WriterLength> writers = new TreeMap<byte[], WriterLength>(Bytes.BYTES_COMPARATOR);
            private byte[] previousRow = HConstants.EMPTY_BYTE_ARRAY;
            private final long now = EnvironmentEdgeManager.currentTimeMillis();
            private boolean rollRequested = false;

            public void write(TableRowkeyPair row, V cell) throws IOException {
                Object kv = cell;
                if (row == null && kv == null) {
                    this.rollWriters();
                    return;
                }
                String tableName = row.getTableName();
                byte[] rowKey = row.getRowkey().get();
                int length = PrivateCellUtil.estimatedSerializedSizeOf(kv) - 4;
                byte[] family = CellUtil.cloneFamily(kv);
                byte[] tableAndFamily = MultiHfileOutputFormat.join(tableName, Bytes.toString((byte[])family));
                WriterLength wl = this.writers.get(tableAndFamily);
                if (wl == null) {
                    Path tableOutputPath = CsvBulkImportUtil.getOutputPath(outputdir, tableName);
                    fs.mkdirs(new Path(tableOutputPath, Bytes.toString((byte[])family)));
                }
                if (wl != null && wl.written + (long)length >= maxsize) {
                    this.rollRequested = true;
                }
                if (this.rollRequested && Bytes.compareTo((byte[])this.previousRow, (byte[])rowKey) != 0) {
                    this.rollWriters();
                }
                if (wl == null || wl.writer == null) {
                    wl = this.getNewWriter(tableName, family, conf);
                }
                if (cell.getTimestamp() == Long.MAX_VALUE) {
                    CellUtil.setTimestamp(cell, (long)this.now);
                }
                wl.writer.append(kv);
                wl.written += (long)length;
                this.previousRow = rowKey;
            }

            private void rollWriters() throws IOException {
                for (WriterLength wl : this.writers.values()) {
                    if (wl.writer != null) {
                        LOGGER.info("Writer=" + wl.writer.getPath() + (String)(wl.written == 0L ? "" : ", wrote=" + wl.written));
                        this.close(wl.writer);
                    }
                    wl.writer = null;
                    wl.written = 0L;
                }
                this.rollRequested = false;
            }

            @SuppressWarnings(value={"BX_UNBOXING_IMMEDIATELY_REBOXED"}, justification="Not important")
            private WriterLength getNewWriter(String tableName, byte[] family, Configuration conf2) throws IOException {
                WriterLength wl = new WriterLength();
                Path tableOutputPath = CsvBulkImportUtil.getOutputPath(outputdir, tableName);
                Path familydir = new Path(tableOutputPath, Bytes.toString((byte[])family));
                Map<byte[], Compression.Algorithm> compressionMap = MultiHfileOutputFormat.createFamilyCompressionMap(conf2, tableName);
                Map<byte[], BloomType> bloomTypeMap = MultiHfileOutputFormat.createFamilyBloomTypeMap(conf2, tableName);
                Map<byte[], Integer> blockSizeMap = MultiHfileOutputFormat.createFamilyBlockSizeMap(conf2, tableName);
                String dataBlockEncodingStr = conf2.get(MultiHfileOutputFormat.DATABLOCK_ENCODING_OVERRIDE_CONF_KEY);
                Map<byte[], DataBlockEncoding> datablockEncodingMap = MultiHfileOutputFormat.createFamilyDataBlockEncodingMap(conf2, tableName);
                DataBlockEncoding overriddenEncoding = dataBlockEncodingStr != null ? DataBlockEncoding.valueOf((String)dataBlockEncodingStr) : null;
                Compression.Algorithm compression = compressionMap.get(family);
                compression = compression == null ? defaultCompression : compression;
                BloomType bloomType = bloomTypeMap.get(family);
                bloomType = bloomType == null ? BloomType.NONE : bloomType;
                Integer blockSize = blockSizeMap.get(family);
                blockSize = blockSize == null ? 65536 : blockSize;
                DataBlockEncoding encoding = overriddenEncoding;
                encoding = encoding == null ? datablockEncodingMap.get(family) : encoding;
                encoding = encoding == null ? DataBlockEncoding.NONE : encoding;
                Configuration tempConf = new Configuration(conf2);
                tempConf.setFloat("hfile.block.cache.size", 0.0f);
                HFileContextBuilder contextBuilder = new HFileContextBuilder().withCompression(compression).withChecksumType(StoreUtils.getChecksumType((Configuration)conf2)).withBytesPerCheckSum(StoreUtils.getBytesPerChecksum((Configuration)conf2)).withBlockSize(blockSize.intValue()).withDataBlockEncoding(encoding).withCellComparator((CellComparator)CellComparatorImpl.COMPARATOR);
                HFileContext hFileContext = contextBuilder.build();
                StoreFileWriter.Builder storeFileWriterBuilder = new StoreFileWriter.Builder(conf2, new CacheConfig(tempConf), fs).withOutputDir(familydir).withBloomType(bloomType).withFileContext(hFileContext);
                wl.writer = storeFileWriterBuilder.build();
                byte[] tableAndFamily = MultiHfileOutputFormat.join(tableName, Bytes.toString((byte[])family));
                this.writers.put(tableAndFamily, wl);
                return wl;
            }

            private void close(StoreFileWriter w) throws IOException {
                if (w != null) {
                    w.appendFileInfo(HStoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes((long)EnvironmentEdgeManager.currentTimeMillis()));
                    w.appendFileInfo(HStoreFile.BULKLOAD_TASK_KEY, Bytes.toBytes((String)context.getTaskAttemptID().toString()));
                    w.appendFileInfo(HStoreFile.MAJOR_COMPACTION_KEY, Bytes.toBytes((boolean)true));
                    w.appendFileInfo(HStoreFile.EXCLUDE_FROM_MINOR_COMPACTION_KEY, Bytes.toBytes((boolean)compactionExclude));
                    w.appendTrackedTimestampsToMetadata();
                    w.close();
                }
            }

            public void close(TaskAttemptContext c) throws IOException, InterruptedException {
                for (WriterLength wl : this.writers.values()) {
                    this.close(wl.writer);
                }
            }
        };
    }

    private static byte[] join(String tableName, String family) {
        return Bytes.toBytes((String)(tableName + AT_DELIMITER + family));
    }

    @VisibleForTesting
    static Map<byte[], Compression.Algorithm> createFamilyCompressionMap(Configuration conf, String tableName) {
        TreeMap<byte[], Compression.Algorithm> compressionMap = new TreeMap<byte[], Compression.Algorithm>(Bytes.BYTES_COMPARATOR);
        Map<String, String> tableConfigs = MultiHfileOutputFormat.getTableConfigurations(conf, tableName);
        if (tableConfigs == null) {
            return compressionMap;
        }
        Map<byte[], String> stringMap = MultiHfileOutputFormat.createFamilyConfValueMap(tableConfigs, COMPRESSION_FAMILIES_CONF_KEY);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            Compression.Algorithm algorithm = HFileWriterImpl.compressionByName((String)e.getValue());
            compressionMap.put(e.getKey(), algorithm);
        }
        return compressionMap;
    }

    private static Map<String, String> getTableConfigurations(Configuration conf, String tableName) {
        String tableDefn = conf.get(tableName);
        if (StringUtils.isEmpty((CharSequence)tableDefn)) {
            return null;
        }
        TargetTableRef table = (TargetTableRef)TargetTableRefFunctions.FROM_JSON.apply((Object)tableDefn);
        Map<String, String> tableConfigs = table.getConfiguration();
        return tableConfigs;
    }

    @VisibleForTesting
    static Map<byte[], BloomType> createFamilyBloomTypeMap(Configuration conf, String tableName) {
        TreeMap<byte[], BloomType> bloomTypeMap = new TreeMap<byte[], BloomType>(Bytes.BYTES_COMPARATOR);
        Map<String, String> tableConfigs = MultiHfileOutputFormat.getTableConfigurations(conf, tableName);
        if (tableConfigs == null) {
            return bloomTypeMap;
        }
        Map<byte[], String> stringMap = MultiHfileOutputFormat.createFamilyConfValueMap(tableConfigs, BLOOM_TYPE_FAMILIES_CONF_KEY);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            BloomType bloomType = BloomType.valueOf((String)e.getValue());
            bloomTypeMap.put(e.getKey(), bloomType);
        }
        return bloomTypeMap;
    }

    @VisibleForTesting
    static Map<byte[], Integer> createFamilyBlockSizeMap(Configuration conf, String tableName) {
        TreeMap<byte[], Integer> blockSizeMap = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        Map<String, String> tableConfigs = MultiHfileOutputFormat.getTableConfigurations(conf, tableName);
        if (tableConfigs == null) {
            return blockSizeMap;
        }
        Map<byte[], String> stringMap = MultiHfileOutputFormat.createFamilyConfValueMap(tableConfigs, BLOCK_SIZE_FAMILIES_CONF_KEY);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            Integer blockSize = Integer.parseInt(e.getValue());
            blockSizeMap.put(e.getKey(), blockSize);
        }
        return blockSizeMap;
    }

    @VisibleForTesting
    static Map<byte[], DataBlockEncoding> createFamilyDataBlockEncodingMap(Configuration conf, String tableName) {
        TreeMap<byte[], DataBlockEncoding> encoderMap = new TreeMap<byte[], DataBlockEncoding>(Bytes.BYTES_COMPARATOR);
        Map<String, String> tableConfigs = MultiHfileOutputFormat.getTableConfigurations(conf, tableName);
        if (tableConfigs == null) {
            return encoderMap;
        }
        Map<byte[], String> stringMap = MultiHfileOutputFormat.createFamilyConfValueMap(tableConfigs, DATABLOCK_ENCODING_FAMILIES_CONF_KEY);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            encoderMap.put(e.getKey(), DataBlockEncoding.valueOf((String)e.getValue()));
        }
        return encoderMap;
    }

    private static Map<byte[], String> createFamilyConfValueMap(Map<String, String> configs, String confName) {
        TreeMap<byte[], String> confValMap = new TreeMap<byte[], String>(Bytes.BYTES_COMPARATOR);
        String confVal = configs.get(confName);
        if (StringUtils.isEmpty((CharSequence)confVal)) {
            return confValMap;
        }
        for (String familyConf : confVal.split("&")) {
            String[] familySplit = familyConf.split("=");
            if (familySplit.length != 2) continue;
            try {
                confValMap.put(URLDecoder.decode(familySplit[0], "UTF-8").getBytes(StandardCharsets.UTF_8), URLDecoder.decode(familySplit[1], "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
        return confValMap;
    }

    static void configurePartitioner(Job job, Set<TableRowkeyPair> tablesStartKeys) throws IOException {
        Configuration conf = job.getConfiguration();
        Path partitionsPath = new Path(conf.get("hadoop.tmp.dir"), "partitions_" + UUID.randomUUID());
        FileSystem fs = partitionsPath.getFileSystem(conf);
        fs.makeQualified(partitionsPath);
        MultiHfileOutputFormat.writePartitions(conf, partitionsPath, tablesStartKeys);
        fs.deleteOnExit(partitionsPath);
        job.setPartitionerClass(TotalOrderPartitioner.class);
        TotalOrderPartitioner.setPartitionFile((Configuration)conf, (Path)partitionsPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"EC_ARRAY_AND_NONARRAY"}, justification="ImmutableBytesWritable DOES implement equals(byte])")
    private static void writePartitions(Configuration conf, Path partitionsPath, Set<TableRowkeyPair> tablesStartKeys) throws IOException {
        LOGGER.info("Writing partition information to " + partitionsPath);
        if (tablesStartKeys.isEmpty()) {
            throw new IllegalArgumentException("No regions passed");
        }
        TreeSet<TableRowkeyPair> sorted = new TreeSet<TableRowkeyPair>(tablesStartKeys);
        TableRowkeyPair first = sorted.first();
        if (!first.getRowkey().equals((Object)HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IllegalArgumentException("First region of table should have empty start key. Instead has: " + Bytes.toStringBinary((byte[])first.getRowkey().get()));
        }
        sorted.remove(first);
        FileSystem fs = partitionsPath.getFileSystem(conf);
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)partitionsPath, TableRowkeyPair.class, NullWritable.class);){
            for (TableRowkeyPair startKey : sorted) {
                writer.append((Writable)startKey, (Writable)NullWritable.get());
            }
        }
    }

    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    @VisibleForTesting
    static String configureCompression(TableDescriptor tableDescriptor) throws UnsupportedEncodingException {
        StringBuilder compressionConfigValue = new StringBuilder();
        if (tableDescriptor == null) {
            return compressionConfigValue.toString();
        }
        ColumnFamilyDescriptor[] families = tableDescriptor.getColumnFamilies();
        int i = 0;
        for (ColumnFamilyDescriptor familyDescriptor : families) {
            if (i++ > 0) {
                compressionConfigValue.append('&');
            }
            compressionConfigValue.append(URLEncoder.encode(familyDescriptor.getNameAsString(), "UTF-8"));
            compressionConfigValue.append('=');
            compressionConfigValue.append(URLEncoder.encode(familyDescriptor.getCompressionType().getName(), "UTF-8"));
        }
        return compressionConfigValue.toString();
    }

    @VisibleForTesting
    static String configureBlockSize(TableDescriptor tableDescriptor) throws UnsupportedEncodingException {
        StringBuilder blockSizeConfigValue = new StringBuilder();
        if (tableDescriptor == null) {
            return blockSizeConfigValue.toString();
        }
        ColumnFamilyDescriptor[] families = tableDescriptor.getColumnFamilies();
        int i = 0;
        for (ColumnFamilyDescriptor familyDescriptor : families) {
            if (i++ > 0) {
                blockSizeConfigValue.append('&');
            }
            blockSizeConfigValue.append(URLEncoder.encode(familyDescriptor.getNameAsString(), "UTF-8"));
            blockSizeConfigValue.append('=');
            blockSizeConfigValue.append(URLEncoder.encode(String.valueOf(familyDescriptor.getBlocksize()), "UTF-8"));
        }
        return blockSizeConfigValue.toString();
    }

    static String configureBloomType(TableDescriptor tableDescriptor) throws UnsupportedEncodingException {
        StringBuilder bloomTypeConfigValue = new StringBuilder();
        if (tableDescriptor == null) {
            return bloomTypeConfigValue.toString();
        }
        ColumnFamilyDescriptor[] families = tableDescriptor.getColumnFamilies();
        int i = 0;
        for (ColumnFamilyDescriptor familyDescriptor : families) {
            if (i++ > 0) {
                bloomTypeConfigValue.append('&');
            }
            bloomTypeConfigValue.append(URLEncoder.encode(familyDescriptor.getNameAsString(), "UTF-8"));
            bloomTypeConfigValue.append('=');
            String bloomType = familyDescriptor.getBloomFilterType().toString();
            if (bloomType == null) {
                bloomType = ColumnFamilyDescriptorBuilder.DEFAULT_BLOOMFILTER.toString();
            }
            bloomTypeConfigValue.append(URLEncoder.encode(bloomType, "UTF-8"));
        }
        return bloomTypeConfigValue.toString();
    }

    static String configureDataBlockEncoding(TableDescriptor tableDescriptor) throws UnsupportedEncodingException {
        StringBuilder dataBlockEncodingConfigValue = new StringBuilder();
        if (tableDescriptor == null) {
            return dataBlockEncodingConfigValue.toString();
        }
        ColumnFamilyDescriptor[] families = tableDescriptor.getColumnFamilies();
        int i = 0;
        for (ColumnFamilyDescriptor familyDescriptor : families) {
            if (i++ > 0) {
                dataBlockEncodingConfigValue.append('&');
            }
            dataBlockEncodingConfigValue.append(URLEncoder.encode(familyDescriptor.getNameAsString(), "UTF-8"));
            dataBlockEncodingConfigValue.append('=');
            DataBlockEncoding encoding = familyDescriptor.getDataBlockEncoding();
            if (encoding == null) {
                encoding = DataBlockEncoding.NONE;
            }
            dataBlockEncodingConfigValue.append(URLEncoder.encode(encoding.toString(), "UTF-8"));
        }
        return dataBlockEncodingConfigValue.toString();
    }

    @SuppressWarnings(value={"deprecation"})
    public static void configureIncrementalLoad(Job job, List<TargetTableRef> tablesToBeLoaded) throws IOException {
        Configuration conf = job.getConfiguration();
        job.setOutputFormatClass(MultiHfileOutputFormat.class);
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName(), CellSerialization.class.getName()});
        TreeSet tablesStartKeys = Sets.newTreeSet();
        for (TargetTableRef table : tablesToBeLoaded) {
            String tableName = table.getPhysicalName();
            Connection hbaseConn = ConnectionFactory.createConnection((Configuration)conf);
            try {
                Set<TableRowkeyPair> startKeys = MultiHfileOutputFormat.getRegionStartKeys(tableName, hbaseConn.getRegionLocator(TableName.valueOf((String)tableName)));
                tablesStartKeys.addAll(startKeys);
                TableDescriptor tableDescriptor = hbaseConn.getTable(TableName.valueOf((String)tableName)).getDescriptor();
                String compressionConfig = MultiHfileOutputFormat.configureCompression(tableDescriptor);
                String bloomTypeConfig = MultiHfileOutputFormat.configureBloomType(tableDescriptor);
                String blockSizeConfig = MultiHfileOutputFormat.configureBlockSize(tableDescriptor);
                String blockEncodingConfig = MultiHfileOutputFormat.configureDataBlockEncoding(tableDescriptor);
                HashMap tableConfigs = Maps.newHashMap();
                if (StringUtils.isNotBlank((CharSequence)compressionConfig)) {
                    tableConfigs.put(COMPRESSION_FAMILIES_CONF_KEY, compressionConfig);
                }
                if (StringUtils.isNotBlank((CharSequence)bloomTypeConfig)) {
                    tableConfigs.put(BLOOM_TYPE_FAMILIES_CONF_KEY, bloomTypeConfig);
                }
                if (StringUtils.isNotBlank((CharSequence)blockSizeConfig)) {
                    tableConfigs.put(BLOCK_SIZE_FAMILIES_CONF_KEY, blockSizeConfig);
                }
                if (StringUtils.isNotBlank((CharSequence)blockEncodingConfig)) {
                    tableConfigs.put(DATABLOCK_ENCODING_FAMILIES_CONF_KEY, blockEncodingConfig);
                }
                table.setConfiguration(tableConfigs);
                String tableDefns = (String)TargetTableRefFunctions.TO_JSON.apply((Object)table);
                conf.set(tableName, tableDefns);
                TargetTableRef tbl = (TargetTableRef)TargetTableRefFunctions.FROM_JSON.apply((Object)tableDefns);
                LOGGER.info(" the table logical name is " + tbl.getLogicalName());
            }
            finally {
                if (hbaseConn == null) continue;
                hbaseConn.close();
            }
        }
        LOGGER.info("Configuring " + tablesStartKeys.size() + " reduce partitions to match current region count");
        job.setNumReduceTasks(tablesStartKeys.size());
        MultiHfileOutputFormat.configurePartitioner(job, tablesStartKeys);
        TableMapReduceUtil.addDependencyJars((Job)job);
        TableMapReduceUtil.initCredentials((Job)job);
    }

    private static Set<TableRowkeyPair> getRegionStartKeys(String tableName, RegionLocator table) throws IOException {
        byte[][] byteKeys = table.getStartKeys();
        TreeSet<TableRowkeyPair> ret = new TreeSet<TableRowkeyPair>();
        for (byte[] byteKey : byteKeys) {
            ret.add(new TableRowkeyPair(tableName, new ImmutableBytesWritable(byteKey)));
        }
        return ret;
    }

    static class WriterLength {
        long written = 0L;
        StoreFileWriter writer = null;

        WriterLength() {
        }
    }
}

