/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.ExtendedCellBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.hfile.BlockCacheFactory;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.OnlineRegions;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.phoenix.iterate.NonAggregateRegionScannerFactory;
import org.apache.phoenix.iterate.RegionScannerFactory;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.schema.stats.DefaultStatisticsCollector;
import org.apache.phoenix.schema.stats.NoOpStatisticsCollector;
import org.apache.phoenix.schema.stats.StatisticsCollector;
import org.apache.phoenix.schema.stats.StatisticsWriter;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotScanner
extends AbstractClientScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotScanner.class);
    private final Scan scan;
    private RegionScanner scanner;
    private HRegion region;
    private List<Cell> values;
    private StatisticsCollector statisticsCollector;

    public SnapshotScanner(Configuration conf, FileSystem fs, Path rootDir, TableDescriptor htd, RegionInfo hri, Scan scan) throws Throwable {
        LOGGER.info("Creating SnapshotScanner for region: " + hri);
        scan.setIsolationLevel(IsolationLevel.READ_UNCOMMITTED);
        this.values = new ArrayList<Cell>();
        this.initRegionForSnapshotScanner(conf, fs, rootDir, htd, hri);
        this.scan = scan;
        RegionCoprocessorEnvironment snapshotEnv = this.getSnapshotContextEnvironment(conf);
        if (ScanUtil.isAnalyzeTable((Scan)scan)) {
            this.scanner = this.region.getScanner(scan);
            PhoenixConnection connection = (PhoenixConnection)ConnectionUtil.getInputConnection((Configuration)conf, (Properties)new Properties());
            String tableName = this.region.getTableDescriptor().getTableName().getNameAsString();
            TableName physicalTableName = SchemaUtil.getPhysicalTableName((byte[])PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, (Configuration)conf);
            Table table = connection.getQueryServices().getTable(physicalTableName.getName());
            StatisticsWriter statsWriter = StatisticsWriter.newWriter(connection, tableName, Long.MAX_VALUE);
            this.statisticsCollector = new DefaultStatisticsCollector(conf, (Region)this.region, tableName, null, null, null, statsWriter, table);
        } else if (scan.getAttribute("_NonAggregateQuery") != null) {
            NonAggregateRegionScannerFactory regionScannerFactory = new NonAggregateRegionScannerFactory(snapshotEnv);
            this.scanner = ((RegionScannerFactory)regionScannerFactory).getRegionScanner(scan, (RegionScanner)this.region.getScanner(scan));
            this.statisticsCollector = new NoOpStatisticsCollector();
        } else {
            throw new UnsupportedOperationException("Snapshot M/R jobs not available for aggregate queries");
        }
        this.statisticsCollector.init();
        this.region.startRegionOperation();
    }

    private void initRegionForSnapshotScanner(Configuration conf, FileSystem fs, Path rootDir, TableDescriptor htd, RegionInfo hri) throws IOException {
        this.region = HRegion.newHRegion((Path)CommonFSUtils.getTableDir((Path)rootDir, (TableName)htd.getTableName()), null, (FileSystem)fs, (Configuration)conf, (RegionInfo)hri, (TableDescriptor)htd, null);
        this.region.setRestoredRegion(true);
        conf.set("hfile.block.cache.policy", "IndexOnlyLRU");
        conf.setIfUnset("hfile.onheap.block.cache.fixed.size", String.valueOf(0x2000000L));
        conf.unset("hbase.bucketcache.ioengine");
        conf.setBoolean("hbase.hregion.memstore.mslab.enabled", false);
        this.region.setBlockCache(BlockCacheFactory.createBlockCache((Configuration)conf));
        this.region.setMobFileCache(new MobFileCache(conf));
        this.region.initialize();
    }

    public Result next() throws IOException {
        this.values.clear();
        boolean hasMore = this.scanner.nextRaw(this.values);
        this.statisticsCollector.collectStatistics(this.values);
        if (hasMore || !this.values.isEmpty()) {
            return Result.create(this.values);
        }
        return null;
    }

    public void close() {
        if (this.scanner != null) {
            try {
                this.statisticsCollector.updateStatistics((Region)this.region, this.scan);
                this.scanner.close();
                this.scanner = null;
            }
            catch (IOException e) {
                LOGGER.warn("Exception while closing scanner", (Throwable)e);
            }
        }
        if (this.region != null) {
            try {
                this.region.closeRegionOperation();
                this.region.close(true);
                this.region = null;
            }
            catch (IOException e) {
                LOGGER.warn("Exception while closing scanner", (Throwable)e);
            }
        }
    }

    public boolean renewLease() {
        return false;
    }

    private RegionCoprocessorEnvironment getSnapshotContextEnvironment(final Configuration conf) {
        return new RegionCoprocessorEnvironment(){

            public Region getRegion() {
                return SnapshotScanner.this.region;
            }

            public RegionInfo getRegionInfo() {
                return SnapshotScanner.this.region.getRegionInfo();
            }

            public ConcurrentMap<String, Object> getSharedData() {
                throw new UnsupportedOperationException();
            }

            public int getVersion() {
                throw new UnsupportedOperationException();
            }

            public String getHBaseVersion() {
                throw new UnsupportedOperationException();
            }

            public int getPriority() {
                throw new UnsupportedOperationException();
            }

            public int getLoadSequence() {
                throw new UnsupportedOperationException();
            }

            public Configuration getConfiguration() {
                return conf;
            }

            public ClassLoader getClassLoader() {
                throw new UnsupportedOperationException();
            }

            public RegionCoprocessor getInstance() {
                throw new UnsupportedOperationException();
            }

            public OnlineRegions getOnlineRegions() {
                throw new UnsupportedOperationException();
            }

            public ServerName getServerName() {
                throw new UnsupportedOperationException();
            }

            public Connection getConnection() {
                throw new UnsupportedOperationException();
            }

            public MetricRegistry getMetricRegistryForRegionServer() {
                throw new UnsupportedOperationException();
            }

            public Connection createConnection(Configuration conf2) throws IOException {
                throw new UnsupportedOperationException();
            }

            public ExtendedCellBuilder getCellBuilder() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

