/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.iterate.BaseResultIterator;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.tuple.EncodedColumnQualiferCellsList;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.PositionBasedMultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.ScanUtil;

public class RegionScannerResultIterator
extends BaseResultIterator {
    private final RegionScanner scanner;
    private final Pair<Integer, Integer> minMaxQualifiers;
    private final boolean useQualifierAsIndex;
    private final PTable.QualifierEncodingScheme encodingScheme;
    private final ScannerContext regionScannerContext;

    public RegionScannerResultIterator(Scan scan, RegionScanner scanner, Pair<Integer, Integer> minMaxQualifiers, PTable.QualifierEncodingScheme encodingScheme) {
        this.scanner = scanner;
        this.useQualifierAsIndex = EncodedColumnsUtil.useQualifierAsIndex(minMaxQualifiers);
        this.minMaxQualifiers = minMaxQualifiers;
        this.encodingScheme = encodingScheme;
        this.regionScannerContext = scan.isScanMetricsEnabled() ? ScannerContext.newBuilder().setTrackMetrics(scan.isScanMetricsEnabled()).build() : null;
    }

    public Tuple next() throws SQLException {
        RegionScanner regionScanner = this.scanner;
        synchronized (regionScanner) {
            try {
                Object results = this.useQualifierAsIndex ? new EncodedColumnQualiferCellsList(((Integer)this.minMaxQualifiers.getFirst()).intValue(), ((Integer)this.minMaxQualifiers.getSecond()).intValue(), this.encodingScheme) : new ArrayList();
                boolean hasMore = this.regionScannerContext == null ? this.scanner.nextRaw((List)results) : this.scanner.nextRaw((List)results, this.regionScannerContext);
                if (!hasMore && results.isEmpty()) {
                    return null;
                }
                if (ScanUtil.isDummy((List)results)) {
                    return new ResultTuple(Result.create((List)results));
                }
                PositionBasedMultiKeyValueTuple tuple = this.useQualifierAsIndex ? new PositionBasedMultiKeyValueTuple() : new MultiKeyValueTuple();
                tuple.setKeyValues((List)results);
                return tuple;
            }
            catch (IOException e) {
                throw ClientUtil.parseServerException((Throwable)e);
            }
        }
    }

    public ScannerContext getRegionScannerContext() {
        return this.regionScannerContext;
    }

    public String toString() {
        return "RegionScannerResultIterator [scanner=" + this.scanner + "]";
    }
}

