/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.cache.GlobalCache;
import org.apache.phoenix.cache.IndexMetaDataCache;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.cache.TenantCache;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.PhoenixIndexMetaData;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.ScanUtil;

public class PhoenixIndexMetaDataBuilder {
    private final RegionCoprocessorEnvironment env;

    PhoenixIndexMetaDataBuilder(RegionCoprocessorEnvironment env) {
        this.env = env;
    }

    public PhoenixIndexMetaData getIndexMetaData(MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        IndexMetaDataCache indexMetaDataCache = PhoenixIndexMetaDataBuilder.getIndexMetaDataCache(this.env, ((Mutation)miniBatchOp.getOperation(0)).getAttributesMap());
        return new PhoenixIndexMetaData(indexMetaDataCache, ((Mutation)miniBatchOp.getOperation(0)).getAttributesMap());
    }

    private static IndexMetaDataCache getIndexMetaDataCache(RegionCoprocessorEnvironment env, Map<String, byte[]> attributes) throws IOException {
        if (attributes == null) {
            return IndexMetaDataCache.EMPTY_INDEX_META_DATA_CACHE;
        }
        byte[] uuid = attributes.get("IdxUUID");
        if (uuid == null) {
            return IndexMetaDataCache.EMPTY_INDEX_META_DATA_CACHE;
        }
        byte[] md = attributes.get("IdxProtoMD");
        if (md == null) {
            md = attributes.get("IdxMD");
        }
        if (md != null) {
            boolean useProto = md != null;
            byte[] txState = attributes.get("_TxState");
            final List indexMaintainers = IndexMaintainer.deserialize((byte[])md, (boolean)useProto);
            byte[] clientVersionBytes = attributes.get("_ClientVersion");
            final int clientVersion = clientVersionBytes == null ? ScanUtil.UNKNOWN_CLIENT_VERSION : Bytes.toInt((byte[])clientVersionBytes);
            final PhoenixTransactionContext txnContext = TransactionFactory.getTransactionContext((byte[])txState, (int)clientVersion);
            return new IndexMetaDataCache(){

                public void close() throws IOException {
                }

                public List<IndexMaintainer> getIndexMaintainers() {
                    return indexMaintainers;
                }

                public PhoenixTransactionContext getTransactionContext() {
                    return txnContext;
                }

                public int getClientVersion() {
                    return clientVersion;
                }
            };
        }
        byte[] tenantIdBytes = attributes.get("TenantId");
        ImmutableBytesPtr tenantId = tenantIdBytes == null ? null : new ImmutableBytesPtr(tenantIdBytes);
        TenantCache cache = GlobalCache.getTenantCache(env, tenantId);
        IndexMetaDataCache indexCache = (IndexMetaDataCache)cache.getServerCache(new ImmutableBytesPtr(uuid));
        if (indexCache == null) {
            String msg = "key=" + ServerCacheClient.idToString((byte[])uuid) + " region=" + env.getRegion() + "host=" + env.getServerName().getServerName();
            SQLException e = new SQLExceptionInfo.Builder(SQLExceptionCode.INDEX_METADATA_NOT_FOUND).setMessage(msg).build().buildException();
            ClientUtil.throwIOException((String)"Index update failed", (Throwable)e);
        }
        return indexCache;
    }
}

