/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import java.io.IOException;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.phoenix.hbase.index.builder.FatalIndexBuildingFailureException;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.write.IndexFailurePolicy;
import org.apache.phoenix.thirdparty.com.google.common.collect.Multimap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillServerOnFailurePolicy
implements IndexFailurePolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(KillServerOnFailurePolicy.class);
    private Stoppable stoppable;

    @Override
    public void setup(Stoppable parent, RegionCoprocessorEnvironment env) {
        this.setup(parent);
    }

    public void setup(Stoppable parent) {
        this.stoppable = parent;
    }

    public void stop(String why) {
    }

    public boolean isStopped() {
        return this.stoppable.isStopped();
    }

    @Override
    public void handleFailure(Multimap<HTableInterfaceReference, Mutation> attempted, Exception cause) throws IOException {
        this.stop("Killing ourselves because of an error:" + cause);
        String msg = "Could not update the index table, killing server region because couldn't write to an index table";
        LOGGER.error(msg, (Throwable)cause);
        throw new FatalIndexBuildingFailureException(msg, (Throwable)cause);
    }
}

