/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.wal;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilder;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;

public class IndexedKeyValue
extends KeyValue {
    private ImmutableBytesPtr indexTableName;
    private Mutation mutation;
    private boolean batchFinished = false;
    private int hashCode;

    private static int calcHashCode(ImmutableBytesPtr indexTableName, Mutation mutation) {
        int prime = 31;
        int result = 1;
        result = 31 * result + indexTableName.hashCode();
        result = 31 * result + Arrays.hashCode(mutation.getRow());
        return result;
    }

    public static IndexedKeyValue newIndexedKeyValue(byte[] bs, Mutation m) {
        Cell indexWALCell = IndexedKeyValue.adaptFirstCellFromMutation(m);
        return new IndexedKeyValue(indexWALCell, bs, m);
    }

    private static Cell adaptFirstCellFromMutation(Mutation m) {
        if (m != null && m.getFamilyCellMap() != null && m.getFamilyCellMap().firstEntry() != null && m.getFamilyCellMap().firstEntry().getValue() != null && ((List)m.getFamilyCellMap().firstEntry().getValue()).get(0) != null) {
            Cell mutationCell = (Cell)((List)m.getFamilyCellMap().firstEntry().getValue()).get(0);
            CellBuilder builder = CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY);
            return builder.setFamily(WALEdit.METAFAMILY).setQualifier(mutationCell.getQualifierArray()).setRow(m.getRow()).setTimestamp(mutationCell.getTimestamp()).setValue(mutationCell.getValueArray()).setType(Cell.Type.Put).build();
        }
        throw new IllegalArgumentException("Tried to create an IndexedKeyValue with a Mutation with no Cells!");
    }

    public IndexedKeyValue() {
    }

    private IndexedKeyValue(Cell c, byte[] bs, Mutation mutation) {
        super(c);
        this.indexTableName = new ImmutableBytesPtr(bs);
        this.mutation = mutation;
        this.hashCode = IndexedKeyValue.calcHashCode(this.indexTableName, mutation);
    }

    public byte[] getIndexTable() {
        return this.indexTableName.get();
    }

    public Mutation getMutation() {
        return this.mutation;
    }

    public String toString() {
        return "IndexWrite:\n\ttable: " + this.indexTableName + "\n\tmutation:" + this.mutation;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        IndexedKeyValue other = (IndexedKeyValue)((Object)obj);
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (!other.indexTableName.equals((Object)this.indexTableName)) {
            return false;
        }
        byte[] current = this.getMutationBytes();
        byte[] otherMutation = other.getMutationBytes();
        return Bytes.equals((byte[])current, (byte[])otherMutation);
    }

    private byte[] getMutationBytes() {
        try {
            ClientProtos.MutationProto m = this.toMutationProto(this.mutation);
            return m.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to get bytes for mutation!", e);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    void writeData(DataOutput out) throws IOException {
        Bytes.writeByteArray((DataOutput)out, (byte[])this.indexTableName.get());
        ClientProtos.MutationProto m = this.toMutationProto(this.mutation);
        Bytes.writeByteArray((DataOutput)out, (byte[])m.toByteArray());
    }

    public boolean getBatchFinished() {
        return this.batchFinished;
    }

    public void markBatchFinished() {
        this.batchFinished = true;
    }

    protected ClientProtos.MutationProto toMutationProto(Mutation mutation) throws IOException {
        ClientProtos.MutationProto m = null;
        if (mutation instanceof Put) {
            m = ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)mutation);
        } else if (mutation instanceof Delete) {
            m = ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.DELETE, (Mutation)mutation);
        } else {
            throw new IOException("Put/Delete mutations only supported");
        }
        return m;
    }
}

