/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.coprocessorclient.BaseScannerRegionObserverConstants;
import org.apache.phoenix.hbase.index.builder.IndexBuilder;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;
import org.apache.phoenix.hbase.index.covered.data.CachedLocalTable;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.PhoenixIndexMetaData;
import org.apache.phoenix.thirdparty.com.google.common.collect.ListMultimap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexBuildManager
implements Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexBuildManager.class);
    private final IndexBuilder delegate;
    private boolean stopped;
    private RegionCoprocessorEnvironment regionCoprocessorEnvironment;

    public IndexBuildManager(RegionCoprocessorEnvironment env) throws IOException {
        this.delegate = IndexBuildManager.getIndexBuilder(env);
        this.regionCoprocessorEnvironment = env;
    }

    private static IndexBuilder getIndexBuilder(RegionCoprocessorEnvironment e) throws IOException {
        Configuration conf = e.getConfiguration();
        Class builderClass = conf.getClass("index.builder", null, IndexBuilder.class);
        try {
            IndexBuilder builder = (IndexBuilder)builderClass.newInstance();
            builder.setup(e);
            return builder;
        }
        catch (InstantiationException e1) {
            throw new IOException("Couldn't instantiate index builder:" + builderClass + ", disabling indexing on table " + e.getRegion().getTableDescriptor().getTableName().getNameAsString());
        }
        catch (IllegalAccessException e1) {
            throw new IOException("Couldn't instantiate index builder:" + builderClass + ", disabling indexing on table " + e.getRegion().getTableDescriptor().getTableName().getNameAsString());
        }
    }

    public IndexMetaData getIndexMetaData(MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        return this.delegate.getIndexMetaData(miniBatchOp);
    }

    public void getIndexUpdates(ListMultimap<HTableInterfaceReference, Pair<Mutation, byte[]>> indexUpdates, MiniBatchOperationInProgress<Mutation> miniBatchOp, Collection<? extends Mutation> mutations, IndexMetaData indexMetaData) throws Throwable {
        this.delegate.batchStarted(miniBatchOp, indexMetaData);
        CachedLocalTable cachedLocalTable = CachedLocalTable.build(mutations, (PhoenixIndexMetaData)indexMetaData, this.regionCoprocessorEnvironment.getRegion());
        for (Mutation mutation : mutations) {
            Collection<Pair<Mutation, byte[]>> updates = this.delegate.getIndexUpdate(mutation, indexMetaData, cachedLocalTable);
            for (Pair<Mutation, byte[]> update : updates) {
                indexUpdates.put((Object)new HTableInterfaceReference(new ImmutableBytesPtr((byte[])update.getSecond())), (Object)new Pair((Object)((Mutation)update.getFirst()), (Object)mutation.getRow()));
            }
        }
    }

    public Collection<Pair<Mutation, byte[]>> getIndexUpdate(MiniBatchOperationInProgress<Mutation> miniBatchOp, Collection<? extends Mutation> mutations) throws Throwable {
        IndexMetaData indexMetaData = this.delegate.getIndexMetaData(miniBatchOp);
        this.delegate.batchStarted(miniBatchOp, indexMetaData);
        CachedLocalTable cachedLocalTable = CachedLocalTable.build(mutations, (PhoenixIndexMetaData)indexMetaData, this.regionCoprocessorEnvironment.getRegion());
        ArrayList<Pair<Mutation, byte[]>> results = new ArrayList<Pair<Mutation, byte[]>>(mutations.size());
        for (Mutation mutation : mutations) {
            Collection<Pair<Mutation, byte[]>> updates = this.delegate.getIndexUpdate(mutation, indexMetaData, cachedLocalTable);
            if (PhoenixIndexMetaData.isIndexRebuild((Map)mutation.getAttributesMap())) {
                for (Pair<Mutation, byte[]> update : updates) {
                    ((Mutation)update.getFirst()).setAttribute("_IGNORE_NEWER_MUTATIONS", BaseScannerRegionObserverConstants.REPLAY_INDEX_REBUILD_WRITES);
                }
            }
            results.addAll(updates);
        }
        return results;
    }

    public Collection<Pair<Mutation, byte[]>> getIndexUpdateForFilteredRows(Collection<Cell> filtered, IndexMetaData indexMetaData) throws IOException {
        return this.delegate.getIndexUpdateForFilteredRows(filtered, indexMetaData);
    }

    public void batchCompleted(MiniBatchOperationInProgress<Mutation> miniBatchOp) {
        this.delegate.batchCompleted(miniBatchOp);
    }

    public void batchStarted(MiniBatchOperationInProgress<Mutation> miniBatchOp, IndexMetaData indexMetaData) throws IOException {
        this.delegate.batchStarted(miniBatchOp, indexMetaData);
    }

    public boolean isEnabled(Mutation m) {
        return this.delegate.isEnabled(m);
    }

    public boolean isAtomicOp(Mutation m) {
        return this.delegate.isAtomicOp(m);
    }

    public List<Mutation> executeAtomicOp(Increment inc) throws IOException {
        return this.delegate.executeAtomicOp(inc);
    }

    public void stop(String why) {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        this.delegate.stop(why);
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public IndexBuilder getBuilderForTesting() {
        return this.delegate;
    }

    public BaseScannerRegionObserverConstants.ReplayWrite getReplayWrite(Mutation m) throws IOException {
        return this.delegate.getReplayWrite(m);
    }

    public boolean returnResult(Mutation m) {
        return this.delegate.returnResult(m);
    }

    public boolean hasConditionalTTL(Mutation m) {
        return this.delegate.hasConditionalTTL(m);
    }
}

