/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index;

import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.SteppingSplitPolicy;
import org.apache.hadoop.hbase.util.Bytes;

public class IndexRegionSplitPolicy
extends SteppingSplitPolicy {
    protected boolean skipStoreFileRangeCheck(String familyName) {
        return familyName.startsWith("L#");
    }

    protected byte[] getSplitPoint() {
        Optional splitPoint;
        byte[] oldSplitPoint = super.getSplitPoint();
        if (oldSplitPoint == null) {
            return null;
        }
        List stores = this.region.getStores();
        byte[] splitPointFromLargestStore = null;
        long largestStoreSize = 0L;
        boolean isLocalIndexKey = false;
        for (HStore s : stores) {
            if (!s.getColumnFamilyName().startsWith("L#")) continue;
            splitPoint = s.getSplitPoint();
            if (oldSplitPoint == null || !splitPoint.isPresent() || Bytes.compareTo((byte[])oldSplitPoint, (byte[])((byte[])splitPoint.get())) != 0) continue;
            isLocalIndexKey = true;
        }
        if (!isLocalIndexKey) {
            return oldSplitPoint;
        }
        for (HStore s : stores) {
            if (s.getColumnFamilyName().startsWith("L#")) continue;
            splitPoint = s.getSplitPoint();
            long storeSize = s.getSize();
            if (!splitPoint.isPresent() || largestStoreSize >= storeSize) continue;
            splitPointFromLargestStore = (byte[])splitPoint.get();
            largestStoreSize = storeSize;
        }
        return splitPointFromLargestStore;
    }
}

