/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.sql.SQLException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.cache.ServerMetadataCache;
import org.apache.phoenix.exception.StaleMetadataCacheException;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyLastDDLTimestamp {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerifyLastDDLTimestamp.class);

    private VerifyLastDDLTimestamp() {
    }

    public static void verifyLastDDLTimestamp(ServerMetadataCache cache, byte[] tenantID, byte[] schemaName, byte[] tableName, long clientLastDDLTimestamp) throws SQLException {
        long lastDDLTimestamp = cache.getLastDDLTimestampForTable(tenantID, schemaName, tableName);
        if (clientLastDDLTimestamp < lastDDLTimestamp) {
            LOGGER.error("Stale metadata for LAST_DDL_TIMESTAMP for tenantID: {}, schema: {}, table: {}, client provided timestamp: {}, server timestamp: {}", new Object[]{Bytes.toString((byte[])tenantID), Bytes.toString((byte[])schemaName), Bytes.toString((byte[])tableName), clientLastDDLTimestamp, lastDDLTimestamp});
            String fullTableName = SchemaUtil.getTableName((byte[])schemaName, (byte[])tableName);
            throw new StaleMetadataCacheException("Stale metadata cache for table name: " + fullTableName);
        }
    }
}

