/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.cache.GlobalCache;
import org.apache.phoenix.cache.TenantCache;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.exception.DataExceedsCapacityException;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.ServerAggregators;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.PhoenixIndexBuilderHelper;
import org.apache.phoenix.memory.InsufficientMemoryException;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.tuple.EncodedColumnQualiferCellsList;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.PositionBasedMultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.thirdparty.com.google.common.primitives.Ints;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ExpressionUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.WALAnnotationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UngroupedAggregateRegionScanner
extends BaseRegionScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(UngroupedAggregateRegionScanner.class);
    private long pageSizeMs;
    private int maxBatchSize = 0;
    private Scan scan;
    private RegionScanner innerScanner;
    private Region region;
    private final UngroupedAggregateRegionObserver ungroupedAggregateRegionObserver;
    private final RegionCoprocessorEnvironment env;
    private final boolean useQualifierAsIndex;
    private boolean needToWrite = false;
    private final Pair<Integer, Integer> minMaxQualifiers;
    private byte[][] values = null;
    private final PTable.QualifierEncodingScheme encodingScheme;
    private PTable writeToTable = null;
    private PTable projectedTable = null;
    private final boolean isDescRowKeyOrderUpgrade;
    private final int offset;
    private final boolean buildLocalIndex;
    private final List<IndexMaintainer> indexMaintainers;
    private boolean isPKChanging = false;
    private final long ts;
    private PhoenixTransactionProvider txnProvider = null;
    private final UngroupedAggregateRegionObserver.MutationList indexMutations;
    private boolean isDelete = false;
    private final byte[] replayMutations;
    private boolean isUpsert = false;
    private List<Expression> selectExpressions = null;
    private byte[] deleteCQ = null;
    private byte[] deleteCF = null;
    private byte[] emptyCF = null;
    private byte[] emptyCQ = null;
    private final byte[] indexUUID;
    private final byte[] txState;
    private final byte[] clientVersionBytes;
    private final long blockingMemStoreSize;
    private long maxBatchSizeBytes = 0L;
    private Table targetHTable = null;
    private boolean incrScanRefCount = false;
    private byte[] indexMaintainersPtr;
    private boolean useIndexProto;
    private boolean isSingleRowDelete = false;

    public UngroupedAggregateRegionScanner(ObserverContext<RegionCoprocessorEnvironment> c, RegionScanner innerScanner, Region region, Scan scan, RegionCoprocessorEnvironment env, UngroupedAggregateRegionObserver ungroupedAggregateRegionObserver) throws IOException, SQLException {
        super(innerScanner);
        byte[] upsertSelectTable;
        this.env = env;
        this.region = region;
        this.scan = scan;
        this.ungroupedAggregateRegionObserver = ungroupedAggregateRegionObserver;
        this.innerScanner = innerScanner;
        Configuration conf = env.getConfiguration();
        this.pageSizeMs = ScanUtil.getPageSizeMsForRegionScanner((Scan)scan);
        this.ts = scan.getTimeRange().getMax();
        boolean localIndexScan = ScanUtil.isLocalIndex((Scan)scan);
        this.encodingScheme = EncodedColumnsUtil.getQualifierEncodingScheme((Scan)scan);
        int offsetToBe = 0;
        if (localIndexScan) {
            offsetToBe = region.getRegionInfo().getStartKey().length != 0 ? region.getRegionInfo().getStartKey().length : region.getRegionInfo().getEndKey().length;
            ScanUtil.setRowKeyOffset((Scan)scan, (int)offsetToBe);
        }
        this.offset = offsetToBe;
        byte[] descRowKeyTableBytes = scan.getAttribute("_UPGRADE_DESC_ROW_KEY");
        boolean bl = this.isDescRowKeyOrderUpgrade = descRowKeyTableBytes != null;
        if (this.isDescRowKeyOrderUpgrade) {
            LOGGER.debug("Upgrading row key for " + region.getRegionInfo().getTable().getNameAsString());
            this.projectedTable = UngroupedAggregateRegionObserver.deserializeTable(descRowKeyTableBytes);
            try {
                this.writeToTable = PTableImpl.builderWithColumns((PTable)this.projectedTable, (Collection)PTableImpl.getColumnsToClone((PTable)this.projectedTable)).setRowKeyOrderOptimizable(true).build();
            }
            catch (SQLException e) {
                ClientUtil.throwIOException((String)"Upgrade failed", (Throwable)e);
            }
            this.values = new byte[this.projectedTable.getPKColumns().size()][];
        }
        boolean useProto = false;
        byte[] localIndexBytes = scan.getAttribute("_LocalIndexBuild");
        boolean bl2 = useProto = localIndexBytes != null;
        if (localIndexBytes == null) {
            localIndexBytes = scan.getAttribute("_LocalIndexBuild");
        }
        this.indexMaintainers = localIndexBytes == null ? null : IndexMaintainer.deserialize((byte[])localIndexBytes, (boolean)useProto);
        this.indexMutations = localIndexBytes == null ? new UngroupedAggregateRegionObserver.MutationList() : new UngroupedAggregateRegionObserver.MutationList(1024);
        byte[] transforming = scan.getAttribute("_DoTransforming");
        this.replayMutations = scan.getAttribute("_IGNORE_NEWER_MUTATIONS");
        this.indexUUID = scan.getAttribute("IdxUUID");
        this.txState = scan.getAttribute("_TxState");
        this.clientVersionBytes = scan.getAttribute("_ClientVersion");
        if (this.txState != null) {
            int clientVersion = this.clientVersionBytes == null ? ScanUtil.UNKNOWN_CLIENT_VERSION : Bytes.toInt((byte[])this.clientVersionBytes);
            this.txnProvider = TransactionFactory.getTransactionProvider((byte[])this.txState, (int)clientVersion);
        }
        if ((upsertSelectTable = scan.getAttribute("_UpsertSelectTable")) != null) {
            this.isUpsert = true;
            this.projectedTable = UngroupedAggregateRegionObserver.deserializeTable(upsertSelectTable);
            this.targetHTable = ServerUtil.ConnectionFactory.getConnection(ServerUtil.ConnectionType.DEFAULT_SERVER_CONNECTION, env).getTable(TableName.valueOf((byte[])this.projectedTable.getPhysicalName().getBytes()));
            this.selectExpressions = UngroupedAggregateRegionObserver.deserializeExpressions(scan.getAttribute("_UpsertSelectExprs"));
            this.values = new byte[this.projectedTable.getPKColumns().size()][];
            this.isPKChanging = ExpressionUtil.isPkPositionChanging((TableRef)new TableRef(this.projectedTable), this.selectExpressions);
        } else {
            byte[] isDeleteAgg = scan.getAttribute("_DeleteAgg");
            this.isDelete = isDeleteAgg != null && Bytes.compareTo((byte[])PDataType.TRUE_BYTES, (byte[])isDeleteAgg) == 0;
            byte[] singleRowDelete = scan.getAttribute("_SingleRowDelete");
            boolean bl3 = this.isSingleRowDelete = singleRowDelete != null && Bytes.compareTo((byte[])PDataType.TRUE_BYTES, (byte[])singleRowDelete) == 0;
            if (this.isSingleRowDelete) {
                this.targetHTable = ServerUtil.ConnectionFactory.getConnection(ServerUtil.ConnectionType.DEFAULT_SERVER_CONNECTION, env).getTable(region.getRegionInfo().getTable());
            }
            if (!this.isDelete) {
                this.deleteCF = scan.getAttribute("_DeleteCF");
                this.deleteCQ = scan.getAttribute("_DeleteCQ");
            }
            this.emptyCF = scan.getAttribute("_EmptyCF");
            this.emptyCQ = scan.getAttribute("_EmptyColumnQualifier");
            if (this.emptyCF != null && this.emptyCQ == null) {
                this.emptyCQ = QueryConstants.EMPTY_COLUMN_BYTES;
            }
        }
        ColumnReference[] dataColumns = IndexUtil.deserializeDataTableColumnsToJoin((Scan)scan);
        this.useQualifierAsIndex = EncodedColumnsUtil.useQualifierAsIndex((Pair)EncodedColumnsUtil.getMinMaxQualifiersFromScan((Scan)scan));
        this.blockingMemStoreSize = UngroupedAggregateRegionObserver.getBlockingMemstoreSize(region, conf);
        boolean bl4 = this.buildLocalIndex = this.indexMaintainers != null && dataColumns == null && !localIndexScan;
        if (this.buildLocalIndex) {
            UngroupedAggregateRegionObserver.checkForLocalIndexColumnFamilies(region, this.indexMaintainers);
        }
        if (this.isDescRowKeyOrderUpgrade || this.isDelete || this.isUpsert || this.deleteCQ != null && this.deleteCF != null || this.emptyCF != null || this.buildLocalIndex) {
            this.needToWrite = true;
            if (this.isUpsert && (this.targetHTable == null || !this.targetHTable.getName().equals((Object)region.getTableDescriptor().getTableName()))) {
                this.needToWrite = false;
            }
            this.maxBatchSize = conf.getInt("phoenix.mutate.batchSize", 100);
            this.maxBatchSizeBytes = conf.getLongBytes("phoenix.mutate.batchSizeBytes", 0x200000L);
        }
        this.minMaxQualifiers = EncodedColumnsUtil.getMinMaxQualifiersFromScan((Scan)scan);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(LogUtil.addCustomAnnotations((String)("Starting ungrouped coprocessor scan " + scan + " " + region.getRegionInfo()), (byte[])ScanUtil.getCustomAnnotations((Scan)scan)));
        }
        this.useIndexProto = true;
        this.indexMaintainersPtr = scan.getAttribute("IdxProtoMD");
        if (this.indexMaintainersPtr == null) {
            this.indexMaintainersPtr = scan.getAttribute("IdxMD");
            this.useIndexProto = false;
        }
        if (this.needToWrite) {
            ungroupedAggregateRegionObserver.incrementScansReferenceCount();
            this.incrScanRefCount = true;
        }
    }

    @Override
    public RegionInfo getRegionInfo() {
        return this.region.getRegionInfo();
    }

    @Override
    public boolean isFilterDone() {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.needToWrite && this.incrScanRefCount) {
            this.ungroupedAggregateRegionObserver.decrementScansReferenceCount();
        }
        try {
            if (this.targetHTable != null) {
                try {
                    this.targetHTable.close();
                }
                catch (IOException e) {
                    LOGGER.error("Closing table: " + this.targetHTable + " failed: ", (Throwable)e);
                }
            }
        }
        finally {
            this.innerScanner.close();
        }
    }

    boolean descRowKeyOrderUpgrade(List<Cell> results, ImmutableBytesWritable ptr, UngroupedAggregateRegionObserver.MutationList mutations) throws IOException {
        Boolean hasValue;
        Arrays.fill((Object[])this.values, null);
        Cell firstKV = results.get(0);
        RowKeySchema schema = this.projectedTable.getRowKeySchema();
        int maxOffset = schema.iterator(firstKV.getRowArray(), firstKV.getRowOffset() + this.offset, (int)firstKV.getRowLength(), ptr);
        for (int i = 0; i < schema.getFieldCount() && (hasValue = schema.next(ptr, i, maxOffset)) != null; ++i) {
            ValueSchema.Field field = schema.getField(i);
            if (field.getSortOrder() == SortOrder.DESC) {
                if (field.getDataType().isArrayType()) {
                    field.getDataType().coerceBytes(ptr, null, field.getDataType(), field.getMaxLength(), field.getScale(), field.getSortOrder(), field.getMaxLength(), field.getScale(), field.getSortOrder(), true);
                } else if (field.getDataType() == PChar.INSTANCE || field.getDataType() == PBinary.INSTANCE) {
                    for (len = ptr.getLength(); len > 0 && ptr.get()[ptr.getOffset() + len - 1] == 32; --len) {
                    }
                    ptr.set(ptr.get(), ptr.getOffset(), len);
                } else if (field.getDataType() == PFloat.INSTANCE || field.getDataType() == PDouble.INSTANCE) {
                    byte[] invertedBytes = SortOrder.invert((byte[])ptr.get(), (int)ptr.getOffset(), (int)ptr.getLength());
                    ptr.set(invertedBytes);
                }
            } else if (field.getDataType() == PBinary.INSTANCE) {
                for (len = ptr.getLength(); len > 0 && ptr.get()[ptr.getOffset() + len - 1] == 32; --len) {
                }
                ptr.set(ptr.get(), ptr.getOffset(), len);
            }
            this.values[i] = ptr.copyBytes();
        }
        this.writeToTable.newKey(ptr, this.values);
        if (Bytes.compareTo((byte[])firstKV.getRowArray(), (int)(firstKV.getRowOffset() + this.offset), (int)firstKV.getRowLength(), (byte[])ptr.get(), (int)(ptr.getOffset() + this.offset), (int)ptr.getLength()) == 0) {
            return false;
        }
        byte[] newRow = ByteUtil.copyKeyBytesIfNecessary((ImmutableBytesWritable)ptr);
        if (this.offset > 0) {
            byte[] newRowWithOffset = new byte[this.offset + newRow.length];
            System.arraycopy(firstKV.getRowArray(), firstKV.getRowOffset(), newRowWithOffset, 0, this.offset);
            System.arraycopy(newRow, 0, newRowWithOffset, this.offset, newRow.length);
            newRow = newRowWithOffset;
        }
        byte[] oldRow = Bytes.copy((byte[])firstKV.getRowArray(), (int)firstKV.getRowOffset(), (int)firstKV.getRowLength());
        for (Cell cell : results) {
            Cell newCell = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(newRow).setFamily(cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength()).setQualifier(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()).setTimestamp(cell.getTimestamp()).setType(cell.getType()).setValue(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()).build();
            switch (cell.getType()) {
                case Put: {
                    Delete del = new Delete(oldRow);
                    Cell newDelCell = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(newRow).setFamily(cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength()).setQualifier(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()).setTimestamp(cell.getTimestamp()).setType(Cell.Type.Delete).setValue(ByteUtil.EMPTY_BYTE_ARRAY, 0, 0).build();
                    del.add(newDelCell);
                    mutations.add((Mutation)del);
                    Put put = new Put(newRow);
                    put.add(newCell);
                    mutations.add((Mutation)put);
                    break;
                }
                case Delete: 
                case DeleteColumn: 
                case DeleteFamily: 
                case DeleteFamilyVersion: {
                    Delete delete = new Delete(newRow);
                    delete.add(newCell);
                    mutations.add((Mutation)delete);
                }
            }
        }
        return true;
    }

    void buildLocalIndex(Tuple result, List<Cell> results, ImmutableBytesWritable ptr) throws IOException {
        for (IndexMaintainer maintainer : this.indexMaintainers) {
            if (results.isEmpty()) continue;
            result.getKey(ptr);
            ValueGetter valueGetter = maintainer.createGetterFromKeyValues(ImmutableBytesPtr.copyBytesIfNecessary((ImmutableBytesWritable)ptr), results);
            Put put = maintainer.buildUpdateMutation(GenericKeyValueBuilder.INSTANCE, valueGetter, ptr, results.get(0).getTimestamp(), this.env.getRegion().getRegionInfo().getStartKey(), this.env.getRegion().getRegionInfo().getEndKey(), false);
            if (this.txnProvider != null) {
                put = this.txnProvider.markPutAsCommitted(put, this.ts, this.ts);
            }
            this.indexMutations.add((Mutation)put);
        }
        result.setKeyValues(results);
    }

    void deleteRow(List<Cell> results, UngroupedAggregateRegionObserver.MutationList mutations) {
        byte[] sourceOperationBytes;
        Cell firstKV = results.get(0);
        Delete delete = new Delete(firstKV.getRowArray(), firstKV.getRowOffset(), (int)firstKV.getRowLength(), this.ts);
        if (this.replayMutations != null) {
            delete.setAttribute("_IGNORE_NEWER_MUTATIONS", this.replayMutations);
        }
        if ((sourceOperationBytes = this.scan.getAttribute("phoenix.source.operation")) != null) {
            delete.setAttribute("phoenix.source.operation", sourceOperationBytes);
        }
        if (this.isSingleRowDelete) {
            delete.setAttribute("_RETURN_RESULT", PhoenixIndexBuilderHelper.RETURN_RESULT_ROW);
        }
        mutations.add((Mutation)delete);
    }

    void deleteCForQ(Tuple result, List<Cell> results, UngroupedAggregateRegionObserver.MutationList mutations) {
        if (this.emptyCF == null || result.getValue(this.deleteCF, this.deleteCQ) != null) {
            Delete delete = new Delete(results.get(0).getRowArray(), results.get(0).getRowOffset(), (int)results.get(0).getRowLength());
            delete.addColumns(this.deleteCF, this.deleteCQ, this.ts);
            mutations.add((Mutation)delete);
        }
    }

    void upsert(Tuple result, ImmutableBytesWritable ptr, UngroupedAggregateRegionObserver.MutationList mutations) {
        int i;
        Arrays.fill((Object[])this.values, null);
        int bucketNumOffset = 0;
        if (this.projectedTable.getBucketNum() != null) {
            this.values[0] = new byte[]{0};
            bucketNumOffset = 1;
        }
        List projectedColumns = this.projectedTable.getColumns();
        for (i = bucketNumOffset; i < this.projectedTable.getPKColumns().size(); ++i) {
            Expression expression = this.selectExpressions.get(i - bucketNumOffset);
            if (expression.evaluate(result, ptr)) {
                this.values[i] = ptr.copyBytes();
                if (expression.getSortOrder() == ((PColumn)projectedColumns.get(i)).getSortOrder()) continue;
                SortOrder.invert((byte[])this.values[i], (int)0, (byte[])this.values[i], (int)0, (int)this.values[i].length);
                continue;
            }
            this.values[i] = ByteUtil.EMPTY_BYTE_ARRAY;
        }
        this.projectedTable.newKey(ptr, this.values);
        PRow row = this.projectedTable.newRow(GenericKeyValueBuilder.INSTANCE, this.ts, ptr, false, (byte[][])new byte[0][]);
        while (i < projectedColumns.size()) {
            Expression expression = this.selectExpressions.get(i - bucketNumOffset);
            if (expression.evaluate(result, ptr)) {
                PColumn column = (PColumn)projectedColumns.get(i);
                if (!column.getDataType().isSizeCompatible(ptr, null, expression.getDataType(), expression.getSortOrder(), expression.getMaxLength(), expression.getScale(), column.getMaxLength(), column.getScale())) {
                    throw new DataExceedsCapacityException(column.getDataType(), column.getMaxLength(), column.getScale(), column.getName().getString());
                }
                column.getDataType().coerceBytes(ptr, null, expression.getDataType(), expression.getMaxLength(), expression.getScale(), expression.getSortOrder(), column.getMaxLength(), column.getScale(), column.getSortOrder(), this.projectedTable.rowKeyOrderOptimizable());
                byte[] bytes = ByteUtil.copyKeyBytesIfNecessary((ImmutableBytesWritable)ptr);
                row.setValue(column, bytes);
            }
            ++i;
        }
        for (Mutation mutation : row.toRowMutations()) {
            if (this.replayMutations != null) {
                mutation.setAttribute("_IGNORE_NEWER_MUTATIONS", this.replayMutations);
            } else if (this.txnProvider != null && this.projectedTable.getType() == PTableType.INDEX) {
                mutation = this.txnProvider.markPutAsCommitted((Put)mutation, this.ts, this.ts);
            }
            mutations.add(mutation);
        }
        for (i = 0; i < this.selectExpressions.size(); ++i) {
            this.selectExpressions.get(i).reset();
        }
    }

    void insertEmptyKeyValue(List<Cell> results, UngroupedAggregateRegionObserver.MutationList mutations) {
        HashSet timeStamps = Sets.newHashSetWithExpectedSize((int)results.size());
        for (Cell kv : results) {
            long kvts = kv.getTimestamp();
            if (timeStamps.contains(kvts)) continue;
            Put put = new Put(kv.getRowArray(), kv.getRowOffset(), (int)kv.getRowLength());
            put.addColumn(this.emptyCF, this.emptyCQ, kvts, QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
            mutations.add((Mutation)put);
            timeStamps.add(kvts);
        }
    }

    @Override
    public boolean nextRaw(List<Cell> results, ScannerContext scannerContext) throws IOException {
        return this.next(results, scannerContext);
    }

    @Override
    public boolean next(List<Cell> resultsToReturn) throws IOException {
        return this.next(resultsToReturn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean next(List<Cell> resultsToReturn, ScannerContext scannerContext) throws IOException {
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        Configuration conf = this.env.getConfiguration();
        TenantCache tenantCache = GlobalCache.getTenantCache(this.env, ScanUtil.getTenantId((Scan)this.scan));
        try (MemoryManager.MemoryChunk em = tenantCache.getMemoryManager().allocate(0L);){
            boolean hasMore;
            ServerAggregators aggregators = ServerAggregators.deserialize((byte[])this.scan.getAttribute("_Aggs"), (Configuration)conf, (MemoryManager.MemoryChunk)em);
            Aggregator[] rowAggregators = aggregators.getAggregators();
            aggregators.reset(rowAggregators);
            Cell lastCell = null;
            boolean hasAny = false;
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            PositionBasedMultiKeyValueTuple result = this.useQualifierAsIndex ? new PositionBasedMultiKeyValueTuple() : new MultiKeyValueTuple();
            UngroupedAggregateRegionObserver.MutationList mutations = new UngroupedAggregateRegionObserver.MutationList();
            if (this.isDescRowKeyOrderUpgrade || this.isDelete || this.isUpsert || this.deleteCQ != null && this.deleteCF != null || this.emptyCF != null || this.buildLocalIndex) {
                mutations = new UngroupedAggregateRegionObserver.MutationList(Ints.saturatedCast((long)(this.maxBatchSize + this.maxBatchSize / 10)));
            }
            Result atomicSingleRowDeleteResult = null;
            this.region.startRegionOperation();
            try {
                RegionScanner regionScanner = this.innerScanner;
                synchronized (regionScanner) {
                    do {
                        this.ungroupedAggregateRegionObserver.checkForRegionClosingOrSplitting();
                        Object results = this.useQualifierAsIndex ? new EncodedColumnQualiferCellsList(((Integer)this.minMaxQualifiers.getFirst()).intValue(), ((Integer)this.minMaxQualifiers.getSecond()).intValue(), this.encodingScheme) : new ArrayList();
                        boolean bl = hasMore = scannerContext == null ? this.innerScanner.nextRaw((List)results) : this.innerScanner.nextRaw((List)results, scannerContext);
                        if (ScanUtil.isDummy((List)results)) {
                            if (hasAny) break;
                            resultsToReturn.addAll((Collection<Cell>)results);
                            boolean bl2 = true;
                            return bl2;
                        }
                        if (results.isEmpty()) continue;
                        lastCell = (Cell)results.get(0);
                        result.setKeyValues((List)results);
                        if (this.isDescRowKeyOrderUpgrade) {
                            if (!this.descRowKeyOrderUpgrade((List<Cell>)results, ptr, mutations)) {
                                continue;
                            }
                        } else if (this.buildLocalIndex) {
                            this.buildLocalIndex((Tuple)result, (List<Cell>)results, ptr);
                        } else if (this.isDelete) {
                            this.deleteRow((List<Cell>)results, mutations);
                        } else if (this.isUpsert) {
                            this.upsert((Tuple)result, ptr, mutations);
                        } else if (this.deleteCF != null && this.deleteCQ != null) {
                            this.deleteCForQ((Tuple)result, (List<Cell>)results, mutations);
                        }
                        if (this.emptyCF != null) {
                            this.insertEmptyKeyValue((List<Cell>)results, mutations);
                        }
                        if (ServerUtil.readyToCommit(mutations.size(), mutations.byteSize(), this.maxBatchSize, this.maxBatchSizeBytes)) {
                            if (!this.isSingleRowDelete) {
                                this.annotateAndCommit(mutations);
                            } else {
                                atomicSingleRowDeleteResult = this.annotateCommitAndReturnResult(mutations);
                            }
                        }
                        if (ServerUtil.readyToCommit(this.indexMutations.size(), this.indexMutations.byteSize(), this.maxBatchSize, this.maxBatchSizeBytes)) {
                            UngroupedAggregateRegionObserver.setIndexAndTransactionProperties(this.indexMutations, this.indexUUID, this.indexMaintainersPtr, this.txState, this.clientVersionBytes, this.useIndexProto);
                            this.ungroupedAggregateRegionObserver.commitBatch(this.region, this.indexMutations, this.blockingMemStoreSize);
                            this.indexMutations.clear();
                        }
                        aggregators.aggregate(rowAggregators, (Tuple)result);
                        hasAny = true;
                    } while (hasMore && EnvironmentEdgeManager.currentTimeMillis() - startTime < this.pageSizeMs);
                    if (!mutations.isEmpty()) {
                        if (!this.isSingleRowDelete) {
                            this.annotateAndCommit(mutations);
                        } else {
                            atomicSingleRowDeleteResult = this.annotateCommitAndReturnResult(mutations);
                        }
                    }
                    if (!this.indexMutations.isEmpty()) {
                        this.ungroupedAggregateRegionObserver.commitBatch(this.region, this.indexMutations, this.blockingMemStoreSize);
                        this.indexMutations.clear();
                    }
                }
            }
            catch (InsufficientMemoryException e) {
                throw new DoNotRetryIOException((Throwable)e);
            }
            catch (DataExceedsCapacityException e) {
                throw new DoNotRetryIOException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                LOGGER.error("Exception in UngroupedAggregateRegionScanner for region " + this.region.getRegionInfo().getRegionNameAsString(), e);
                throw e;
            }
            finally {
                this.region.closeRegionOperation();
            }
            if (hasAny) {
                Cell keyValue;
                if (this.isSingleRowDelete && atomicSingleRowDeleteResult != null) {
                    resultsToReturn.addAll(atomicSingleRowDeleteResult.listCells());
                    boolean bl = hasMore;
                    return bl;
                }
                byte[] value = aggregators.toBytes(rowAggregators);
                if (this.pageSizeMs == Long.MAX_VALUE) {
                    boolean isIncompatibleClient = ScanUtil.isIncompatibleClientForServerReturnValidRowKey((Scan)this.scan);
                    byte[] rowKey = !isIncompatibleClient ? CellUtil.cloneRow((Cell)lastCell) : QueryConstants.UNGROUPED_AGG_ROW_KEY;
                    keyValue = PhoenixKeyValueUtil.newKeyValue((byte[])rowKey, (byte[])QueryConstants.SINGLE_COLUMN_FAMILY, (byte[])QueryConstants.SINGLE_COLUMN, (long)Long.MAX_VALUE, (byte[])value, (int)0, (int)value.length);
                } else {
                    keyValue = PhoenixKeyValueUtil.newKeyValue((byte[])CellUtil.cloneRow((Cell)lastCell), (byte[])QueryConstants.SINGLE_COLUMN_FAMILY, (byte[])QueryConstants.SINGLE_COLUMN, (long)Long.MAX_VALUE, (byte[])value, (int)0, (int)value.length);
                }
                resultsToReturn.add(keyValue);
            }
            boolean bl = hasMore;
            return bl;
        }
    }

    private void annotateAndCommit(UngroupedAggregateRegionObserver.MutationList mutations) throws IOException {
        this.annotateMutations(mutations);
        this.ungroupedAggregateRegionObserver.commit(this.region, mutations, this.indexUUID, this.blockingMemStoreSize, this.indexMaintainersPtr, this.txState, this.targetHTable, this.useIndexProto, this.isPKChanging, this.clientVersionBytes);
        mutations.clear();
    }

    private Result annotateCommitAndReturnResult(UngroupedAggregateRegionObserver.MutationList mutations) throws IOException {
        this.annotateMutations(mutations);
        Result result = this.ungroupedAggregateRegionObserver.commitWithResultReturned(mutations, this.indexUUID, this.indexMaintainersPtr, this.txState, this.targetHTable, this.useIndexProto, this.clientVersionBytes);
        mutations.clear();
        return result;
    }

    private void annotateMutations(UngroupedAggregateRegionObserver.MutationList mutations) {
        this.annotateDataMutations(mutations, this.scan);
        if (this.isDelete || this.isUpsert) {
            this.annotateDataMutationsWithExternalSchemaId(mutations, this.scan);
        }
    }

    @Override
    public long getMaxResultSize() {
        return this.scan.getMaxResultSize();
    }

    private void annotateDataMutations(UngroupedAggregateRegionObserver.MutationList mutationsList, Scan scan) {
        byte[] tenantId = scan.getAttribute(MutationState.MutationMetadataType.TENANT_ID.toString());
        byte[] schemaName = scan.getAttribute(MutationState.MutationMetadataType.SCHEMA_NAME.toString());
        byte[] logicalTableName = scan.getAttribute(MutationState.MutationMetadataType.LOGICAL_TABLE_NAME.toString());
        byte[] tableType = scan.getAttribute(MutationState.MutationMetadataType.TABLE_TYPE.toString());
        byte[] ddlTimestamp = scan.getAttribute(MutationState.MutationMetadataType.TIMESTAMP.toString());
        for (Mutation m : mutationsList) {
            WALAnnotationUtil.annotateMutation((Mutation)m, (byte[])tenantId, (byte[])schemaName, (byte[])logicalTableName, (byte[])tableType, (byte[])ddlTimestamp);
        }
    }

    private void annotateDataMutationsWithExternalSchemaId(UngroupedAggregateRegionObserver.MutationList mutationsList, Scan scan) {
        byte[] externalSchemaRegistryId = scan.getAttribute(MutationState.MutationMetadataType.EXTERNAL_SCHEMA_ID.toString());
        for (Mutation m : mutationsList) {
            WALAnnotationUtil.annotateMutation((Mutation)m, (byte[])externalSchemaRegistryId);
        }
    }
}

