/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.phoenix.coprocessor.UncoveredIndexRegionScanner;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerIndexUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UncoveredLocalIndexRegionScanner
extends UncoveredIndexRegionScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(UncoveredLocalIndexRegionScanner.class);
    final int offset;
    final byte[] actualStartKey;

    public UncoveredLocalIndexRegionScanner(RegionScanner innerScanner, Region region, Scan scan, RegionCoprocessorEnvironment env, Scan dataTableScan, TupleProjector tupleProjector, IndexMaintainer indexMaintainer, byte[][] viewConstants, ImmutableBytesWritable ptr, long pageSizeMs, int offset, byte[] actualStartKey, long queryLimit) {
        super(innerScanner, region, scan, env, dataTableScan, tupleProjector, indexMaintainer, viewConstants, ptr, pageSizeMs, queryLimit);
        this.offset = offset;
        this.actualStartKey = actualStartKey;
    }

    protected void scanDataRows(Collection<byte[]> dataRowKeys, long startTime) throws IOException {
        Scan dataScan = this.prepareDataTableScan(dataRowKeys);
        if (dataScan == null) {
            return;
        }
        try (RegionScanner regionScanner = this.region.getScanner(dataScan);){
            boolean hasMore;
            do {
                ArrayList row = new ArrayList();
                hasMore = regionScanner.nextRaw(row);
                if (row.isEmpty()) continue;
                if (ScanUtil.isDummy(row)) {
                    this.state = UncoveredIndexRegionScanner.State.SCANNING_DATA_INTERRUPTED;
                    break;
                }
                Cell firstCell = (Cell)row.get(0);
                this.dataRows.put(new ImmutableBytesPtr(CellUtil.cloneRow((Cell)firstCell)), Result.create(row));
                if (!hasMore || EnvironmentEdgeManager.currentTimeMillis() - startTime < this.pageSizeMs) continue;
                this.state = UncoveredIndexRegionScanner.State.SCANNING_DATA_INTERRUPTED;
                break;
            } while (hasMore);
            if (this.state == UncoveredIndexRegionScanner.State.SCANNING_DATA_INTERRUPTED) {
                LOGGER.info("Data table scan is interrupted in UncoveredLocalIndexRegionScanner for region " + this.region.getRegionInfo().getRegionNameAsString() + " as it could not complete on time (in " + this.pageSizeMs + " ms), and it will be resubmitted");
            }
        }
    }

    @Override
    protected void scanDataTableRows(long startTime) throws IOException {
        if (this.indexToDataRowKeyMap.size() == 0) {
            this.state = UncoveredIndexRegionScanner.State.READY;
            return;
        }
        this.scanDataRows(this.indexToDataRowKeyMap.values(), startTime);
        this.state = this.state == UncoveredIndexRegionScanner.State.SCANNING_DATA_INTERRUPTED ? UncoveredIndexRegionScanner.State.SCANNING_DATA : UncoveredIndexRegionScanner.State.READY;
    }

    @Override
    protected boolean scanIndexTableRows(List<Cell> result, long startTime, ScannerContext scannerContext) throws IOException {
        return this.scanIndexTableRows(result, startTime, this.actualStartKey, this.offset, scannerContext);
    }

    @Override
    public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
        boolean hasMore = super.next(result, scannerContext);
        ServerIndexUtil.wrapResultUsingOffset(result, this.offset);
        return hasMore;
    }

    @Override
    public boolean next(List<Cell> result) throws IOException {
        return this.next(result, null);
    }
}

