/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.coprocessor.IndexRepairRegionScanner;
import org.apache.phoenix.coprocessor.PhoenixRegionServerEndpoint;
import org.apache.phoenix.coprocessor.UncoveredIndexRegionScanner;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.hbase.index.parallel.EarlyExitFailure;
import org.apache.phoenix.hbase.index.parallel.Task;
import org.apache.phoenix.hbase.index.parallel.TaskBatch;
import org.apache.phoenix.hbase.index.parallel.TaskRunner;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.write.IndexWriterUtils;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UncoveredGlobalIndexRegionScanner
extends UncoveredIndexRegionScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(UncoveredGlobalIndexRegionScanner.class);
    public static final String NUM_CONCURRENT_INDEX_THREADS_CONF_KEY = "phoenix.index.threads.max";
    public static final String INDEX_ROW_COUNTS_PER_TASK_CONF_KEY = "phoenix.index.row.count.per.task";
    public static final int DEFAULT_INDEX_ROW_COUNTS_PER_TASK = 2048;
    protected byte[][] regionEndKeys;
    protected final Table dataHTable;
    protected final int rowCountPerTask;
    protected String exceptionMessage;
    protected final HTableFactory hTableFactory;

    public UncoveredGlobalIndexRegionScanner(RegionScanner innerScanner, Region region, Scan scan, RegionCoprocessorEnvironment env, Scan dataTableScan, TupleProjector tupleProjector, IndexMaintainer indexMaintainer, byte[][] viewConstants, ImmutableBytesWritable ptr, long pageSizeMs, long queryLimit) throws IOException {
        super(innerScanner, region, scan, env, dataTableScan, tupleProjector, indexMaintainer, viewConstants, ptr, pageSizeMs, queryLimit);
        Configuration config = env.getConfiguration();
        this.hTableFactory = IndexWriterUtils.getDefaultDelegateHTableFactory(env);
        this.rowCountPerTask = config.getInt(INDEX_ROW_COUNTS_PER_TASK_CONF_KEY, 2048);
        byte[] dataTableName = scan.getAttribute("_PhysicalDataTableName");
        this.dataHTable = this.hTableFactory.getTable(new ImmutableBytesPtr(dataTableName));
        this.regionEndKeys = this.hTableFactory.getConnection().getRegionLocator(this.dataHTable.getName()).getEndKeys();
        if (indexMaintainer.isUncovered()) {
            ScanUtil.addEmptyColumnToScan((Scan)dataTableScan, (byte[])indexMaintainer.getDataEmptyKeyValueCF(), (byte[])indexMaintainer.getEmptyKeyValueQualifierForDataTable());
        }
    }

    @Override
    public void close() throws IOException {
        this.innerScanner.close();
        this.hTableFactory.shutdown();
        if (this.dataHTable != null) {
            this.dataHTable.close();
        }
    }

    protected void scanDataRows(Collection<byte[]> dataRowKeys, long startTime) throws IOException {
        Scan dataScan = this.prepareDataTableScan(dataRowKeys);
        if (dataScan == null) {
            return;
        }
        try (ResultScanner resultScanner = this.dataHTable.getScanner(dataScan);){
            Result result = resultScanner.next();
            while (result != null) {
                if (ScanUtil.isDummy((Result)result)) {
                    this.state = UncoveredIndexRegionScanner.State.SCANNING_DATA_INTERRUPTED;
                    break;
                }
                this.dataRows.put(new ImmutableBytesPtr(result.getRow()), result);
                if (EnvironmentEdgeManager.currentTimeMillis() - startTime >= this.pageSizeMs) {
                    this.state = UncoveredIndexRegionScanner.State.SCANNING_DATA_INTERRUPTED;
                    break;
                }
                result = resultScanner.next();
            }
            if (this.state == UncoveredIndexRegionScanner.State.SCANNING_DATA_INTERRUPTED) {
                LOGGER.info("One of the scan tasks in UncoveredGlobalIndexRegionScanner for region " + this.region.getRegionInfo().getRegionNameAsString() + " could not complete on time (in " + this.pageSizeMs + " ms) and will be resubmitted");
            }
        }
        catch (Throwable t) {
            this.exceptionMessage = "scanDataRows fails for at least one task";
            ClientUtil.throwIOException((String)this.dataHTable.getName().toString(), (Throwable)t);
        }
    }

    private void addTasksForScanningDataTableRowsInParallel(TaskBatch<Boolean> tasks, final Set<byte[]> dataRowKeys, final long startTime) {
        tasks.add((Task)new Task<Boolean>(){

            public Boolean call() throws Exception {
                if (Thread.currentThread().isInterrupted()) {
                    UncoveredGlobalIndexRegionScanner.this.exceptionMessage = "Pool closed, not retrieving data table rows for " + UncoveredGlobalIndexRegionScanner.this.region.getRegionInfo().getRegionNameAsString();
                    throw new IOException(UncoveredGlobalIndexRegionScanner.this.exceptionMessage);
                }
                UncoveredGlobalIndexRegionScanner.this.scanDataRows(dataRowKeys, startTime);
                return Boolean.TRUE;
            }
        });
    }

    protected void submitTasks(TaskBatch<Boolean> tasks) throws IOException {
        Pair resultsAndFutures = null;
        try {
            LOGGER.debug("Waiting on index tasks to complete...");
            TaskRunner pool = PhoenixRegionServerEndpoint.getUncoveredIndexThreadPool();
            if (pool == null) {
                throw new IOException("PhoenixRegionServerEndpoint should be loaded to use Uncovered Indexes.");
            }
            resultsAndFutures = pool.submitUninterruptible(tasks);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Should not fail on the results while using a WaitForCompletionTaskRunner", e);
        }
        catch (EarlyExitFailure e) {
            throw new RuntimeException("Stopped while waiting for batch, quitting!", e);
        }
        int index = 0;
        for (Boolean result : (List)resultsAndFutures.getFirst()) {
            if (result == null) {
                Throwable cause = ServerUtil.getExceptionFromFailedFuture((Future)((List)resultsAndFutures.getSecond()).get(index));
                throw new IOException(this.exceptionMessage == null ? "" : this.exceptionMessage, cause);
            }
            ++index;
        }
    }

    @Override
    protected void scanDataTableRows(long startTime) throws IOException {
        if (this.indexToDataRowKeyMap.size() == 0) {
            this.state = UncoveredIndexRegionScanner.State.READY;
            return;
        }
        TreeSet<byte[]> dataRowKeys = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (byte[] dataRowKey : this.indexToDataRowKeyMap.values()) {
            dataRowKeys.add(dataRowKey);
        }
        List<Set<byte[]>> setList = IndexRepairRegionScanner.getPerTaskDataRowKeys(dataRowKeys, this.regionEndKeys, this.rowCountPerTask);
        int taskCount = setList.size();
        TaskBatch tasks = new TaskBatch(taskCount);
        for (int i = 0; i < taskCount; ++i) {
            this.addTasksForScanningDataTableRowsInParallel((TaskBatch<Boolean>)tasks, setList.get(i), startTime);
        }
        this.submitTasks((TaskBatch<Boolean>)tasks);
        this.state = this.state == UncoveredIndexRegionScanner.State.SCANNING_DATA_INTERRUPTED ? UncoveredIndexRegionScanner.State.SCANNING_DATA : UncoveredIndexRegionScanner.State.READY;
    }

    static {
        Configuration.addDeprecation((String)"index.threads.max", (String)NUM_CONCURRENT_INDEX_THREADS_CONF_KEY);
        Configuration.addDeprecation((String)"index.row.count.per.task", (String)INDEX_ROW_COUNTS_PER_TASK_CONF_KEY);
    }
}

