/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.DelegateRegionScanner;
import org.apache.phoenix.schema.CompiledTTLExpression;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.TTLExpressionFactory;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTLRegionScanner
extends BaseRegionScanner {
    private static final Logger LOG = LoggerFactory.getLogger(TTLRegionScanner.class);
    private final boolean isMaskingEnabled;
    private final RegionCoprocessorEnvironment env;
    private Scan scan;
    private long rowCount = 0L;
    private long maxRowCount = Long.MAX_VALUE;
    private long pageSizeMs;
    long ttl;
    long ttlWindowStart;
    byte[] emptyCQ;
    byte[] emptyCF;
    private boolean initialized = false;
    private CompiledTTLExpression ttlExpression;
    long currentTime;

    public TTLRegionScanner(RegionCoprocessorEnvironment env, Scan scan, RegionScanner s) throws IOException {
        super(s);
        this.env = env;
        this.scan = scan;
        this.pageSizeMs = ScanUtil.getPageSizeMsForRegionScanner((Scan)scan);
        this.emptyCQ = scan.getAttribute("_EmptyCQName");
        this.emptyCF = scan.getAttribute("_EmptyCFName");
        this.currentTime = scan.getTimeRange().getMax() == Long.MAX_VALUE ? EnvironmentEdgeManager.currentTimeMillis() : scan.getTimeRange().getMax();
        CompiledTTLExpression scanTTLExpression = ScanUtil.getTTLExpression((Scan)scan);
        if (BaseScannerRegionObserver.isPhoenixCompactionEnabled(env.getConfiguration()) && scanTTLExpression != null && !scanTTLExpression.equals(LiteralTTLExpression.TTL_EXPRESSION_DEFINED_IN_TABLE_DESCRIPTOR)) {
            this.ttlExpression = scanTTLExpression;
        } else {
            ColumnFamilyDescriptor cfd = env.getRegion().getTableDescriptor().getColumnFamilies()[0];
            this.ttlExpression = TTLExpressionFactory.create((int)cfd.getTimeToLive());
        }
        this.isMaskingEnabled = this.emptyCF != null && this.emptyCQ != null && !this.ttlExpression.equals(LiteralTTLExpression.TTL_EXPRESSION_FOREVER) && BaseScannerRegionObserver.isPhoenixCompactionEnabled(env.getConfiguration()) && ScanUtil.isStrictTTL((Scan)scan);
    }

    private void init() throws IOException {
        PageFilter pageFilter = ScanUtil.removePageFilter((Scan)this.scan);
        if (pageFilter != null) {
            this.maxRowCount = pageFilter.getPageSize();
            this.delegate.close();
            this.delegate = ((DelegateRegionScanner)this.delegate).getNewRegionScanner(this.scan);
        }
    }

    private void setTTLContextForRow(List<Cell> result) {
        this.ttl = this.ttlExpression.getRowTTLForMasking(result, this.scan.isRaw());
        this.ttlWindowStart = this.ttl == Integer.MAX_VALUE ? 1L : this.currentTime - this.ttl * 1000L;
        this.ttl *= 1000L;
    }

    private boolean isExpired(List<Cell> result) throws IOException {
        long maxTimestamp = 0L;
        long minTimestamp = Long.MAX_VALUE;
        boolean found = false;
        this.setTTLContextForRow(result);
        for (Cell c : result) {
            long ts = c.getTimestamp();
            if (!found && ScanUtil.isEmptyColumn((Cell)c, (byte[])this.emptyCF, (byte[])this.emptyCQ)) {
                if (ts < this.ttlWindowStart) {
                    return true;
                }
                found = true;
            }
            if (maxTimestamp < ts) {
                maxTimestamp = ts;
            }
            if (minTimestamp <= ts) continue;
            minTimestamp = ts;
        }
        if (!found) {
            LOG.warn("No empty column cell " + this.env.getRegion().getRegionInfo().getTable());
        }
        if (maxTimestamp - minTimestamp <= this.ttl) {
            return false;
        }
        long wndStartTS = minTimestamp + 1L;
        long wndEndTS = wndStartTS + this.ttl;
        long trimTimestamp = minTimestamp;
        ArrayList row = new ArrayList();
        LOG.debug("Doing gap analysis for {} min = {}, max = {}", new Object[]{this.env.getRegionInfo().getRegionNameAsString(), minTimestamp, maxTimestamp});
        while (wndEndTS <= maxTimestamp) {
            LOG.debug("WndStart = {}, WndEnd = {}, trim = {}", new Object[]{wndStartTS, wndEndTS, trimTimestamp});
            row.clear();
            Scan singleRowScan = new Scan();
            singleRowScan.setTimeRange(wndStartTS, wndEndTS);
            byte[] rowKey = CellUtil.cloneRow((Cell)result.get(0));
            singleRowScan.withStartRow(rowKey, true);
            singleRowScan.withStopRow(rowKey, true);
            RegionScanner scanner = ((DelegateRegionScanner)this.delegate).getNewRegionScanner(singleRowScan);
            scanner.next(row);
            scanner.close();
            if (row.isEmpty()) {
                trimTimestamp = wndEndTS - 1L;
                LOG.debug("Found gap at {}", (Object)trimTimestamp);
                wndStartTS = wndEndTS;
            } else {
                long lastUpdateTS = 0L;
                for (Cell cell : row) {
                    lastUpdateTS = Math.max(lastUpdateTS, cell.getTimestamp());
                }
                LOG.debug("lastUpdateTS = {}", (Object)lastUpdateTS);
                wndStartTS = lastUpdateTS + 1L;
            }
            wndEndTS = wndStartTS + this.ttl;
        }
        Iterator<Cell> iterator = result.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getTimestamp() >= trimTimestamp) continue;
            iterator.remove();
        }
        return false;
    }

    private boolean skipExpired(List<Cell> result, boolean raw, boolean hasMore) throws IOException {
        boolean expired = this.isExpired(result);
        if (!expired) {
            return hasMore;
        }
        result.clear();
        if (!hasMore) {
            return false;
        }
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        do {
            boolean bl = hasMore = raw ? this.delegate.nextRaw(result) : this.delegate.next(result);
            if (result.isEmpty() || ScanUtil.isDummy(result)) {
                return hasMore;
            }
            if (!this.isExpired(result)) {
                return hasMore;
            }
            Cell cell = result.get(0);
            result.clear();
            if (EnvironmentEdgeManager.currentTimeMillis() - startTime <= this.pageSizeMs) continue;
            ScanUtil.getDummyResult((byte[])CellUtil.cloneRow((Cell)cell), result);
            return hasMore;
        } while (hasMore);
        return false;
    }

    private boolean next(List<Cell> result, boolean raw, ScannerContext scannerContext) throws IOException {
        boolean hasMore;
        if (!this.isMaskingEnabled) {
            boolean hasMore2 = scannerContext != null ? (raw ? this.delegate.nextRaw(result, scannerContext) : this.delegate.next(result, scannerContext)) : (raw ? this.delegate.nextRaw(result) : this.delegate.next(result));
            return hasMore2;
        }
        if (!this.initialized) {
            this.init();
            this.initialized = true;
        }
        if (scannerContext != null) {
            hasMore = raw ? this.delegate.nextRaw(result, scannerContext) : this.delegate.next(result, scannerContext);
        } else {
            boolean bl = hasMore = raw ? this.delegate.nextRaw(result) : this.delegate.next(result);
        }
        if (result.isEmpty() || ScanUtil.isDummy(result)) {
            return hasMore;
        }
        hasMore = this.skipExpired(result, raw, hasMore);
        if (result.isEmpty() || ScanUtil.isDummy(result)) {
            return hasMore;
        }
        ++this.rowCount;
        if (this.rowCount >= this.maxRowCount) {
            return false;
        }
        return hasMore;
    }

    @Override
    public boolean next(List<Cell> results) throws IOException {
        return this.next(results, false, null);
    }

    @Override
    public boolean nextRaw(List<Cell> results) throws IOException {
        return this.next(results, true, null);
    }

    @Override
    public boolean next(List<Cell> results, ScannerContext scannerContext) throws IOException {
        return this.next(results, false, scannerContext);
    }

    @Override
    public boolean nextRaw(List<Cell> results, ScannerContext scannerContext) throws IOException {
        return this.next(results, true, scannerContext);
    }

    @Override
    public RegionScanner getNewRegionScanner(Scan scan) throws IOException {
        try {
            return new TTLRegionScanner(this.env, scan, ((DelegateRegionScanner)this.delegate).getNewRegionScanner(scan));
        }
        catch (ClassCastException e) {
            throw new DoNotRetryIOException((Throwable)e);
        }
    }
}

