/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.Collections;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.cache.GlobalCache;
import org.apache.phoenix.cache.TenantCache;
import org.apache.phoenix.coprocessor.generated.ServerCachingProtos;
import org.apache.phoenix.coprocessorclient.ServerCachingProtocol;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.ScanUtil;

public class ServerCachingEndpointImpl
extends ServerCachingProtos.ServerCachingService
implements RegionCoprocessor {
    private RegionCoprocessorEnvironment env;

    public Iterable<Service> getServices() {
        return Collections.singleton(this);
    }

    public void addServerCache(RpcController controller, ServerCachingProtos.AddServerCacheRequest request, RpcCallback<ServerCachingProtos.AddServerCacheResponse> done) {
        ImmutableBytesPtr tenantId = null;
        if (request.hasTenantId()) {
            tenantId = new ImmutableBytesPtr(request.getTenantId().toByteArray());
        }
        TenantCache tenantCache = GlobalCache.getTenantCache(this.env, tenantId);
        ImmutableBytesWritable cachePtr = ProtobufUtil.toImmutableBytesWritable((ServerCachingProtos.ImmutableBytesWritable)request.getCachePtr());
        byte[] txState = request.hasTxState() ? request.getTxState().toByteArray() : ByteUtil.EMPTY_BYTE_ARRAY;
        try {
            Class<?> serverCacheFactoryClass = Class.forName(request.getCacheFactory().getClassName());
            ServerCachingProtocol.ServerCacheFactory cacheFactory = (ServerCachingProtocol.ServerCacheFactory)serverCacheFactoryClass.newInstance();
            tenantCache.addServerCache(new ImmutableBytesPtr(request.getCacheId().toByteArray()), cachePtr, txState, cacheFactory, request.hasHasProtoBufIndexMaintainer() && request.getHasProtoBufIndexMaintainer(), request.getUsePersistentCache(), request.hasClientVersion() ? request.getClientVersion() : ScanUtil.UNKNOWN_CLIENT_VERSION);
        }
        catch (Throwable e) {
            ProtobufUtil.setControllerException((RpcController)controller, (IOException)ClientUtil.createIOException((String)"Error when adding cache: ", (Throwable)e));
        }
        ServerCachingProtos.AddServerCacheResponse.Builder responseBuilder = ServerCachingProtos.AddServerCacheResponse.newBuilder();
        responseBuilder.setReturn(true);
        ServerCachingProtos.AddServerCacheResponse result = responseBuilder.build();
        done.run((Object)result);
    }

    public void removeServerCache(RpcController controller, ServerCachingProtos.RemoveServerCacheRequest request, RpcCallback<ServerCachingProtos.RemoveServerCacheResponse> done) {
        ImmutableBytesPtr tenantId = null;
        if (request.hasTenantId()) {
            tenantId = new ImmutableBytesPtr(request.getTenantId().toByteArray());
        }
        TenantCache tenantCache = GlobalCache.getTenantCache(this.env, tenantId);
        tenantCache.removeServerCache(new ImmutableBytesPtr(request.getCacheId().toByteArray()));
        ServerCachingProtos.RemoveServerCacheResponse.Builder responseBuilder = ServerCachingProtos.RemoveServerCacheResponse.newBuilder();
        responseBuilder.setReturn(true);
        ServerCachingProtos.RemoveServerCacheResponse result = responseBuilder.build();
        done.run((Object)result);
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
    }

    public void stop(CoprocessorEnvironment arg0) throws IOException {
    }
}

