/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.protobuf.ByteString;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.io.Serializable;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.ObserverContextImpl;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcUtil;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.AccessControlUtil;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.AuthResult;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.phoenix.coprocessor.BaseMetaDataEndpointObserver;
import org.apache.phoenix.coprocessor.MetaDataEndpointObserver;
import org.apache.phoenix.coprocessor.PhoenixMetaDataCoprocessorHost;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixAccessController
extends BaseMetaDataEndpointObserver {
    private PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment env;
    AtomicReference<ArrayList<MasterObserver>> accessControllers = new AtomicReference();
    private boolean hbaseAccessControllerEnabled;
    private boolean accessCheckEnabled;
    private boolean execPermissionsCheckEnabled;
    private UserProvider userProvider;
    private AccessChecker accessChecker;
    private Connection serverConnection;
    public static final Logger LOGGER = LoggerFactory.getLogger(PhoenixAccessController.class);
    private static final Logger AUDITLOG = LoggerFactory.getLogger((String)("SecurityLogger." + PhoenixAccessController.class.getName()));

    @Override
    public Optional<MetaDataEndpointObserver> getPhoenixObserver() {
        return Optional.of(this);
    }

    private List<MasterObserver> getAccessControllers() throws IOException {
        ArrayList<Object> oldAccessControllers = this.accessControllers.get();
        if (oldAccessControllers == null) {
            oldAccessControllers = new ArrayList();
            RegionCoprocessorHost cpHost = this.env.getCoprocessorHost();
            for (RegionCoprocessor cp : cpHost.findCoprocessors(RegionCoprocessor.class)) {
                if (!(cp instanceof AccessControlProtos.AccessControlService.Interface) || !(cp instanceof MasterObserver)) continue;
                oldAccessControllers.add((MasterObserver)cp);
                if (!cp.getClass().getName().equals(AccessController.class.getName())) continue;
                this.hbaseAccessControllerEnabled = true;
            }
            this.accessControllers.set(oldAccessControllers);
        }
        return this.accessControllers.get();
    }

    public ObserverContext<MasterCoprocessorEnvironment> getMasterObsevrverContext() throws IOException {
        return new ObserverContextImpl(this.getActiveUser());
    }

    @Override
    public void preGetTable(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String tenantId, String tableName, TableName physicalTableName) throws IOException {
        if (!this.accessCheckEnabled) {
            return;
        }
        if (this.execPermissionsCheckEnabled) {
            this.requireAccess("GetTable" + tenantId, physicalTableName, Permission.Action.READ, Permission.Action.EXEC);
        } else {
            this.requireAccess("GetTable" + tenantId, physicalTableName, Permission.Action.READ);
        }
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        Configuration conf = env.getConfiguration();
        this.accessCheckEnabled = conf.getBoolean("phoenix.acls.enabled", false);
        if (this.accessCheckEnabled) {
            this.serverConnection = ServerUtil.ConnectionFactory.getConnection(ServerUtil.ConnectionType.DEFAULT_SERVER_CONNECTION, ((PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment)env).getRegionCoprocessorEnvironment());
        } else {
            LOGGER.warn("PhoenixAccessController has been loaded with authorization checks disabled.");
        }
        this.execPermissionsCheckEnabled = conf.getBoolean("hbase.security.exec.permission.checks", false);
        if (!(env instanceof PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment)) {
            throw new IllegalArgumentException("Not a valid environment, should be loaded by PhoenixMetaDataControllerEnvironment");
        }
        this.env = (PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment)env;
        this.accessChecker = new AccessChecker(env.getConfiguration());
        this.userProvider = UserProvider.instantiate((Configuration)env.getConfiguration());
        Superusers.initialize(env.getConfiguration());
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
        super.stop(env);
    }

    @Override
    public void preCreateTable(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String tenantId, String tableName, TableName physicalTableName, TableName parentPhysicalTableName, PTableType tableType, Set<byte[]> familySet, Set<TableName> indexes) throws IOException {
        if (!this.accessCheckEnabled) {
            return;
        }
        if (tableType != PTableType.VIEW && tableType != PTableType.CDC) {
            TableDescriptorBuilder tableDescBuilder = TableDescriptorBuilder.newBuilder((TableName)physicalTableName);
            for (byte[] familyName : familySet) {
                tableDescBuilder.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])familyName).build());
            }
            TableDescriptor htd = tableDescBuilder.build();
            for (MasterObserver observer : this.getAccessControllers()) {
                observer.preCreateTable(this.getMasterObsevrverContext(), htd, null);
            }
        }
        HashSet<TableName> physicalTablesChecked = new HashSet<TableName>();
        if (tableType == PTableType.VIEW || tableType == PTableType.INDEX || tableType == PTableType.CDC) {
            physicalTablesChecked.add(parentPhysicalTableName);
            if (this.execPermissionsCheckEnabled) {
                this.requireAccess("Create" + tableType, parentPhysicalTableName, Permission.Action.READ, Permission.Action.EXEC);
            } else {
                this.requireAccess("Create" + tableType, parentPhysicalTableName, Permission.Action.READ);
            }
        }
        if (tableType == PTableType.VIEW) {
            Permission.Action[] actionArray;
            if (this.execPermissionsCheckEnabled) {
                Permission.Action[] actionArray2 = new Permission.Action[2];
                actionArray2[0] = Permission.Action.READ;
                actionArray = actionArray2;
                actionArray2[1] = Permission.Action.EXEC;
            } else {
                Permission.Action[] actionArray3 = new Permission.Action[1];
                actionArray = actionArray3;
                actionArray3[0] = Permission.Action.READ;
            }
            Permission.Action[] requiredActions = actionArray;
            for (TableName index : indexes) {
                if (!physicalTablesChecked.add(index)) continue;
                User user = this.getActiveUser();
                List<UserPermission> permissionForUser = this.getPermissionForUser(this.getUserPermissions(index), user.getShortName());
                HashSet<Permission.Action> requireAccess = new HashSet<Permission.Action>();
                HashSet<Permission.Action> accessExists = new HashSet<Permission.Action>();
                if (permissionForUser != null) {
                    for (UserPermission userPermission : permissionForUser) {
                        for (Permission.Action action : Arrays.asList(requiredActions)) {
                            if (userPermission.getPermission().implies(action)) continue;
                            requireAccess.add(action);
                        }
                    }
                    if (!requireAccess.isEmpty()) {
                        for (UserPermission userPermission : permissionForUser) {
                            accessExists.addAll(Arrays.asList(userPermission.getPermission().getActions()));
                        }
                    }
                } else {
                    requireAccess.addAll(Arrays.asList(requiredActions));
                }
                if (requireAccess.isEmpty()) continue;
                byte[] indexPhysicalTable = index.getName();
                this.handleRequireAccessOnDependentTable("Create" + tableType, user.getName(), TableName.valueOf((byte[])indexPhysicalTable), tableName, requireAccess, accessExists);
            }
        }
        if (tableType == PTableType.INDEX && physicalTableName != null && !parentPhysicalTableName.equals((Object)physicalTableName) && !MetaDataUtil.isViewIndex((String)physicalTableName.getNameAsString())) {
            ArrayList<Permission.Action> actions = new ArrayList<Permission.Action>(Arrays.asList(Permission.Action.READ, Permission.Action.WRITE, Permission.Action.CREATE, Permission.Action.ADMIN));
            if (this.execPermissionsCheckEnabled) {
                actions.add(Permission.Action.EXEC);
            }
            this.authorizeOrGrantAccessToUsers("Create" + tableType, parentPhysicalTableName, actions, physicalTableName);
        }
    }

    public void handleRequireAccessOnDependentTable(String request, String userName, TableName dependentTable, String requestTable, Set<Permission.Action> requireAccess, Set<Permission.Action> accessExists) throws IOException {
        HashSet<Permission.Action> unionSet = new HashSet<Permission.Action>();
        unionSet.addAll(requireAccess);
        unionSet.addAll(accessExists);
        AUDITLOG.info(request + ": Automatically granting access to index table during creation of view:" + requestTable + this.authString(userName, dependentTable, requireAccess));
        this.grantPermissions(userName, dependentTable.getName(), unionSet.toArray(new Permission.Action[0]));
    }

    private void grantPermissions(final String toUser, final byte[] table, final Permission.Action ... actions) throws IOException {
        User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    AccessControlClient.grant((Connection)PhoenixAccessController.this.serverConnection, (TableName)TableName.valueOf((byte[])table), (String)toUser, null, null, (Permission.Action[])actions);
                }
                catch (Throwable e) {
                    throw new DoNotRetryIOException(e);
                }
                return null;
            }
        });
    }

    private void authorizeOrGrantAccessToUsers(final String request, final TableName fromTable, final List<Permission.Action> requiredActionsOnTable, final TableName toTable) throws IOException {
        User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                List<UserPermission> userPermissions = PhoenixAccessController.this.getUserPermissions(fromTable);
                List<UserPermission> permissionsOnTheTable = PhoenixAccessController.this.getUserPermissions(toTable);
                if (userPermissions != null) {
                    for (UserPermission userPermission : userPermissions) {
                        HashSet<Permission.Action> requireAccess = new HashSet<Permission.Action>();
                        HashSet<Permission.Action> accessExists = new HashSet<Permission.Action>();
                        List<UserPermission> permsToTable = PhoenixAccessController.this.getPermissionForUser(permissionsOnTheTable, userPermission.getUser());
                        for (Permission.Action action : requiredActionsOnTable) {
                            boolean haveAccess = false;
                            if (!userPermission.getPermission().implies(action)) continue;
                            if (permsToTable == null) {
                                requireAccess.add(action);
                                continue;
                            }
                            for (UserPermission permToTable : permsToTable) {
                                if (!permToTable.getPermission().implies(action)) continue;
                                haveAccess = true;
                            }
                            if (haveAccess) continue;
                            requireAccess.add(action);
                        }
                        if (permsToTable != null) {
                            for (UserPermission permToTable : permsToTable) {
                                accessExists.addAll(Arrays.asList(permToTable.getPermission().getActions()));
                            }
                        }
                        if (requireAccess.isEmpty()) continue;
                        if (AuthUtil.isGroupPrincipal((String)userPermission.getUser())) {
                            AUDITLOG.warn("Users of GROUP:" + userPermission.getUser() + " will not have following access " + requireAccess + " to the newly created index " + toTable + ", Automatic grant is not yet allowed on Groups");
                            continue;
                        }
                        PhoenixAccessController.this.handleRequireAccessOnDependentTable(request, userPermission.getUser(), toTable, toTable.getNameAsString(), requireAccess, accessExists);
                    }
                }
                return null;
            }
        });
    }

    private List<UserPermission> getPermissionForUser(List<UserPermission> perms, String user) {
        if (perms != null) {
            ArrayList<UserPermission> permissions = new ArrayList<UserPermission>();
            for (UserPermission p : perms) {
                if (!p.getUser().equals(user)) continue;
                permissions.add(p);
            }
            if (!permissions.isEmpty()) {
                return permissions;
            }
        }
        return null;
    }

    @Override
    public void preDropTable(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String tenantId, String tableName, TableName physicalTableName, TableName parentPhysicalTableName, PTableType tableType, List<PTable> indexes) throws IOException {
        if (!this.accessCheckEnabled) {
            return;
        }
        for (MasterObserver observer : this.getAccessControllers()) {
            if (tableType != PTableType.VIEW && tableType != PTableType.CDC) {
                observer.preDeleteTable(this.getMasterObsevrverContext(), physicalTableName);
            }
            if (indexes == null) continue;
            for (PTable index : indexes) {
                observer.preDeleteTable(this.getMasterObsevrverContext(), TableName.valueOf((byte[])index.getPhysicalName().getBytes()));
            }
        }
        if (tableType == PTableType.VIEW || tableType == PTableType.INDEX || tableType == PTableType.CDC) {
            if (this.execPermissionsCheckEnabled) {
                this.requireAccess("Drop " + tableType, parentPhysicalTableName, Permission.Action.READ, Permission.Action.EXEC);
            } else {
                this.requireAccess("Drop " + tableType, parentPhysicalTableName, Permission.Action.READ);
            }
        }
    }

    @Override
    public void preAlterTable(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String tenantId, String tableName, TableName physicalTableName, TableName parentPhysicalTableName, PTableType tableType) throws IOException {
        if (!this.accessCheckEnabled) {
            return;
        }
        for (MasterObserver observer : this.getAccessControllers()) {
            if (tableType == PTableType.VIEW) continue;
            observer.preModifyTable(this.getMasterObsevrverContext(), physicalTableName, null, TableDescriptorBuilder.newBuilder((TableName)physicalTableName).build());
        }
        if (tableType == PTableType.VIEW) {
            if (this.execPermissionsCheckEnabled) {
                this.requireAccess("Alter " + tableType, parentPhysicalTableName, Permission.Action.READ, Permission.Action.EXEC);
            } else {
                this.requireAccess("Alter " + tableType, parentPhysicalTableName, Permission.Action.READ);
            }
        }
    }

    @Override
    public void preGetSchema(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String schemaName) throws IOException {
        if (!this.accessCheckEnabled) {
            return;
        }
        for (MasterObserver observer : this.getAccessControllers()) {
            observer.preListNamespaceDescriptors(this.getMasterObsevrverContext(), Arrays.asList(NamespaceDescriptor.create((String)schemaName).build()));
        }
    }

    @Override
    public void preCreateSchema(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String schemaName) throws IOException {
        if (!this.accessCheckEnabled) {
            return;
        }
        for (MasterObserver observer : this.getAccessControllers()) {
            observer.preCreateNamespace(this.getMasterObsevrverContext(), NamespaceDescriptor.create((String)schemaName).build());
        }
    }

    @Override
    public void preDropSchema(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String schemaName) throws IOException {
        if (!this.accessCheckEnabled) {
            return;
        }
        for (MasterObserver observer : this.getAccessControllers()) {
            observer.preDeleteNamespace(this.getMasterObsevrverContext(), schemaName);
        }
    }

    @Override
    public void preIndexUpdate(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String tenantId, String indexName, TableName physicalTableName, TableName parentPhysicalTableName, PIndexState newState) throws IOException {
        if (!this.accessCheckEnabled) {
            return;
        }
        for (MasterObserver observer : this.getAccessControllers()) {
            observer.preModifyTable(this.getMasterObsevrverContext(), physicalTableName, null, TableDescriptorBuilder.newBuilder((TableName)physicalTableName).build());
        }
        if (newState == PIndexState.BUILDING) {
            if (this.execPermissionsCheckEnabled) {
                this.requireAccess("Rebuild:", parentPhysicalTableName, Permission.Action.READ, Permission.Action.EXEC);
            } else {
                this.requireAccess("Rebuild:", parentPhysicalTableName, Permission.Action.READ);
            }
        }
    }

    private List<UserPermission> getUserPermissions(final TableName tableName) throws IOException {
        List userPermissions = (List)User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<UserPermission>>(){

            @Override
            public List<UserPermission> run() throws Exception {
                ArrayList<UserPermission> userPermissions = new ArrayList<UserPermission>();
                RpcCall rpcContext = RpcUtil.getRpcContext();
                try {
                    RpcUtil.setRpcContext(null);
                    for (MasterObserver service : PhoenixAccessController.this.getAccessControllers()) {
                        if (!service.getClass().getName().equals(AccessController.class.getName())) continue;
                        userPermissions.addAll(AccessControlClient.getUserPermissions((Connection)PhoenixAccessController.this.serverConnection, (String)tableName.getNameWithNamespaceInclAsString()));
                        userPermissions.addAll(AccessControlClient.getUserPermissions((Connection)PhoenixAccessController.this.serverConnection, (String)AuthUtil.toGroupEntry((String)tableName.getNamespaceAsString())));
                    }
                }
                catch (Throwable e) {
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    throw new Exception(e);
                }
                finally {
                    RpcUtil.setRpcContext(rpcContext);
                }
                return userPermissions;
            }
        });
        this.getUserDefinedPermissions(tableName, userPermissions);
        return userPermissions;
    }

    private void getUserDefinedPermissions(final TableName tableName, final List<UserPermission> userPermissions) throws IOException {
        User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<UserPermission>>(){

            @Override
            public List<UserPermission> run() throws Exception {
                RpcCall rpcContext = RpcUtil.getRpcContext();
                try {
                    RpcUtil.setRpcContext(null);
                    for (MasterObserver service : PhoenixAccessController.this.getAccessControllers()) {
                        if (service.getClass().getName().equals(AccessController.class.getName())) continue;
                        this.getUserPermsFromUserDefinedAccessController(userPermissions, (AccessControlProtos.AccessControlService.Interface)service);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    throw new Exception(e);
                }
                finally {
                    RpcUtil.setRpcContext(rpcContext);
                }
                return userPermissions;
            }

            private void getUserPermsFromUserDefinedAccessController(List<UserPermission> userPermissions2, AccessControlProtos.AccessControlService.Interface service) {
                ServerRpcController controller = new ServerRpcController();
                AccessControlProtos.GetUserPermissionsRequest.Builder builderTablePerms = AccessControlProtos.GetUserPermissionsRequest.newBuilder();
                builderTablePerms.setTableName(ProtobufUtil.toProtoTableName((TableName)tableName));
                builderTablePerms.setType(AccessControlProtos.Permission.Type.Table);
                AccessControlProtos.GetUserPermissionsRequest requestTablePerms = builderTablePerms.build();
                this.callGetUserPermissionsRequest(userPermissions2, service, requestTablePerms, (RpcController)controller);
                AccessControlProtos.GetUserPermissionsRequest.Builder builderNamespacePerms = AccessControlProtos.GetUserPermissionsRequest.newBuilder();
                builderNamespacePerms.setNamespaceName(ByteString.copyFrom((byte[])tableName.getNamespace()));
                builderNamespacePerms.setType(AccessControlProtos.Permission.Type.Namespace);
                AccessControlProtos.GetUserPermissionsRequest requestNamespacePerms = builderNamespacePerms.build();
                this.callGetUserPermissionsRequest(userPermissions2, service, requestNamespacePerms, (RpcController)controller);
            }

            private void callGetUserPermissionsRequest(final List<UserPermission> userPermissions2, AccessControlProtos.AccessControlService.Interface service, AccessControlProtos.GetUserPermissionsRequest request, RpcController controller) {
                service.getUserPermissions(controller, request, (RpcCallback)new RpcCallback<AccessControlProtos.GetUserPermissionsResponse>(){

                    public void run(AccessControlProtos.GetUserPermissionsResponse message) {
                        if (message != null) {
                            for (AccessControlProtos.UserPermission perm : message.getUserPermissionList()) {
                                userPermissions2.add(AccessControlUtil.toUserPermission((AccessControlProtos.UserPermission)perm));
                            }
                        }
                    }
                });
            }
        });
    }

    private void requireAccess(String request, TableName tableName, Permission.Action ... permissions) throws IOException {
        User user = this.getActiveUser();
        AuthResult result = null;
        ArrayList<Permission.Action> requiredAccess = new ArrayList<Permission.Action>();
        for (Permission.Action permission : permissions) {
            if (this.hasAccess(this.getUserPermissions(tableName), tableName, permission, user)) {
                result = AuthResult.allow((String)request, (String)"Table permission granted", (User)user, (Permission.Action)permission, (TableName)tableName, null, null);
            } else {
                result = AuthResult.deny((String)request, (String)"Insufficient permissions", (User)user, (Permission.Action)permission, (TableName)tableName, null, null);
                requiredAccess.add(permission);
            }
            this.logResult(result);
        }
        if (!requiredAccess.isEmpty()) {
            result = AuthResult.deny((String)request, (String)"Insufficient permissions", (User)user, (Permission.Action)((Permission.Action)requiredAccess.get(0)), (TableName)tableName, null, null);
        }
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + this.authString(user.getName(), tableName, new HashSet<Permission.Action>(Arrays.asList(permissions))));
        }
    }

    private boolean hasAccess(List<UserPermission> perms, TableName table, Permission.Action action, User user) {
        if (Superusers.isSuperUser(user)) {
            return true;
        }
        if (perms != null) {
            String[] groupNames;
            if (this.hbaseAccessControllerEnabled && this.accessChecker.getAuthManager().authorizeUserTable(user, table, action)) {
                return true;
            }
            List<UserPermission> permissionsForUser = this.getPermissionForUser(perms, user.getShortName());
            if (permissionsForUser != null) {
                for (UserPermission permissionForUser : permissionsForUser) {
                    if (!permissionForUser.getPermission().implies(action)) continue;
                    return true;
                }
            }
            if ((groupNames = user.getGroupNames()) != null) {
                for (String group : groupNames) {
                    List<UserPermission> groupPerms = this.getPermissionForUser(perms, AuthUtil.toGroupEntry((String)group));
                    if (groupPerms == null) continue;
                    for (UserPermission permissionForUser : groupPerms) {
                        if (!permissionForUser.getPermission().implies(action)) continue;
                        return true;
                    }
                }
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("No permissions found for table=" + table + " or namespace=" + table.getNamespaceAsString());
        }
        return false;
    }

    private User getActiveUser() throws IOException {
        Optional user = RpcServer.getRequestUser();
        if (!user.isPresent()) {
            return this.userProvider.getCurrent();
        }
        return (User)user.get();
    }

    private void logResult(AuthResult result) {
        if (AUDITLOG.isTraceEnabled()) {
            Optional remoteAddr = RpcServer.getRemoteAddress();
            AUDITLOG.trace("Access " + (result.isAllowed() ? "allowed" : "denied") + " for user " + (result.getUser() != null ? result.getUser().getShortName() : "UNKNOWN") + "; reason: " + result.getReason() + "; remote address: " + (Serializable)(remoteAddr.isPresent() ? (Serializable)remoteAddr.get() : "") + "; request: " + result.getRequest() + "; context: " + result.toContextString());
        }
    }

    public String authString(String user, TableName table, Set<Permission.Action> actions) {
        StringBuilder sb = new StringBuilder();
        sb.append(" (user=").append(user != null ? user : "UNKNOWN").append(", ");
        sb.append("scope=").append(table == null ? "GLOBAL" : table.getNameWithNamespaceInclAsString()).append(", ");
        sb.append(actions.size() > 1 ? "actions=" : "action=").append(actions.toString()).append(")");
        return sb.toString();
    }

    private static final class Superusers {
        private static final Logger LOGGER = LoggerFactory.getLogger(Superusers.class);
        public static final String SUPERUSER_CONF_KEY = "hbase.superuser";
        private static List<String> superUsers;
        private static List<String> superGroups;
        private static User systemUser;

        private Superusers() {
        }

        public static void initialize(Configuration conf) throws IOException {
            String[] superUserList;
            superUsers = new ArrayList<String>();
            superGroups = new ArrayList<String>();
            systemUser = User.getCurrent();
            if (systemUser == null) {
                throw new IllegalStateException("Unable to obtain the current user, authorization checks for internal operations will not work correctly!");
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Current user name is " + systemUser.getShortName());
            }
            String currentUser = systemUser.getShortName();
            for (String name : superUserList = conf.getStrings(SUPERUSER_CONF_KEY, new String[0])) {
                if (AuthUtil.isGroupPrincipal((String)name)) {
                    superGroups.add(AuthUtil.getGroupName((String)name));
                    continue;
                }
                superUsers.add(name);
            }
            superUsers.add(currentUser);
        }

        public static boolean isSuperUser(User user) {
            if (superUsers == null) {
                throw new IllegalStateException("Super users/super groups lists haven't been initialized properly.");
            }
            if (superUsers.contains(user.getShortName())) {
                return true;
            }
            for (String group : user.getGroupNames()) {
                if (!superGroups.contains(group)) continue;
                return true;
            }
            return false;
        }
    }
}

