/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.cache.GlobalCache;
import org.apache.phoenix.cache.HashCache;
import org.apache.phoenix.cache.TenantCache;
import org.apache.phoenix.coprocessorclient.HashJoinCacheNotFoundException;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.iterate.RegionScannerFactory;
import org.apache.phoenix.join.HashJoinInfo;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.PositionBasedResultTuple;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.TupleUtil;

public class HashJoinRegionScanner
implements RegionScanner {
    private final RegionScanner scanner;
    private final TupleProjector projector;
    private final HashJoinInfo joinInfo;
    private final RegionCoprocessorEnvironment env;
    private Queue<Tuple> resultQueue;
    private boolean hasMore;
    private long count;
    private long limit;
    private HashCache[] hashCaches;
    private List<Tuple>[] tempTuples;
    private ValueBitSet tempDestBitSet;
    private ValueBitSet[] tempSrcBitSet;
    private final boolean useQualifierAsListIndex;
    private final boolean useNewValueColumnQualifier;
    private final boolean addArrayCell;
    private final long pageSizeMs;

    public HashJoinRegionScanner(RegionScanner scanner, Scan scan, TupleProjector projector, HashJoinInfo joinInfo, ImmutableBytesPtr tenantId, RegionCoprocessorEnvironment env, boolean useQualifierAsIndex, boolean useNewValueColumnQualifier) throws IOException {
        this(env, scanner, scan, null, null, projector, joinInfo, tenantId, useQualifierAsIndex, useNewValueColumnQualifier);
    }

    public HashJoinRegionScanner(RegionCoprocessorEnvironment env, RegionScanner scanner, Scan scan, Set<KeyValueColumnExpression> arrayKVRefs, Expression[] arrayFuncRefs, TupleProjector projector, HashJoinInfo joinInfo, ImmutableBytesPtr tenantId, boolean useQualifierAsIndex, boolean useNewValueColumnQualifier) throws IOException {
        this.env = env;
        this.scanner = scanner;
        this.projector = projector;
        this.joinInfo = joinInfo;
        this.resultQueue = new LinkedList<Tuple>();
        this.hasMore = true;
        this.count = 0L;
        this.limit = Long.MAX_VALUE;
        for (JoinTableNode.JoinType type : joinInfo.getJoinTypes()) {
            if (type == JoinTableNode.JoinType.Inner || type == JoinTableNode.JoinType.Left || type == JoinTableNode.JoinType.Semi || type == JoinTableNode.JoinType.Anti) continue;
            throw new DoNotRetryIOException("Got join type '" + type + "'. Expect only INNER or LEFT with hash-joins.");
        }
        if (joinInfo.getLimit() != null) {
            this.limit = joinInfo.getLimit().intValue();
        }
        int count = joinInfo.getJoinIds().length;
        this.tempTuples = new List[count];
        this.hashCaches = new HashCache[count];
        this.tempSrcBitSet = new ValueBitSet[count];
        TenantCache cache = GlobalCache.getTenantCache(env, tenantId);
        for (int i = 0; i < count; ++i) {
            ImmutableBytesPtr joinId = joinInfo.getJoinIds()[i];
            if (joinId.getLength() == 0) {
                this.hashCaches[i] = null;
                this.tempSrcBitSet[i] = null;
                this.tempTuples[i] = null;
                continue;
            }
            HashCache hashCache = (HashCache)cache.getServerCache(joinId);
            if (hashCache == null) {
                HashJoinCacheNotFoundException cause = new HashJoinCacheNotFoundException(Long.valueOf(Bytes.toLong((byte[])joinId.get())));
                throw new DoNotRetryIOException(cause.getMessage(), (Throwable)cause);
            }
            this.hashCaches[i] = hashCache;
            this.tempSrcBitSet[i] = ValueBitSet.newInstance((ValueSchema)joinInfo.getSchemas()[i]);
        }
        if (this.projector != null) {
            this.tempDestBitSet = ValueBitSet.newInstance((ValueSchema)joinInfo.getJoinedSchema());
            this.projector.setValueBitSet(this.tempDestBitSet);
        }
        this.useQualifierAsListIndex = useQualifierAsIndex;
        this.useNewValueColumnQualifier = useNewValueColumnQualifier;
        this.addArrayCell = arrayFuncRefs != null && arrayFuncRefs.length > 0 && arrayKVRefs != null && arrayKVRefs.size() > 0;
        this.pageSizeMs = ScanUtil.getPageSizeMsForRegionScanner((Scan)scan);
    }

    private void processResults(List<Cell> result, boolean hasBatchLimit) throws IOException {
        if (result.isEmpty()) {
            return;
        }
        PositionBasedResultTuple tuple = this.useQualifierAsListIndex ? new PositionBasedResultTuple(result) : new ResultTuple(Result.create(result));
        boolean projected = false;
        if (this.joinInfo.forceProjection()) {
            tuple = this.projector.projectResults((Tuple)tuple, this.useNewValueColumnQualifier);
            projected = true;
        }
        if (hasBatchLimit) {
            throw new UnsupportedOperationException("Cannot support join operations in scans with limit");
        }
        int count = this.joinInfo.getJoinIds().length;
        boolean cont = true;
        for (int i = 0; i < count; ++i) {
            if (!this.joinInfo.earlyEvaluation()[i] || this.hashCaches[i] == null) continue;
            ImmutableBytesPtr key = TupleUtil.getConcatenatedValue((Tuple)tuple, (List)this.joinInfo.getJoinExpressions()[i]);
            this.tempTuples[i] = this.hashCaches[i].get(key);
            JoinTableNode.JoinType type = this.joinInfo.getJoinTypes()[i];
            if ((type != JoinTableNode.JoinType.Inner && type != JoinTableNode.JoinType.Semi || this.tempTuples[i] != null) && (type != JoinTableNode.JoinType.Anti || this.tempTuples[i] == null)) continue;
            cont = false;
            break;
        }
        if (cont) {
            Expression postFilter;
            if (this.projector == null) {
                int dup = 1;
                for (i = 0; i < count; ++i) {
                    dup *= this.tempTuples[i] == null ? 1 : this.tempTuples[i].size();
                }
                for (i = 0; i < dup; ++i) {
                    this.offerResult((Tuple)tuple, projected, result);
                }
            } else {
                KeyValueSchema schema = this.joinInfo.getJoinedSchema();
                if (!this.joinInfo.forceProjection()) {
                    tuple = this.projector.projectResults((Tuple)tuple, this.useNewValueColumnQualifier);
                    projected = true;
                }
                this.offerResult((Tuple)tuple, projected, result);
                for (i = 0; i < count; ++i) {
                    boolean earlyEvaluation = this.joinInfo.earlyEvaluation()[i];
                    JoinTableNode.JoinType type = this.joinInfo.getJoinTypes()[i];
                    if (earlyEvaluation && (type == JoinTableNode.JoinType.Semi || type == JoinTableNode.JoinType.Anti)) continue;
                    int j = this.resultQueue.size();
                    while (j-- > 0) {
                        Tuple lhs = this.resultQueue.poll();
                        if (!earlyEvaluation) {
                            ImmutableBytesPtr key = TupleUtil.getConcatenatedValue((Tuple)lhs, (List)this.joinInfo.getJoinExpressions()[i]);
                            this.tempTuples[i] = this.hashCaches[i].get(key);
                            if (this.tempTuples[i] == null) {
                                if (type == JoinTableNode.JoinType.Inner || type == JoinTableNode.JoinType.Semi) continue;
                                if (type == JoinTableNode.JoinType.Anti) {
                                    this.offerResult(lhs, projected, result);
                                    continue;
                                }
                            }
                        }
                        if (this.tempTuples[i] == null) {
                            Tuple joined = this.tempSrcBitSet[i] == ValueBitSet.EMPTY_VALUE_BITSET ? lhs : this.mergeProjectedValue(lhs, schema, this.tempDestBitSet, null, this.joinInfo.getSchemas()[i], this.tempSrcBitSet[i], this.joinInfo.getFieldPositions()[i]);
                            this.offerResult(joined, projected, result);
                            continue;
                        }
                        for (Tuple t : this.tempTuples[i]) {
                            Tuple joined = this.tempSrcBitSet[i] == ValueBitSet.EMPTY_VALUE_BITSET ? lhs : this.mergeProjectedValue(lhs, schema, this.tempDestBitSet, t, this.joinInfo.getSchemas()[i], this.tempSrcBitSet[i], this.joinInfo.getFieldPositions()[i]);
                            this.offerResult(joined, projected, result);
                        }
                    }
                }
            }
            if ((postFilter = this.joinInfo.getPostJoinFilterExpression()) != null) {
                Iterator iter = this.resultQueue.iterator();
                while (iter.hasNext()) {
                    ImmutableBytesPtr tempPtr;
                    block22: {
                        Tuple t = (Tuple)iter.next();
                        postFilter.reset();
                        tempPtr = new ImmutableBytesPtr();
                        try {
                            if (!postFilter.evaluate(t, (ImmutableBytesWritable)tempPtr) || tempPtr.getLength() == 0) {
                                iter.remove();
                            }
                            break block22;
                        }
                        catch (IllegalDataException e) {
                            iter.remove();
                        }
                        continue;
                    }
                    Boolean b = (Boolean)postFilter.getDataType().toObject((ImmutableBytesWritable)tempPtr);
                    if (Boolean.TRUE.equals(b)) continue;
                    iter.remove();
                }
            }
        }
    }

    private boolean shouldAdvance() {
        if (!this.resultQueue.isEmpty()) {
            return false;
        }
        return this.hasMore;
    }

    private boolean nextInQueue(List<Cell> results) {
        if (this.resultQueue.isEmpty()) {
            return false;
        }
        Tuple tuple = this.resultQueue.poll();
        for (int i = 0; i < tuple.size(); ++i) {
            results.add(tuple.getValue(i));
        }
        return this.count++ < this.limit && (!this.resultQueue.isEmpty() || this.hasMore);
    }

    public long getMvccReadPoint() {
        return this.scanner.getMvccReadPoint();
    }

    public RegionInfo getRegionInfo() {
        return this.scanner.getRegionInfo();
    }

    public boolean isFilterDone() throws IOException {
        return this.scanner.isFilterDone() && this.resultQueue.isEmpty();
    }

    public boolean nextRaw(List<Cell> result) throws IOException {
        return this.next(result, true, null);
    }

    public boolean nextRaw(List<Cell> result, ScannerContext scannerContext) throws IOException {
        return this.next(result, true, scannerContext);
    }

    private boolean next(List<Cell> result, boolean raw, ScannerContext scannerContext) throws IOException {
        try {
            long startTime = EnvironmentEdgeManager.currentTimeMillis();
            while (this.shouldAdvance()) {
                if (scannerContext != null) {
                    this.hasMore = raw ? this.scanner.nextRaw(result, scannerContext) : this.scanner.next(result, scannerContext);
                } else {
                    boolean bl = this.hasMore = raw ? this.scanner.nextRaw(result) : this.scanner.next(result);
                }
                if (ScanUtil.isDummy(result)) {
                    return true;
                }
                if (result.isEmpty()) {
                    return this.hasMore;
                }
                Cell cell = result.get(0);
                this.processResults(result, false);
                if (EnvironmentEdgeManager.currentTimeMillis() - startTime >= this.pageSizeMs) {
                    byte[] rowKey = CellUtil.cloneRow((Cell)cell);
                    result.clear();
                    ScanUtil.getDummyResult((byte[])rowKey, result);
                    return true;
                }
                result.clear();
            }
            return this.nextInQueue(result);
        }
        catch (Throwable t) {
            ClientUtil.throwIOException((String)this.env.getRegion().getRegionInfo().getRegionNameAsString(), (Throwable)t);
            return false;
        }
    }

    public boolean reseek(byte[] row) throws IOException {
        return this.scanner.reseek(row);
    }

    public void close() throws IOException {
        this.scanner.close();
    }

    public boolean next(List<Cell> result) throws IOException {
        return this.next(result, false, null);
    }

    public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
        return this.next(result, false, scannerContext);
    }

    public long getMaxResultSize() {
        return this.scanner.getMaxResultSize();
    }

    public int getBatch() {
        return this.scanner.getBatch();
    }

    private void offerResult(Tuple tuple, boolean projected, List<Cell> result) {
        if (!projected || !this.addArrayCell) {
            this.resultQueue.offer(tuple);
            return;
        }
        Cell projectedCell = tuple.getValue(0);
        int arrayCellPosition = RegionScannerFactory.getArrayCellPosition(result);
        Cell arrayCell = result.get(arrayCellPosition);
        ArrayList<Cell> cells = new ArrayList<Cell>(2);
        cells.add(projectedCell);
        cells.add(arrayCell);
        MultiKeyValueTuple multi = new MultiKeyValueTuple(cells);
        this.resultQueue.offer((Tuple)multi);
    }

    private Tuple mergeProjectedValue(Tuple dest, KeyValueSchema destSchema, ValueBitSet destBitSet, Tuple src, KeyValueSchema srcSchema, ValueBitSet srcBitSet, int offset) throws IOException {
        if (dest instanceof TupleProjector.ProjectedValueTuple) {
            return TupleProjector.mergeProjectedValue((TupleProjector.ProjectedValueTuple)((TupleProjector.ProjectedValueTuple)dest), (ValueBitSet)destBitSet, (Tuple)src, (ValueBitSet)srcBitSet, (int)offset, (boolean)this.useNewValueColumnQualifier);
        }
        TupleProjector.ProjectedValueTuple first = this.projector.projectResults((Tuple)new SingleKeyValueTuple(dest.getValue(0)));
        TupleProjector.ProjectedValueTuple merged = TupleProjector.mergeProjectedValue((TupleProjector.ProjectedValueTuple)first, (ValueBitSet)destBitSet, (Tuple)src, (ValueBitSet)srcBitSet, (int)offset, (boolean)this.useNewValueColumnQualifier);
        int size = dest.size();
        if (size == 1) {
            return merged;
        }
        ArrayList<Cell> cells = new ArrayList<Cell>(size);
        cells.add(merged.getValue(0));
        for (int i = 1; i < size; ++i) {
            cells.add(dest.getValue(i));
        }
        MultiKeyValueTuple multi = new MultiKeyValueTuple(cells);
        return multi;
    }
}

