/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.IndexToolVerificationResult;
import org.apache.phoenix.coprocessor.PagingRegionScanner;
import org.apache.phoenix.coprocessor.TTLRegionScanner;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.coprocessorclient.BaseScannerRegionObserverConstants;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.hbase.index.IndexRegionObserver;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.parallel.EarlyExitFailure;
import org.apache.phoenix.hbase.index.parallel.TaskBatch;
import org.apache.phoenix.hbase.index.parallel.TaskRunner;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolBuilder;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolManager;
import org.apache.phoenix.hbase.index.parallel.WaitForCompletionTaskRunner;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;
import org.apache.phoenix.hbase.index.write.IndexWriterUtils;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.IndexVerificationOutputRepository;
import org.apache.phoenix.mapreduce.index.IndexVerificationResultRepository;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.CompiledConditionalTTLExpression;
import org.apache.phoenix.schema.CompiledTTLExpression;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.transform.TransformMaintainer;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GlobalIndexRegionScanner
extends BaseRegionScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalIndexRegionScanner.class);
    public static final String NUM_CONCURRENT_INDEX_VERIFY_THREADS_CONF_KEY = "phoenix.index.verify.threads.max";
    public static final int DEFAULT_CONCURRENT_INDEX_VERIFY_THREADS = 16;
    public static final String INDEX_VERIFY_ROW_COUNTS_PER_TASK_CONF_KEY = "phoenix.index.verify.row.count.per.task";
    public static final int DEFAULT_INDEX_VERIFY_ROW_COUNTS_PER_TASK = 2048;
    public static final String NO_EXPECTED_MUTATION = "No expected mutation";
    public static final String ACTUAL_MUTATION_IS_NULL_OR_EMPTY = "actualMutationList is null or empty";
    public static final String ERROR_MESSAGE_MISSING_INDEX_ROW_BEYOND_MAX_LOOKBACK = "Missing index row beyond maxLookBack";
    public static final String ERROR_MESSAGE_MISSING_INDEX_ROW = "Missing index row";
    public static final String ERROR_MESSAGE_EXTRA_INDEX_ROW = "Extra index row";
    public static final String PHOENIX_INDEX_MR_LOG_BEYOND_MAX_LOOKBACK_ERRORS = "phoenix.index.mr.log.beyond.max.lookback.errors";
    public static final boolean DEFAULT_PHOENIX_INDEX_MR_LOG_BEYOND_MAX_LOOKBACK_ERRORS = false;
    protected final UngroupedAggregateRegionObserver ungroupedAggregateRegionObserver;
    protected IndexTool.IndexDisableLoggingType disableLoggingVerifyType = IndexTool.IndexDisableLoggingType.NONE;
    protected byte[][] viewConstants;
    protected IndexVerificationOutputRepository verificationOutputRepository = null;
    protected boolean skipped = false;
    protected boolean shouldRetry = false;
    protected boolean shouldVerifyCheckDone = false;
    protected final RegionCoprocessorEnvironment env;
    protected byte[][] regionEndKeys;
    protected byte[] nextStartKey;
    protected boolean hasMoreIncr = false;
    protected long minTimestamp = 0L;
    protected byte[] indexRowKeyforReadRepair;
    protected Table dataHTable = null;
    protected long pageSizeInRows = Long.MAX_VALUE;
    protected int rowCountPerTask;
    protected boolean hasMore;
    protected int maxBatchSize;
    protected final long maxBatchSizeBytes;
    protected final long blockingMemstoreSize;
    protected final byte[] clientVersionBytes;
    protected boolean useProto = true;
    protected byte[] indexMetaData;
    protected Scan scan;
    protected RegionScanner innerScanner;
    protected Region region;
    protected IndexMaintainer indexMaintainer;
    protected Table indexHTable = null;
    protected TaskRunner pool;
    protected String exceptionMessage;
    protected HTableFactory hTableFactory;
    protected int indexTableTTL;
    protected long maxLookBackInMills;
    protected IndexToolVerificationResult verificationResult = null;
    protected IndexVerificationResultRepository verificationResultRepository = null;
    protected Map<byte[], NavigableSet<byte[]>> familyMap;
    protected IndexTool.IndexVerifyType verifyType = IndexTool.IndexVerifyType.NONE;
    protected boolean verify = false;
    protected byte[] tenantId;
    protected byte[] schemaName;
    protected byte[] logicalTableName;
    protected byte[] tableType;
    protected byte[] lastDdlTimestamp;
    private final CompiledTTLExpression ttlExpression;
    private final boolean isTTLStrict;
    public static final Comparator<Mutation> MUTATION_TS_DESC_COMPARATOR;
    public static final Comparator<Mutation> MUTATION_TS_COMPARATOR;

    public GlobalIndexRegionScanner(RegionScanner innerScanner, Region region, Scan scan, RegionCoprocessorEnvironment env, UngroupedAggregateRegionObserver ungroupedAggregateRegionObserver) throws IOException {
        super(innerScanner);
        Configuration config = env.getConfiguration();
        if (scan.getAttribute("_IndexRebuildPaging") != null) {
            byte[] pageSizeFromScan = scan.getAttribute("_IndexRebuildPageRows");
            this.pageSizeInRows = pageSizeFromScan != null ? Bytes.toLong((byte[])pageSizeFromScan) : config.getLong("phoenix.index.rebuild_page_size_in_rows", 32768L);
        }
        this.maxBatchSize = config.getInt("phoenix.mutate.batchSize", 100);
        this.maxBatchSizeBytes = config.getLongBytes("phoenix.mutate.batchSizeBytes", 0x200000L);
        this.blockingMemstoreSize = UngroupedAggregateRegionObserver.getBlockingMemstoreSize(region, config);
        this.clientVersionBytes = scan.getAttribute("_ClientVersion");
        this.familyMap = scan.getFamilyMap();
        if (this.familyMap.isEmpty()) {
            this.familyMap = null;
        }
        this.indexMetaData = scan.getAttribute("IdxProtoMD");
        if (this.indexMetaData == null) {
            this.indexMetaData = scan.getAttribute("IdxMD");
        }
        this.tenantId = scan.getAttribute(MutationState.MutationMetadataType.TENANT_ID.toString());
        this.schemaName = scan.getAttribute(MutationState.MutationMetadataType.SCHEMA_NAME.toString());
        this.logicalTableName = scan.getAttribute(MutationState.MutationMetadataType.LOGICAL_TABLE_NAME.toString());
        this.tableType = scan.getAttribute(MutationState.MutationMetadataType.TABLE_TYPE.toString());
        this.lastDdlTimestamp = scan.getAttribute(MutationState.MutationMetadataType.TIMESTAMP.toString());
        this.ttlExpression = ScanUtil.getTTLExpression((Scan)scan);
        this.isTTLStrict = ScanUtil.isStrictTTL((Scan)scan);
        byte[] transforming = scan.getAttribute("_DoTransforming");
        List maintainers = null;
        maintainers = transforming == null ? IndexMaintainer.deserialize((byte[])this.indexMetaData, (boolean)true) : TransformMaintainer.deserialize((byte[])this.indexMetaData);
        this.indexMaintainer = (IndexMaintainer)maintainers.get(0);
        this.scan = scan;
        this.innerScanner = innerScanner;
        this.region = region;
        this.env = env;
        this.ungroupedAggregateRegionObserver = ungroupedAggregateRegionObserver;
        byte[] valueBytes = scan.getAttribute("_IndexRebuildVerifyType");
        if (valueBytes != null) {
            this.verifyType = IndexTool.IndexVerifyType.fromValue(valueBytes);
            if (this.verifyType != IndexTool.IndexVerifyType.NONE) {
                this.verify = true;
            }
        }
        this.hTableFactory = IndexWriterUtils.getDefaultDelegateHTableFactory(env);
        this.maxLookBackInMills = BaseScannerRegionObserverConstants.getMaxLookbackInMillis((Configuration)config);
        this.rowCountPerTask = config.getInt(INDEX_VERIFY_ROW_COUNTS_PER_TASK_CONF_KEY, 2048);
        this.pool = new WaitForCompletionTaskRunner((ExecutorService)ThreadPoolManager.getExecutor(new ThreadPoolBuilder("IndexVerify", env.getConfiguration()).setMaxThread(NUM_CONCURRENT_INDEX_VERIFY_THREADS_CONF_KEY, 16).setCoreTimeout("phoenix.index.writer.threads.keepalivetime"), env));
        if (this.verify) {
            byte[] scanParamShouldLogBeyondMaxLookbackInvalidRows = scan.getAttribute("_IndexRebuildDisableLoggingBeyondMaxLookbackAge");
            boolean shouldLogBeyondMaxLookbackInvalidRows = scanParamShouldLogBeyondMaxLookbackInvalidRows != null ? Boolean.parseBoolean(Bytes.toString((byte[])scanParamShouldLogBeyondMaxLookbackInvalidRows)) : env.getConfiguration().getBoolean(PHOENIX_INDEX_MR_LOG_BEYOND_MAX_LOOKBACK_ERRORS, false);
            this.viewConstants = IndexUtil.deserializeViewConstantsFromScan((Scan)scan);
            byte[] disableLoggingValueBytes = scan.getAttribute("_IndexRebuildDisableLoggingVerifyType");
            if (disableLoggingValueBytes != null) {
                this.disableLoggingVerifyType = IndexTool.IndexDisableLoggingType.fromValue(disableLoggingValueBytes);
            }
            this.verificationOutputRepository = new IndexVerificationOutputRepository(this.indexMaintainer.getIndexTableName(), this.hTableFactory, this.disableLoggingVerifyType);
            this.verificationOutputRepository.setShouldLogBeyondMaxLookback(shouldLogBeyondMaxLookbackInvalidRows);
            this.verificationResult = new IndexToolVerificationResult(scan);
            this.verificationResultRepository = new IndexVerificationResultRepository(this.indexMaintainer.getIndexTableName(), this.hTableFactory);
            this.nextStartKey = null;
        }
        this.computeMinTimestamp(config);
    }

    private void computeMinTimestamp(Configuration config) throws IOException {
        this.minTimestamp = this.scan.getTimeRange().getMin();
        if (this.indexMaintainer.isCDCIndex()) {
            this.minTimestamp = EnvironmentEdgeManager.currentTimeMillis() - this.maxLookBackInMills;
            try (PhoenixConnection conn = QueryUtil.getConnectionOnServer((Configuration)config).unwrap(PhoenixConnection.class);){
                PTable indexTable = conn.getTableNoCache(this.indexMaintainer.getLogicalIndexName());
                this.minTimestamp = Math.max(indexTable.getTimeStamp() + 1L, this.minTimestamp);
            }
            catch (SQLException e) {
                LOGGER.error("Unable to get the PTable for the index table " + this.indexMaintainer.getLogicalIndexName() + " " + e);
                throw new IOException(e);
            }
        }
    }

    public static long getTimestamp(Mutation m) {
        for (List cells : m.getFamilyCellMap().values()) {
            Iterator iterator = cells.iterator();
            if (!iterator.hasNext()) continue;
            Cell cell = (Cell)iterator.next();
            return cell.getTimestamp();
        }
        throw new IllegalStateException("No cell found");
    }

    protected static boolean isTimestampBeforeTTL(int tableTTL, long currentTime, long tsToCheck) {
        if (tableTTL == Integer.MAX_VALUE) {
            return false;
        }
        return tsToCheck < currentTime - (long)tableTTL * 1000L;
    }

    protected static boolean isTimestampBeyondMaxLookBack(long maxLookBackInMills, long currentTime, long tsToCheck) {
        if (!BaseScannerRegionObserver.isMaxLookbackTimeEnabled(maxLookBackInMills)) {
            return true;
        }
        return tsToCheck < currentTime - maxLookBackInMills;
    }

    protected boolean isColumnIncluded(Cell cell) {
        byte[] family = CellUtil.cloneFamily((Cell)cell);
        if (!this.familyMap.containsKey(family)) {
            return false;
        }
        NavigableSet<byte[]> set = this.familyMap.get(family);
        if (set == null || set.isEmpty()) {
            return true;
        }
        byte[] qualifier = CellUtil.cloneQualifier((Cell)cell);
        return set.contains(qualifier);
    }

    @VisibleForTesting
    public boolean shouldVerify(IndexTool.IndexVerifyType verifyType, byte[] indexRowKey, Scan scan, Region region, IndexMaintainer indexMaintainer, IndexVerificationResultRepository verificationResultRepository, boolean shouldVerifyCheckDone) throws IOException {
        this.verifyType = verifyType;
        this.indexRowKeyforReadRepair = indexRowKey;
        this.scan = scan;
        this.region = region;
        this.indexMaintainer = indexMaintainer;
        this.verificationResultRepository = verificationResultRepository;
        this.shouldVerifyCheckDone = shouldVerifyCheckDone;
        return this.shouldVerify();
    }

    public boolean shouldVerify() throws IOException {
        byte[] lastVerifyTimeValue = this.scan.getAttribute("_IndexRetryVerify");
        Long lastVerifyTime = lastVerifyTimeValue == null ? 0L : Bytes.toLong((byte[])lastVerifyTimeValue);
        if (this.indexRowKeyforReadRepair != null || lastVerifyTime == 0L || this.shouldVerifyCheckDone) {
            return true;
        }
        IndexToolVerificationResult verificationResultTemp = this.verificationResultRepository.getVerificationResult(lastVerifyTime, this.scan, this.region, this.indexMaintainer.getIndexTableName());
        if (verificationResultTemp != null) {
            this.verificationResult = verificationResultTemp;
        }
        this.shouldVerifyCheckDone = true;
        if (this.verificationResult != null && this.verificationResult.getShouldRetry()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("ShouldRetry is true. " + this.region.getRegionInfo().getRegionNameAsString());
            }
            return true;
        }
        return verificationResultTemp == null;
    }

    @Override
    public RegionInfo getRegionInfo() {
        return this.region.getRegionInfo();
    }

    @Override
    public boolean isFilterDone() {
        return false;
    }

    private void closeTables() throws IOException {
        this.hTableFactory.shutdown();
        if (this.indexHTable != null) {
            this.indexHTable.close();
        }
        if (this.dataHTable != null) {
            this.dataHTable.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        this.innerScanner.close();
        if (this.indexRowKeyforReadRepair != null) {
            this.closeTables();
            return;
        }
        if (this.verify) {
            try {
                if (this.verificationResultRepository == null) return;
                this.verificationResultRepository.logToIndexToolResultTable(this.verificationResult, this.verifyType, this.region.getRegionInfo().getRegionName(), this.skipped, this.shouldRetry);
                return;
            }
            finally {
                this.pool.stop("IndexRegionObserverRegionScanner is closing");
                this.closeTables();
                if (this.verificationResultRepository != null) {
                    this.verificationResultRepository.close();
                }
                if (this.verificationOutputRepository != null) {
                    this.verificationOutputRepository.close();
                }
            }
        } else {
            this.pool.stop("GlobalIndexRegionScanner is closing");
            this.closeTables();
        }
    }

    @VisibleForTesting
    public int setIndexMaintainer(IndexMaintainer indexMaintainer) {
        this.indexMaintainer = indexMaintainer;
        return 0;
    }

    @VisibleForTesting
    public long setMaxLookBackInMills(long maxLookBackInMills) {
        this.maxLookBackInMills = maxLookBackInMills;
        return 0L;
    }

    public void logToIndexToolOutputTable(byte[] dataRowKey, byte[] indexRowKey, long dataRowTs, long indexRowTs, String errorMsg, boolean isBeforeRebuild, IndexVerificationOutputRepository.IndexVerificationErrorType errorType) throws IOException {
        this.logToIndexToolOutputTable(dataRowKey, indexRowKey, dataRowTs, indexRowTs, errorMsg, null, null, isBeforeRebuild, errorType);
    }

    protected byte[] getDataTableName() {
        return this.region.getRegionInfo().getTable().getName();
    }

    @VisibleForTesting
    public void logToIndexToolOutputTable(byte[] dataRowKey, byte[] indexRowKey, long dataRowTs, long indexRowTs, String errorMsg, byte[] expectedVaue, byte[] actualValue, boolean isBeforeRebuild, IndexVerificationOutputRepository.IndexVerificationErrorType errorType) throws IOException {
        this.ungroupedAggregateRegionObserver.checkForRegionClosingOrSplitting();
        byte[] dataTableName = this.getDataTableName();
        this.verificationOutputRepository.logToIndexToolOutputTable(dataRowKey, indexRowKey, dataRowTs, indexRowTs, errorMsg, expectedVaue, actualValue, this.scan.getTimeRange().getMax(), dataTableName, isBeforeRebuild, errorType);
    }

    private static Cell getCell(Mutation m, byte[] family, byte[] qualifier) {
        List cellList = (List)m.getFamilyCellMap().get(family);
        if (cellList == null) {
            return null;
        }
        for (Cell cell : cellList) {
            if (!CellUtil.matchingQualifier((Cell)cell, (byte[])qualifier)) continue;
            return cell;
        }
        return null;
    }

    private void logMismatch(Mutation expected, Mutation actual, int iteration, IndexToolVerificationResult.PhaseResult verificationPhaseResult, boolean isBeforeRebuild) throws IOException {
        if (GlobalIndexRegionScanner.getTimestamp(expected) != GlobalIndexRegionScanner.getTimestamp(actual)) {
            String errorMsg = "Not matching timestamp";
            byte[] dataKey = this.indexMaintainer.buildDataRowKey(new ImmutableBytesWritable(expected.getRow()), this.viewConstants);
            this.logToIndexToolOutputTable(dataKey, expected.getRow(), GlobalIndexRegionScanner.getTimestamp(expected), GlobalIndexRegionScanner.getTimestamp(actual), errorMsg, null, null, isBeforeRebuild, IndexVerificationOutputRepository.IndexVerificationErrorType.INVALID_ROW);
            return;
        }
        int expectedCellCount = 0;
        for (Object cells : expected.getFamilyCellMap().values()) {
            if (cells == null) continue;
            Iterator iterator = cells.iterator();
            while (iterator.hasNext()) {
                byte[] qualifier;
                Cell expectedCell = (Cell)iterator.next();
                ++expectedCellCount;
                byte[] family = CellUtil.cloneFamily((Cell)expectedCell);
                Cell actualCell = GlobalIndexRegionScanner.getCell(actual, family, qualifier = CellUtil.cloneQualifier((Cell)expectedCell));
                if (actualCell == null || expectedCell.getType() != actualCell.getType()) {
                    byte[] dataKey = this.indexMaintainer.buildDataRowKey(new ImmutableBytesWritable(expected.getRow()), this.viewConstants);
                    String errorMsg = "Missing cell (in iteration " + iteration + ") " + Bytes.toString((byte[])family) + ":" + Bytes.toString((byte[])qualifier);
                    this.logToIndexToolOutputTable(dataKey, expected.getRow(), GlobalIndexRegionScanner.getTimestamp(expected), GlobalIndexRegionScanner.getTimestamp(actual), errorMsg, isBeforeRebuild, IndexVerificationOutputRepository.IndexVerificationErrorType.INVALID_ROW);
                    verificationPhaseResult.setIndexHasMissingCellsCount(verificationPhaseResult.getIndexHasMissingCellsCount() + 1L);
                    return;
                }
                if (CellUtil.matchingValue((Cell)actualCell, (Cell)expectedCell)) continue;
                String errorMsg = "Not matching value (in iteration " + iteration + ") for " + Bytes.toString((byte[])family) + ":" + Bytes.toString((byte[])qualifier);
                byte[] dataKey = this.indexMaintainer.buildDataRowKey(new ImmutableBytesWritable(expected.getRow()), this.viewConstants);
                this.logToIndexToolOutputTable(dataKey, expected.getRow(), GlobalIndexRegionScanner.getTimestamp(expected), GlobalIndexRegionScanner.getTimestamp(actual), errorMsg, CellUtil.cloneValue((Cell)expectedCell), CellUtil.cloneValue((Cell)actualCell), isBeforeRebuild, IndexVerificationOutputRepository.IndexVerificationErrorType.INVALID_ROW);
                return;
            }
        }
        int actualCellCount = 0;
        for (List cells : actual.getFamilyCellMap().values()) {
            if (cells == null) continue;
            actualCellCount += cells.size();
        }
        if (expectedCellCount != actualCellCount) {
            String errorMsg = "Index has extra cells (in iteration " + iteration + ")";
            byte[] dataKey = this.indexMaintainer.buildDataRowKey(new ImmutableBytesWritable(expected.getRow()), this.viewConstants);
            this.logToIndexToolOutputTable(dataKey, expected.getRow(), GlobalIndexRegionScanner.getTimestamp(expected), GlobalIndexRegionScanner.getTimestamp(actual), errorMsg, isBeforeRebuild, IndexVerificationOutputRepository.IndexVerificationErrorType.EXTRA_CELLS);
            verificationPhaseResult.setIndexHasExtraCellsCount(verificationPhaseResult.getIndexHasExtraCellsCount() + 1L);
        }
    }

    private boolean isMatchingMutation(Mutation expected, Mutation actual) {
        if (GlobalIndexRegionScanner.getTimestamp(expected) != GlobalIndexRegionScanner.getTimestamp(actual)) {
            return false;
        }
        int expectedCellCount = 0;
        for (List cells : expected.getFamilyCellMap().values()) {
            if (cells == null) continue;
            for (Cell expectedCell : cells) {
                byte[] qualifier;
                ++expectedCellCount;
                byte[] family = CellUtil.cloneFamily((Cell)expectedCell);
                Cell actualCell = GlobalIndexRegionScanner.getCell(actual, family, qualifier = CellUtil.cloneQualifier((Cell)expectedCell));
                if (actualCell == null || expectedCell.getType() != actualCell.getType()) {
                    return false;
                }
                if (CellUtil.matchingValue((Cell)actualCell, (Cell)expectedCell)) continue;
                return false;
            }
        }
        int actualCellCount = 0;
        for (List cells : actual.getFamilyCellMap().values()) {
            if (cells == null) continue;
            actualCellCount += cells.size();
        }
        return expectedCellCount == actualCellCount;
    }

    private boolean isVerified(Put mutation) throws IOException {
        Cell cell;
        List cellList = mutation.get(this.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), this.indexMaintainer.getEmptyKeyValueQualifier());
        Cell cell2 = cell = cellList != null && !cellList.isEmpty() ? (Cell)cellList.get(0) : null;
        if (cell == null) {
            return false;
        }
        return Bytes.compareTo((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength(), (byte[])QueryConstants.VERIFIED_BYTES, (int)0, (int)QueryConstants.VERIFIED_BYTES.length) == 0;
    }

    private void updateUnverifiedIndexRowCounters(Put actual, long expectedTs, List<Mutation> indexRowsToBeDeleted, IndexToolVerificationResult.PhaseResult verificationPhaseResult) {
        long actualTs;
        Cell cell;
        List cellList = actual.get(this.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), this.indexMaintainer.getEmptyKeyValueQualifier());
        Cell cell2 = cell = cellList != null && !cellList.isEmpty() ? (Cell)cellList.get(0) : null;
        if (cell == null) {
            verificationPhaseResult.setUnknownIndexRowCount(verificationPhaseResult.getUnknownIndexRowCount() + 1L);
            return;
        }
        if (Bytes.compareTo((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength(), (byte[])QueryConstants.VERIFIED_BYTES, (int)0, (int)QueryConstants.VERIFIED_BYTES.length) == 0) {
            return;
        }
        if (Bytes.compareTo((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength(), (byte[])QueryConstants.UNVERIFIED_BYTES, (int)0, (int)QueryConstants.UNVERIFIED_BYTES.length) == 0) {
            verificationPhaseResult.setUnverifiedIndexRowCount(verificationPhaseResult.getUnverifiedIndexRowCount() + 1L);
            return;
        }
        verificationPhaseResult.setOldIndexRowCount(verificationPhaseResult.getOldIndexRowCount() + 1L);
        if ((this.verifyType == IndexTool.IndexVerifyType.BEFORE || this.verifyType == IndexTool.IndexVerifyType.BOTH) && (actualTs = GlobalIndexRegionScanner.getTimestamp((Mutation)actual)) > expectedTs) {
            indexRowsToBeDeleted.add((Mutation)this.indexMaintainer.buildRowDeleteMutation(actual.getRow(), IndexMaintainer.DeleteType.SINGLE_VERSION, actualTs));
        }
    }

    private void logExtraIndexRowAndUpdateCounters(List<Mutation> actualIndexMutationList, IndexToolVerificationResult.PhaseResult verificationPhaseResult, boolean isBeforeRebuild) throws IOException {
        block3: {
            Iterator<Mutation> iterator = actualIndexMutationList.iterator();
            if (!iterator.hasNext()) break block3;
            Mutation m = iterator.next();
            if (m instanceof Delete) {
                return;
            }
            if (this.isVerified((Put)m)) {
                verificationPhaseResult.setExtraVerifiedIndexRowCount(verificationPhaseResult.getExtraVerifiedIndexRowCount() + 1L);
            } else {
                verificationPhaseResult.setExtraUnverifiedIndexRowCount(verificationPhaseResult.getExtraUnverifiedIndexRowCount() + 1L);
            }
            byte[] indexKey = m.getRow();
            byte[] dataKey = this.indexMaintainer.buildDataRowKey(new ImmutableBytesWritable(indexKey), this.viewConstants);
            String errorMsg = ERROR_MESSAGE_EXTRA_INDEX_ROW;
            IndexVerificationOutputRepository.IndexVerificationErrorType errorType = IndexVerificationOutputRepository.IndexVerificationErrorType.EXTRA_ROW;
            this.logToIndexToolOutputTable(dataKey, indexKey, 0L, GlobalIndexRegionScanner.getTimestamp(m), errorMsg, isBeforeRebuild, errorType);
        }
    }

    private void repairActualMutationList(List<Mutation> actualMutationList, List<Mutation> expectedMutationList) throws IOException {
        ArrayList<Mutation> repairedMutationList = new ArrayList<Mutation>(expectedMutationList.size());
        for (Mutation actual : actualMutationList) {
            int expectedIndex;
            if (!(actual instanceof Put) || this.isVerified((Put)actual)) continue;
            long ts = GlobalIndexRegionScanner.getTimestamp(actual);
            int expectedListSize = expectedMutationList.size();
            for (expectedIndex = 0; expectedIndex < expectedListSize; ++expectedIndex) {
                if (GlobalIndexRegionScanner.getTimestamp(expectedMutationList.get(expectedIndex)) > ts) continue;
                if (expectedIndex <= 0) break;
                --expectedIndex;
                break;
            }
            if (expectedIndex == expectedListSize) continue;
            while (expectedIndex < expectedListSize) {
                Object mutation = expectedMutationList.get(expectedIndex);
                mutation = mutation instanceof Put ? new Put((Put)mutation) : new Delete((Delete)mutation);
                repairedMutationList.add((Mutation)mutation);
                ++expectedIndex;
            }
            break block0;
        }
        if (repairedMutationList.isEmpty()) {
            return;
        }
        actualMutationList.addAll(repairedMutationList);
        Collections.sort(actualMutationList, MUTATION_TS_DESC_COMPARATOR);
    }

    private void cleanUpActualMutationList(List<Mutation> actualMutationList) throws IOException {
        Iterator<Mutation> iterator = actualMutationList.iterator();
        Mutation previous = null;
        while (iterator.hasNext()) {
            Mutation mutation = iterator.next();
            if (mutation instanceof Put && !this.isVerified((Put)mutation) || mutation instanceof Delete && !IndexUtil.isDeleteFamilyOrDeleteColumn((Mutation)mutation)) {
                iterator.remove();
                continue;
            }
            if ((previous instanceof Put && mutation instanceof Put || previous instanceof Delete && mutation instanceof Delete) && this.isMatchingMutation(previous, mutation)) {
                iterator.remove();
                continue;
            }
            previous = mutation;
        }
    }

    @VisibleForTesting
    public boolean verifySingleIndexRow(byte[] indexRowKey, List<Mutation> actualMutationList, List<Mutation> expectedMutationList, Set<byte[]> mostRecentIndexRowKeys, List<Mutation> indexRowsToBeDeleted, IndexToolVerificationResult.PhaseResult verificationPhaseResult, boolean isBeforeRebuild) throws IOException {
        Mutation m;
        if (expectedMutationList == null) {
            throw new DoNotRetryIOException(NO_EXPECTED_MUTATION);
        }
        if (actualMutationList == null || actualMutationList.isEmpty()) {
            throw new DoNotRetryIOException(ACTUAL_MUTATION_IS_NULL_OR_EMPTY);
        }
        if (isBeforeRebuild && (m = actualMutationList.get(0)) instanceof Put && (mostRecentIndexRowKeys.isEmpty() || mostRecentIndexRowKeys.contains(m.getRow()))) {
            this.updateUnverifiedIndexRowCounters((Put)m, GlobalIndexRegionScanner.getTimestamp(expectedMutationList.get(0)), indexRowsToBeDeleted, verificationPhaseResult);
        }
        if (this.verifyType == IndexTool.IndexVerifyType.ONLY) {
            this.repairActualMutationList(actualMutationList, expectedMutationList);
        }
        this.cleanUpActualMutationList(actualMutationList);
        long currentTime = EnvironmentEdgeManager.currentTimeMillis();
        int actualIndex = 0;
        int expectedIndex = 0;
        int expectedSize = expectedMutationList.size();
        int actualSize = actualMutationList.size();
        Mutation expected = null;
        Mutation actual = null;
        while (expectedIndex < expectedSize && actualIndex < actualSize) {
            Mutation previousExpected = expected;
            expected = expectedMutationList.get(expectedIndex);
            actual = actualMutationList.get(actualIndex);
            if (expected instanceof Put) {
                if (previousExpected instanceof Delete) {
                    while (GlobalIndexRegionScanner.getTimestamp(actual) >= GlobalIndexRegionScanner.getTimestamp(expected) && IndexUtil.isDeleteFamily((Mutation)actual) && ++actualIndex != actualSize) {
                        actual = actualMutationList.get(actualIndex);
                    }
                    if (actualIndex == actualSize) break;
                }
                if (actual instanceof Delete || !this.isMatchingMutation(expected, actual)) break;
                ++expectedIndex;
                ++actualIndex;
                continue;
            }
            while (GlobalIndexRegionScanner.getTimestamp(actual) > GlobalIndexRegionScanner.getTimestamp(expected) && IndexUtil.isDeleteFamily((Mutation)actual) && ++actualIndex != actualSize) {
                actual = actualMutationList.get(actualIndex);
            }
            if (actualIndex == actualSize || !this.isMatchingMutation(expected, actual)) break;
            ++expectedIndex;
            ++actualIndex;
        }
        if (expectedIndex == expectedSize) {
            verificationPhaseResult.setValidIndexRowCount(verificationPhaseResult.getValidIndexRowCount() + 1L);
            return true;
        }
        if (GlobalIndexRegionScanner.isTimestampBeyondMaxLookBack(this.maxLookBackInMills, currentTime, GlobalIndexRegionScanner.getTimestamp(expectedMutationList.get(expectedIndex)))) {
            if (expectedIndex > 0) {
                verificationPhaseResult.setValidIndexRowCount(verificationPhaseResult.getValidIndexRowCount() + 1L);
                return true;
            }
            verificationPhaseResult.setBeyondMaxLookBackInvalidIndexRowCount(verificationPhaseResult.getBeyondMaxLookBackInvalidIndexRowCount() + 1L);
            byte[] dataKey = this.indexMaintainer.buildDataRowKey(new ImmutableBytesWritable(indexRowKey), this.viewConstants);
            String errorMsg = String.format("Expect %1$s mutations but got %2$s (beyond maxLookBack)", expectedSize, actualSize);
            this.logToIndexToolOutputTable(dataKey, indexRowKey, GlobalIndexRegionScanner.getTimestamp(expectedMutationList.get(expectedIndex)), 0L, errorMsg, isBeforeRebuild, IndexVerificationOutputRepository.IndexVerificationErrorType.BEYOND_MAX_LOOKBACK_INVALID);
            return false;
        }
        if (actualIndex < actualSize && actual instanceof Put && expected instanceof Put) {
            this.logMismatch(expected, actual, expectedIndex, verificationPhaseResult, isBeforeRebuild);
        } else {
            if (expected == null) {
                expected = expectedMutationList.get(0);
            }
            byte[] dataKey = this.indexMaintainer.buildDataRowKey(new ImmutableBytesWritable(indexRowKey), this.viewConstants);
            String errorMsg = String.format("Not matching index row. expectedIndex=%d. expectedMutationSize=%d. actualIndex=%d. actualMutationSize=%d. expectedType=%s. actualType=%s", expectedIndex, expectedSize, actualIndex, actualSize, expected.getClass().getName(), actualIndex < actualSize ? actual.getClass().getName() : "null");
            this.logToIndexToolOutputTable(dataKey, indexRowKey, GlobalIndexRegionScanner.getTimestamp(expected), actualIndex < actualSize ? GlobalIndexRegionScanner.getTimestamp(actual) : 0L, errorMsg, isBeforeRebuild, IndexVerificationOutputRepository.IndexVerificationErrorType.INVALID_ROW);
        }
        verificationPhaseResult.setInvalidIndexRowCount(verificationPhaseResult.getInvalidIndexRowCount() + 1L);
        return false;
    }

    protected void verifyIndexRows(Map<byte[], List<Mutation>> actualIndexMutationMap, Map<byte[], List<Mutation>> expectedIndexMutationMap, Set<byte[]> mostRecentIndexRowKeys, List<Mutation> indexRowsToBeDeleted, IndexToolVerificationResult.PhaseResult verificationPhaseResult, boolean isBeforeRebuild) throws IOException {
        TreeMap invalidIndexRows = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        try {
            for (Map.Entry<byte[], List<Mutation>> entry : actualIndexMutationMap.entrySet()) {
                byte[] indexRowKey = entry.getKey();
                List<Mutation> expectedMutationList = expectedIndexMutationMap.get(indexRowKey);
                if (expectedMutationList != null) {
                    if (!this.verifySingleIndexRow(entry.getKey(), entry.getValue(), expectedMutationList, mostRecentIndexRowKeys, indexRowsToBeDeleted, verificationPhaseResult, isBeforeRebuild)) {
                        invalidIndexRows.put(indexRowKey, expectedMutationList);
                    }
                    expectedIndexMutationMap.remove(indexRowKey);
                    continue;
                }
                this.logExtraIndexRowAndUpdateCounters(entry.getValue(), verificationPhaseResult, isBeforeRebuild);
                indexRowsToBeDeleted.add((Mutation)this.indexMaintainer.buildRowDeleteMutation(indexRowKey, IndexMaintainer.DeleteType.ALL_VERSIONS, GlobalIndexRegionScanner.getTimestamp(entry.getValue().get(0))));
            }
        }
        catch (Throwable t) {
            if (this.indexHTable != null) {
                ClientUtil.throwIOException((String)this.indexHTable.getName().toString(), (Throwable)t);
            }
            ClientUtil.throwIOException((String)this.region.getRegionInfo().getRegionNameAsString(), (Throwable)t);
        }
        for (Map.Entry<byte[], List<Mutation>> entry : expectedIndexMutationMap.entrySet()) {
            IndexVerificationOutputRepository.IndexVerificationErrorType errorType;
            String errorMsg;
            byte[] indexKey = entry.getKey();
            List<Mutation> mutationList = entry.getValue();
            Mutation mutation = mutationList.get(mutationList.size() - 1);
            if (mutation instanceof Delete) continue;
            long currentTime = EnvironmentEdgeManager.currentTimeMillis();
            if (GlobalIndexRegionScanner.isTimestampBeyondMaxLookBack(this.maxLookBackInMills, currentTime, GlobalIndexRegionScanner.getTimestamp(mutation))) {
                errorMsg = ERROR_MESSAGE_MISSING_INDEX_ROW_BEYOND_MAX_LOOKBACK;
                errorType = IndexVerificationOutputRepository.IndexVerificationErrorType.BEYOND_MAX_LOOKBACK_MISSING;
                verificationPhaseResult.setBeyondMaxLookBackMissingIndexRowCount(verificationPhaseResult.getBeyondMaxLookBackMissingIndexRowCount() + 1L);
            } else {
                errorMsg = ERROR_MESSAGE_MISSING_INDEX_ROW;
                errorType = IndexVerificationOutputRepository.IndexVerificationErrorType.MISSING_ROW;
                verificationPhaseResult.setMissingIndexRowCount(verificationPhaseResult.getMissingIndexRowCount() + 1L);
            }
            byte[] dataKey = this.indexMaintainer.buildDataRowKey(new ImmutableBytesWritable(indexKey), this.viewConstants);
            this.logToIndexToolOutputTable(dataKey, indexKey, GlobalIndexRegionScanner.getTimestamp(mutation), 0L, errorMsg, isBeforeRebuild, errorType);
        }
        expectedIndexMutationMap.putAll(invalidIndexRows);
    }

    protected void commitBatch(List<Mutation> indexUpdates) throws IOException, InterruptedException {
        throw new DoNotRetryIOException("This method has not been implement by the sub class");
    }

    protected void updateIndexRows(Map<byte[], List<Mutation>> indexMutationMap, List<Mutation> indexRowsToBeDeleted, IndexToolVerificationResult verificationResult) throws IOException {
        try {
            int batchSize = 0;
            ArrayList<Object> indexUpdates = new ArrayList<Mutation>(this.maxBatchSize);
            for (List<Mutation> mutationList : indexMutationMap.values()) {
                indexUpdates.addAll(mutationList);
                if ((batchSize += mutationList.size()) < this.maxBatchSize) continue;
                this.commitBatch(indexUpdates);
                batchSize = 0;
                indexUpdates = new ArrayList(this.maxBatchSize);
            }
            if (batchSize > 0) {
                this.commitBatch(indexUpdates);
            }
            batchSize = 0;
            indexUpdates = new ArrayList(this.maxBatchSize);
            for (Mutation mutation : indexRowsToBeDeleted) {
                indexUpdates.add(mutation);
                if (++batchSize < this.maxBatchSize) continue;
                this.commitBatch(indexUpdates);
                batchSize = 0;
                indexUpdates = new ArrayList(this.maxBatchSize);
            }
            if (batchSize > 0) {
                this.commitBatch(indexUpdates);
            }
            if (this.verify) {
                verificationResult.setRebuiltIndexRowCount(verificationResult.getRebuiltIndexRowCount() + (long)indexMutationMap.size());
            }
        }
        catch (Throwable t) {
            if (this.indexHTable != null) {
                ClientUtil.throwIOException((String)this.indexHTable.getName().toString(), (Throwable)t);
            }
            ClientUtil.throwIOException((String)this.region.getRegionInfo().getRegionNameAsString(), (Throwable)t);
        }
    }

    @VisibleForTesting
    public List<Mutation> prepareActualIndexMutations(Result indexRow) throws IOException {
        Put put = null;
        Delete del = null;
        for (Cell cell : indexRow.rawCells()) {
            if (cell.getType() == Cell.Type.Put) {
                if (put == null) {
                    put = new Put(CellUtil.cloneRow((Cell)cell));
                }
                put.add(cell);
                continue;
            }
            if (del == null) {
                del = new Delete(CellUtil.cloneRow((Cell)cell));
            }
            del.add(cell);
        }
        return GlobalIndexRegionScanner.getMutationsWithSameTS(put, del, MUTATION_TS_DESC_COMPARATOR);
    }

    protected Scan prepareIndexScan(Map<byte[], List<Mutation>> indexMutationMap) throws IOException {
        ArrayList<KeyRange> keys = new ArrayList<KeyRange>(indexMutationMap.size());
        for (byte[] indexKey : indexMutationMap.keySet()) {
            keys.add(PVarbinary.INSTANCE.getKeyRange(indexKey, SortOrder.ASC));
        }
        ScanRanges scanRanges = ScanRanges.createPointLookup(keys);
        Scan indexScan = new Scan();
        indexScan.setTimeRange(this.scan.getTimeRange().getMin(), this.scan.getTimeRange().getMax());
        scanRanges.initializeScan(indexScan);
        SkipScanFilter skipScanFilter = scanRanges.getSkipScanFilter();
        indexScan.setFilter((Filter)new SkipScanFilter(skipScanFilter, true, true));
        indexScan.setRaw(true);
        indexScan.readAllVersions();
        indexScan.setCacheBlocks(false);
        return indexScan;
    }

    protected void submitTasks(TaskBatch<Boolean> tasks) throws IOException {
        Pair resultsAndFutures = null;
        try {
            LOGGER.debug("Waiting on index verify and/or rebuild tasks to complete...");
            resultsAndFutures = this.pool.submitUninterruptible(tasks);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Should not fail on the results while using a WaitForCompletionTaskRunner", e);
        }
        catch (EarlyExitFailure e) {
            throw new RuntimeException("Stopped while waiting for batch, quitting!", e);
        }
        int index = 0;
        for (Boolean result : (List)resultsAndFutures.getFirst()) {
            if (result == null) {
                Throwable cause = ServerUtil.getExceptionFromFailedFuture((Future)((List)resultsAndFutures.getSecond()).get(index));
                throw new IOException(this.exceptionMessage, cause);
            }
            ++index;
        }
    }

    public static List<Mutation> getMutationsWithSameTS(Put put, Delete del) {
        return GlobalIndexRegionScanner.getMutationsWithSameTS(put, del, MUTATION_TS_COMPARATOR);
    }

    public static List<Mutation> getMutationsWithSameTS(Put put, Delete del, Comparator<Mutation> comparator) {
        List mutationList = Lists.newArrayListWithExpectedSize((int)2);
        if (put != null) {
            mutationList.add(put);
        }
        if (del != null) {
            mutationList.add(del);
        }
        mutationList = (List)IndexManagementUtil.flattenMutationsByTimestamp((Collection)mutationList);
        Collections.sort(mutationList, comparator);
        return mutationList;
    }

    private static Put prepareIndexPutForRebuild(IndexMaintainer indexMaintainer, ImmutableBytesPtr rowKeyPtr, ValueGetter mergedRowVG, long ts, byte[] encodedRegionName) throws IOException {
        Put indexPut = indexMaintainer.buildUpdateMutation(GenericKeyValueBuilder.INSTANCE, mergedRowVG, (ImmutableBytesWritable)rowKeyPtr, ts, null, null, false, encodedRegionName);
        if (indexPut == null) {
            byte[] indexRowKey = indexMaintainer.buildRowKey(mergedRowVG, (ImmutableBytesWritable)rowKeyPtr, null, null, ts, encodedRegionName);
            indexPut = new Put(indexRowKey);
        } else {
            IndexUtil.removeEmptyColumn((Mutation)indexPut, (byte[])indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), (byte[])indexMaintainer.getEmptyKeyValueQualifier());
        }
        indexPut.addColumn(indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), indexMaintainer.getEmptyKeyValueQualifier(), ts, QueryConstants.VERIFIED_BYTES);
        return indexPut;
    }

    public static void removeColumn(Put put, Cell deleteCell) {
        byte[] family = CellUtil.cloneFamily((Cell)deleteCell);
        List cellList = (List)put.getFamilyCellMap().get(family);
        if (cellList == null) {
            return;
        }
        Iterator cellIterator = cellList.iterator();
        while (cellIterator.hasNext()) {
            Cell cell = (Cell)cellIterator.next();
            if (!CellUtil.matchingQualifier((Cell)cell, (Cell)deleteCell)) continue;
            cellIterator.remove();
            if (cellList.isEmpty()) {
                put.getFamilyCellMap().remove(family);
            }
            return;
        }
    }

    public static void apply(Put destination, Put source) throws IOException {
        for (List cells : source.getFamilyCellMap().values()) {
            for (Cell cell : cells) {
                if (destination.has(CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell))) continue;
                destination.add(cell);
            }
        }
    }

    public static Put applyNew(Put destination, Put source) throws IOException {
        Put next = new Put(destination);
        GlobalIndexRegionScanner.apply(next, source);
        return next;
    }

    private static void applyDeleteOnPut(Delete del, Put put) throws IOException {
        for (List cells : del.getFamilyCellMap().values()) {
            block5: for (Cell cell : cells) {
                switch (cell.getType()) {
                    case DeleteFamily: {
                        put.getFamilyCellMap().remove(CellUtil.cloneFamily((Cell)cell));
                        continue block5;
                    }
                    case DeleteColumn: {
                        GlobalIndexRegionScanner.removeColumn(put, cell);
                        continue block5;
                    }
                }
                throw new DoNotRetryIOException("Single version delete marker in data mutation " + del);
            }
        }
    }

    public static List<Mutation> prepareIndexMutationsForRebuild(IndexMaintainer indexMaintainer, Put dataPut, Delete dataDel, byte[] encodedRegionName, CompiledTTLExpression ttlExpr, boolean isTTLStrict) throws IOException {
        boolean isCondTTL = ttlExpr instanceof CompiledConditionalTTLExpression;
        List<Mutation> dataMutations = GlobalIndexRegionScanner.getMutationsWithSameTS(dataPut, dataDel);
        ArrayList indexMutations = Lists.newArrayListWithExpectedSize((int)dataMutations.size());
        ImmutableBytesPtr rowKeyPtr = dataPut != null ? new ImmutableBytesPtr(dataPut.getRow()) : new ImmutableBytesPtr(dataDel.getRow());
        Put currentDataRowState = null;
        byte[] indexRowKeyForCurrentDataRow = null;
        int dataMutationListSize = dataMutations.size();
        for (int i = 0; i < dataMutationListSize; ++i) {
            Delete del;
            Delete deleteColumn;
            Put indexPut;
            IndexUtil.SimpleValueGetter nextDataRowVG;
            Delete del2;
            List<Cell> currentRow;
            CompiledConditionalTTLExpression condExpr;
            if (isCondTTL && currentDataRowState != null && isTTLStrict && (condExpr = (CompiledConditionalTTLExpression)ttlExpr).isExpired(currentRow = GlobalIndexRegionScanner.flattenCells(currentDataRowState), false)) {
                currentDataRowState = null;
                indexRowKeyForCurrentDataRow = null;
            }
            Mutation mutation = dataMutations.get(i);
            long ts = GlobalIndexRegionScanner.getTimestamp(mutation);
            Delete deleteToApply = null;
            if (mutation instanceof Put) {
                Mutation nextMutation;
                if (i < dataMutationListSize - 1 && GlobalIndexRegionScanner.getTimestamp(nextMutation = dataMutations.get(i + 1)) == ts && nextMutation instanceof Delete) {
                    GlobalIndexRegionScanner.applyDeleteOnPut((Delete)nextMutation, (Put)mutation);
                    if (mutation.getFamilyCellMap().size() != 0) {
                        if (currentDataRowState != null) {
                            GlobalIndexRegionScanner.applyDeleteOnPut((Delete)nextMutation, currentDataRowState);
                            if (currentDataRowState.getFamilyCellMap().size() == 0) {
                                currentDataRowState = null;
                                indexRowKeyForCurrentDataRow = null;
                            }
                        }
                    } else {
                        deleteToApply = (Delete)nextMutation;
                    }
                    ++i;
                }
                if (mutation.getFamilyCellMap().size() != 0) {
                    Put nextDataRow;
                    Put put = nextDataRow = currentDataRowState == null ? new Put((Put)mutation) : GlobalIndexRegionScanner.applyNew((Put)mutation, currentDataRowState);
                    if (!indexMaintainer.shouldPrepareIndexMutations(nextDataRow)) {
                        currentDataRowState = nextDataRow;
                        if (indexRowKeyForCurrentDataRow != null) {
                            del2 = indexMaintainer.buildRowDeleteMutation(indexRowKeyForCurrentDataRow, IndexMaintainer.DeleteType.ALL_VERSIONS, ts);
                            indexMutations.add(del2);
                        }
                        indexRowKeyForCurrentDataRow = null;
                        continue;
                    }
                    nextDataRowVG = new IndexUtil.SimpleValueGetter(nextDataRow);
                    indexPut = GlobalIndexRegionScanner.prepareIndexPutForRebuild(indexMaintainer, rowKeyPtr, (ValueGetter)nextDataRowVG, ts, encodedRegionName);
                    indexMutations.add(indexPut);
                    deleteColumn = indexMaintainer.buildDeleteColumnMutation(indexPut, ts);
                    if (deleteColumn != null) {
                        indexMutations.add(deleteColumn);
                    }
                    if (indexRowKeyForCurrentDataRow != null && Bytes.compareTo((byte[])indexPut.getRow(), indexRowKeyForCurrentDataRow) != 0) {
                        del = indexMaintainer.buildRowDeleteMutation(indexRowKeyForCurrentDataRow, IndexMaintainer.DeleteType.ALL_VERSIONS, ts);
                        indexMutations.add(del);
                    }
                    currentDataRowState = nextDataRow;
                    indexRowKeyForCurrentDataRow = indexPut.getRow();
                    continue;
                }
            } else if (mutation instanceof Delete) {
                deleteToApply = (Delete)mutation;
            }
            if (deleteToApply == null || currentDataRowState == null) continue;
            GlobalIndexRegionScanner.applyDeleteOnPut(deleteToApply, currentDataRowState);
            Put nextDataRowState = currentDataRowState;
            if (nextDataRowState.getFamilyCellMap().size() == 0) {
                if (indexRowKeyForCurrentDataRow != null) {
                    del2 = indexMaintainer.buildRowDeleteMutation(indexRowKeyForCurrentDataRow, IndexMaintainer.DeleteType.ALL_VERSIONS, ts);
                    indexMutations.add(del2);
                    if (indexMaintainer.isCDCIndex()) {
                        indexMutations.add(IndexRegionObserver.getDeleteIndexMutation(currentDataRowState, indexMaintainer, ts, rowKeyPtr, encodedRegionName));
                    }
                }
                currentDataRowState = null;
                indexRowKeyForCurrentDataRow = null;
                continue;
            }
            if (indexRowKeyForCurrentDataRow != null) {
                if (!indexMaintainer.shouldPrepareIndexMutations(nextDataRowState)) {
                    currentDataRowState = nextDataRowState;
                    del2 = indexMaintainer.buildRowDeleteMutation(indexRowKeyForCurrentDataRow, IndexMaintainer.DeleteType.ALL_VERSIONS, ts);
                    indexMutations.add(del2);
                    indexRowKeyForCurrentDataRow = null;
                    continue;
                }
                nextDataRowVG = new IndexUtil.SimpleValueGetter(nextDataRowState);
                indexPut = GlobalIndexRegionScanner.prepareIndexPutForRebuild(indexMaintainer, rowKeyPtr, (ValueGetter)nextDataRowVG, ts, encodedRegionName);
                indexMutations.add(indexPut);
                deleteColumn = indexMaintainer.buildDeleteColumnMutation(indexPut, ts);
                if (deleteColumn != null) {
                    indexMutations.add(deleteColumn);
                }
                if (indexRowKeyForCurrentDataRow != null && Bytes.compareTo((byte[])indexPut.getRow(), (byte[])indexRowKeyForCurrentDataRow) != 0) {
                    del = indexMaintainer.buildRowDeleteMutation(indexRowKeyForCurrentDataRow, IndexMaintainer.DeleteType.ALL_VERSIONS, ts);
                    indexMutations.add(del);
                }
                indexRowKeyForCurrentDataRow = indexPut.getRow();
                continue;
            }
            currentDataRowState = nextDataRowState;
            indexRowKeyForCurrentDataRow = null;
        }
        return indexMutations;
    }

    private static List<Cell> flattenCells(Mutation m) {
        ArrayList flattenedCells = Lists.newArrayList();
        for (List cells : m.getFamilyCellMap().values()) {
            flattenedCells.addAll(cells);
        }
        return flattenedCells;
    }

    @VisibleForTesting
    public int prepareIndexMutations(Put put, Delete del, Map<byte[], List<Mutation>> indexMutationMap, Set<byte[]> mostRecentIndexRowKeys) throws IOException {
        List<Mutation> indexMutations = GlobalIndexRegionScanner.prepareIndexMutationsForRebuild(this.indexMaintainer, put, del, this.region.getRegionInfo().getEncodedNameAsBytes(), this.ttlExpression, this.isTTLStrict);
        Collections.reverse(indexMutations);
        boolean mostRecentDone = false;
        if (this.verifyType == IndexTool.IndexVerifyType.NONE || this.verifyType == IndexTool.IndexVerifyType.AFTER) {
            mostRecentDone = true;
        }
        for (Mutation mutation : indexMutations) {
            byte[] indexRowKey = mutation.getRow();
            List<Mutation> mutationList = indexMutationMap.get(indexRowKey);
            if (mutationList == null) {
                if (!mostRecentDone && (mutation instanceof Put || IndexUtil.isDeleteColumn((Mutation)mutation))) {
                    mostRecentIndexRowKeys.add(indexRowKey);
                    mostRecentDone = true;
                }
                mutationList = new ArrayList<Mutation>();
                mutationList.add(mutation);
                indexMutationMap.put(indexRowKey, mutationList);
                continue;
            }
            mutationList.add(mutation);
        }
        return indexMutations.size();
    }

    protected RegionScanner getLocalScanner() throws IOException {
        if (this.minTimestamp != 0L) {
            Scan incrScan = new Scan(this.scan);
            incrScan.setTimeRange(this.minTimestamp, this.scan.getTimeRange().getMax());
            incrScan.setRaw(true);
            incrScan.readAllVersions();
            incrScan.getFamilyMap().clear();
            incrScan.setCacheBlocks(false);
            for (byte[] family : this.scan.getFamilyMap().keySet()) {
                incrScan.addFamily(family);
            }
            ScanUtil.adjustScanFilterForGlobalIndexRegionScanner((Scan)incrScan);
            if (this.nextStartKey != null) {
                incrScan.withStartRow(this.nextStartKey);
            }
            ArrayList<KeyRange> keys = new ArrayList<KeyRange>();
            try (TTLRegionScanner scanner = new TTLRegionScanner(this.env, incrScan, new PagingRegionScanner(this.region, this.region.getScanner(incrScan), incrScan));){
                ArrayList row = new ArrayList();
                int rowCount = 0;
                do {
                    this.ungroupedAggregateRegionObserver.checkForRegionClosingOrSplitting();
                    this.hasMoreIncr = scanner.nextRaw(row);
                    if (!row.isEmpty()) {
                        if (ScanUtil.isDummy(row)) {
                            row.clear();
                            continue;
                        }
                        keys.add(PVarbinary.INSTANCE.getKeyRange(CellUtil.cloneRow((Cell)((Cell)row.get(0))), SortOrder.ASC));
                        ++rowCount;
                    }
                    row.clear();
                } while (this.hasMoreIncr && (long)rowCount < this.pageSizeInRows);
            }
            if (!this.hasMoreIncr && keys.isEmpty()) {
                return null;
            }
            if (keys.isEmpty()) {
                return this.innerScanner;
            }
            ScanRanges scanRanges = ScanRanges.createPointLookup(keys);
            scanRanges.initializeScan(incrScan);
            SkipScanFilter skipScanFilter = scanRanges.getSkipScanFilter();
            incrScan.setFilter((Filter)new SkipScanFilter(skipScanFilter, true, true));
            incrScan.setTimeRange(0L, this.scan.getTimeRange().getMax());
            this.scan.setTimeRange(0L, this.scan.getTimeRange().getMax());
            return this.region.getScanner(incrScan);
        }
        return this.innerScanner;
    }

    @Override
    public long getMaxResultSize() {
        return this.scan.getMaxResultSize();
    }

    static {
        Configuration.addDeprecation((String)"index.verify.threads.max", (String)NUM_CONCURRENT_INDEX_VERIFY_THREADS_CONF_KEY);
        Configuration.addDeprecation((String)"index.verify.row.count.per.task", (String)INDEX_VERIFY_ROW_COUNTS_PER_TASK_CONF_KEY);
        MUTATION_TS_DESC_COMPARATOR = new Comparator<Mutation>(){

            @Override
            public int compare(Mutation o1, Mutation o2) {
                long ts2;
                long ts1 = GlobalIndexRegionScanner.getTimestamp(o1);
                if (ts1 > (ts2 = GlobalIndexRegionScanner.getTimestamp(o2))) {
                    return -1;
                }
                if (ts1 < ts2) {
                    return 1;
                }
                if (o1 instanceof Delete && o2 instanceof Put) {
                    return -1;
                }
                if (o1 instanceof Put && o2 instanceof Delete) {
                    return 1;
                }
                return 0;
            }
        };
        MUTATION_TS_COMPARATOR = new Comparator<Mutation>(){

            @Override
            public int compare(Mutation o1, Mutation o2) {
                long ts2;
                long ts1 = GlobalIndexRegionScanner.getTimestamp(o1);
                if (ts1 < (ts2 = GlobalIndexRegionScanner.getTimestamp(o2))) {
                    return -1;
                }
                if (ts1 > ts2) {
                    return 1;
                }
                if (o1 instanceof Put && o2 instanceof Delete) {
                    return -1;
                }
                if (o1 instanceof Delete && o2 instanceof Put) {
                    return 1;
                }
                return 0;
            }
        };
    }
}

