/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.CDCCompactionUtil;
import org.apache.phoenix.coprocessorclient.RowKeyMatcher;
import org.apache.phoenix.coprocessorclient.TableInfo;
import org.apache.phoenix.coprocessorclient.TableTTLInfo;
import org.apache.phoenix.coprocessorclient.TableTTLInfoCache;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.filter.RowKeyComparisonFilter;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.schema.CompiledConditionalTTLExpression;
import org.apache.phoenix.schema.CompiledTTLExpression;
import org.apache.phoenix.schema.ConditionalTTLExpression;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TTLExpressionFactory;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.CDCUtil;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ViewUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionScanner
implements InternalScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompactionScanner.class);
    public static final String SEPARATOR = ":";
    private final InternalScanner storeScanner;
    private final Region region;
    private final Store store;
    private final RegionCoprocessorEnvironment env;
    private long maxLookbackWindowStart;
    private final long maxLookbackInMillis;
    private int minVersion;
    private int maxVersion;
    private final boolean emptyCFStore;
    private final boolean localIndex;
    private final int familyCount;
    private KeepDeletedCells keepDeletedCells;
    private long compactionTime;
    private byte[] compactionTimeBytes;
    private final byte[] emptyCF;
    private final byte[] emptyCQ;
    private final byte[] storeColumnFamily;
    private final String tableName;
    private final String columnFamilyName;
    private static Map<String, Long> maxLookbackMap = new ConcurrentHashMap<String, Long>();
    private PhoenixLevelRowCompactor phoenixLevelRowCompactor;
    private HBaseLevelRowCompactor hBaseLevelRowCompactor;
    private boolean major;
    private long inputCellCount = 0L;
    private long outputCellCount = 0L;
    private boolean phoenixLevelOnly = false;
    private boolean isCDCIndex;
    private final boolean isCdcTtlEnabled;
    private final PTable table;
    private final int cdcTtlMutationMaxRetries;
    private CDCCompactionUtil.CDCBatchProcessor cdcBatchProcessor;
    private static boolean forceMinorCompaction = false;

    public CompactionScanner(RegionCoprocessorEnvironment env, Store store, InternalScanner storeScanner, long maxLookbackAgeInMillis, boolean major, boolean keepDeleted, PTable table) throws IOException {
        this.storeScanner = storeScanner;
        this.region = env.getRegion();
        this.store = store;
        this.env = env;
        this.emptyCF = SchemaUtil.getEmptyColumnFamily((PTable)table);
        this.emptyCQ = SchemaUtil.getEmptyColumnQualifier((PTable)table);
        this.compactionTime = EnvironmentEdgeManager.currentTimeMillis();
        this.compactionTimeBytes = PDate.INSTANCE.toBytes((Object)new Date(this.compactionTime));
        this.columnFamilyName = store.getColumnFamilyName();
        this.storeColumnFamily = this.columnFamilyName.getBytes();
        this.tableName = this.region.getRegionInfo().getTable().getNameAsString();
        String dataTableName = table.getName().toString();
        Long overriddenMaxLookback = maxLookbackMap.get(this.tableName + SEPARATOR + this.columnFamilyName);
        this.maxLookbackInMillis = overriddenMaxLookback == null ? maxLookbackAgeInMillis : Math.max(maxLookbackAgeInMillis, overriddenMaxLookback);
        this.maxLookbackWindowStart = this.maxLookbackInMillis == 0L ? this.compactionTime : this.compactionTime - (this.maxLookbackInMillis + 1L);
        ColumnFamilyDescriptor cfd = store.getColumnFamilyDescriptor();
        this.major = major && !forceMinorCompaction;
        this.minVersion = cfd.getMinVersions();
        this.maxVersion = cfd.getMaxVersions();
        this.keepDeletedCells = keepDeleted ? KeepDeletedCells.TTL : cfd.getKeepDeletedCells();
        this.familyCount = this.region.getTableDescriptor().getColumnFamilies().length;
        this.localIndex = this.columnFamilyName.startsWith("L#");
        this.emptyCFStore = this.familyCount == 1 || this.columnFamilyName.equals(Bytes.toString((byte[])this.emptyCF)) || this.localIndex;
        this.table = table;
        this.isCDCIndex = CDCUtil.isCDCIndex((PTable)table);
        this.isCdcTtlEnabled = CDCUtil.hasActiveCDCIndex((PTable)table) && major && !table.isMultiTenant() && table.getType() == PTableType.TABLE;
        this.cdcTtlMutationMaxRetries = env.getConfiguration().getInt("phoenix.cdc.ttl.mutation.max.retries", 5);
        if (this.isCdcTtlEnabled) {
            int cdcTtlMutationBatchSize = env.getConfiguration().getInt("phoenix.cdc.ttl.mutation.batch.size", 50);
            this.cdcBatchProcessor = CDCCompactionUtil.createBatchProcessor(table, env, this.region, this.compactionTimeBytes, this.compactionTime, this.tableName, this.cdcTtlMutationMaxRetries, cdcTtlMutationBatchSize);
        }
        TTLTracker ttlTracker = this.major ? this.createTTLTrackerFor(env, store, table) : new TableTTLTrackerForFlushesAndMinor(this.tableName);
        this.phoenixLevelRowCompactor = new PhoenixLevelRowCompactor(ttlTracker);
        this.hBaseLevelRowCompactor = new HBaseLevelRowCompactor(ttlTracker);
        LOGGER.info("Starting CompactionScanner for table " + this.tableName + " store " + this.columnFamilyName + (this.major ? " major " : " not major ") + "compaction ttl " + ttlTracker.getDefaultTTL() + " max lookback " + this.maxLookbackInMillis + "ms");
        LOGGER.info(String.format("CompactionScanner params:- (physical-data-tablename = %s, compaction-tablename = %s, region = %s, start-key = %s, end-key = %s, emptyCF = %s, emptyCQ = %s, minVersion = %d, maxVersion = %d, keepDeletedCells = %s, familyCount = %d, localIndex = %s, emptyCFStore = %s, compactionTime = %d, maxLookbackWindowStart = %d, maxLookbackInMillis = %d, major = %s)", dataTableName, this.tableName, this.region.getRegionInfo().getEncodedName(), Bytes.toStringBinary((byte[])this.region.getRegionInfo().getStartKey()), Bytes.toStringBinary((byte[])this.region.getRegionInfo().getEndKey()), Bytes.toString((byte[])this.emptyCF), Bytes.toString((byte[])this.emptyCQ), this.minVersion, this.maxVersion, this.keepDeletedCells.name(), this.familyCount, this.localIndex, this.emptyCFStore, this.compactionTime, this.maxLookbackWindowStart, this.maxLookbackInMillis, this.major));
    }

    @VisibleForTesting
    public static void setForceMinorCompaction(boolean doMinorCompaction) {
        forceMinorCompaction = doMinorCompaction;
    }

    @VisibleForTesting
    public static boolean getForceMinorCompaction() {
        return forceMinorCompaction;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TTLTracker createTTLTrackerFor(RegionCoprocessorEnvironment env, Store store, PTable baseTable) throws IOException {
        boolean isViewTTLEnabled = env.getConfiguration().getBoolean("phoenix.view.ttl.enabled", true);
        boolean isLongViewIndexEnabled = env.getConfiguration().getBoolean("phoenix.index.longViewIndex.enabled", false);
        int viewTTLTenantViewsPerScanLimit = -1;
        if (isViewTTLEnabled) {
            viewTTLTenantViewsPerScanLimit = env.getConfiguration().getInt("phoenix.view.ttl.tenant_views_per_scan.limit", 100);
        }
        long currentTime = EnvironmentEdgeManager.currentTimeMillis();
        String compactionTableName = env.getRegion().getRegionInfo().getTable().getNameAsString();
        String schemaName = SchemaUtil.getSchemaNameFromFullName((String)baseTable.getName().toString());
        String tableName = SchemaUtil.getTableNameFromFullName((String)baseTable.getName().toString());
        boolean isSharedIndex = false;
        if (compactionTableName.startsWith("_IDX_")) {
            isSharedIndex = true;
        }
        boolean isSalted = baseTable.getBucketNum() != null;
        try (PhoenixConnection serverConnection = QueryUtil.getConnectionOnServer((Properties)new Properties(), (Configuration)env.getConfiguration()).unwrap(PhoenixConnection.class);){
            if (!isViewTTLEnabled) {
                NonPartitionedTableTTLTracker nonPartitionedTableTTLTracker = new NonPartitionedTableTTLTracker(serverConnection, baseTable, store);
                return nonPartitionedTableTTLTracker;
            }
            byte[] childLinkTableNameBytes = SchemaUtil.isNamespaceMappingEnabled((PTableType)PTableType.SYSTEM, (Configuration)env.getConfiguration()) ? PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAMESPACE_BYTES : PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES;
            Table childLinkHTable = serverConnection.getQueryServices().getTable(childLinkTableNameBytes);
            boolean isPartitioned = ViewUtil.hasChildViews((Table)childLinkHTable, (byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])Bytes.toBytes((String)schemaName), (byte[])Bytes.toBytes((String)tableName), (long)currentTime);
            TTLTracker tTLTracker = isPartitioned ? new PartitionedTableTTLTracker(serverConnection, baseTable, isSalted, isSharedIndex, isLongViewIndexEnabled, viewTTLTenantViewsPerScanLimit) : new NonPartitionedTableTTLTracker(serverConnection, baseTable, store);
            return tTLTracker;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public static void overrideMaxLookback(String tableName, String columnFamilyName, long maxLookbackInMillis) {
        if (tableName == null || columnFamilyName == null) {
            return;
        }
        Long old = maxLookbackMap.putIfAbsent(tableName + SEPARATOR + columnFamilyName, maxLookbackInMillis);
        if (old != null) {
            maxLookbackMap.put(tableName + SEPARATOR + columnFamilyName, maxLookbackInMillis);
        }
    }

    public static long getMaxLookbackInMillis(String tableName, String columnFamilyName, long maxLookbackInMillis) {
        if (tableName == null || columnFamilyName == null) {
            return maxLookbackInMillis;
        }
        Long value = maxLookbackMap.get(tableName + SEPARATOR + columnFamilyName);
        return value == null ? maxLookbackInMillis : maxLookbackMap.get(tableName + SEPARATOR + columnFamilyName);
    }

    private void printRow(List<Cell> result, String title, boolean sort, boolean output) {
        List<Cell> row;
        if (sort) {
            row = new ArrayList<Cell>(result);
            Collections.sort(row, CellTimeComparator.COMPARATOR);
        } else {
            row = result;
        }
        System.out.println("---- " + title + " ----");
        System.out.println((this.major ? "Major " : "Not major ") + "compaction time: " + this.compactionTime);
        System.out.println("Max lookback window start time: " + this.maxLookbackWindowStart);
        System.out.println("Max lookback in ms: " + this.maxLookbackInMillis);
        if (output) {
            RowContext rowContext = this.phoenixLevelRowCompactor.rowContext;
            System.out.println("TTL in ms: " + rowContext.ttl);
            System.out.println("TTL window start time: " + rowContext.ttlWindowStart);
            System.out.println("Max lookback window start time: " + rowContext.maxLookbackWindowStartForRow);
        }
        for (Cell cell : row) {
            System.out.println(cell);
        }
    }

    private void postProcessForConditionalTTL(List<Cell> result) {
        RowContext rowContext = this.phoenixLevelRowCompactor.rowContext;
        for (Cell cell : result) {
            if (cell.getTimestamp() < rowContext.getMaxLookbackWindowStart()) continue;
            return;
        }
        CompiledConditionalTTLExpression ttlExpr = (CompiledConditionalTTLExpression)rowContext.ttlExprForRow;
        if (ttlExpr.isExpired(result, true)) {
            if (this.isCdcTtlEnabled && this.cdcBatchProcessor != null && !result.isEmpty()) {
                CDCCompactionUtil.handleTTLRowExpiration(result, "conditional_ttl", this.tableName, this.cdcBatchProcessor);
            }
            result.clear();
        }
    }

    public boolean next(List<Cell> result) throws IOException {
        boolean hasMore = this.storeScanner.next(result);
        this.inputCellCount += (long)result.size();
        if (!result.isEmpty()) {
            this.phoenixLevelRowCompactor.compact(result, false);
            if (this.phoenixLevelRowCompactor.rowContext.hasConditionalTTL()) {
                this.postProcessForConditionalTTL(result);
            }
            this.outputCellCount += (long)result.size();
        }
        return hasMore;
    }

    public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
        return this.next(result);
    }

    public void close() throws IOException {
        LOGGER.info("Closing CompactionScanner for table " + this.tableName + " store " + this.columnFamilyName + (this.major ? " major " : " not major ") + "compaction retained " + this.outputCellCount + " of " + this.inputCellCount + " cells" + (this.phoenixLevelOnly ? " phoenix level only" : ""));
        if (forceMinorCompaction) {
            forceMinorCompaction = false;
        }
        this.storeScanner.close();
        if (this.cdcBatchProcessor != null) {
            try {
                this.cdcBatchProcessor.close();
            }
            catch (Exception e) {
                LOGGER.error("Error closing CDC batch processor for table {}", (Object)this.tableName, (Object)e);
                throw new IOException("Failed to close CDC batch processor", e);
            }
            finally {
                CDCCompactionUtil.getSharedRowImageCache(this.env.getConfiguration()).cleanUp();
            }
        }
    }

    private static interface TTLTracker {
        public CompiledTTLExpression getTTLExpressionForRow(List<Cell> var1) throws IOException;

        public CompiledTTLExpression getDefaultTTL();
    }

    private class TableTTLTrackerForFlushesAndMinor
    implements TTLTracker {
        private CompiledTTLExpression ttlExpr = LiteralTTLExpression.TTL_EXPRESSION_FOREVER;

        public TableTTLTrackerForFlushesAndMinor(String tableName) {
            LOGGER.info(String.format("TableTTLTrackerForFlushesAndMinor params:- (table-name=%s, ttl=%s)", tableName, this.ttlExpr));
        }

        @Override
        public CompiledTTLExpression getTTLExpressionForRow(List<Cell> result) throws IOException {
            return this.ttlExpr;
        }

        @Override
        public CompiledTTLExpression getDefaultTTL() {
            return this.ttlExpr;
        }
    }

    class PhoenixLevelRowCompactor {
        private RowContext rowContext;
        List<Cell> lastRowVersion;
        List<Cell> emptyColumn;
        List<Cell> phoenixResult;
        List<Cell> trimmedRow;
        List<Cell> trimmedEmptyColumn;
        List<Cell> deleteFamilyVersionCellList;
        private TTLTracker rowTracker;

        PhoenixLevelRowCompactor(TTLTracker rowTracker) {
            this.rowContext = new RowContext();
            this.lastRowVersion = new ArrayList<Cell>();
            this.emptyColumn = new ArrayList<Cell>();
            this.phoenixResult = new ArrayList<Cell>();
            this.trimmedRow = new ArrayList<Cell>();
            this.trimmedEmptyColumn = new ArrayList<Cell>();
            this.deleteFamilyVersionCellList = new ArrayList<Cell>();
            this.rowTracker = rowTracker;
        }

        private int skipColumn(List<Cell> result, Cell currentColumnCell, List<Cell> retainedCells, int index) {
            for (int i = index + 1; i < result.size(); ++i) {
                Cell cell = result.get(i);
                if (CellUtil.matchingColumn((Cell)cell, (Cell)currentColumnCell)) {
                    ++index;
                    if (cell.getType() == Cell.Type.Put || CompactionScanner.this.major) continue;
                    retainedCells.add(cell);
                    continue;
                }
                return index;
            }
            return index;
        }

        private int addEmptyColumn(List<Cell> result, Cell currentColumnCell, int index, List<Cell> emptyColumn) {
            for (int i = index + 1; i < result.size(); ++i) {
                Cell cell = result.get(i);
                if (CellUtil.matchingColumn((Cell)cell, (Cell)currentColumnCell)) {
                    ++index;
                } else {
                    return index;
                }
                emptyColumn.add(cell);
            }
            return index;
        }

        private void getLastRowVersionInMaxLookbackWindow(List<Cell> result, List<Cell> lastRowVersion, List<Cell> retainedCells, List<Cell> emptyColumn) {
            long maxLookbackWindowStart = this.rowContext.getMaxLookbackWindowStart();
            Cell currentColumnCell = null;
            Cell deleteFamilyCell = null;
            this.deleteFamilyVersionCellList.clear();
            block0: for (int index = 0; index < result.size(); ++index) {
                Cell cell = result.get(index);
                if (cell.getTimestamp() > maxLookbackWindowStart) {
                    retainedCells.add(cell);
                    continue;
                }
                if (currentColumnCell == null) {
                    currentColumnCell = cell;
                    if (cell.getType() == Cell.Type.DeleteFamily) {
                        deleteFamilyCell = cell;
                        if (cell.getTimestamp() == maxLookbackWindowStart) {
                            lastRowVersion.add(cell);
                        } else if (!CompactionScanner.this.major) {
                            retainedCells.add(cell);
                        }
                        index = this.skipColumn(result, currentColumnCell, retainedCells, index);
                        continue;
                    }
                    if (cell.getType() == Cell.Type.DeleteFamilyVersion) {
                        this.deleteFamilyVersionCellList.add(cell);
                        if (cell.getTimestamp() == maxLookbackWindowStart) {
                            lastRowVersion.add(cell);
                        } else if (!CompactionScanner.this.major) {
                            retainedCells.add(cell);
                        }
                        for (int i = index + 1; i < result.size(); ++i) {
                            cell = result.get(i);
                            if (cell.getType() == Cell.Type.DeleteFamilyVersion) {
                                ++index;
                                this.deleteFamilyVersionCellList.add(cell);
                                if (CompactionScanner.this.major) continue;
                                retainedCells.add(cell);
                                continue;
                            }
                            if (cell.getType() != Cell.Type.DeleteFamily) continue block0;
                            ++index;
                            deleteFamilyCell = cell;
                            if (!CompactionScanner.this.major) {
                                retainedCells.add(cell);
                            }
                            index = this.skipColumn(result, currentColumnCell, retainedCells, index);
                            continue block0;
                        }
                        break;
                    }
                }
                currentColumnCell = cell;
                if (!this.deleteFamilyVersionCellList.isEmpty()) {
                    for (Cell deleteFamilyVersionCell : this.deleteFamilyVersionCellList) {
                        if (cell.getTimestamp() > deleteFamilyVersionCell.getTimestamp()) break;
                        if (cell.getTimestamp() != deleteFamilyVersionCell.getTimestamp()) continue;
                        if (cell.getType() != Cell.Type.Put) {
                            if (cell.getTimestamp() == maxLookbackWindowStart) {
                                lastRowVersion.add(cell);
                            } else if (!CompactionScanner.this.major) {
                                retainedCells.add(cell);
                            }
                        }
                        if (index + 1 >= result.size()) break block0;
                        cell = result.get(index + 1);
                        if (!CellUtil.matchingColumn((Cell)cell, (Cell)currentColumnCell)) continue block0;
                        ++index;
                    }
                }
                if (deleteFamilyCell != null && deleteFamilyCell.getTimestamp() >= cell.getTimestamp()) {
                    if (cell.getType() != Cell.Type.Put) {
                        if (cell.getTimestamp() == maxLookbackWindowStart) {
                            lastRowVersion.add(cell);
                        } else if (!CompactionScanner.this.major) {
                            retainedCells.add(cell);
                        }
                    }
                    index = this.skipColumn(result, currentColumnCell, retainedCells, index);
                    continue;
                }
                while (cell.getType() == Cell.Type.Delete) {
                    if (cell.getTimestamp() == maxLookbackWindowStart) {
                        lastRowVersion.add(cell);
                    } else if (!CompactionScanner.this.major) {
                        retainedCells.add(cell);
                    }
                    if (index + 1 >= result.size()) break block0;
                    Cell nextCell = result.get(index + 1);
                    if (!CellUtil.matchingColumn((Cell)currentColumnCell, (Cell)nextCell)) continue block0;
                    ++index;
                    if (nextCell.getType() != Cell.Type.Put || cell.getTimestamp() != nextCell.getTimestamp()) continue;
                    if (++index >= result.size()) break block0;
                    cell = result.get(index);
                }
                if (cell.getType() == Cell.Type.DeleteColumn) {
                    if (cell.getTimestamp() == maxLookbackWindowStart) {
                        lastRowVersion.add(cell);
                    } else if (!CompactionScanner.this.major) {
                        retainedCells.add(cell);
                    }
                    index = this.skipColumn(result, currentColumnCell, retainedCells, index);
                    continue;
                }
                if (cell.getType() == Cell.Type.Put) {
                    lastRowVersion.add(cell);
                    if (ScanUtil.isEmptyColumn((Cell)cell, (byte[])CompactionScanner.this.emptyCF, (byte[])CompactionScanner.this.emptyCQ)) {
                        index = this.addEmptyColumn(result, currentColumnCell, index, emptyColumn);
                        continue;
                    }
                    index = this.skipColumn(result, currentColumnCell, retainedCells, index);
                    continue;
                }
                if (CompactionScanner.this.major || !CellUtil.matchingFamily((Cell)cell, (byte[])CompactionScanner.this.storeColumnFamily) || cell.getType() != Cell.Type.DeleteFamily && cell.getType() != Cell.Type.DeleteFamilyVersion) continue;
                index = this.skipColumn(result, currentColumnCell, retainedCells, index);
            }
        }

        private void closeGap(long max, long min, long ttl, List<Cell> input, List<Cell> output) {
            int previous = -1;
            for (Cell cell : input) {
                long ts = cell.getTimestamp();
                if (ts >= max) {
                    ++previous;
                    continue;
                }
                if (previous == -1 && max - ts > ttl) break;
                if (max - ts > ttl) {
                    max = input.get(previous).getTimestamp();
                    output.add(input.remove(previous));
                    if (max - min > ttl) {
                        this.closeGap(max, min, ttl, input, output);
                    }
                    return;
                }
                ++previous;
            }
            if (previous > -1 && max - min > ttl) {
                output.add(input.remove(previous));
            }
        }

        private void retainEmptyCellsInMinorCompaction(List<Cell> emptyColumn, List<Cell> retainedCells) {
            if (emptyColumn.isEmpty()) {
                return;
            }
            if (CompactionScanner.this.familyCount == 1 || CompactionScanner.this.localIndex) {
                long minRowTimestamp = this.rowContext.minTimestamp;
                for (Cell emptyCell : emptyColumn) {
                    if (emptyCell.getTimestamp() <= minRowTimestamp) continue;
                    retainedCells.add(emptyCell);
                }
                return;
            }
            retainedCells.addAll(emptyColumn);
        }

        private void retainCellsOfLastRowVersion(List<Cell> lastRow, List<Cell> emptyColumn, List<Cell> retainedCells) {
            if (lastRow.isEmpty()) {
                return;
            }
            this.rowContext.init();
            long ttl = this.rowContext.getTTL();
            this.rowContext.getNextRowVersionTimestamps(lastRow, CompactionScanner.this.storeColumnFamily);
            Cell firstCell = lastRow.get(0);
            while (firstCell.getType() == Cell.Type.DeleteFamilyVersion && firstCell.getTimestamp() == this.rowContext.maxTimestamp) {
                this.rowContext.getNextRowVersionTimestamps(lastRow, CompactionScanner.this.storeColumnFamily);
            }
            if (firstCell.getType() == Cell.Type.DeleteFamily && firstCell.getTimestamp() >= this.rowContext.maxTimestamp || firstCell.getType() == Cell.Type.DeleteFamilyVersion && firstCell.getTimestamp() == this.rowContext.maxTimestamp) {
                return;
            }
            if (CompactionScanner.this.major && CompactionScanner.this.compactionTime - this.rowContext.maxTimestamp > CompactionScanner.this.maxLookbackInMillis + ttl) {
                if (CompactionScanner.this.isCdcTtlEnabled && CompactionScanner.this.cdcBatchProcessor != null && !lastRow.isEmpty()) {
                    CDCCompactionUtil.handleTTLRowExpiration(lastRow, "time_based_ttl", CompactionScanner.this.tableName, CompactionScanner.this.cdcBatchProcessor);
                }
                return;
            }
            retainedCells.addAll(lastRow);
            if (CompactionScanner.this.major && this.rowContext.maxTimestamp - this.rowContext.minTimestamp <= ttl) {
                return;
            }
            if (emptyColumn.isEmpty()) {
                return;
            }
            if (!CompactionScanner.this.major) {
                this.retainEmptyCellsInMinorCompaction(emptyColumn, retainedCells);
                return;
            }
            int size = lastRow.size();
            long[] tsArray = new long[size];
            int i = 0;
            for (Cell cell : lastRow) {
                tsArray[i++] = cell.getTimestamp();
            }
            Arrays.sort(tsArray);
            for (i = size - 1; i > 0; --i) {
                if (tsArray[i] - tsArray[i - 1] <= ttl) continue;
                this.closeGap(tsArray[i], tsArray[i - 1], ttl, emptyColumn, retainedCells);
            }
        }

        private boolean retainCellsForCDCIndex(List<Cell> result, List<Cell> retainedCells) {
            for (Cell cell : result) {
                if (cell.getTimestamp() < this.rowContext.getMaxLookbackWindowStart()) continue;
                retainedCells.add(cell);
            }
            return true;
        }

        private boolean retainCellsForMaxLookback(List<Cell> result, boolean regionLevel, List<Cell> retainedCells) {
            this.lastRowVersion.clear();
            this.emptyColumn.clear();
            if (CompactionScanner.this.isCDCIndex) {
                return this.retainCellsForCDCIndex(result, retainedCells);
            }
            this.getLastRowVersionInMaxLookbackWindow(result, this.lastRowVersion, retainedCells, this.emptyColumn);
            if (this.lastRowVersion.isEmpty()) {
                return true;
            }
            if (!CompactionScanner.this.major) {
                this.retainCellsOfLastRowVersion(this.lastRowVersion, this.emptyColumn, retainedCells);
                return true;
            }
            long ttl = this.rowContext.getTTL();
            long maxTimestamp = 0L;
            long minTimestamp = Long.MAX_VALUE;
            for (Cell cell : this.lastRowVersion) {
                long ts = cell.getTimestamp();
                if (ts > maxTimestamp) {
                    maxTimestamp = ts;
                }
                if ((ts = cell.getTimestamp()) >= minTimestamp) continue;
                minTimestamp = ts;
            }
            if (CompactionScanner.this.compactionTime - maxTimestamp > CompactionScanner.this.maxLookbackInMillis + ttl) {
                if (!CompactionScanner.this.emptyCFStore && !regionLevel) {
                    return false;
                }
                if (CompactionScanner.this.isCdcTtlEnabled && CompactionScanner.this.cdcBatchProcessor != null && !this.lastRowVersion.isEmpty()) {
                    CDCCompactionUtil.handleTTLRowExpiration(this.lastRowVersion, "max_lookback_ttl", CompactionScanner.this.tableName, CompactionScanner.this.cdcBatchProcessor);
                }
                return true;
            }
            if (maxTimestamp - minTimestamp > ttl) {
                if (CompactionScanner.this.familyCount > 1 && !regionLevel && !CompactionScanner.this.localIndex) {
                    return false;
                }
                int size = this.lastRowVersion.size();
                long[] tsArray = new long[size += this.emptyColumn.size()];
                int i = 0;
                for (Cell cell : this.lastRowVersion) {
                    tsArray[i++] = cell.getTimestamp();
                }
                for (Cell cell : this.emptyColumn) {
                    tsArray[i++] = cell.getTimestamp();
                }
                Arrays.sort(tsArray);
                boolean gapFound = false;
                for (i = size - 1; i > 0; --i) {
                    if (tsArray[i] - tsArray[i - 1] <= ttl) continue;
                    minTimestamp = tsArray[i];
                    gapFound = true;
                    break;
                }
                if (gapFound) {
                    this.trimmedRow.clear();
                    for (Cell cell : this.lastRowVersion) {
                        if (cell.getTimestamp() < minTimestamp) continue;
                        this.trimmedRow.add(cell);
                    }
                    this.lastRowVersion.clear();
                    this.lastRowVersion.addAll(this.trimmedRow);
                    this.trimmedEmptyColumn.clear();
                    for (Cell cell : this.emptyColumn) {
                        if (cell.getTimestamp() < minTimestamp) continue;
                        this.trimmedEmptyColumn.add(cell);
                    }
                    this.emptyColumn = this.trimmedEmptyColumn;
                }
            }
            this.retainCellsOfLastRowVersion(this.lastRowVersion, this.emptyColumn, retainedCells);
            return true;
        }

        private void removeDuplicates(List<Cell> input, List<Cell> output) {
            Cell previousCell = null;
            for (Cell cell : input) {
                if (previousCell == null || cell.getTimestamp() != previousCell.getTimestamp() || cell.getType() != previousCell.getType() || !CellUtil.matchingColumn((Cell)cell, (Cell)previousCell)) {
                    output.add(cell);
                }
                previousCell = cell;
            }
        }

        private void compact(List<Cell> result, boolean regionLevel) throws IOException {
            if (result.isEmpty()) {
                return;
            }
            this.phoenixResult.clear();
            CompiledTTLExpression ttlExprForRow = this.rowTracker.getTTLExpressionForRow(result);
            this.rowContext.setTTL(ttlExprForRow, result);
            if (CompactionScanner.this.major && CompactionScanner.this.familyCount > 1 && !CompactionScanner.this.localIndex && CompactionScanner.this.emptyCFStore && !regionLevel) {
                this.compactRegionLevel(result, this.phoenixResult);
            } else if (!this.retainCellsForMaxLookback(result, regionLevel, this.phoenixResult)) {
                if (CompactionScanner.this.familyCount == 1 || regionLevel) {
                    throw new RuntimeException("UNEXPECTED");
                }
                this.phoenixResult.clear();
                this.compactRegionLevel(result, this.phoenixResult);
            }
            if (CompactionScanner.this.maxVersion == 1 && (!CompactionScanner.this.major || CompactionScanner.this.minVersion == 0 && CompactionScanner.this.keepDeletedCells == KeepDeletedCells.FALSE)) {
                Collections.sort(this.phoenixResult, CellComparator.getInstance());
                result.clear();
                this.removeDuplicates(this.phoenixResult, result);
                CompactionScanner.this.phoenixLevelOnly = true;
                return;
            }
            int phoenixResultSize = this.phoenixResult.size();
            ArrayList<Cell> hbaseResult = new ArrayList<Cell>(result);
            CompactionScanner.this.hBaseLevelRowCompactor.compact(hbaseResult);
            this.phoenixResult.addAll(hbaseResult);
            Collections.sort(this.phoenixResult, CellComparator.getInstance());
            result.clear();
            this.removeDuplicates(this.phoenixResult, result);
            if (result.size() > phoenixResultSize) {
                LOGGER.debug("HBase level compaction retained " + (result.size() - phoenixResultSize) + " more cells");
            }
        }

        private int compareTypes(Cell a, Cell b) {
            Cell.Type bType;
            Cell.Type aType = a.getType();
            if (aType == (bType = b.getType())) {
                return 0;
            }
            if (aType == Cell.Type.DeleteFamily) {
                return -1;
            }
            if (bType == Cell.Type.DeleteFamily) {
                return 1;
            }
            if (aType == Cell.Type.DeleteFamilyVersion) {
                return -1;
            }
            if (bType == Cell.Type.DeleteFamilyVersion) {
                return 1;
            }
            if (aType == Cell.Type.DeleteColumn) {
                return -1;
            }
            return 1;
        }

        private int compare(Cell a, Cell b) {
            int result = Bytes.compareTo((byte[])a.getFamilyArray(), (int)a.getFamilyOffset(), (int)a.getFamilyLength(), (byte[])b.getFamilyArray(), (int)b.getFamilyOffset(), (int)b.getFamilyLength());
            if (result != 0) {
                return result;
            }
            result = Bytes.compareTo((byte[])a.getQualifierArray(), (int)a.getQualifierOffset(), (int)a.getQualifierLength(), (byte[])b.getQualifierArray(), (int)b.getQualifierOffset(), (int)b.getQualifierLength());
            if (result != 0) {
                return result;
            }
            if (a.getTimestamp() > b.getTimestamp()) {
                return -1;
            }
            if (a.getTimestamp() < b.getTimestamp()) {
                return 1;
            }
            return this.compareTypes(a, b);
        }

        private void trimRegionResult(List<Cell> regionResult, List<Cell> input, List<Cell> result) {
            if (regionResult.isEmpty()) {
                return;
            }
            int index = 0;
            int size = regionResult.size();
            for (Cell originalCell : input) {
                Cell regionCell = regionResult.get(index);
                int compare = this.compare(originalCell, regionCell);
                while (compare > 0 && ++index != size) {
                    regionCell = regionResult.get(index);
                    compare = this.compare(originalCell, regionCell);
                }
                if (compare == 0) {
                    result.add(originalCell);
                    ++index;
                }
                if (index != size) continue;
                break;
            }
        }

        private void compactRegionLevel(List<Cell> input, List<Cell> result) throws IOException {
            byte[] rowKey = CellUtil.cloneRow((Cell)input.get(0));
            Scan scan = new Scan();
            scan.setRaw(true);
            scan.readAllVersions();
            scan.setTimeRange(0L, CompactionScanner.this.compactionTime + 1L);
            scan.withStartRow(rowKey, true);
            scan.withStopRow(rowKey, true);
            RegionScanner scanner = CompactionScanner.this.region.getScanner(scan);
            ArrayList<Cell> regionResult = new ArrayList<Cell>(result.size());
            scanner.next(regionResult);
            scanner.close();
            Collections.sort(regionResult, CellComparator.getInstance());
            this.compact(regionResult, true);
            result.clear();
            this.trimRegionResult(regionResult, input, result);
        }
    }

    class HBaseLevelRowCompactor {
        private RowContext rowContext;
        private CompactionRowVersion rowVersion;
        private TTLTracker rowTracker;

        HBaseLevelRowCompactor(TTLTracker rowTracker) {
            this.rowContext = new RowContext();
            this.rowVersion = new CompactionRowVersion();
            this.rowTracker = rowTracker;
        }

        private void retainInsideTTLWindow(CompactionRowVersion rowVersion, RowContext rowContext, List<Cell> retainedCells) {
            if (rowContext.familyDeleteMarker == null && rowContext.familyVersionDeleteMarker == null) {
                if (rowVersion.version < CompactionScanner.this.maxVersion) {
                    this.retainCells(rowVersion, rowContext, retainedCells);
                }
            } else if (rowVersion.version < CompactionScanner.this.maxVersion && CompactionScanner.this.keepDeletedCells != KeepDeletedCells.FALSE) {
                this.retainCells(rowVersion, rowContext, retainedCells);
                rowContext.retainFamilyDeleteMarker(retainedCells);
            }
        }

        private void retainOutsideTTLWindow(CompactionRowVersion rowVersion, RowContext rowContext, List<Cell> retainedCells) {
            if (rowContext.familyDeleteMarker == null && rowContext.familyVersionDeleteMarker == null) {
                if (rowVersion.version < CompactionScanner.this.minVersion) {
                    this.retainCells(rowVersion, rowContext, retainedCells);
                }
            } else if (CompactionScanner.this.keepDeletedCells == KeepDeletedCells.TTL && rowContext.familyDeleteMarker != null && rowContext.familyDeleteMarker.getTimestamp() > rowContext.getTtlWindowStart()) {
                this.retainCells(rowVersion, rowContext, retainedCells);
                rowContext.retainFamilyDeleteMarker(retainedCells);
            }
        }

        private void retainCells(CompactionRowVersion rowVersion, RowContext rowContext, List<Cell> retainedCells) {
            if (rowContext.columnDeleteMarkers == null) {
                retainedCells.addAll(rowVersion.cells);
                return;
            }
            for (Cell cell : rowVersion.cells) {
                rowContext.retainCell(cell, retainedCells, CompactionScanner.this.keepDeletedCells, rowContext.getTtlWindowStart());
            }
        }

        private void formNextCompactionRowVersion(LinkedList<LinkedList<Cell>> columns, RowContext rowContext, List<Cell> retainedCells) {
            this.rowVersion.init();
            rowContext.getNextRowVersionTimestamps(columns, CompactionScanner.this.storeColumnFamily);
            this.rowVersion.ts = rowContext.maxTimestamp;
            for (LinkedList linkedList : columns) {
                Cell cell = (Cell)linkedList.getFirst();
                if (((Cell)linkedList.getFirst()).getTimestamp() < rowContext.minTimestamp) continue;
                if (cell.getType() == Cell.Type.DeleteFamily) {
                    if (cell.getTimestamp() < rowContext.maxTimestamp) continue;
                    rowContext.familyDeleteMarker = cell;
                    linkedList.removeFirst();
                    break;
                }
                if (cell.getType() == Cell.Type.DeleteFamilyVersion) {
                    if (cell.getTimestamp() != this.rowVersion.ts) continue;
                    rowContext.familyVersionDeleteMarker = cell;
                    linkedList.removeFirst();
                    break;
                }
                linkedList.removeFirst();
                if (cell.getType() == Cell.Type.DeleteColumn || cell.getType() == Cell.Type.Delete) {
                    rowContext.addColumnDeleteMarker(cell);
                    continue;
                }
                this.rowVersion.cells.add(cell);
            }
            if (this.rowVersion.cells.isEmpty()) {
                return;
            }
            this.rowVersion.version = rowContext.version++;
            if (this.rowVersion.ts >= rowContext.getTtlWindowStart()) {
                this.retainInsideTTLWindow(this.rowVersion, rowContext, retainedCells);
            } else {
                this.retainOutsideTTLWindow(this.rowVersion, rowContext, retainedCells);
            }
        }

        private void formCompactionRowVersions(LinkedList<LinkedList<Cell>> columns, List<Cell> result) throws IOException {
            this.rowContext.init();
            CompiledTTLExpression ttlExprForRow = this.rowTracker.getTTLExpressionForRow(result);
            this.rowContext.setTTL(ttlExprForRow, result);
            while (!columns.isEmpty()) {
                this.formNextCompactionRowVersion(columns, this.rowContext, result);
                Iterator iterator = columns.iterator();
                while (iterator.hasNext()) {
                    LinkedList column = (LinkedList)iterator.next();
                    if (!column.isEmpty()) continue;
                    iterator.remove();
                }
            }
        }

        private void formColumns(List<Cell> result, LinkedList<LinkedList<Cell>> columns) {
            Cell currentColumnCell = null;
            LinkedList<Cell> currentColumn = null;
            for (Cell cell : result) {
                if (currentColumnCell == null) {
                    currentColumn = new LinkedList<Cell>();
                    currentColumnCell = cell;
                    currentColumn.add(cell);
                    continue;
                }
                if (!CellUtil.matchingColumn((Cell)cell, currentColumnCell)) {
                    columns.add(currentColumn);
                    currentColumn = new LinkedList();
                    currentColumnCell = cell;
                    currentColumn.add(cell);
                    continue;
                }
                currentColumn.add(cell);
            }
            if (currentColumn != null) {
                columns.add(currentColumn);
            }
        }

        private void compact(List<Cell> result) throws IOException {
            if (result.isEmpty()) {
                return;
            }
            LinkedList<LinkedList<Cell>> columns = new LinkedList<LinkedList<Cell>>();
            this.formColumns(result, columns);
            result.clear();
            this.formCompactionRowVersions(columns, result);
        }

        class CompactionRowVersion {
            List<Cell> cells = new ArrayList<Cell>();
            long ts = 0L;
            int version = 0;

            CompactionRowVersion() {
            }

            private void init() {
                this.cells.clear();
            }

            public String toString() {
                StringBuilder output = new StringBuilder();
                output.append("Cell count: " + this.cells.size() + "\n");
                for (Cell cell : this.cells) {
                    output.append(cell + "\n");
                }
                output.append("ts:" + this.ts + " v:" + this.version);
                return output.toString();
            }
        }
    }

    private class NonPartitionedTableTTLTracker
    implements TTLTracker {
        private CompiledTTLExpression ttlExpr;

        public NonPartitionedTableTTLTracker(PhoenixConnection pConn, PTable pTable, Store store) throws IOException {
            boolean isSystemTable = pTable.getType() == PTableType.SYSTEM;
            boolean ttlFromDescriptor = false;
            try {
                if (isSystemTable || pTable.getTTLExpression().equals(LiteralTTLExpression.TTL_EXPRESSION_DEFINED_IN_TABLE_DESCRIPTOR)) {
                    ColumnFamilyDescriptor cfd = store.getColumnFamilyDescriptor();
                    this.ttlExpr = TTLExpressionFactory.create((int)cfd.getTimeToLive());
                    ttlFromDescriptor = true;
                } else {
                    this.ttlExpr = !pTable.getTTLExpression().equals(LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED) ? pTable.getCompiledTTLExpression(pConn) : LiteralTTLExpression.TTL_EXPRESSION_FOREVER;
                }
            }
            catch (SQLException e) {
                throw ClientUtil.createIOException((String)String.format("Error compiling ttl expression %s", this.ttlExpr), (Throwable)e);
            }
            LOGGER.info(String.format("NonPartitionedTableTTLTracker params:- (physical-name=%s, ttl=%s, ttlFromDescriptor=%s, isSystemTable=%s)", pTable.getName().toString(), this.ttlExpr, ttlFromDescriptor, isSystemTable));
        }

        @Override
        public CompiledTTLExpression getTTLExpressionForRow(List<Cell> result) throws IOException {
            return this.ttlExpr;
        }

        @Override
        public CompiledTTLExpression getDefaultTTL() {
            return this.ttlExpr;
        }
    }

    private class PartitionedTableTTLTracker
    implements TTLTracker {
        private final Logger LOGGER;
        private CompiledTTLExpression ttlExpr;
        private boolean isSharedIndex;
        private boolean isMultiTenant;
        private boolean isSalted;
        private boolean isLongViewIndexEnabled;
        private int startingPKPosition;
        private PartitionedTableRowKeyMatcher tableRowKeyMatcher;

        public PartitionedTableTTLTracker(PhoenixConnection pConn, PTable table, boolean isSalted, boolean isSharedIndex, boolean isLongViewIndexEnabled, int viewTTLTenantViewsPerScanLimit) throws IOException {
            block11: {
                block10: {
                    this.LOGGER = LoggerFactory.getLogger(PartitionedTableTTLTracker.class);
                    this.isSharedIndex = false;
                    this.isMultiTenant = false;
                    this.isSalted = false;
                    this.isLongViewIndexEnabled = false;
                    try {
                        this.tableRowKeyMatcher = new PartitionedTableRowKeyMatcher(table, isSalted, isSharedIndex, isLongViewIndexEnabled, viewTTLTenantViewsPerScanLimit);
                        boolean ttlFromDescriptor = false;
                        try {
                            if (table.getTTLExpression().equals(LiteralTTLExpression.TTL_EXPRESSION_DEFINED_IN_TABLE_DESCRIPTOR)) {
                                ColumnFamilyDescriptor cfd = CompactionScanner.this.store.getColumnFamilyDescriptor();
                                this.ttlExpr = TTLExpressionFactory.create((int)cfd.getTimeToLive());
                                ttlFromDescriptor = true;
                            } else {
                                this.ttlExpr = !table.getTTLExpression().equals(LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED) ? table.getCompiledTTLExpression(pConn) : LiteralTTLExpression.TTL_EXPRESSION_FOREVER;
                            }
                        }
                        catch (SQLException e) {
                            throw ClientUtil.createIOException((String)String.format("Error compiling ttl expression %s", this.ttlExpr), (Throwable)e);
                        }
                        this.isSharedIndex = isSharedIndex || CompactionScanner.this.localIndex;
                        this.isLongViewIndexEnabled = isLongViewIndexEnabled;
                        this.isSalted = isSalted;
                        this.isMultiTenant = table.isMultiTenant();
                        this.startingPKPosition = this.getStartingPKPosition();
                        this.LOGGER.info(String.format("PartitionedTableTTLTracker params:- region-name = %s, table-name = %s,  multi-tenant = %s, shared-index = %s, salted = %s, default-ttl = %s, ttlFromDescriptor = %s, startingPKPosition = %d", CompactionScanner.this.region.getRegionInfo().getEncodedName(), CompactionScanner.this.region.getRegionInfo().getTable().getNameAsString(), this.isMultiTenant, this.isSharedIndex, this.isSalted, this.ttlExpr, ttlFromDescriptor, this.startingPKPosition));
                        if (this.tableRowKeyMatcher == null) break block10;
                    }
                    catch (SQLException e) {
                        try {
                            this.LOGGER.error(String.format("Failed to read from catalog: " + e.getMessage(), new Object[0]));
                            throw new IOException(e);
                        }
                        catch (Throwable throwable) {
                            if (this.tableRowKeyMatcher != null) {
                                this.LOGGER.info(String.format("PartitionedTableTTLTracker stats (index-entries, table-entries) for region = %s:-global-views = %d, %d, tenant-views = %d, %d, global-indexes = %d, %d tenant-indexes = %d, %d ", CompactionScanner.this.region.getRegionInfo().getEncodedName(), this.tableRowKeyMatcher.getNumGlobalEntries(), this.tableRowKeyMatcher.getNumTablesInGlobalCache(), this.tableRowKeyMatcher.getNumTenantEntries(), this.tableRowKeyMatcher.getNumTablesInTenantCache(), this.tableRowKeyMatcher.getNumGlobalIndexEntries(), this.tableRowKeyMatcher.getNumTablesInGlobalIndexCache(), this.tableRowKeyMatcher.getNumTenantIndexEntries(), this.tableRowKeyMatcher.getNumTablesInTenantIndexCache()));
                            } else {
                                this.LOGGER.error(String.format("Failed to initialize: tableRowKeyMatcher is null", new Object[0]));
                            }
                            throw throwable;
                        }
                    }
                    this.LOGGER.info(String.format("PartitionedTableTTLTracker stats (index-entries, table-entries) for region = %s:-global-views = %d, %d, tenant-views = %d, %d, global-indexes = %d, %d tenant-indexes = %d, %d ", CompactionScanner.this.region.getRegionInfo().getEncodedName(), this.tableRowKeyMatcher.getNumGlobalEntries(), this.tableRowKeyMatcher.getNumTablesInGlobalCache(), this.tableRowKeyMatcher.getNumTenantEntries(), this.tableRowKeyMatcher.getNumTablesInTenantCache(), this.tableRowKeyMatcher.getNumGlobalIndexEntries(), this.tableRowKeyMatcher.getNumTablesInGlobalIndexCache(), this.tableRowKeyMatcher.getNumTenantIndexEntries(), this.tableRowKeyMatcher.getNumTablesInTenantIndexCache()));
                    break block11;
                }
                this.LOGGER.error(String.format("Failed to initialize: tableRowKeyMatcher is null", new Object[0]));
            }
        }

        private int getStartingPKPosition() {
            int startingPKPosition = 0;
            startingPKPosition = this.isMultiTenant && this.isSalted && this.isSharedIndex ? 1 : (this.isMultiTenant && this.isSalted && !this.isSharedIndex ? 2 : (this.isMultiTenant && !this.isSalted && this.isSharedIndex ? 0 : (this.isMultiTenant && !this.isSalted && !this.isSharedIndex ? 1 : (!this.isMultiTenant && this.isSalted && this.isSharedIndex ? 1 : (!this.isMultiTenant && this.isSalted && !this.isSharedIndex ? 1 : (!this.isMultiTenant && !this.isSalted && this.isSharedIndex ? 0 : 0))))));
            return startingPKPosition;
        }

        @Override
        public CompiledTTLExpression getTTLExpressionForRow(List<Cell> result) throws IOException {
            CompiledTTLExpression compiledTTLExpression;
            CompiledTTLExpression defaultTTLExpr;
            boolean matched = false;
            String tableTTLInfo = null;
            List<Integer> pkPositions = null;
            CompiledTTLExpression rowTTLExpr = defaultTTLExpr = this.ttlExpr;
            long matchedOffset = -1L;
            int pkPosition = this.startingPKPosition;
            MatcherType matchedType = null;
            Cell firstCell = result.get(0);
            try {
                pkPositions = this.isSharedIndex ? (this.isSalted ? Arrays.asList(0, 1) : Arrays.asList(0)) : this.tableRowKeyMatcher.getRowKeyParser().parsePKPositions(firstCell);
                int offset = pkPositions.get(pkPosition);
                byte[] rowKey = CellUtil.cloneRow((Cell)firstCell);
                Object tableId = null;
                if (this.isSharedIndex) {
                    matchedType = MatcherType.GLOBAL_INDEXES;
                    tableTTLInfo = this.tableRowKeyMatcher.match(rowKey, offset, MatcherType.GLOBAL_INDEXES);
                    if (tableTTLInfo == null) {
                        matchedType = MatcherType.TENANT_INDEXES;
                        tableTTLInfo = this.tableRowKeyMatcher.match(rowKey, offset, MatcherType.TENANT_INDEXES);
                    }
                } else if (this.isMultiTenant) {
                    matchedType = MatcherType.GLOBAL_VIEWS;
                    tableTTLInfo = this.tableRowKeyMatcher.match(rowKey, offset, MatcherType.GLOBAL_VIEWS);
                    if (tableTTLInfo == null) {
                        pkPosition = this.isSalted ? 1 : 0;
                        offset = pkPositions.get(pkPosition);
                        matchedType = MatcherType.TENANT_VIEWS;
                        tableTTLInfo = this.tableRowKeyMatcher.match(rowKey, offset, MatcherType.TENANT_VIEWS);
                    }
                } else {
                    matchedType = MatcherType.GLOBAL_VIEWS;
                    tableTTLInfo = this.tableRowKeyMatcher.match(rowKey, offset, MatcherType.GLOBAL_VIEWS);
                }
                matched = tableTTLInfo != null;
                matchedOffset = matched ? (long)offset : -1L;
                rowTTLExpr = matched ? tableTTLInfo.getTTL() : defaultTTLExpr;
                compiledTTLExpression = rowTTLExpr;
            }
            catch (SQLException e) {
                try {
                    this.LOGGER.error(String.format("Exception when visiting table: " + e.getMessage(), new Object[0]));
                    throw new IOException(e);
                }
                catch (Throwable throwable) {
                    if (this.LOGGER.isTraceEnabled()) {
                        this.LOGGER.trace(String.format("visiting row-key = %s, region = %s, table-ttl-info=%s, matched = %s, matched-type = %s, match-pattern = %s, ttlExpr = %s, matched-offset = %d, pk-pos = %d, pk-pos-list = %s", new Object[]{CellUtil.getCellKeyAsString((Cell)firstCell), CompactionScanner.this.store.getRegionInfo().getEncodedName(), matched ? tableTTLInfo : "NULL", matched, matchedType, matched ? Bytes.toStringBinary((byte[])tableTTLInfo.getMatchPattern()) : "NULL", rowTTLExpr, matchedOffset, pkPosition, pkPositions != null ? pkPositions.stream().map(p -> String.valueOf(p)).collect(Collectors.joining(",")) : ""}));
                    }
                    throw throwable;
                }
            }
            if (this.LOGGER.isTraceEnabled()) {
                this.LOGGER.trace(String.format("visiting row-key = %s, region = %s, table-ttl-info=%s, matched = %s, matched-type = %s, match-pattern = %s, ttlExpr = %s, matched-offset = %d, pk-pos = %d, pk-pos-list = %s", new Object[]{CellUtil.getCellKeyAsString((Cell)firstCell), CompactionScanner.this.store.getRegionInfo().getEncodedName(), matched ? tableTTLInfo : "NULL", matched, matchedType, matched ? Bytes.toStringBinary((byte[])tableTTLInfo.getMatchPattern()) : "NULL", rowTTLExpr, matchedOffset, pkPosition, pkPositions != null ? pkPositions.stream().map(p -> String.valueOf(p)).collect(Collectors.joining(",")) : ""}));
            }
            return compiledTTLExpression;
        }

        @Override
        public CompiledTTLExpression getDefaultTTL() {
            return this.ttlExpr;
        }
    }

    static class CellTimeComparator
    implements Comparator<Cell> {
        public static final CellTimeComparator COMPARATOR = new CellTimeComparator();

        CellTimeComparator() {
        }

        @Override
        public int compare(Cell o1, Cell o2) {
            long ts2;
            long ts1 = o1.getTimestamp();
            if (ts1 == (ts2 = o2.getTimestamp())) {
                return 0;
            }
            if (ts1 > ts2) {
                return -1;
            }
            return 1;
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    }

    class RowContext {
        Cell familyDeleteMarker = null;
        Cell familyVersionDeleteMarker = null;
        List<Cell> columnDeleteMarkers = new ArrayList<Cell>();
        int version = 0;
        long maxTimestamp;
        long minTimestamp;
        long ttl;
        CompiledTTLExpression ttlExprForRow;
        long ttlWindowStart;
        long maxLookbackWindowStartForRow;

        RowContext() {
        }

        private void init() {
            this.familyDeleteMarker = null;
            this.familyVersionDeleteMarker = null;
            this.columnDeleteMarkers.clear();
            this.version = 0;
        }

        private void setTTL(long ttlInSecs) {
            this.ttl = Math.max(ttlInSecs * 1000L, CompactionScanner.this.maxLookbackInMillis + 1L);
            this.ttlWindowStart = ttlInSecs == Integer.MAX_VALUE ? 1L : CompactionScanner.this.compactionTime - this.ttl;
            this.maxLookbackWindowStartForRow = Math.max(this.ttlWindowStart, CompactionScanner.this.maxLookbackWindowStart);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("RowContext:- (ttlWindowStart=%d, maxLookbackWindowStart=%d)", this.ttlWindowStart, CompactionScanner.this.maxLookbackWindowStart));
            }
        }

        public void setTTL(CompiledTTLExpression ttlExpr, List<Cell> result) {
            this.ttlExprForRow = ttlExpr;
            this.setTTL(this.ttlExprForRow.getRowTTLForCompaction(result));
        }

        public boolean hasConditionalTTL() {
            return this.ttlExprForRow != null && this.ttlExprForRow instanceof CompiledConditionalTTLExpression;
        }

        public long getTTL() {
            return this.ttl;
        }

        public long getTtlWindowStart() {
            return this.ttlWindowStart;
        }

        public long getMaxLookbackWindowStart() {
            return this.maxLookbackWindowStartForRow;
        }

        private void addColumnDeleteMarker(Cell deleteMarker) {
            if (this.columnDeleteMarkers.isEmpty()) {
                this.columnDeleteMarkers.add(deleteMarker);
                return;
            }
            int i = 0;
            for (Cell cell : this.columnDeleteMarkers) {
                if (cell.getType() == deleteMarker.getType() && CellUtil.matchingColumn((Cell)cell, (Cell)deleteMarker)) {
                    this.columnDeleteMarkers.remove(i);
                    break;
                }
                ++i;
            }
            this.columnDeleteMarkers.add(deleteMarker);
        }

        private void retainFamilyDeleteMarker(List<Cell> retainedCells) {
            if (this.familyVersionDeleteMarker != null) {
                retainedCells.add(this.familyVersionDeleteMarker);
                this.familyVersionDeleteMarker = null;
            } else {
                retainedCells.add(this.familyDeleteMarker);
            }
        }

        private void retainCell(Cell cell, List<Cell> retainedCells, KeepDeletedCells keepDeletedCells, long ttlWindowStart) {
            int i = 0;
            for (Cell dm : this.columnDeleteMarkers) {
                if (cell.getTimestamp() > dm.getTimestamp()) continue;
                if (CellUtil.matchingFamily((Cell)cell, (Cell)dm) && CellUtil.matchingQualifier((Cell)cell, (Cell)dm)) {
                    if (dm.getType() == Cell.Type.Delete) {
                        if (cell.getTimestamp() != dm.getTimestamp()) continue;
                        this.columnDeleteMarkers.remove(i);
                    }
                    if (this.maxTimestamp >= ttlWindowStart) {
                        if (keepDeletedCells != KeepDeletedCells.FALSE) {
                            retainedCells.add(cell);
                            retainedCells.add(dm);
                        }
                    } else if (keepDeletedCells == KeepDeletedCells.TTL && dm.getTimestamp() >= ttlWindowStart) {
                        retainedCells.add(cell);
                        retainedCells.add(dm);
                    }
                    return;
                }
                ++i;
            }
            retainedCells.add(cell);
        }

        private void getNextRowVersionTimestamps(LinkedList<LinkedList<Cell>> columns, byte[] columnFamily) {
            long ts;
            this.maxTimestamp = 0L;
            this.minTimestamp = Long.MAX_VALUE;
            AbstractSequentialList deleteColumn = null;
            for (LinkedList linkedList : columns) {
                Cell firstCell = (Cell)linkedList.getFirst();
                ts = firstCell.getTimestamp();
                if ((firstCell.getType() == Cell.Type.DeleteFamily || firstCell.getType() == Cell.Type.DeleteFamilyVersion) && CellUtil.matchingFamily((Cell)firstCell, (byte[])columnFamily)) {
                    deleteColumn = linkedList;
                }
                if (this.maxTimestamp < ts) {
                    this.maxTimestamp = ts;
                }
                if (this.minTimestamp <= ts) continue;
                this.minTimestamp = ts;
            }
            if (deleteColumn != null) {
                for (Cell cell : deleteColumn) {
                    ts = cell.getTimestamp();
                    if (ts >= this.maxTimestamp) continue;
                    this.minTimestamp = ts + 1L;
                    break;
                }
            }
        }

        private void getNextRowVersionTimestamps(List<Cell> row, byte[] columnFamily) {
            long ts;
            this.maxTimestamp = 0L;
            this.minTimestamp = Long.MAX_VALUE;
            Cell deleteFamily = null;
            for (Cell cell : row) {
                ts = cell.getTimestamp();
                if ((cell.getType() == Cell.Type.DeleteFamily || cell.getType() == Cell.Type.DeleteFamilyVersion) && CellUtil.matchingFamily((Cell)cell, (byte[])columnFamily)) {
                    deleteFamily = cell;
                }
                if (this.maxTimestamp < ts) {
                    this.maxTimestamp = ts;
                }
                if (this.minTimestamp <= ts) continue;
                this.minTimestamp = ts;
            }
            if (deleteFamily != null && (ts = deleteFamily.getTimestamp()) < this.maxTimestamp) {
                this.minTimestamp = ts + 1L;
            }
        }
    }

    public class RowKeyParser {
        private final RowKeyColumnExpression[] baseTableColExprs;
        private final List<PColumn> baseTablePKColumns;
        private final PColumn[] sharedIndexPKColumns;
        private final boolean isSalted;
        private final boolean isLongViewIndexEnabled;
        private final boolean isMultiTenant;
        private final PDataType tenantDataType;

        public RowKeyParser(PTable table, boolean isLongViewIndexEnabled) {
            int tenantPos;
            this.isLongViewIndexEnabled = isLongViewIndexEnabled;
            this.isSalted = table.getBucketNum() != null;
            this.isMultiTenant = table.isMultiTenant();
            this.tenantDataType = table.getRowKeySchema().getField(this.isSalted ? 1 : 0).getDataType();
            this.baseTablePKColumns = table.getPKColumns();
            this.baseTableColExprs = new RowKeyColumnExpression[this.baseTablePKColumns.size()];
            int saltPos = this.isSalted ? 0 : -1;
            for (int i = 0; i < this.baseTablePKColumns.size(); ++i) {
                PColumn column = this.baseTablePKColumns.get(i);
                this.baseTableColExprs[i] = new RowKeyColumnExpression((PDatum)column, new RowKeyValueAccessor(this.baseTablePKColumns, i));
            }
            this.sharedIndexPKColumns = new PColumn[3];
            if (saltPos == 0) {
                this.sharedIndexPKColumns[saltPos] = this.baseTablePKColumns.get(saltPos);
            }
            int n = tenantPos = this.isMultiTenant ? saltPos + 1 : -1;
            if (tenantPos == 0 || tenantPos == 1) {
                this.sharedIndexPKColumns[tenantPos] = new PColumn(){

                    public PName getName() {
                        return PNameFactory.newName((String)"_INDEX_ID");
                    }

                    public PName getFamilyName() {
                        return null;
                    }

                    public int getPosition() {
                        return tenantPos;
                    }

                    public Integer getArraySize() {
                        return 0;
                    }

                    public byte[] getViewConstant() {
                        return new byte[0];
                    }

                    public boolean isViewReferenced() {
                        return false;
                    }

                    public int getEstimatedSize() {
                        return 0;
                    }

                    public String getExpressionStr() {
                        return "";
                    }

                    public long getTimestamp() {
                        return 0L;
                    }

                    public boolean isDerived() {
                        return false;
                    }

                    public boolean isExcluded() {
                        return false;
                    }

                    public boolean isRowTimestamp() {
                        return false;
                    }

                    public boolean isDynamic() {
                        return false;
                    }

                    public byte[] getColumnQualifierBytes() {
                        return new byte[0];
                    }

                    public boolean isNullable() {
                        return false;
                    }

                    public PDataType getDataType() {
                        return RowKeyParser.this.isLongViewIndexEnabled ? PLong.INSTANCE : PSmallint.INSTANCE;
                    }

                    public Integer getMaxLength() {
                        return 0;
                    }

                    public Integer getScale() {
                        return 0;
                    }

                    public SortOrder getSortOrder() {
                        return SortOrder.ASC;
                    }
                };
                this.sharedIndexPKColumns[tenantPos + 1] = this.baseTablePKColumns.get(tenantPos);
            }
        }

        public PDataType getTenantIdDataType() {
            return this.tenantDataType;
        }

        public List<Integer> parsePKPositions(Cell inputCell) {
            RowKeyComparisonFilter.RowKeyTuple inputTuple = new RowKeyComparisonFilter.RowKeyTuple();
            inputTuple.setKey(inputCell.getRowArray(), inputCell.getRowOffset(), (int)inputCell.getRowLength());
            int lastPos = 0;
            ArrayList<Integer> pkPositions = new ArrayList<Integer>();
            pkPositions.add(lastPos);
            for (int i = 0; i < this.baseTableColExprs.length; ++i) {
                RowKeyColumnExpression expr = this.baseTableColExprs[i];
                ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                expr.evaluate((Tuple)inputTuple, ptr);
                int separatorLength = this.baseTablePKColumns.get(i).getDataType().isFixedWidth() ? 0 : 1;
                int endPos = lastPos + ptr.getLength() + separatorLength;
                pkPositions.add(endPos);
                lastPos = endPos;
            }
            return pkPositions;
        }

        private String getTenantIdFromRowKey(byte[] rowKey) throws SQLException {
            return this.getTenantIdFromRowKey(rowKey, false);
        }

        private String getTenantIdFromRowKey(byte[] rowKey, boolean isSharedIndex) throws SQLException {
            PDataType dataType;
            RowKeyColumnExpression expr;
            if (rowKey != null && ByteUtil.isEmptyOrNull((byte[])rowKey, (int)0, (int)rowKey.length) || !this.isMultiTenant) {
                return "";
            }
            Cell rowKeyCell = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(rowKey).setFamily(CompactionScanner.this.emptyCF).setQualifier(CompactionScanner.this.emptyCQ).setTimestamp(EnvironmentEdgeManager.currentTimeMillis()).setType(Cell.Type.Put).setValue(HConstants.EMPTY_BYTE_ARRAY).build();
            int tenantIdPosition = (this.isSalted ? 1 : 0) + (isSharedIndex ? 1 : 0);
            RowKeyComparisonFilter.RowKeyTuple inputTuple = new RowKeyComparisonFilter.RowKeyTuple();
            if (isSharedIndex) {
                expr = new RowKeyColumnExpression((PDatum)this.sharedIndexPKColumns[tenantIdPosition], new RowKeyValueAccessor(Arrays.asList(this.sharedIndexPKColumns), tenantIdPosition));
                dataType = this.sharedIndexPKColumns[tenantIdPosition].getDataType();
                inputTuple.setKey(rowKeyCell.getRowArray(), rowKeyCell.getRowOffset(), (int)rowKeyCell.getRowLength());
            } else {
                expr = this.baseTableColExprs[tenantIdPosition];
                dataType = this.baseTablePKColumns.get(tenantIdPosition).getDataType();
                inputTuple.setKey(rowKeyCell.getRowArray(), rowKeyCell.getRowOffset(), (int)rowKeyCell.getRowLength());
            }
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            String tenantId = "";
            try {
                expr.evaluate((Tuple)inputTuple, ptr);
                dataType.pad(ptr, expr.getMaxLength(), expr.getSortOrder());
                tenantId = ByteUtil.isEmptyOrNull((byte[])ptr.get(), (int)ptr.getOffset(), (int)ptr.getLength()) ? "" : dataType.toObject(ptr).toString();
            }
            catch (IllegalDataException ex) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.TENANTID_IS_OF_WRONG_TYPE).build().buildException();
            }
            finally {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("TenantId in getTenantIdFromRowKey: {}, {}", (Object)CompactionScanner.this.store.getRegionInfo().getEncodedName(), (Object)tenantId);
                }
            }
            return tenantId;
        }
    }

    private class PartitionedTableRowKeyMatcher {
        private static final int NO_BATCH = -1;
        private boolean isSharedIndex = false;
        private boolean isMultiTenant = false;
        private boolean isSalted = false;
        private boolean shouldBatchCatalogAccess = true;
        private RowKeyParser rowKeyParser;
        private PTable baseTable;
        private RowKeyMatcher globalViewMatcher;
        private RowKeyMatcher tenantViewMatcher;
        private RowKeyMatcher globalIndexMatcher;
        private RowKeyMatcher tenantIndexMatcher;
        private TableTTLInfoCache globalViewTTLCache;
        private TableTTLInfoCache tenantViewTTLCache;
        private TableTTLInfoCache globalIndexTTLCache;
        private TableTTLInfoCache tenantIndexTTLCache;
        private String startTenantId = "";
        private String endTenantId = "";
        private String lastTenantId = "";
        private String currentTenantId = "";
        private int viewTTLTenantViewsPerScanLimit;

        public PartitionedTableRowKeyMatcher(PTable table, boolean isSalted, boolean isSharedIndex, boolean isLongViewIndexEnabled, int viewTTLTenantViewsPerScanLimit) throws SQLException {
            this.baseTable = table;
            this.globalViewTTLCache = new TableTTLInfoCache();
            this.globalIndexTTLCache = new TableTTLInfoCache();
            this.tenantViewTTLCache = new TableTTLInfoCache();
            this.tenantIndexTTLCache = new TableTTLInfoCache();
            this.rowKeyParser = new RowKeyParser(this.baseTable, isLongViewIndexEnabled);
            PDataType tenantIdType = this.rowKeyParser.getTenantIdDataType();
            this.shouldBatchCatalogAccess = tenantIdType.getSqlType() == 12 || tenantIdType.getSqlType() == 1;
            this.isSharedIndex = isSharedIndex || CompactionScanner.this.localIndex;
            this.isSalted = isSalted;
            this.isMultiTenant = table.isMultiTenant();
            this.viewTTLTenantViewsPerScanLimit = viewTTLTenantViewsPerScanLimit;
            this.initializeMatchers();
        }

        private void initializeMatchers() throws SQLException {
            if (this.isSharedIndex) {
                this.globalIndexMatcher = this.initializeMatcher(MatcherType.GLOBAL_INDEXES);
            } else if (this.isMultiTenant) {
                this.globalViewMatcher = this.initializeMatcher(MatcherType.GLOBAL_VIEWS);
                this.tenantViewMatcher = this.initializeMatcher(MatcherType.TENANT_VIEWS);
            } else {
                this.globalViewMatcher = this.initializeMatcher(MatcherType.GLOBAL_VIEWS);
            }
        }

        private RowKeyMatcher initializeMatcher(MatcherType type) throws SQLException {
            List<Object> tableList = null;
            RowKeyMatcher matcher = new RowKeyMatcher();
            String regionName = CompactionScanner.this.region.getRegionInfo().getEncodedName();
            switch (type) {
                case GLOBAL_INDEXES: {
                    tableList = this.getMatchPatternsForGlobalPartitions(this.baseTable.getName().getString(), CompactionScanner.this.env.getConfiguration(), false, true);
                    break;
                }
                case TENANT_INDEXES: {
                    try {
                        this.startTenantId = this.rowKeyParser.getTenantIdFromRowKey(CompactionScanner.this.region.getRegionInfo().getStartKey());
                        this.endTenantId = this.rowKeyParser.getTenantIdFromRowKey(CompactionScanner.this.region.getRegionInfo().getEndKey());
                    }
                    catch (SQLException sqle) {
                        LOGGER.error(sqle.getMessage());
                        throw sqle;
                    }
                    if (this.startTenantId == null || this.startTenantId.isEmpty()) break;
                    tableList = this.getMatchPatternsForTenant(this.baseTable.getName().getString(), CompactionScanner.this.env.getConfiguration(), true, false, regionName, this.startTenantId);
                    break;
                }
                case GLOBAL_VIEWS: {
                    tableList = this.getMatchPatternsForGlobalPartitions(this.baseTable.getName().getString(), CompactionScanner.this.env.getConfiguration(), true, false);
                    break;
                }
                case TENANT_VIEWS: {
                    try {
                        this.startTenantId = this.rowKeyParser.getTenantIdFromRowKey(CompactionScanner.this.region.getRegionInfo().getStartKey());
                        this.endTenantId = this.rowKeyParser.getTenantIdFromRowKey(CompactionScanner.this.region.getRegionInfo().getEndKey());
                    }
                    catch (SQLException sqle) {
                        LOGGER.error(sqle.getMessage());
                        throw sqle;
                    }
                    if (this.shouldBatchCatalogAccess) {
                        tableList = this.getMatchPatternsForTenantBatch(this.baseTable.getName().getString(), CompactionScanner.this.env.getConfiguration(), regionName, this.startTenantId, this.viewTTLTenantViewsPerScanLimit);
                        break;
                    }
                    if (this.startTenantId == null || this.startTenantId.isEmpty()) break;
                    tableList = this.getMatchPatternsForTenant(this.baseTable.getName().getString(), CompactionScanner.this.env.getConfiguration(), true, false, regionName, this.startTenantId);
                    break;
                }
                default: {
                    tableList = new ArrayList();
                }
            }
            if (tableList != null && !tableList.isEmpty()) {
                tableList.forEach(m -> {
                    if (!m.getTTL().equals(LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED)) {
                        int tableId = -1;
                        switch (type) {
                            case GLOBAL_INDEXES: {
                                tableId = this.globalIndexTTLCache.addTable(m);
                                break;
                            }
                            case TENANT_INDEXES: {
                                tableId = this.tenantIndexTTLCache.addTable(m);
                                break;
                            }
                            case GLOBAL_VIEWS: {
                                tableId = this.globalViewTTLCache.addTable(m);
                                break;
                            }
                            case TENANT_VIEWS: {
                                tableId = this.tenantViewTTLCache.addTable(m);
                            }
                        }
                        matcher.put(m.getMatchPattern(), tableId);
                        LOGGER.debug("Matcher updated (init) {} : {}", (Object)type.toString(), m);
                    }
                });
            }
            LOGGER.debug(String.format("Initialized matcher for type r=%s, t=%s :- s=%s, e=%s, c=%s, l=%s", new Object[]{regionName, type, this.startTenantId, this.endTenantId, this.currentTenantId, this.lastTenantId}));
            return matcher;
        }

        private void refreshMatcher(MatcherType type) throws SQLException {
            List<TableTTLInfo> tableList = null;
            String regionName = CompactionScanner.this.region.getRegionInfo().getEncodedName();
            int catalogAccessBatchSize = -1;
            switch (type) {
                case TENANT_INDEXES: {
                    this.tenantIndexMatcher = new RowKeyMatcher();
                    this.tenantIndexTTLCache = new TableTTLInfoCache();
                    if (this.currentTenantId == null || this.currentTenantId.isEmpty()) break;
                    tableList = this.getMatchPatternsForTenant(this.baseTable.getName().getString(), CompactionScanner.this.env.getConfiguration(), false, true, regionName, this.currentTenantId);
                    break;
                }
                case TENANT_VIEWS: {
                    this.tenantViewMatcher = new RowKeyMatcher();
                    this.tenantViewTTLCache = new TableTTLInfoCache();
                    if (this.shouldBatchCatalogAccess) {
                        tableList = this.getMatchPatternsForTenantBatch(this.baseTable.getName().getString(), CompactionScanner.this.env.getConfiguration(), regionName, this.currentTenantId, this.viewTTLTenantViewsPerScanLimit);
                        break;
                    }
                    if (this.currentTenantId == null || this.currentTenantId.isEmpty()) break;
                    tableList = this.getMatchPatternsForTenant(this.baseTable.getName().getString(), CompactionScanner.this.env.getConfiguration(), true, false, regionName, this.currentTenantId);
                    break;
                }
                default: {
                    throw new SQLException("Refresh for type " + type.toString() + " is not supported");
                }
            }
            if (tableList != null && !tableList.isEmpty()) {
                tableList.forEach(m -> {
                    if (!m.getTTL().equals(LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED)) {
                        int tableId = -1;
                        switch (type) {
                            case TENANT_INDEXES: {
                                tableId = this.tenantIndexTTLCache.addTable(m);
                                this.tenantIndexMatcher.put(m.getMatchPattern(), tableId);
                                break;
                            }
                            case TENANT_VIEWS: {
                                tableId = this.tenantViewTTLCache.addTable(m);
                                this.tenantViewMatcher.put(m.getMatchPattern(), tableId);
                            }
                        }
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("Refreshed matcher for type (updated) {}, {} : {}", new Object[]{regionName, type.toString(), m});
                        }
                    }
                });
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Refreshed matcher for type  r={}, t={}:- rs={}, re={}, s={}, e={}, c={}, l={}", new Object[]{regionName, type, Bytes.toStringBinary((byte[])CompactionScanner.this.region.getRegionInfo().getStartKey()), Bytes.toStringBinary((byte[])CompactionScanner.this.region.getRegionInfo().getEndKey()), this.startTenantId, this.endTenantId, this.currentTenantId, this.lastTenantId});
                }
            }
        }

        private TableTTLInfo match(byte[] rowkey, int offset, MatcherType matcherType) throws SQLException {
            TableTTLInfo tableTTLInfo;
            Integer tableId = null;
            TableTTLInfoCache tableTTLInfoCache = null;
            RowKeyMatcher matcher = null;
            if (this.isSharedIndex && matcherType.compareTo(MatcherType.TENANT_INDEXES) == 0) {
                this.currentTenantId = this.rowKeyParser.getTenantIdFromRowKey(rowkey, true);
                if (Bytes.BYTES_COMPARATOR.compare(Bytes.toBytes((String)this.currentTenantId), Bytes.toBytes((String)this.lastTenantId)) != 0) {
                    this.refreshMatcher(MatcherType.TENANT_INDEXES);
                }
                matcher = this.tenantIndexMatcher;
                tableTTLInfoCache = this.tenantIndexTTLCache;
            } else if (this.isSharedIndex && matcherType.compareTo(MatcherType.GLOBAL_INDEXES) == 0) {
                matcher = this.globalIndexMatcher;
                tableTTLInfoCache = this.globalIndexTTLCache;
            } else if (this.isMultiTenant && matcherType.compareTo(MatcherType.TENANT_VIEWS) == 0) {
                this.currentTenantId = this.rowKeyParser.getTenantIdFromRowKey(rowkey);
                if (this.shouldBatchCatalogAccess && Bytes.BYTES_COMPARATOR.compare(Bytes.toBytes((String)this.currentTenantId), Bytes.toBytes((String)this.lastTenantId)) > 0 || !this.shouldBatchCatalogAccess && Bytes.BYTES_COMPARATOR.compare(Bytes.toBytes((String)this.currentTenantId), Bytes.toBytes((String)this.lastTenantId)) != 0) {
                    this.refreshMatcher(MatcherType.TENANT_VIEWS);
                }
                matcher = this.tenantViewMatcher;
                tableTTLInfoCache = this.tenantViewTTLCache;
            } else if (matcherType.compareTo(MatcherType.GLOBAL_VIEWS) == 0) {
                matcher = this.globalViewMatcher;
                tableTTLInfoCache = this.globalViewTTLCache;
            } else {
                matcher = null;
                tableTTLInfoCache = null;
            }
            tableId = matcher != null ? matcher.match(rowkey, offset) : null;
            TableTTLInfo tableTTLInfo2 = tableTTLInfo = tableTTLInfoCache != null ? tableTTLInfoCache.getTableById(tableId) : null;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("Matched matcher for type r=%s, t=%s, r=%s:- s=%s, e=%s, c=%s, l=%s", new Object[]{CompactionScanner.this.region.getRegionInfo().getEncodedName(), matcherType, Bytes.toStringBinary((byte[])rowkey), this.startTenantId, this.endTenantId, this.currentTenantId, this.lastTenantId}));
            }
            return tableTTLInfo;
        }

        private List<TableTTLInfo> getMatchPatternsForGlobalPartitions(String physicalTableName, Configuration configuration, boolean globalViews, boolean globalIndexes) throws SQLException {
            Set<TableInfo> globalViewSet;
            ArrayList tableTTLInfoList = Lists.newArrayList();
            if ((globalViews || globalIndexes) && (globalViewSet = this.getGlobalViews(physicalTableName, configuration)).size() > 0) {
                this.getTTLInfo(physicalTableName, globalViewSet, configuration, globalIndexes, tableTTLInfoList);
            }
            return tableTTLInfoList;
        }

        private List<TableTTLInfo> getMatchPatternsForTenantBatch(String physicalTableName, Configuration configuration, String regionName, String startTenantId, int batchSize) throws SQLException {
            ArrayList tableTTLInfoList = Lists.newArrayList();
            Set<TableInfo> tenantViewSet = this.getNextTenantViews(physicalTableName, configuration, regionName, startTenantId, batchSize);
            if (tenantViewSet.size() > 0) {
                this.getTTLInfo(physicalTableName, tenantViewSet, configuration, false, tableTTLInfoList);
            }
            return tableTTLInfoList;
        }

        private List<TableTTLInfo> getMatchPatternsForTenant(String physicalTableName, Configuration configuration, boolean tenantViews, boolean tenantIndexes, String regionName, String tenantId) throws SQLException {
            Set<TableInfo> tenantViewSet;
            ArrayList tableTTLInfoList = Lists.newArrayList();
            if ((tenantViews || tenantIndexes) && (tenantViewSet = this.getNextTenantViews(physicalTableName, configuration, regionName, tenantId, -1)).size() > 0) {
                this.getTTLInfo(physicalTableName, tenantViewSet, configuration, tenantIndexes, tableTTLInfoList);
            }
            return tableTTLInfoList;
        }

        private Set<TableInfo> getGlobalViews(String physicalTableName, Configuration configuration) throws SQLException {
            HashSet<TableInfo> globalViewSet = new HashSet<TableInfo>();
            try (Connection serverConnection = QueryUtil.getConnectionOnServer((Properties)new Properties(), (Configuration)configuration);){
                String globalViewsSQLFormat = "SELECT TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME AS PHYSICAL_TABLE_TENANT_ID, COLUMN_FAMILY AS PHYSICAL_TABLE_FULL_NAME FROM SYSTEM.CATALOG WHERE LINK_TYPE = 2 AND TABLE_TYPE IS NULL AND COLUMN_FAMILY = '%s' AND TENANT_ID IS NULL";
                String globalViewSQL = String.format(globalViewsSQLFormat, physicalTableName);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("globalViewSQL: {}", (Object)globalViewSQL);
                }
                try (PhoenixPreparedStatement globalViewStmt = serverConnection.prepareStatement(globalViewSQL).unwrap(PhoenixPreparedStatement.class);
                     ResultSet globalViewRS = globalViewStmt.executeQuery();){
                    while (globalViewRS.next()) {
                        String tid = globalViewRS.getString("TENANT_ID");
                        String schem = globalViewRS.getString("TABLE_SCHEM");
                        String tName = globalViewRS.getString("TABLE_NAME");
                        String tenantId = tid == null || tid.isEmpty() ? "NULL" : "'" + tid + "'";
                        String schemCol = schem == null || schem.isEmpty() ? "NULL" : "'" + schem + "'";
                        TableInfo tableInfo = new TableInfo(tenantId.getBytes(), schemCol.getBytes(), tName.getBytes());
                        globalViewSet.add(tableInfo);
                    }
                }
            }
            return globalViewSet;
        }

        private Set<TableInfo> getNextTenantViews(String physicalTableName, Configuration configuration, String regionName, String fromTenantId, int batchSize) throws SQLException {
            HashSet<TableInfo> tenantViewSet = new HashSet<TableInfo>();
            try (Connection serverConnection = QueryUtil.getConnectionOnServer((Properties)new Properties(), (Configuration)configuration);){
                Object tenantViewsSQLFormat = "SELECT TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME AS PHYSICAL_TABLE_TENANT_ID, COLUMN_FAMILY AS PHYSICAL_TABLE_FULL_NAME FROM SYSTEM.CATALOG WHERE LINK_TYPE = 2 AND COLUMN_FAMILY = '%s' AND TENANT_ID IS NOT NULL ";
                tenantViewsSQLFormat = batchSize <= 0 ? (String)tenantViewsSQLFormat + (fromTenantId != null && fromTenantId.length() > 0 ? "AND TENANT_ID = ? " : "") : (String)tenantViewsSQLFormat + (String)(fromTenantId != null && fromTenantId.length() > 0 ? "AND TENANT_ID >= ? LIMIT " + batchSize : "");
                String tenantViewSQL = String.format((String)tenantViewsSQLFormat, physicalTableName);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(String.format("tenantViewSQL region-name = %s, start-tenant-id = %s, batch = %d, sql = %s ", regionName, fromTenantId, batchSize, tenantViewSQL));
                }
                try (PhoenixPreparedStatement tenantViewStmt = serverConnection.prepareStatement(tenantViewSQL).unwrap(PhoenixPreparedStatement.class);){
                    int paramPos = 1;
                    if (fromTenantId != null && fromTenantId.length() > 0) {
                        tenantViewStmt.setString(paramPos, fromTenantId);
                    }
                    try (ResultSet tenantViewRS = tenantViewStmt.executeQuery();){
                        while (tenantViewRS.next()) {
                            String tid = tenantViewRS.getString("TENANT_ID");
                            String schem = tenantViewRS.getString("TABLE_SCHEM");
                            String tName = tenantViewRS.getString("TABLE_NAME");
                            String tenantId = tid == null || tid.isEmpty() ? "NULL" : "'" + tid + "'";
                            String schemCol = schem == null || schem.isEmpty() ? "NULL" : "'" + schem + "'";
                            TableInfo tableInfo = new TableInfo(tenantId.getBytes(), schemCol.getBytes(), tName.getBytes());
                            this.lastTenantId = tid == null || tid.isEmpty() ? "" : tid;
                            tenantViewSet.add(tableInfo);
                        }
                    }
                }
            }
            return tenantViewSet;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void getTTLInfo(String physicalTableName, Set<TableInfo> viewSet, Configuration configuration, boolean isSharedIndex, List<TableTTLInfo> tableTTLInfoList) throws SQLException {
            if (viewSet.size() == 0) {
                return;
            }
            String viewsClause = viewSet.stream().map(v -> String.format("(%s, %s,'%s')", Bytes.toString((byte[])v.getTenantId()), Bytes.toString((byte[])v.getSchemaName()), Bytes.toString((byte[])v.getTableName()))).collect(Collectors.joining(","));
            String viewsWithTTLSQL = "SELECT TENANT_ID, TABLE_SCHEM, TABLE_NAME, TTL, ROW_KEY_MATCHER FROM SYSTEM.CATALOG WHERE TABLE_TYPE = 'v' AND (TENANT_ID, TABLE_SCHEM, TABLE_NAME) IN (" + viewsClause.toString() + ")";
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("ViewsWithTTLSQL : %s", viewsWithTTLSQL));
            }
            try (Connection serverConnection = QueryUtil.getConnectionOnServer((Properties)new Properties(), (Configuration)configuration);
                 PhoenixPreparedStatement viewTTLStmt = serverConnection.prepareStatement(viewsWithTTLSQL).unwrap(PhoenixPreparedStatement.class);
                 ResultSet viewTTLRS = viewTTLStmt.executeQuery();){
                block25: while (viewTTLRS.next()) {
                    LiteralTTLExpression compiledExpr;
                    String tid = viewTTLRS.getString("TENANT_ID");
                    String schem = viewTTLRS.getString("TABLE_SCHEM");
                    String tName = viewTTLRS.getString("TABLE_NAME");
                    String viewTTLStr = viewTTLRS.getString("TTL");
                    LiteralTTLExpression viewTTL = viewTTLStr == null || viewTTLStr.isEmpty() ? LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED : TTLExpressionFactory.create((String)viewTTLStr);
                    byte[] rowKeyMatcher = viewTTLRS.getBytes("ROW_KEY_MATCHER");
                    byte[] tenantIdBytes = tid == null || tid.isEmpty() ? ByteUtil.EMPTY_BYTE_ARRAY : tid.getBytes();
                    String fullTableName = SchemaUtil.getTableName((String)schem, (String)tName);
                    Properties tenantProps = new Properties();
                    if (tid != null) {
                        tenantProps.setProperty("TenantId", tid);
                    }
                    if (isSharedIndex) {
                        Connection tableConnection = QueryUtil.getConnectionOnServer((Properties)tenantProps, (Configuration)configuration);
                        try {
                            PTable pTable = PhoenixRuntime.getTableNoCache((Connection)tableConnection, (String)fullTableName);
                            Iterator iterator = pTable.getIndexes().iterator();
                            while (true) {
                                if (!iterator.hasNext()) continue block25;
                                PTable index = (PTable)iterator.next();
                                if (index.getViewIndexId() == null) continue;
                                PDataType viewIndexIdType = index.getviewIndexIdType();
                                byte[] viewIndexIdBytes = PSmallint.INSTANCE.toBytes((Object)index.getViewIndexId());
                                if (viewIndexIdType.compareTo((PDataType)PLong.INSTANCE) == 0) {
                                    viewIndexIdBytes = PLong.INSTANCE.toBytes((Object)index.getViewIndexId());
                                }
                                PhoenixConnection pcon = tableConnection.unwrap(PhoenixConnection.class);
                                CompiledTTLExpression indexTTL = index.getCompiledTTLExpression(pcon);
                                tableTTLInfoList.add(new TableTTLInfo(pTable.getPhysicalName().getBytes(), tenantIdBytes, index.getTableName().getBytes(), viewIndexIdBytes, indexTTL));
                            }
                        }
                        finally {
                            if (tableConnection == null) continue;
                            tableConnection.close();
                            continue;
                        }
                    }
                    if (viewTTL instanceof ConditionalTTLExpression) {
                        try (Connection tableConnection = QueryUtil.getConnectionOnServer((Properties)tenantProps, (Configuration)configuration);){
                            PTable pTable = PhoenixRuntime.getTableNoCache((Connection)tableConnection, (String)fullTableName);
                            compiledExpr = pTable.getCompiledTTLExpression(tableConnection.unwrap(PhoenixConnection.class));
                        }
                    } else {
                        compiledExpr = viewTTL;
                    }
                    tableTTLInfoList.add(new TableTTLInfo(physicalTableName.getBytes(), tenantIdBytes, fullTableName.getBytes(), rowKeyMatcher, (CompiledTTLExpression)compiledExpr));
                }
                return;
            }
        }

        public boolean isSharedIndex() {
            return this.isSharedIndex;
        }

        public boolean isMultiTenant() {
            return this.isMultiTenant;
        }

        public boolean isSalted() {
            return this.isSalted;
        }

        public RowKeyParser getRowKeyParser() {
            return this.rowKeyParser;
        }

        public PTable getBaseTable() {
            return this.baseTable;
        }

        public RowKeyMatcher getGlobalViewMatcher() {
            return this.globalViewMatcher;
        }

        public RowKeyMatcher getTenantViewMatcher() {
            return this.tenantViewMatcher;
        }

        public RowKeyMatcher getGlobalIndexMatcher() {
            return this.globalIndexMatcher;
        }

        public RowKeyMatcher getTenantIndexMatcher() {
            return this.tenantIndexMatcher;
        }

        public TableTTLInfoCache getGlobalViewTTLCache() {
            return this.globalViewTTLCache;
        }

        public TableTTLInfoCache getTenantViewTTLCache() {
            return this.tenantViewTTLCache;
        }

        public TableTTLInfoCache getGlobalIndexTTLCache() {
            return this.globalIndexTTLCache;
        }

        public TableTTLInfoCache getTenantIndexTTLCache() {
            return this.tenantIndexTTLCache;
        }

        public int getNumGlobalEntries() {
            return this.globalViewMatcher == null ? 0 : this.globalViewMatcher.getNumEntries();
        }

        public int getNumTenantEntries() {
            return this.tenantViewMatcher == null ? 0 : this.tenantViewMatcher.getNumEntries();
        }

        public int getNumGlobalIndexEntries() {
            return this.globalIndexMatcher == null ? 0 : this.globalIndexMatcher.getNumEntries();
        }

        public int getNumTenantIndexEntries() {
            return this.tenantIndexMatcher == null ? 0 : this.tenantIndexMatcher.getNumEntries();
        }

        public int getNumTablesInGlobalCache() {
            return this.globalViewTTLCache == null ? 0 : this.globalViewTTLCache.getNumTablesInCache();
        }

        public int getNumTablesInTenantCache() {
            return this.tenantViewTTLCache == null ? 0 : this.tenantViewTTLCache.getNumTablesInCache();
        }

        public int getNumTablesInGlobalIndexCache() {
            return this.globalIndexTTLCache == null ? 0 : this.globalIndexTTLCache.getNumTablesInCache();
        }

        public int getNumTablesInTenantIndexCache() {
            return this.tenantIndexTTLCache == null ? 0 : this.tenantIndexTTLCache.getNumTablesInCache();
        }

        public int getNumTablesInCache() {
            int totalNumTables = 0;
            totalNumTables += this.globalViewTTLCache == null ? 0 : this.globalViewTTLCache.getNumTablesInCache();
            totalNumTables += this.tenantViewTTLCache == null ? 0 : this.tenantViewTTLCache.getNumTablesInCache();
            totalNumTables += this.globalIndexTTLCache == null ? 0 : this.globalIndexTTLCache.getNumTablesInCache();
            return totalNumTables += this.tenantIndexTTLCache == null ? 0 : this.tenantIndexTTLCache.getNumTablesInCache();
        }
    }

    static enum MatcherType {
        GLOBAL_VIEWS,
        GLOBAL_INDEXES,
        TENANT_VIEWS,
        TENANT_INDEXES;

    }
}

