/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.ExtendedCellBuilder;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.coprocessor.ColumnMutator;
import org.apache.phoenix.coprocessor.MetaDataEndpointImpl;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.UpgradeUtil;
import org.apache.phoenix.util.ViewUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddColumnMutator
implements ColumnMutator {
    private static final Logger logger = LoggerFactory.getLogger(AddColumnMutator.class);

    private int getInteger(Put p, byte[] family, byte[] qualifier) {
        List cells = p.get(family, qualifier);
        if (cells != null && cells.size() > 0) {
            Cell cell = (Cell)cells.get(0);
            return (Integer)PInteger.INSTANCE.toObject(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
        }
        return 0;
    }

    @Override
    public ColumnMutator.MutateColumnType getMutateColumnType() {
        return ColumnMutator.MutateColumnType.ADD_COLUMN;
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult validateWithChildViews(PTable table, List<PTable> childViews, List<Mutation> tableMetadata, byte[] schemaName, byte[] tableName) throws SQLException {
        if (!childViews.isEmpty() && this.switchAttribute(table.isMultiTenant(), tableMetadata, PhoenixDatabaseMetaData.MULTI_TENANT_BYTES)) {
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), null);
        }
        ArrayList columnPutsForBaseTable = Lists.newArrayListWithExpectedSize((int)tableMetadata.size());
        boolean salted = table.getBucketNum() != null;
        for (Mutation m : tableMetadata) {
            if (!(m instanceof Put)) continue;
            byte[][] rkmd = new byte[5][];
            int pkCount = SchemaUtil.getVarChars((byte[])m.getRow(), (byte[][])rkmd);
            if (pkCount <= 3 || rkmd[3] == null || rkmd[3].length <= 0 || Bytes.compareTo((byte[])schemaName, (byte[])rkmd[1]) != 0 || Bytes.compareTo((byte[])tableName, (byte[])rkmd[2]) != 0) continue;
            columnPutsForBaseTable.add((Put)m);
        }
        for (PTable view : childViews) {
            if (!columnPutsForBaseTable.isEmpty() && view.isAppendOnlySchema()) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), null);
            }
            ArrayList viewPkCols = new ArrayList(view.getPKColumns());
            if (salted) {
                viewPkCols.remove(0);
            }
            viewPkCols.removeAll(table.getPKColumns());
            boolean addedPkColumn = false;
            for (Put columnToBeAdded : columnPutsForBaseTable) {
                PColumn existingViewColumn = null;
                byte[][] rkmd = new byte[5][];
                SchemaUtil.getVarChars((byte[])columnToBeAdded.getRow(), (byte[][])rkmd);
                String columnName = Bytes.toString((byte[])rkmd[3]);
                String columnFamily = rkmd[4] == null ? null : Bytes.toString((byte[])rkmd[4]);
                try {
                    existingViewColumn = columnFamily == null ? view.getColumnForColumnName(columnName) : view.getColumnFamily(columnFamily).getPColumnForColumnName(columnName);
                }
                catch (ColumnFamilyNotFoundException columnFamilyNotFoundException) {
                }
                catch (ColumnNotFoundException columnNotFoundException) {
                    // empty catch block
                }
                boolean isCurrColumnToBeAddPkCol = columnFamily == null;
                addedPkColumn |= isCurrColumnToBeAddPkCol;
                if (existingViewColumn != null) {
                    List keySeqCells;
                    int existingScale;
                    int existingMaxLength;
                    if (EncodedColumnsUtil.usesEncodedColumnNames((PTable)table) && !SchemaUtil.isPKColumn((PColumn)existingViewColumn)) {
                        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), table);
                    }
                    int baseColumnDataType = this.getInteger(columnToBeAdded, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TYPE_BYTES);
                    if (baseColumnDataType != existingViewColumn.getDataType().getSqlType()) {
                        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), table);
                    }
                    int maxLength = this.getInteger(columnToBeAdded, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.COLUMN_SIZE_BYTES);
                    int n = existingMaxLength = existingViewColumn.getMaxLength() == null ? 0 : existingViewColumn.getMaxLength();
                    if (maxLength != existingMaxLength) {
                        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), table);
                    }
                    int scale = this.getInteger(columnToBeAdded, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DECIMAL_DIGITS_BYTES);
                    int n2 = existingScale = existingViewColumn.getScale() == null ? 0 : existingViewColumn.getScale();
                    if (scale != existingScale) {
                        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), table);
                    }
                    int sortOrder = this.getInteger(columnToBeAdded, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.SORT_ORDER_BYTES);
                    if (sortOrder != existingViewColumn.getSortOrder().getSystemValue()) {
                        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), table);
                    }
                    if (isCurrColumnToBeAddPkCol && (keySeqCells = columnToBeAdded.get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.KEY_SEQ_BYTES)) != null && keySeqCells.size() > 0) {
                        Cell cell = (Cell)keySeqCells.get(0);
                        int keySeq = PSmallint.INSTANCE.getCodec().decodeInt(cell.getValueArray(), cell.getValueOffset(), SortOrder.getDefault());
                        int pkPosition = SchemaUtil.getPKPosition((PTable)view, (PColumn)existingViewColumn) + 1 - (salted ? 1 : 0);
                        if (pkPosition != keySeq) {
                            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), table);
                        }
                    }
                }
                if (existingViewColumn == null || !isCurrColumnToBeAddPkCol) continue;
                viewPkCols.remove(existingViewColumn);
            }
            if (!addedPkColumn || viewPkCols.isEmpty()) continue;
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), table);
        }
        return null;
    }

    private boolean switchAttribute(boolean currAttribute, List<Mutation> tableMetaData, byte[] attrQualifier) {
        for (Mutation m : tableMetaData) {
            Put p;
            List cells;
            if (!(m instanceof Put) || (cells = (p = (Put)m).get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, attrQualifier)) == null || cells.size() <= 0) continue;
            Cell cell = (Cell)cells.get(0);
            boolean newAttribute = (Boolean)PBoolean.INSTANCE.toObject(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            return currAttribute != newAttribute;
        }
        return false;
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult validateAndAddMetadata(PTable table, byte[][] rowKeyMetaData, List<Mutation> tableMetaData, Region region, List<ImmutableBytesPtr> invalidateList, List<Region.RowLock> locks, long clientTimeStamp, long clientVersion, ExtendedCellBuilder extendedCellBuilder, boolean isAddingColumns) {
        byte[] tenantId = rowKeyMetaData[0];
        byte[] schemaName = rowKeyMetaData[1];
        byte[] tableName = rowKeyMetaData[2];
        PTableType type = table.getType();
        byte[] tableHeaderRowKey = SchemaUtil.getTableKey((byte[])tenantId, (byte[])schemaName, (byte[])tableName);
        ArrayList additionalTableMetadataMutations = Lists.newArrayListWithExpectedSize((int)2);
        boolean addingCol = false;
        for (Mutation m : tableMetaData) {
            byte[] key = m.getRow();
            boolean addingPKColumn = false;
            int pkCount = SchemaUtil.getVarChars((byte[])key, (byte[][])rowKeyMetaData);
            if (pkCount > 3 && Bytes.compareTo((byte[])schemaName, (byte[])rowKeyMetaData[1]) == 0 && Bytes.compareTo((byte[])tableName, (byte[])rowKeyMetaData[2]) == 0) {
                try {
                    addingCol = true;
                    byte[] familyName = null;
                    byte[] colName = null;
                    if (pkCount > 4) {
                        familyName = rowKeyMetaData[4];
                    }
                    if (pkCount > 3) {
                        colName = rowKeyMetaData[3];
                    }
                    if (table.getExcludedColumns().contains(PColumnImpl.createExcludedColumn((PName)MetaDataEndpointImpl.newPName(familyName), (PName)MetaDataEndpointImpl.newPName(colName), (Long)0L))) {
                        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), null);
                    }
                    if (familyName != null && familyName.length > 0) {
                        MetaDataProtocol.MetaDataMutationResult result = this.compareWithPkColumns(colName, table, familyName);
                        if (result != null) {
                            return result;
                        }
                        PColumnFamily family = table.getColumnFamily(familyName);
                        family.getPColumnForColumnNameBytes(colName);
                    } else {
                        if (colName == null || colName.length <= 0) continue;
                        addingPKColumn = true;
                        table.getPKColumn(Bytes.toString((byte[])colName));
                    }
                    return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.COLUMN_ALREADY_EXISTS, EnvironmentEdgeManager.currentTimeMillis(), table);
                }
                catch (ColumnFamilyNotFoundException e) {
                    continue;
                }
                catch (ColumnNotFoundException e) {
                    if (!addingPKColumn) continue;
                    if (table.rowKeyOrderOptimizable()) {
                        UpgradeUtil.addRowKeyOrderOptimizableCell((List)additionalTableMetadataMutations, (byte[])tableHeaderRowKey, (long)clientTimeStamp);
                    } else if (table.getType() == PTableType.VIEW) {
                        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), null);
                    }
                    for (PTable index : table.getIndexes()) {
                        invalidateList.add(new ImmutableBytesPtr(SchemaUtil.getTableKey((byte[])tenantId, (byte[])index.getSchemaName().getBytes(), (byte[])index.getTableName().getBytes())));
                        if (!index.rowKeyOrderOptimizable()) continue;
                        byte[] indexHeaderRowKey = SchemaUtil.getTableKey((byte[])(index.getTenantId() == null ? ByteUtil.EMPTY_BYTE_ARRAY : index.getTenantId().getBytes()), (byte[])index.getSchemaName().getBytes(), (byte[])index.getTableName().getBytes());
                        UpgradeUtil.addRowKeyOrderOptimizableCell((List)additionalTableMetadataMutations, (byte[])indexHeaderRowKey, (long)clientTimeStamp);
                    }
                    continue;
                }
            }
            if (pkCount != 3 || Bytes.compareTo((byte[])schemaName, (byte[])rowKeyMetaData[1]) == 0 && Bytes.compareTo((byte[])tableName, (byte[])rowKeyMetaData[2]) == 0) continue;
            invalidateList.add(new ImmutableBytesPtr(SchemaUtil.getTableKey((byte[])tenantId, (byte[])rowKeyMetaData[1], (byte[])rowKeyMetaData[2])));
        }
        long serverTimestamp = EnvironmentEdgeManager.currentTimeMillis();
        if (MetaDataUtil.isTableDirectlyQueried((PTableType)table.getType())) {
            additionalTableMetadataMutations.add(MetaDataUtil.getLastDDLTimestampUpdate((byte[])tableHeaderRowKey, (long)clientTimeStamp, (long)serverTimestamp));
        }
        tableMetaData.addAll(additionalTableMetadataMutations);
        if (type == PTableType.VIEW) {
            if (EncodedColumnsUtil.usesEncodedColumnNames((PTable)table) && addingCol && !table.isAppendOnlySchema()) {
                invalidateList.add(new ImmutableBytesPtr(MetaDataUtil.getPhysicalTableRowForView((PTable)table)));
            }
            ViewUtil.addTagsToPutsForViewAlteredProperties(tableMetaData, null, (ExtendedCellBuilder)extendedCellBuilder);
        }
        return null;
    }

    private MetaDataProtocol.MetaDataMutationResult compareWithPkColumns(byte[] colName, PTable table, byte[] familyName) {
        if (Bytes.compareTo((byte[])familyName, (byte[])QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES) == 0 && colName != null && colName.length > 0) {
            for (PColumn pColumn : table.getPKColumns()) {
                if (Bytes.compareTo((byte[])pColumn.getName().getBytes(), (byte[])colName) != 0) continue;
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.COLUMN_ALREADY_EXISTS, EnvironmentEdgeManager.currentTimeMillis(), table);
            }
        }
        return null;
    }

    @Override
    public List<Pair<PTable, PColumn>> getTableAndDroppedColumnPairs() {
        return Collections.emptyList();
    }
}

