/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.BaseDecoder;
import org.apache.hadoop.hbase.codec.BaseEncoder;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.regionserver.wal.BinaryCompatibleBaseDecoder;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.hbase.index.wal.IndexedKeyValue;
import org.apache.phoenix.hbase.index.wal.KeyValueCodec;
import org.apache.phoenix.util.PhoenixKeyValueUtil;

public class IndexedWALEditCodec
extends WALCellCodec {
    private static final int REGULAR_KEY_VALUE_MARKER = 0;
    private CompressionContext compression;
    private static final int MIN_BINARY_COMPATIBLE_INDEX_CODEC_VERSION = VersionUtil.encodeVersion((String)"1", (String)"1", (String)"3");
    private final boolean useDefaultDecoder;

    private static boolean isUseDefaultDecoder() {
        String hbaseVersion = VersionInfo.getVersion();
        return VersionUtil.encodeVersion((String)hbaseVersion) >= MIN_BINARY_COMPATIBLE_INDEX_CODEC_VERSION;
    }

    public IndexedWALEditCodec() {
        this.compression = null;
        this.useDefaultDecoder = IndexedWALEditCodec.isUseDefaultDecoder();
    }

    public IndexedWALEditCodec(Configuration conf, CompressionContext compression) {
        super(conf, compression);
        this.compression = compression;
        this.useDefaultDecoder = IndexedWALEditCodec.isUseDefaultDecoder();
    }

    public Codec.Decoder getDecoder(InputStream is) {
        if (this.compression == null) {
            return this.useDefaultDecoder ? new IndexKeyValueDecoder(is) : new BinaryCompatibleIndexKeyValueDecoder(is);
        }
        Codec.Decoder decoder = super.getDecoder(is);
        return this.useDefaultDecoder ? new CompressedIndexKeyValueDecoder(is, decoder) : new BinaryCompatibleCompressedIndexKeyValueDecoder(is, decoder);
    }

    public Codec.Encoder getEncoder(OutputStream os) {
        if (this.compression == null) {
            return new IndexKeyValueEncoder(os);
        }
        Codec.Encoder encoder = super.getEncoder(os);
        return new CompressedIndexKeyValueEncoder(os, encoder);
    }

    private static DataInput getDataInput(InputStream is) {
        return is instanceof DataInput ? (DataInput)((Object)is) : new DataInputStream(is);
    }

    private static DataOutput getDataOutput(OutputStream os) {
        return os instanceof DataOutput ? (DataOutput)((Object)os) : new DataOutputStream(os);
    }

    public static class IndexKeyValueDecoder
    extends PhoenixBaseDecoder {
        public IndexKeyValueDecoder(InputStream is) {
            super(is);
        }

        protected KeyValue parseCell() throws IOException {
            return KeyValueCodec.readKeyValue(this.dataInput);
        }
    }

    private static class BinaryCompatibleIndexKeyValueDecoder
    extends BinaryCompatiblePhoenixBaseDecoder {
        public BinaryCompatibleIndexKeyValueDecoder(InputStream is) {
            super(is);
        }

        protected KeyValue parseCell() throws IOException {
            return KeyValueCodec.readKeyValue(this.dataInput);
        }
    }

    public static class CompressedIndexKeyValueDecoder
    extends PhoenixBaseDecoder {
        private Codec.Decoder decoder;

        public CompressedIndexKeyValueDecoder(InputStream is, Codec.Decoder compressedDecoder) {
            super(is);
            this.decoder = compressedDecoder;
        }

        protected Cell parseCell() throws IOException {
            int marker = this.in.read();
            if (marker < 0) {
                throw new EOFException("Unexepcted end of stream found while reading next (Indexed) KeyValue");
            }
            if (marker == 0) {
                if (!this.decoder.advance()) {
                    throw new IOException("Could not read next key-value from generic KeyValue Decoder!");
                }
                return this.decoder.current();
            }
            return KeyValueCodec.readKeyValue(this.dataInput);
        }
    }

    private static class BinaryCompatibleCompressedIndexKeyValueDecoder
    extends BinaryCompatiblePhoenixBaseDecoder {
        private Codec.Decoder decoder;

        public BinaryCompatibleCompressedIndexKeyValueDecoder(InputStream is, Codec.Decoder compressedDecoder) {
            super(is);
            this.decoder = compressedDecoder;
        }

        @Override
        protected Cell parseCell() throws IOException {
            int marker = this.in.read();
            if (marker < 0) {
                throw new EOFException("Unexepcted end of stream found while reading next (Indexed) KeyValue");
            }
            if (marker == 0) {
                if (!this.decoder.advance()) {
                    throw new IOException("Could not read next key-value from generic KeyValue Decoder!");
                }
                return this.decoder.current();
            }
            return KeyValueCodec.readKeyValue(this.dataInput);
        }
    }

    private static class IndexKeyValueEncoder
    extends PhoenixBaseEncoder {
        public IndexKeyValueEncoder(OutputStream os) {
            super(os);
        }

        public void flush() throws IOException {
            super.flush();
        }

        public void write(Cell cell) throws IOException {
            this.checkFlushed();
            KeyValueCodec.write(this.dataOutput, PhoenixKeyValueUtil.maybeCopyCell((Cell)cell));
        }
    }

    private static class CompressedIndexKeyValueEncoder
    extends PhoenixBaseEncoder {
        private Codec.Encoder compressedKvEncoder;

        public CompressedIndexKeyValueEncoder(OutputStream os, Codec.Encoder compressedKvEncoder) {
            super(os);
            this.compressedKvEncoder = compressedKvEncoder;
        }

        public void flush() throws IOException {
            this.compressedKvEncoder.flush();
            super.flush();
        }

        public void write(Cell cell) throws IOException {
            this.checkFlushed();
            int marker = 0;
            if (cell instanceof IndexedKeyValue) {
                marker = -1;
            }
            this.out.write(marker);
            if (marker == 0) {
                this.compressedKvEncoder.write(cell);
            } else {
                KeyValueCodec.write(this.dataOutput, PhoenixKeyValueUtil.maybeCopyCell((Cell)cell));
            }
        }
    }

    private static abstract class BinaryCompatiblePhoenixBaseDecoder
    extends BinaryCompatibleBaseDecoder {
        protected DataInput dataInput;

        public BinaryCompatiblePhoenixBaseDecoder(InputStream in) {
            super(in);
            this.dataInput = IndexedWALEditCodec.getDataInput(this.in);
        }
    }

    private static abstract class PhoenixBaseEncoder
    extends BaseEncoder {
        protected DataOutput dataOutput;

        public PhoenixBaseEncoder(OutputStream out) {
            super(out);
            this.dataOutput = IndexedWALEditCodec.getDataOutput(this.out);
        }
    }

    private static abstract class PhoenixBaseDecoder
    extends BaseDecoder {
        protected DataInput dataInput;

        public PhoenixBaseDecoder(InputStream in) {
            super(in);
            this.dataInput = IndexedWALEditCodec.getDataInput(this.in);
        }
    }
}

