/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.regionserver.ScannerContext;

public class ScannerContextUtil {
    public static void incrementSizeProgress(ScannerContext sc, List<Cell> cells) {
        for (Cell cell : cells) {
            sc.incrementSizeProgress((long)PrivateCellUtil.estimatedSerializedSizeOf((Cell)cell), cell.heapSize());
        }
    }

    public static void updateMetrics(ScannerContext src, ScannerContext dst) {
        if (src != null && dst != null && src.isTrackingMetrics() && dst.isTrackingMetrics()) {
            for (Map.Entry entry : src.getMetrics().getMetricsMap().entrySet()) {
                dst.metrics.addToCounter((String)entry.getKey(), ((Long)entry.getValue()).longValue());
            }
        }
    }

    public static ScannerContext copyNoLimitScanner(ScannerContext sc) {
        return new ScannerContext(sc.keepProgress, null, sc.isTrackingMetrics());
    }

    public static void updateTimeProgress(ScannerContext sc) {
        sc.updateTimeProgress();
    }

    public static void setReturnImmediately(ScannerContext sc) {
        sc.returnImmediately();
    }
}

