/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.regionserver.DataTableLocalIndexRegionScanner;
import org.apache.hadoop.hbase.regionserver.IndexHalfStoreFileReader;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compat.hbase.CompatUtil;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.RepairUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexHalfStoreFileReaderGenerator
implements RegionObserver,
RegionCoprocessor {
    private static final String LOCAL_INDEX_AUTOMATIC_REPAIR = "local.index.automatic.repair";
    public static final Logger LOGGER = LoggerFactory.getLogger(IndexHalfStoreFileReaderGenerator.class);

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    /*
     * Unable to fully structure code
     */
    public StoreFileReader preStoreFileReaderOpen(ObserverContext<RegionCoprocessorEnvironment> ctx, FileSystem fs, Path p, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Reference r, StoreFileReader reader) throws IOException {
        block38: {
            tableName = ((RegionCoprocessorEnvironment)ctx.getEnvironment()).getRegion().getTableDescriptor().getTableName();
            region = ((RegionCoprocessorEnvironment)ctx.getEnvironment()).getRegion();
            childRegion = region.getRegionInfo();
            splitKey = null;
            if (reader != null || r == null) break block38;
            if (!p.toString().contains("L#")) {
                return reader;
            }
            metaTable = null;
            regionStartKeyInHFile = null;
            try {
                block37: {
                    block35: {
                        block36: {
                            block40: {
                                block33: {
                                    block34: {
                                        block39: {
                                            block31: {
                                                block32: {
                                                    conn = QueryUtil.getConnectionOnServer((Configuration)((RegionCoprocessorEnvironment)ctx.getEnvironment()).getConfiguration()).unwrap(PhoenixConnection.class);
                                                    hbaseConn = conn.getQueryServices().getAdmin().getConnection();
                                                    scan = MetaTableAccessor.getScanForTableName((Configuration)hbaseConn.getConfiguration(), (TableName)tableName);
                                                    scvf = null;
                                                    if (Reference.isTopFileRegion((Reference.Range)r.getFileRegion())) {
                                                        scvf = new SingleColumnValueFilter(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER, CompareOperator.EQUAL, RegionInfoUtil.toByteArray((RegionInfo)region.getRegionInfo()));
                                                        scvf.setFilterIfMissing(true);
                                                    } else {
                                                        scvf = new SingleColumnValueFilter(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER, CompareOperator.EQUAL, RegionInfoUtil.toByteArray((RegionInfo)region.getRegionInfo()));
                                                        scvf.setFilterIfMissing(true);
                                                    }
                                                    if (scvf != null) {
                                                        scan.setFilter((Filter)scvf);
                                                    }
                                                    metaTable = hbaseConn.getTable(TableName.META_TABLE_NAME);
                                                    result = null;
                                                    scanner = metaTable.getScanner(scan);
                                                    try {
                                                        result = scanner.next();
                                                    }
                                                    finally {
                                                        if (scanner != null) {
                                                            scanner.close();
                                                        }
                                                    }
                                                    if (result != null && !result.isEmpty()) ** GOTO lbl67
                                                    mergeRegions = CompatUtil.getMergeRegions((Connection)((RegionCoprocessorEnvironment)ctx.getEnvironment()).getConnection(), (RegionInfo)region.getRegionInfo());
                                                    if (mergeRegions != null && !mergeRegions.isEmpty()) break block31;
                                                    var22_25 = reader;
                                                    if (conn == null) break block32;
                                                    conn.close();
                                                }
                                                return var22_25;
                                            }
                                            splitRow = CellUtil.cloneRow((Cell)KeyValueUtil.createKeyValueFromKey((byte[])r.getSplitKey()));
                                            if (Bytes.compareTo((byte[])((RegionInfo)mergeRegions.get(0)).getStartKey(), (byte[])splitRow) != 0) break block33;
                                            if (((RegionInfo)mergeRegions.get(0)).getStartKey().length != 0 || region.getRegionInfo().getEndKey().length == ((RegionInfo)mergeRegions.get(0)).getEndKey().length) break block39;
                                            childRegion = (RegionInfo)mergeRegions.get(0);
                                            regionStartKeyInHFile = ((RegionInfo)mergeRegions.get(0)).getStartKey().length == 0 ? new byte[((RegionInfo)mergeRegions.get(0)).getEndKey().length] : ((RegionInfo)mergeRegions.get(0)).getStartKey();
                                            ** GOTO lbl65
                                        }
                                        var23_28 = reader;
                                        if (conn == null) break block34;
                                        conn.close();
                                    }
                                    return var23_28;
                                }
                                for (StoreFileReader mergeRegion : mergeRegions.subList(1, mergeRegions.size())) {
                                    if (Bytes.compareTo((byte[])mergeRegion.getStartKey(), (byte[])splitRow) != 0) continue;
                                    childRegion = mergeRegion;
                                    regionStartKeyInHFile = mergeRegion.getStartKey();
                                    break;
                                }
lbl65:
                                // 3 sources

                                splitKey = KeyValueUtil.createFirstOnRow((byte[])(region.getRegionInfo().getStartKey().length == 0 ? new byte[region.getRegionInfo().getEndKey().length] : region.getRegionInfo().getStartKey())).getKey();
                                break block40;
lbl67:
                                // 1 sources

                                parentRegion = MetaTableAccessor.getRegionInfo((Result)result);
                                regionStartKeyInHFile = parentRegion.getStartKey().length == 0 ? new byte[parentRegion.getEndKey().length] : parentRegion.getStartKey();
                            }
                            dataTable = IndexUtil.getPDataTable((PhoenixConnection)conn, (TableDescriptor)((RegionCoprocessorEnvironment)ctx.getEnvironment()).getRegion().getTableDescriptor());
                            indexes = dataTable.getIndexes();
                            indexMaintainers = new HashMap<ImmutableBytesWritable, IndexMaintainer>();
                            for (PTable index : indexes) {
                                if (index.getIndexType() != PTable.IndexType.LOCAL) continue;
                                indexMaintainer = index.getIndexMaintainer(dataTable, conn);
                                indexMaintainers.put(new ImmutableBytesWritable(index.getviewIndexIdType().toBytes((Object)index.getViewIndexId())), indexMaintainer);
                            }
                            if (!indexMaintainers.isEmpty()) break block35;
                            mergeRegion = reader;
                            if (conn == null) break block36;
                            conn.close();
                        }
                        return mergeRegion;
                    }
                    try {
                        viewConstants = this.getViewConstants(dataTable);
                        var25_31 = new IndexHalfStoreFileReader(fs, p, cacheConf, in, size, r, ((RegionCoprocessorEnvironment)ctx.getEnvironment()).getConfiguration(), indexMaintainers, viewConstants, childRegion, regionStartKeyInHFile, splitKey, childRegion.getReplicaId() == 0, new AtomicInteger(0), region.getRegionInfo());
                        if (conn == null) break block37;
                    }
                    catch (Throwable var17_18) {
                        try {
                            if (conn != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable var18_20) {
                                    var17_18.addSuppressed(var18_20);
                                }
                            }
                            throw var17_18;
                        }
                        catch (SQLException e) {
                            throw new IOException(e);
                        }
                    }
                    conn.close();
                }
                return var25_31;
            }
            finally {
                if (metaTable != null) {
                    metaTable.close();
                }
            }
        }
        return reader;
    }

    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner s, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
        if (!this.isLocalIndexStore(store)) {
            return s;
        }
        if (!store.hasReferences()) {
            InternalScanner repairScanner = null;
            if (request.isMajor() && !RepairUtil.isLocalIndexStoreFilesConsistent((RegionCoprocessorEnvironment)c.getEnvironment(), store)) {
                LOGGER.info("we have found inconsistent data for local index for region:" + ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo());
                if (((RegionCoprocessorEnvironment)c.getEnvironment()).getConfiguration().getBoolean(LOCAL_INDEX_AUTOMATIC_REPAIR, true)) {
                    LOGGER.info("Starting automatic repair of local Index for region:" + ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo());
                    repairScanner = this.getRepairScanner((RegionCoprocessorEnvironment)c.getEnvironment(), store);
                }
            }
            if (repairScanner != null) {
                if (s != null) {
                    s.close();
                }
                return repairScanner;
            }
            return s;
        }
        return s;
    }

    private byte[][] getViewConstants(PTable dataTable) {
        int dataPosOffset = (dataTable.getBucketNum() != null ? 1 : 0) + (dataTable.isMultiTenant() ? 1 : 0);
        byte[][] viewConstants = null;
        int nViewConstants = 0;
        if (dataTable.getType() == PTableType.VIEW) {
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            List dataPkColumns = dataTable.getPKColumns();
            for (int i = dataPosOffset; i < dataPkColumns.size(); ++i) {
                PColumn dataPKColumn = (PColumn)dataPkColumns.get(i);
                if (dataPKColumn.getViewConstant() == null) continue;
                ++nViewConstants;
            }
            if (nViewConstants > 0) {
                viewConstants = new byte[nViewConstants][];
                int j = 0;
                for (int i = dataPosOffset; i < dataPkColumns.size(); ++i) {
                    PColumn dataPkColumn = (PColumn)dataPkColumns.get(i);
                    if (dataPkColumn.getViewConstant() == null) continue;
                    if (IndexUtil.getViewConstantValue((PColumn)dataPkColumn, (ImmutableBytesWritable)ptr)) {
                        viewConstants[j++] = ByteUtil.copyKeyBytesIfNecessary((ImmutableBytesWritable)ptr);
                        continue;
                    }
                    throw new IllegalStateException();
                }
            }
        }
        return viewConstants;
    }

    private InternalScanner getRepairScanner(RegionCoprocessorEnvironment env, Store store) throws IOException {
        DataTableLocalIndexRegionScanner dataTableLocalIndexRegionScanner;
        block10: {
            Scan scan = new Scan();
            scan.readVersions(store.getColumnFamilyDescriptor().getMaxVersions());
            for (Store s : env.getRegion().getStores()) {
                if (this.isLocalIndexStore(s)) continue;
                scan.addFamily(s.getColumnFamilyDescriptor().getName());
            }
            PhoenixConnection conn = QueryUtil.getConnectionOnServer((Configuration)env.getConfiguration()).unwrap(PhoenixConnection.class);
            try {
                PTable dataPTable = IndexUtil.getPDataTable((PhoenixConnection)conn, (TableDescriptor)env.getRegion().getTableDescriptor());
                ArrayList maintainers = Lists.newArrayListWithExpectedSize((int)dataPTable.getIndexes().size());
                for (PTable index : dataPTable.getIndexes()) {
                    if (index.getIndexType() != PTable.IndexType.LOCAL) continue;
                    maintainers.add(index.getIndexMaintainer(dataPTable, conn));
                }
                dataTableLocalIndexRegionScanner = new DataTableLocalIndexRegionScanner(env.getRegion().getScanner(scan), env.getRegion(), maintainers, store.getColumnFamilyDescriptor().getName(), env.getConfiguration());
                if (conn == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            conn.close();
        }
        return dataTableLocalIndexRegionScanner;
    }

    private boolean isLocalIndexStore(Store store) {
        return store.getColumnFamilyDescriptor().getNameAsString().startsWith("L#");
    }
}

