/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ipc.PhoenixRpcScheduler;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.regionserver.RpcSchedulerFactory;
import org.apache.hadoop.hbase.regionserver.SimpleRpcSchedulerFactory;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.IndexUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixRpcSchedulerFactory
implements RpcSchedulerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixRpcSchedulerFactory.class);
    private static final String VERSION_TOO_OLD_FOR_INDEX_RPC = "Running an older version of HBase (less than 0.98.4), Phoenix index RPC handling cannot be enabled.";

    public RpcScheduler create(Configuration conf, PriorityFunction priorityFunction, Abortable abortable) {
        RpcScheduler delegate;
        try {
            delegate = new SimpleRpcSchedulerFactory().create(conf, priorityFunction, abortable);
        }
        catch (IllegalAccessError e) {
            LOGGER.error(VERSION_TOO_OLD_FOR_INDEX_RPC);
            throw e;
        }
        int indexPriority = IndexUtil.getIndexPriority((Configuration)conf);
        this.validatePriority(indexPriority);
        int metadataPriority = IndexUtil.getMetadataPriority((Configuration)conf);
        this.validatePriority(metadataPriority);
        int serverSidePriority = IndexUtil.getServerSidePriority((Configuration)conf);
        this.validatePriority(serverSidePriority);
        Preconditions.checkArgument((indexPriority != metadataPriority ? 1 : 0) != 0, (Object)("Index and Metadata priority must not be same " + indexPriority));
        LOGGER.info("Using custom Phoenix Index RPC Handling with index rpc priority " + indexPriority + " and metadata rpc priority " + metadataPriority);
        int invalidateCachePriority = IndexUtil.getInvalidateMetadataCachePriority((Configuration)conf);
        this.validatePriority(invalidateCachePriority);
        PhoenixRpcScheduler scheduler = new PhoenixRpcScheduler(conf, delegate, indexPriority, metadataPriority, serverSidePriority, invalidateCachePriority, priorityFunction, abortable);
        return scheduler;
    }

    public RpcScheduler create(Configuration configuration, PriorityFunction priorityFunction) {
        return this.create(configuration, priorityFunction, null);
    }

    private void validatePriority(int priority) {
        Preconditions.checkArgument((priority < 0 || priority > 200 ? 1 : 0) != 0, (Object)"priority cannot be within hbase priority range 0 to 200");
    }
}

