/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ipc.BalancedQueueRpcExecutor;
import org.apache.hadoop.hbase.ipc.CallQueueInfo;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcExecutor;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.phoenix.compat.hbase.CompatPhoenixRpcScheduler;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;

public class PhoenixRpcScheduler
extends CompatPhoenixRpcScheduler {
    private static final String CALL_QUEUE_HANDLER_FACTOR_CONF_KEY = "ipc.server.callqueue.handler.factor";
    private static final String CALLQUEUE_LENGTH_CONF_KEY = "ipc.server.max.callqueue.length";
    private static final int DEFAULT_MAX_CALLQUEUE_LENGTH_PER_HANDLER = 10;
    private int indexPriority;
    private int metadataPriority;
    private int serverSidePriority;
    private int invalidateMetadataCachePriority;
    private RpcExecutor indexCallExecutor;
    private RpcExecutor metadataCallExecutor;
    private RpcExecutor serverSideCallExecutor;
    private RpcExecutor invalidateMetadataCacheCallExecutor;
    private int port;

    public PhoenixRpcScheduler(Configuration conf, RpcScheduler delegate, int indexPriority, int metadataPriority, int serversidePriority, int invalidateMetadataCachePriority, PriorityFunction priorityFunction, Abortable abortable) {
        int indexHandlerCount = conf.getInt("phoenix.rpc.index.handler.count", 30);
        int metadataHandlerCount = conf.getInt("phoenix.rpc.metadata.handler.count", 30);
        int serverSideHandlerCount = conf.getInt("phoenix.rpc.serverside.handler.count", 30);
        int invalidateMetadataCacheHandlerCount = conf.getInt("phoenix.rpc.invalidate.cache.handler.count", 10);
        int maxIndexQueueLength = conf.getInt(CALLQUEUE_LENGTH_CONF_KEY, indexHandlerCount * 10);
        int maxMetadataQueueLength = conf.getInt(CALLQUEUE_LENGTH_CONF_KEY, metadataHandlerCount * 10);
        int maxServerSideQueueLength = conf.getInt(CALLQUEUE_LENGTH_CONF_KEY, serverSideHandlerCount * 10);
        int maxInvalidateMetadataCacheQueueLength = conf.getInt(CALLQUEUE_LENGTH_CONF_KEY, invalidateMetadataCacheHandlerCount * 10);
        this.indexPriority = indexPriority;
        this.metadataPriority = metadataPriority;
        this.serverSidePriority = serversidePriority;
        this.invalidateMetadataCachePriority = invalidateMetadataCachePriority;
        this.delegate = delegate;
        this.indexCallExecutor = new BalancedQueueRpcExecutor("Index", indexHandlerCount, maxIndexQueueLength, priorityFunction, conf, abortable);
        this.metadataCallExecutor = new BalancedQueueRpcExecutor("Metadata", metadataHandlerCount, maxMetadataQueueLength, priorityFunction, conf, abortable);
        this.serverSideCallExecutor = new BalancedQueueRpcExecutor("ServerSide", serverSideHandlerCount, maxServerSideQueueLength, priorityFunction, conf, abortable);
        this.invalidateMetadataCacheCallExecutor = new BalancedQueueRpcExecutor("InvalidateMetadataCache", invalidateMetadataCacheHandlerCount, maxInvalidateMetadataCacheQueueLength, priorityFunction, conf, abortable);
    }

    public void init(RpcScheduler.Context context) {
        this.delegate.init(context);
        this.port = context.getListenerAddress().getPort();
    }

    public void start() {
        this.delegate.start();
        this.indexCallExecutor.start(this.port);
        this.metadataCallExecutor.start(this.port);
        this.serverSideCallExecutor.start(this.port);
        this.invalidateMetadataCacheCallExecutor.start(this.port);
    }

    public void stop() {
        this.delegate.stop();
        this.indexCallExecutor.stop();
        this.metadataCallExecutor.stop();
        this.serverSideCallExecutor.stop();
        this.invalidateMetadataCacheCallExecutor.stop();
    }

    public boolean compatDispatch(CallRunner callTask) throws IOException, InterruptedException {
        RpcCall call = callTask.getRpcCall();
        int priority = call.getHeader().getPriority();
        if (this.indexPriority == priority) {
            return this.indexCallExecutor.dispatch(callTask);
        }
        if (this.metadataPriority == priority) {
            return this.metadataCallExecutor.dispatch(callTask);
        }
        if (this.serverSidePriority == priority) {
            return this.serverSideCallExecutor.dispatch(callTask);
        }
        if (this.invalidateMetadataCachePriority == priority) {
            return this.invalidateMetadataCacheCallExecutor.dispatch(callTask);
        }
        return this.delegate.dispatch(callTask);
    }

    public CallQueueInfo getCallQueueInfo() {
        return this.delegate.getCallQueueInfo();
    }

    public int getGeneralQueueLength() {
        return this.delegate.getGeneralQueueLength() + this.indexCallExecutor.getQueueLength() + this.metadataCallExecutor.getQueueLength() + this.serverSideCallExecutor.getQueueLength() + this.invalidateMetadataCacheCallExecutor.getQueueLength();
    }

    public int getPriorityQueueLength() {
        return this.delegate.getPriorityQueueLength();
    }

    public int getReplicationQueueLength() {
        return this.delegate.getReplicationQueueLength();
    }

    public int getActiveRpcHandlerCount() {
        return this.delegate.getActiveRpcHandlerCount() + this.indexCallExecutor.getActiveHandlerCount() + this.metadataCallExecutor.getActiveHandlerCount() + this.serverSideCallExecutor.getActiveHandlerCount() + this.invalidateMetadataCacheCallExecutor.getActiveHandlerCount();
    }

    public long getNumGeneralCallsDropped() {
        return this.delegate.getNumGeneralCallsDropped();
    }

    public long getNumLifoModeSwitches() {
        return this.delegate.getNumLifoModeSwitches();
    }

    @VisibleForTesting
    public void setIndexExecutorForTesting(RpcExecutor executor) {
        this.indexCallExecutor = executor;
    }

    @VisibleForTesting
    public void setMetadataExecutorForTesting(RpcExecutor executor) {
        this.metadataCallExecutor = executor;
    }

    @VisibleForTesting
    public void setInvalidateMetadataCacheExecutorForTesting(RpcExecutor executor) {
        this.invalidateMetadataCacheCallExecutor = executor;
    }

    @VisibleForTesting
    public void setServerSideExecutorForTesting(RpcExecutor executor) {
        this.serverSideCallExecutor = executor;
    }

    @VisibleForTesting
    public RpcExecutor getIndexExecutorForTesting() {
        return this.indexCallExecutor;
    }

    @VisibleForTesting
    public RpcExecutor getMetadataExecutorForTesting() {
        return this.metadataCallExecutor;
    }

    @VisibleForTesting
    public RpcExecutor getServerSideExecutorForTesting() {
        return this.serverSideCallExecutor;
    }

    public int getWriteQueueLength() {
        return this.delegate.getWriteQueueLength();
    }

    public int getReadQueueLength() {
        return this.delegate.getReadQueueLength();
    }

    public int getScanQueueLength() {
        return this.delegate.getScanQueueLength();
    }

    public int getActiveWriteRpcHandlerCount() {
        return this.delegate.getActiveWriteRpcHandlerCount();
    }

    public int getActiveReadRpcHandlerCount() {
        return this.delegate.getActiveReadRpcHandlerCount();
    }

    public int getActiveScanRpcHandlerCount() {
        return this.delegate.getActiveScanRpcHandlerCount();
    }

    public int getMetaPriorityQueueLength() {
        return this.delegate.getMetaPriorityQueueLength();
    }

    public int getActiveGeneralRpcHandlerCount() {
        return this.delegate.getActiveGeneralRpcHandlerCount();
    }

    public int getActivePriorityRpcHandlerCount() {
        return this.delegate.getActivePriorityRpcHandlerCount();
    }

    public int getActiveMetaPriorityRpcHandlerCount() {
        return this.delegate.getActiveMetaPriorityRpcHandlerCount();
    }

    public int getActiveReplicationRpcHandlerCount() {
        return this.delegate.getActiveReplicationRpcHandlerCount();
    }
}

