/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util.json;

import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.spi.json.AbstractJsonProvider;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.json.JsonReader;
import org.bson.types.ObjectId;

public class BsonJsonProvider
extends AbstractJsonProvider {
    public Object parse(String json) throws InvalidJsonException {
        JsonReader jsonReader = new JsonReader(json);
        BsonType bsonType = jsonReader.readBsonType();
        switch (bsonType) {
            case ARRAY: {
                return BsonArray.parse((String)json);
            }
            case DOCUMENT: {
                return BsonDocument.parse((String)json);
            }
            case STRING: {
                return new BsonString(jsonReader.readString());
            }
            case INT32: {
                return new BsonInt32(jsonReader.readInt32());
            }
        }
        throw new InvalidJsonException(String.format("Unsupported bson type %s", bsonType));
    }

    public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
        return null;
    }

    public String toJson(Object obj) {
        return null;
    }

    public Object createArray() {
        return new BsonArray();
    }

    public boolean isArray(Object obj) {
        return obj instanceof BsonArray || obj instanceof List;
    }

    public Object getArrayIndex(Object obj, int idx) {
        return BsonJsonProvider.toBsonArray(obj).get(idx);
    }

    public void setArrayIndex(Object array, int index, Object newValue) {
        if (!this.isArray(array)) {
            throw new UnsupportedOperationException();
        }
        BsonArray arr = BsonJsonProvider.toBsonArray(array);
        if (index == arr.size()) {
            arr.add(BsonJsonProvider.toBsonValue(newValue));
        } else {
            arr.set(index, BsonJsonProvider.toBsonValue(newValue));
        }
    }

    public Object createMap() {
        return new BsonDocument();
    }

    public boolean isMap(Object obj) {
        return obj instanceof BsonDocument;
    }

    public Object getMapValue(Object obj, String key) {
        BsonDocument bsonDocument = BsonJsonProvider.toBsonDocument(obj);
        BsonValue o = bsonDocument.get((Object)key);
        if (!bsonDocument.containsKey((Object)key)) {
            return UNDEFINED;
        }
        return this.unwrap(o);
    }

    public Iterable<?> toIterable(Object obj) {
        BsonArray arr = BsonJsonProvider.toBsonArray(obj);
        ArrayList<Object> values = new ArrayList<Object>(arr.size());
        for (Object o : arr) {
            values.add(BsonJsonProvider.toJavaType(BsonJsonProvider.toBsonValue(o)));
        }
        return values;
    }

    public void setProperty(Object obj, Object key, Object value) {
        if (this.isMap(obj)) {
            BsonJsonProvider.toBsonDocument(obj).put(key.toString(), BsonJsonProvider.toBsonValue(value));
        } else {
            BsonArray array;
            int index = key != null ? (key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString())) : array.size();
            if (index == (array = BsonJsonProvider.toBsonArray(obj)).size()) {
                array.add(BsonJsonProvider.toBsonValue(value));
            } else {
                array.set(index, BsonJsonProvider.toBsonValue(value));
            }
        }
    }

    private static BsonArray toBsonArray(Object o) {
        return (BsonArray)o;
    }

    private static BsonDocument toBsonDocument(Object o) {
        return (BsonDocument)o;
    }

    private static BsonValue toBsonValue(Object source) {
        if (source instanceof BsonValue) {
            return (BsonValue)source;
        }
        if (source instanceof String) {
            return new BsonString((String)source);
        }
        if (source instanceof ObjectId) {
            return new BsonObjectId((ObjectId)source);
        }
        if (source instanceof Double) {
            return new BsonDouble(((Double)source).doubleValue());
        }
        if (source instanceof Integer) {
            return new BsonInt32(((Integer)source).intValue());
        }
        if (source instanceof Long) {
            return new BsonInt64(((Long)source).longValue());
        }
        if (source instanceof byte[]) {
            return new BsonBinary((byte[])source);
        }
        if (source instanceof Boolean) {
            return new BsonBoolean(((Boolean)source).booleanValue());
        }
        if (source instanceof Float) {
            return new BsonDouble((double)((Float)source).floatValue());
        }
        throw new IllegalArgumentException(String.format("Unable to convert %s (%s) to BsonValue.", source, source != null ? source.getClass().getName() : "null"));
    }

    public static Object toJavaType(BsonValue value) {
        switch (value.getBsonType()) {
            case INT32: {
                return value.asInt32().getValue();
            }
            case INT64: {
                return value.asInt64().getValue();
            }
            case STRING: {
                return value.asString().getValue();
            }
            case DECIMAL128: {
                return value.asDecimal128().doubleValue();
            }
            case DOUBLE: {
                return value.asDouble().getValue();
            }
            case BOOLEAN: {
                return value.asBoolean().getValue();
            }
            case OBJECT_ID: {
                return value.asObjectId().getValue();
            }
            case BINARY: {
                return value.asBinary().getData();
            }
            case DATE_TIME: {
                return new Date(value.asDateTime().getValue());
            }
            case SYMBOL: {
                return value.asSymbol().getSymbol();
            }
            case ARRAY: {
                return value.asArray().toArray();
            }
            case DOCUMENT: {
                return Document.parse((String)value.asDocument().toJson());
            }
        }
        return value;
    }
}

